/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.SymmetricCipherBase;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.LogBytes;
import org.apache.log4j.Logger;

public class PasswordEncryption
extends SymmetricCipherBase {
    private ARDataKey arDataKey;
    private static Logger logger = Logger.getLogger(PasswordEncryption.class);

    @Override
    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    public PasswordEncryption(boolean debug) {
        super(true, debug);
        this.prepareDataKey();
    }

    public PasswordEncryption(int seedType, boolean debug) {
        this(debug);
        this.setSeedType(seedType);
    }

    public byte[] encryptPasswordEx(byte[] plainMessage) throws AREncryptionException {
        return this.encryptPasswordEx(this.getArDataKey(), plainMessage);
    }

    public byte[] encryptPasswordEx(ARDataKey arDataKey, byte[] plainMessage) throws AREncryptionException {
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(plainMessage, "PasswordEncryption.encryptPasswordEx-orgData");
        }
        byte[] actureBuf = this.setUpActualEncryptBuffer(plainMessage, this.getPadSize(plainMessage.length));
        arDataKey.setEncMode(1);
        byte[] saltedData = this.saltData(actureBuf);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(saltedData, "PasswordEncryption.encryptPasswordEx- after saltData() saltedData");
        }
        return this.encryptData(arDataKey, saltedData);
    }

    public byte[] decryptPasswordEx(byte[] fromBuf) throws AREncryptionException {
        return this.decryptPasswordEx(this.getArDataKey(), fromBuf);
    }

    public byte[] decryptPasswordEx(ARDataKey arDataKey, byte[] fromBuf) throws AREncryptionException {
        arDataKey.setEncMode(2);
        byte[] saltedBuf = this.decryptData(arDataKey, fromBuf);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(saltedBuf, "PasswordEncryption.decryptPasswordEx- decrypted-salted-buffer");
        }
        byte[] decryptedMessage = this.unsaltData(saltedBuf);
        if (this.logFlag) {
            LogBytes.printByteArrayAsHex(decryptedMessage, "PasswordEncryption.decryptPasswordEx- after unsaltData() paddedPasswd");
        }
        return this.getPlainText(decryptedMessage);
    }

    public ARDataKey getArDataKey() {
        return this.arDataKey;
    }

    public void setArDataKey(ARDataKey arDataKey) {
        this.arDataKey = arDataKey;
    }

    @Override
    protected int getPadSize(int passwdStrLen) {
        return 36 - passwdStrLen;
    }

    @Override
    protected byte[] getSaltIv() {
        return this.getArDataKey().getSaltIv();
    }

    private void prepareDataKey() {
        this.arDataKey = new ARDataKey();
        this.arDataKey.setEncAlgorithmStr("DES");
        this.arDataKey.setEncType("Enc");
        this.arDataKey.setEncXForm("DES/CBC/PKCS5Padding");
        this.arDataKey.setKeySize(56);
        boolean macMasked = true;
        this.arDataKey.setMacKey(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.M, macMasked));
        this.arDataKey.setMacMasked(macMasked);
    }

    protected void setSeedType(int seedType) {
        this.arDataKey.setSeedType(seedType);
    }

    @Override
    protected boolean isSaltIvMasked() {
        return this.getArDataKey().isSaltIvMasked();
    }
}

