/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.apitransport.session.ARKeyExchanger;
import com.bmc.arsys.apitransport.session.ApiRpcClientStubBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4In;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4Out;
import com.bmc.arsys.arrpc.ArRandomBytes;
import com.bmc.arsys.arrpc.ArServerInfoList;
import com.bmc.arsys.arrpc.xdr.ArEsRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ArEsKeyExchanger
extends ARKeyExchanger {
    private static Logger log = Logger.getLogger(ArEsKeyExchanger.class);

    protected ArEsKeyExchanger(ApiRpcClientStubBase rpcClient) {
        super(rpcClient);
    }

    @Override
    protected ArRpcControlStruct createRpcControlStruct() {
        return new ArEsRpcControlStruct();
    }

    @Override
    protected ArRpcXdrOut createServerInfoOut() {
        return new ArEsGetEncryptInfo4Out();
    }

    @Override
    protected ArRpcXdrIn createServerInfoIn(ArRpcControlStruct control) {
        ArEsGetEncryptInfo4In in = new ArEsGetEncryptInfo4In();
        in.setControl((ArEsRpcControlStruct)control);
        in.requestList.value = new int[4];
        in.requestList.value[0] = 133;
        in.requestList.value[1] = 129;
        in.requestList.value[2] = 132;
        in.requestList.value[3] = 168;
        return in;
    }

    @Override
    protected ArRpcXdrIn createKeyExchangeBeginIn(ArRpcControlStruct control, AREncryptAPISessionNodeBase encCtx) {
        ArEsKeyExchangeBegin4In in = new ArEsKeyExchangeBegin4In();
        in.setControl((ArEsRpcControlStruct)control);
        in.clientRandBytes = new ArRandomBytes(encCtx.getClientRandBytes());
        return in;
    }

    @Override
    protected ArRpcXdrOut createKeyExchangeBeginOut() {
        return new ArEsKeyExchangeBegin4Out();
    }

    @Override
    protected ArRpcXdrOut createKeyExchangeFinalOut() {
        return new ArEsKeyExchangeFinal4Out();
    }

    @Override
    protected ArRpcXdrIn createKeyExchangeFinalIn(ArRpcControlStruct control, AREncryptAPISessionNodeBase encCtx) throws AREncryptionException, ARException, OncRpcException, IOException {
        ArEsKeyExchangeFinal4In in = new ArEsKeyExchangeFinal4In();
        in.control = (ArEsRpcControlStruct)control;
        in.sessionId = encCtx.getClintKeyInfo().getSessionId();
        log.debug("sessionID before encryption = " + in.sessionId);
        byte[] encXdrPreMasterKey = this.xdrAndEncrypPreMasterKey(this._svrPublicKey, encCtx.getPreMasterKey());
        in.setEncPreMasterKey(encXdrPreMasterKey);
        return in;
    }

    @Override
    protected ArServerInfoList getServerInfoList(ArRpcXdrOut out) {
        return ((ArEsGetEncryptInfo4Out)out).getServerInfoList();
    }

    @Override
    protected byte[] getEncSessionId(ArRpcXdrOut out) {
        return ((ArEsKeyExchangeFinal4Out)out).getEncSessionId();
    }

    @Override
    protected int getProcNumEncryptInfo() {
        return 16;
    }

    @Override
    protected int getProcNumKeyExchangeBegin() {
        return 17;
    }

    @Override
    protected int getProcNumKeyExchangeFinal() {
        return 18;
    }

    @Override
    protected void setInEncCtx(AREncryptAPISessionNodeBase encCtx, ArRpcXdrOut out) {
        encCtx.setServerRandBytes(((ArEsKeyExchangeBegin4Out)out).serverRandBytes.value);
        encCtx.getClintKeyInfo().setSessionId(((ArEsKeyExchangeBegin4Out)out).sessionId);
    }
}

