/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.connection.ApiProxyPoolI;
import com.bmc.arsys.utils.ProcessUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class ApiProxyPool
implements ApiProxyPoolI {
    private static Logger logger = Logger.getLogger(ApiProxyPool.class);
    private final String poolName;
    private long lastUsed = 0L;
    private long lastCleaned = 0L;
    private long lastEvaluatedForConnectionLifeSpan = 0L;
    private long establishTime = 0L;
    final ReentrantLock poolLock = new ReentrantLock();
    private final Condition notEmpty = this.poolLock.newCondition();
    private Stack<ApiProxyI> pool;
    private volatile int idleConnectionsPerServer = ApiProxyManager.idleConnectionsPerServer;
    private volatile int maximumPoolSize = ApiProxyManager.maxProxiesPerServer;
    private volatile int poolSize;

    public ApiProxyPool(String name, int idleConnectionSize, int maximumPoolSize, long connectionTimeout, ARTimeUnit unit) {
        if (idleConnectionSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < idleConnectionSize || connectionTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.poolName = name;
        this.idleConnectionsPerServer = idleConnectionSize;
        this.maximumPoolSize = maximumPoolSize;
        this.pool = new Stack();
        long time = System.currentTimeMillis();
        this.setLastUsed(time);
        this.setEstablishTime(time);
        logger.debug("Pool " + name + " established");
    }

    public ApiProxyPool(String name, int maxProxiesPerServer) {
        this.poolName = name;
        this.maximumPoolSize = maxProxiesPerServer;
        this.pool = new Stack();
        long time = System.currentTimeMillis();
        this.setLastUsed(time);
        this.setEstablishTime(time);
        logger.debug("Pool " + name + " established");
    }

    @Override
    public void setLastUsed(long tm) {
        this.lastUsed = tm;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiProxyI recordNewProxy(ApiProxyI t) {
        if (t != null) {
            String msg = null;
            this.poolLock.lock();
            try {
                int nt = ++this.poolSize;
                int mark = 0;
                Integer waterMark = ApiProxyManager.poolsWaterMark.get(this.poolName);
                if (waterMark != null) {
                    mark = waterMark;
                }
                if (nt > mark) {
                    waterMark = new Integer(mark + 1);
                    ApiProxyManager.poolsWaterMark.put(this.poolName, waterMark);
                    msg = "Pool " + this.poolName + " reached high water mark pool size = " + waterMark;
                }
            }
            finally {
                this.poolLock.unlock();
                if (msg != null && logger.isDebugEnabled()) {
                    logger.debug(msg);
                }
            }
        }
        return t;
    }

    public void deRecodeProxy(ApiProxyI t) {
        if (t != null && this.poolSize > 0) {
            this.poolLock.lock();
            try {
                --this.poolSize;
                if (logger.isTraceEnabled()) {
                    logger.trace("poolSize reduced to = " + this.poolSize + " after deRecodeProxy " + t);
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiProxyI get(ApiUserContextI context) throws ARException {
        this.poolLock.lock();
        try {
            this.setLastUsed(System.currentTimeMillis());
            while (this.pool.size() == 0) {
                String msg = "Pool " + this.poolName + " Tid_" + Thread.currentThread().getId() + " for " + context.getServerInfoStr();
                if (this.poolSize < this.maximumPoolSize) {
                    ApiProxyI proxy = this.createProxy(context);
                    if (proxy != null && proxy.getEstablishTime() == 0L) {
                        logger.error("*** createProxy " + proxy + " established = " + proxy.getEstablishTime());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Pool " + this.poolName + " Created proxy " + proxy + " numberOfProxies = " + this.poolSize + ", current in pool = " + this.pool.size() + ", maxSizeLimit = " + this.maximumPoolSize + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount() + " by " + msg);
                    }
                    this.recordNewProxy(proxy);
                    this.pool.push(proxy);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Pool " + this.poolName + " waiting proxy available.  numberOfProxies = " + this.poolSize + ", pool size = " + this.pool.size() + ", max = " + this.maximumPoolSize + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount() + " by " + msg);
                }
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException proxy) {}
            }
            ApiProxyI apiProxyI = this.pool.pop();
            return apiProxyI;
        }
        finally {
            int uCnt2 = this.poolLock.getHoldCount();
            if (uCnt2 > 0) {
                this.poolLock.unlock();
            }
        }
    }

    protected abstract ApiProxyI createProxy(ApiUserContextI var1) throws ARException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ApiProxyI proxy) {
        this.poolLock.lock();
        try {
            long tm = System.currentTimeMillis();
            this.setLastUsed(tm);
            proxy.setLastUsed(tm);
            if (this.poolSize <= this.maximumPoolSize) {
                this.pool.push(proxy);
                this.notEmpty.signal();
            } else {
                this.deRecodeProxy(proxy);
                if (logger.isDebugEnabled()) {
                    logger.debug("done deRecodeProxy " + proxy + " from pool " + this.poolName + " for new maximumPoolSize " + this.maximumPoolSize + ". Will terminate the proxy " + proxy);
                }
                this.interruptIfIdle(proxy);
            }
        }
        finally {
            int cnt = this.poolLock.getHoldCount();
            if (cnt > 0) {
                this.poolLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ageOutIdleProxy() {
        if (ApiProxyManager.connectionTimeout <= 0L || ApiProxyManager.connectionTimeout == Long.MAX_VALUE) {
            return;
        }
        if (System.currentTimeMillis() - this.getLastCleaned() < 100L) {
            return;
        }
        if (this.poolLock.tryLock()) {
            HashSet<ApiProxyI> removeList = new HashSet<ApiProxyI>();
            try {
                long c = System.currentTimeMillis();
                this.setLastCleaned(c);
                int numInPool = this.pool.size();
                if (numInPool > this.idleConnectionsPerServer) {
                    String ageOutMsg = null;
                    String idleStr = null;
                    String estStr = null;
                    Iterator it = this.pool.iterator();
                    while (it.hasNext()) {
                        if (numInPool <= this.idleConnectionsPerServer) {
                            return;
                        }
                        ApiProxyI p = (ApiProxyI)it.next();
                        long t = p.getLastUsed();
                        c = System.currentTimeMillis();
                        long idleTime = c - t;
                        if (logger.isDebugEnabled()) {
                            idleStr = ProcessUtil.getElapsedTimeToFormatedString(idleTime);
                            estStr = ProcessUtil.getElapsedTimeToFormatedString(c - p.getEstablishTime());
                        }
                        if (logger.isTraceEnabled()) {
                            String idleTimeStr = null;
                            String idleTimeMsg = null;
                            idleTimeStr = ProcessUtil.getElapsedTimeToFormatedString(ApiProxyManager.connectionTimeout);
                            idleTimeMsg = " for connectionTimeout setting " + idleTimeStr;
                            logger.trace("Evalauting " + this.poolName + " " + p + " been idle for " + idleStr + idleTimeMsg + ", which have established for " + estStr);
                        }
                        if (idleTime <= ApiProxyManager.connectionTimeout) continue;
                        removeList.add(p);
                        if (logger.isDebugEnabled()) {
                            ageOutMsg = "Time out pool " + this.poolName + " proxy " + p + " after idle " + idleStr + ", which had established for " + estStr;
                            logger.debug(ageOutMsg);
                        }
                        this.interruptIfIdle(p);
                        --numInPool;
                    }
                    return;
                }
                if (!logger.isTraceEnabled()) return;
                logger.trace("Skip timeout for pool " + this.poolName + " since numInPool:" + numInPool + " <= idleConnectionsPerServer:" + this.idleConnectionsPerServer);
                return;
            }
            finally {
                try {
                    if (removeList.size() > 0) {
                        int orgPoolSize = this.poolSize;
                        for (ApiProxyI p : removeList) {
                            this.pool.remove(p);
                            --this.poolSize;
                        }
                        if (logger.isDebugEnabled()) {
                            String msg = "Reduced pool " + this.poolName + " size from " + orgPoolSize + " to " + this.poolSize;
                            logger.debug(msg);
                        }
                    }
                }
                finally {
                    if (this.poolLock.getHoldCount() > 0) {
                        this.poolLock.unlock();
                    }
                }
            }
        }
        if (!logger.isTraceEnabled()) return;
        logger.trace("pool " + this.poolName + " was in use. skip clean up for connection timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateProxyForLoadBalancer() {
        if (ApiProxyManager.connectionLifespan <= 0L || ApiProxyManager.connectionLifespan == Long.MAX_VALUE) {
            return;
        }
        if (System.currentTimeMillis() - this.lastEvaluatedForConnectionLifeSpan < 100L) {
            return;
        }
        if (this.poolLock.tryLock()) {
            HashSet<ApiProxyI> removeList = new HashSet<ApiProxyI>();
            try {
                String liveMsg = null;
                Object estStr = null;
                Iterator it = this.pool.iterator();
                int numInPool = this.pool.size();
                while (it.hasNext()) {
                    long c;
                    this.lastEvaluatedForConnectionLifeSpan = c = System.currentTimeMillis();
                    if (logger.isTraceEnabled()) {
                        logger.trace("eval connectionlifeSpan in pool " + this.poolName + ", numInPool " + numInPool + ", pool established " + (c - this.getEstablishTime()) + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(c - this.getEstablishTime()) + ")" + ", lastTimeUsed " + (c - this.getLastUsed()) + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(c - this.getLastUsed()) + ")");
                    }
                    ApiProxyI p = (ApiProxyI)it.next();
                    long t = p.getEstablishTime();
                    long liveTime = c - t;
                    if (logger.isDebugEnabled()) {
                        estStr = ProcessUtil.getElapsedTimeToFormatedString(liveTime);
                    }
                    if (liveTime <= ApiProxyManager.connectionLifespan) continue;
                    removeList.add(p);
                    if (logger.isDebugEnabled()) {
                        liveMsg = "Exceed connectionLifeSpan in pool " + this.poolName + " terminate proxy " + p + " after established for " + liveTime + " ms (" + (String)estStr + ")";
                        logger.debug(liveMsg);
                    }
                    this.interruptIfIdle(p);
                    --numInPool;
                }
            }
            finally {
                try {
                    if (removeList.size() > 0) {
                        int orgPoolSize = this.poolSize;
                        for (ApiProxyI p : removeList) {
                            this.pool.remove(p);
                            --this.poolSize;
                        }
                        if (logger.isDebugEnabled()) {
                            String msg = "Reduced exceeding connectionLifeSpan pool " + this.poolName + " poolSize from " + orgPoolSize + " to " + this.poolSize;
                            logger.debug(msg);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.trace(e.getLocalizedMessage());
                }
                finally {
                    if (this.poolLock.getHoldCount() > 0) {
                        this.poolLock.unlock();
                    }
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("pool was in use. skip clean up connection life span");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustPoolParameters(int maximumPoolSize, int idleConnectionsPerServer) {
        if (maximumPoolSize <= 0 || maximumPoolSize < idleConnectionsPerServer) {
            throw new IllegalArgumentException();
        }
        if (logger.isInfoEnabled()) {
            logger.info("AdjustPoolParameters pool " + this.poolName + " with maximumPoolSize = " + maximumPoolSize + " idleConnectionsPerServer = " + idleConnectionsPerServer);
        }
        this.poolLock.lock();
        HashSet<ApiProxyI> removeList = new HashSet<ApiProxyI>();
        try {
            int evalPoolSize;
            int extra = 0;
            if (maximumPoolSize < this.maximumPoolSize) {
                extra = this.maximumPoolSize - maximumPoolSize;
            }
            if (extra > 0 && evalPoolSize > maximumPoolSize) {
                Iterator it = this.pool.iterator();
                for (evalPoolSize = this.poolSize; it.hasNext() && extra > 0 && evalPoolSize > maximumPoolSize; --evalPoolSize, --extra) {
                    ApiProxyI p = (ApiProxyI)it.next();
                    removeList.add(p);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Forced to terminate current idle proxy " + p + " in pool " + this.poolName + " which exceeds maximumPoolSize " + maximumPoolSize + " to make proxy in pool = " + this.pool.size() + " down to poolSize " + (evalPoolSize - 1));
                    }
                    this.interruptIfIdle(p);
                }
            }
        }
        finally {
            try {
                if (removeList.size() > 0) {
                    int orgPoolSize = this.poolSize;
                    for (ApiProxyI p : removeList) {
                        this.pool.remove(p);
                        --this.poolSize;
                    }
                    if (logger.isDebugEnabled()) {
                        String msg = "Pool " + this.poolName + " poolSize reduced from " + orgPoolSize + " to " + this.poolSize;
                        logger.debug(msg);
                    }
                }
            }
            catch (Throwable e) {
                logger.debug(e.getCause());
            }
            this.maximumPoolSize = maximumPoolSize;
            this.idleConnectionsPerServer = idleConnectionsPerServer;
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        if (this.poolLock.tryLock()) {
            HashSet<ApiProxyI> removeList = new HashSet<ApiProxyI>();
            try {
                for (ApiProxyI apiProxyI : this.pool) {
                    removeList.add(apiProxyI);
                    this.interruptIfIdle(apiProxyI);
                }
            }
            finally {
                try {
                    if (removeList.size() > 0) {
                        int orgPoolSize = this.poolSize;
                        for (ApiProxyI p : removeList) {
                            this.pool.remove(p);
                            --this.poolSize;
                        }
                        if (logger.isDebugEnabled()) {
                            String string = "Pool " + this.poolName + " poolSize reduced from " + orgPoolSize + " to " + this.poolSize;
                            logger.debug(string);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.debug(e.getCause());
                }
                this.poolLock.unlock();
            }
        }
    }

    void interruptIfIdle(ApiProxyI p) {
        if (this.poolLock.tryLock()) {
            try {
                p.ARTermination(null);
            }
            catch (ARException e) {
                logger.debug(e.getLocalizedMessage());
            }
            finally {
                this.poolLock.unlock();
            }
        }
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    protected int getMaximumPoolSize() {
        this.poolLock.lock();
        try {
            int n = this.maximumPoolSize;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public int getLargestPoolSize() {
        int mark = 0;
        Integer waterMark = ApiProxyManager.poolsWaterMark.get(this.poolName);
        if (waterMark != null) {
            mark = waterMark;
        }
        return mark;
    }

    @Override
    public void clear() {
        this.poolLock.lock();
        try {
            if (this.poolSize > 0 && this.pool.size() > 0) {
                this.interruptIdleWorkers();
                logger.debug("Pool " + this.poolName + " clear out ");
            }
            this.setLastCleaned(System.currentTimeMillis());
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected abstract Object getInfo(String var1);

    protected long getConnectionTimeout(ARTimeUnit unit) {
        return unit == null ? ApiProxyManager.connectionTimeout : unit.convert(ApiProxyManager.connectionTimeout, ARTimeUnit.MILLISECONDS);
    }

    protected long getConnectionLifespan(ARTimeUnit unit) {
        return unit == null ? ApiProxyManager.connectionLifespan : unit.convert(ApiProxyManager.connectionLifespan, ARTimeUnit.MILLISECONDS);
    }

    protected int getPoolSize() {
        this.poolLock.lock();
        try {
            int n = this.poolSize;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected int getIdlePoolSize() {
        return this.pool.size();
    }

    long getLastCleaned() {
        return this.lastCleaned;
    }

    void setLastCleaned(long lastCleaned) {
        this.lastCleaned = lastCleaned;
    }

    public void setEstablishTime(long m_establishTime) {
        this.establishTime = m_establishTime;
    }

    @Override
    public long getEstablishTime() {
        return this.establishTime;
    }

    protected int getMaxProxiesPerServer() {
        return this.maximumPoolSize;
    }

    protected int getIdleConnectionsPerServer() {
        return this.idleConnectionsPerServer;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.poolName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiProxyPool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ApiProxyPool rhs = (ApiProxyPool)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.poolName, rhs.poolName).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("ServerKey", this.poolName).toString();
    }
}

