/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.IARServerLogInterface;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiValueBase;
import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.utils.LocaleInfo;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class ApiUserContextBase
implements ApiUserContextI {
    public Map<Integer, ApiValueBase> userSession = new HashMap<Integer, ApiValueBase>();
    protected Map<Object, Object> userGenericSession = new HashMap<Object, Object>();
    public ReentrantLock proxyILock = new ReentrantLock();
    public ApiProxyI m_proxyI = null;
    public ApiProxyI m_CMDBproxyI = null;
    private String m_impersonatedUser;
    private long m_impersonatedCacheId;
    private LocaleInfo m_localeInfo;
    private String userSessionGuid;
    private int overlayObjType;
    private String overlayGroup = _overlayGroupDefault;
    private String designOverlayGroup = _designOverlayGroupDefault;
    private int granularOverlayMode;
    private String tenantId;
    protected long m_cacheId;
    protected boolean m_adminFlag;
    protected boolean m_subAdminFlag;
    protected boolean m_customFlag;
    protected boolean m_stadminFlag;
    protected boolean m_stsubAdminFlag;
    protected boolean m_overlayFlag;
    protected boolean m_boverlayFlag;
    protected Timestamp m_operationTime;
    protected IARServerLogInterface m_logInterface;
    private String m_serviceStatMsg = null;
    protected static int _timeoutNormalDefault = 120;
    protected static int _timeoutLongDefault = 300;
    protected static int _timeoutXLongDefault = 1800;
    private static String _designOverlayGroupDefault;
    private static String _overlayGroupDefault;

    protected static void setAPIDefaultTimeouts(Logger logger) {
        String value = System.getProperty("ARAPITIMEOUTS");
        if (logger.isInfoEnabled()) {
            logger.info("APITIMEOUT from system property : " + value);
        }
        if (value == null || value.length() == 0) {
            value = System.getenv("ARAPITIMEOUTS");
            if (logger.isInfoEnabled()) {
                logger.info("APITIMEOUT from Environment : " + value);
            }
        }
        if (value != null && value.length() > 0) {
            try {
                String[] timeoutVal = value.split("[:;]");
                for (int i = 0; i < timeoutVal.length; ++i) {
                    if (i == 0) {
                        if (timeoutVal[i].trim().length() > 0) {
                            _timeoutNormalDefault = Integer.parseInt(timeoutVal[i].trim());
                            continue;
                        }
                        _timeoutNormalDefault = 120;
                        continue;
                    }
                    if (i == 1) {
                        if (timeoutVal[i].trim().length() > 0) {
                            _timeoutLongDefault = Integer.parseInt(timeoutVal[i].trim());
                            continue;
                        }
                        _timeoutLongDefault = 300;
                        continue;
                    }
                    if (i != 2) continue;
                    _timeoutXLongDefault = timeoutVal[i].trim().length() > 0 ? Integer.parseInt(timeoutVal[i].trim()) : 1800;
                }
            }
            catch (Exception ex) {
                logger.warn("Unable to parse ENV variable ARAPITIMEOUTS : " + value);
            }
        }
    }

    protected static void setAPIDefaultOverlayGroups(Logger logger) {
        String value = System.getProperty("AROVERLAYGROUPS");
        if (logger.isInfoEnabled()) {
            logger.info("AROVERLAYGROUPS from system property : " + value);
        }
        if (value == null || value.length() == 0) {
            value = System.getenv("AROVERLAYGROUPS");
            if (logger.isInfoEnabled()) {
                logger.info("AROVERLAYGROUPS from Environment : " + value);
            }
        }
        if (value != null && value.length() > 0) {
            try {
                String[] groupVal = value.split("[:;]");
                for (int i = 0; i < groupVal.length; ++i) {
                    if (i == 0) {
                        if (groupVal[i].trim().length() <= 0) continue;
                        _designOverlayGroupDefault = groupVal[i].trim();
                        continue;
                    }
                    if (i != 1 || groupVal[i].trim().length() <= 0) continue;
                    _overlayGroupDefault = groupVal[i].trim();
                }
            }
            catch (Exception ex) {
                logger.warn("Unable to parse ENV variable AROVERLAYGROUPS : " + value);
            }
        }
    }

    protected ApiUserContextBase() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public ApiProxyI getProxyI() {
        return this.m_proxyI;
    }

    @Override
    public void setProxyI(ApiProxyI prxy) {
        this.m_proxyI = prxy;
    }

    @Override
    public boolean isProxyInContext() {
        return this.m_proxyI != null;
    }

    @Override
    public boolean isCMDBProxyInContext() {
        return this.m_CMDBproxyI != null;
    }

    @Override
    public void setUserSessionGuid(String guid) {
        this.userSessionGuid = guid;
    }

    @Override
    public String getUserSessionGuid() {
        return this.userSessionGuid;
    }

    public void setImpersonatedUser(String impersonatedUser) {
        this.m_impersonatedUser = impersonatedUser == null || impersonatedUser.length() == 0 ? null : impersonatedUser;
    }

    @Override
    public String getImpersonatedUser() {
        return this.m_impersonatedUser;
    }

    @Override
    public void setImpersonatedCacheId(int cacheId) {
        this.m_impersonatedCacheId = cacheId;
    }

    @Override
    public long getImpersonatedCacheId() {
        return this.m_impersonatedCacheId;
    }

    @Override
    public long getCacheId() {
        return this.m_cacheId;
    }

    @Override
    public void setCacheId(long cacheId) {
        this.m_cacheId = cacheId;
    }

    @Override
    public Timestamp getOperationTime() {
        return this.m_operationTime;
    }

    @Override
    public void setOperationTime(Timestamp operationTime) {
        this.m_operationTime = operationTime;
    }

    @Override
    public void logApiTime(String msg) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
        long time = System.currentTimeMillis();
        String logString = "<CLAT> /* " + formatter.format(time) + " */" + msg + "\n";
        if (this.m_logInterface != null) {
            this.m_logInterface.log(logString);
        } else if (this.getLogging() != null) {
            this.getLogging().log(logString);
        }
    }

    @Override
    public Map<Integer, ApiValueBase> getUserSession() {
        return this.userSession;
    }

    public void setUserSession(Map<Integer, ApiValueBase> userSession) {
        this.userSession = userSession;
    }

    @Override
    public void setAdminFlag(boolean adminFlag) {
        this.m_adminFlag = adminFlag;
    }

    @Override
    public void setCustomFlag(boolean customFlag) {
        this.m_customFlag = customFlag;
    }

    @Override
    public void setSubAdminFlag(boolean subAdminFlag) {
        this.m_subAdminFlag = subAdminFlag;
    }

    @Override
    public void setStructAdminFlag(boolean stadminFlag) {
        this.m_stadminFlag = stadminFlag;
    }

    @Override
    public void setOverlayFlag(boolean overlayFlag) {
        this.m_overlayFlag = overlayFlag;
    }

    @Override
    public void setBaseOverlayFlag(boolean boverlayFlag) {
        this.m_boverlayFlag = boverlayFlag;
    }

    @Override
    public void setStructSubAdminFlag(boolean stsubAdminFlag) {
        this.m_stsubAdminFlag = stsubAdminFlag;
    }

    @Override
    public int getOverlayObjType() {
        return this.overlayObjType;
    }

    @Override
    public void setOverlayObjType(int overlayType) {
        this.overlayObjType = overlayType;
    }

    @Override
    public String getOverlayGroup() {
        return this.overlayGroup;
    }

    @Override
    public void setOverlayGroup(String name) {
        this.overlayGroup = name;
    }

    @Override
    public void setDesignOverlayGroup(String designOverlayGroup) {
        this.cleanLastStatus();
        this.designOverlayGroup = designOverlayGroup;
    }

    @Override
    public String getDesignOverlayGroup() {
        return this.designOverlayGroup;
    }

    @Override
    public int getGranularMode() {
        return this.granularOverlayMode;
    }

    @Override
    public void setGranularMode(int granularOverlayMode) {
        this.granularOverlayMode = granularOverlayMode;
    }

    @Override
    public ApiProxyI getCMDBProxyI() {
        return this.m_CMDBproxyI;
    }

    @Override
    public void setCMDBProxyI(ApiProxyI prxy) {
        this.m_CMDBproxyI = prxy;
    }

    public boolean isProxyInMultiThreadTransaction() {
        boolean flag = false;
        if (this.getTransactionHandle() != null || this.isBulkEntryTxnActive() || !ApiThreadLocalStorageBlock.getTLB().isIgnoreCMTHandle()) {
            flag = true;
        }
        return flag;
    }

    public String getTransactionHandle() {
        return null;
    }

    protected boolean isBulkEntryTxnActive() {
        return false;
    }

    @Override
    public LoggingInfo getLogging() {
        return null;
    }

    protected void deRecodeProxy(ApiProxyI t) {
        if (ProxyManager.isUseConnectionPooling()) {
            ((ApiProxyManager)ProxyManager.getProxyManager()).deRecodeProxy(this, t);
        }
    }

    @Override
    public String getContextInfoStr() {
        String rst = this.getUser() == null ? " a user instance" : this.getUser() + " to " + this.getServerInfoStr();
        return rst;
    }

    @Override
    public String getServerInfoStr() {
        StringBuilder info = new StringBuilder();
        info.append(this.getServer() + (this.getPort() > 0 ? ":" + this.getPort() : ""));
        String url = this.getWebSocketURLKey();
        if (url != null) {
            info.append(" tunneling ").append(url);
        }
        return info.toString();
    }

    public String getWebSocketURLKey() {
        String url = null;
        Map<Object, Object> apiThreadInfo = ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo();
        if (apiThreadInfo != null) {
            return (String)apiThreadInfo.get("webSocket.URL");
        }
        return url;
    }

    @Override
    public LocaleInfo getLocaleInfo() {
        if (this.m_localeInfo == null) {
            this.m_localeInfo = new LocaleInfo();
        }
        return this.m_localeInfo;
    }

    @Override
    public void setLocaleInfo(LocaleInfo localeInfo) {
        this.m_localeInfo = localeInfo;
    }

    public void setUserGenericSessionMap(Map<Object, Object> newUserGenericSessionN) {
        if (newUserGenericSessionN != null && newUserGenericSessionN.get("server") == null) {
            newUserGenericSessionN.put("server", this.getServer());
        }
        this.userGenericSession = newUserGenericSessionN;
    }

    public Map<Object, Object> getUserGenericSessionMap() {
        return this.userGenericSession;
    }

    @Override
    public String getServiceStatMsg() {
        return this.m_serviceStatMsg;
    }

    @Override
    public void setServiceStatMsg(String serviceStatMsg) {
        this.m_serviceStatMsg = serviceStatMsg;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    protected void cleanLastStatus() {
        if (this.getLastStatus() != null) {
            this.getLastStatus().clear();
        }
    }
}

