/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorBase;
import com.bmc.arsys.apitransport.chunking.IARChunkSendable;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arrpc.ArImport15In;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class ARChunkImport
extends ARChunkProcessorBase
implements IARChunkSendable {
    private static Logger logger = Logger.getLogger(ARChunkImport.class);
    private int bytesRemaining;
    private ByteBuffer totalByteBuf;
    private boolean isCompressDone;
    private byte[] originBytes;

    @Override
    public void loadOneChunkToParamIn(int chunkResponseSize, ArRpcXdrIn params) throws ARException {
        byte[] importBytes = ((ArImport15In)params).getImportBuf();
        if (importBytes == null || importBytes.length == 0) {
            return;
        }
        int currentChunkLen = 0;
        int chunkSize = chunkResponseSize - 500;
        byte[] compressedBytes = null;
        byte[] currentChunk = null;
        if (!this.isCompressDone) {
            logger.debug("compressing bytes for import...");
            ARCompressor compresser = new ARCompressor();
            compresser.setInput(importBytes);
            compressedBytes = compresser.deflate();
            this.bytesRemaining = compressedBytes.length;
            logger.debug("the compression finished");
            if (this.bytesRemaining <= chunkSize) {
                this.setChunkingDone(true, params.getControl());
                currentChunk = compressedBytes;
                logger.debug("only one round, and with bytes len " + this.bytesRemaining);
            } else {
                this.setChunkingDone(false, params.getControl());
                this.totalByteBuf = ByteBuffer.allocate(compressedBytes.length);
                this.totalByteBuf.put(compressedBytes);
                this.totalByteBuf.position(0);
            }
            this.originBytes = importBytes;
            this.isCompressDone = true;
        }
        if (currentChunk == null) {
            if (this.bytesRemaining <= chunkSize) {
                currentChunkLen = this.bytesRemaining;
                this.setChunkingDone(true, params.getControl());
                logger.debug("last round with bytes len " + this.bytesRemaining);
            } else {
                currentChunkLen = chunkSize;
                logger.debug(String.format("round %d with bytes len %d", this.getRoundNumber(), currentChunkLen));
            }
            currentChunk = new byte[currentChunkLen];
            this.totalByteBuf.get(currentChunk, 0, currentChunkLen);
        }
        ((ArImport15In)params).setImportBuf(currentChunk);
        this.bytesRemaining -= currentChunk.length;
    }

    public void resetToOriginImportBuf(ArRpcXdrIn paramIn) {
        if (paramIn instanceof ArImport15In) {
            ((ArImport15In)paramIn).setImportBuf(this.originBytes);
        }
    }
}

