/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.LocaleInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;
import java.util.Locale;

@ARStructTypeInfo(Name="ARStatusStruct", NumberOfMembers=4)
public class StatusInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7110006459362220600L;
    @ARStructMemTypeInfo(Name="messageType", Offset=0)
    private int m_messageType;
    @ARStructMemTypeInfo(Name="messageNum", Offset=1)
    private long m_messageNum;
    @ARStructMemTypeInfo(Name="messageText", Offset=2)
    private String m_messageText;
    @ARStructMemTypeInfo(Name="appendedText", Offset=3)
    private String m_appendedText;
    private static final String[] returnTypeStrings = new String[]{"OK", "WARNING", "ERROR", "FATAL", "BAD_STATUS", "PROMPT"};

    public StatusInfo() {
    }

    public StatusInfo(int messageType, long messageNum, String messageText, String appendedText) {
        this.setMessageType(messageType);
        this.setMessageNum(messageNum);
        if (messageText != null) {
            this.setMessageText(messageText);
        }
        if (appendedText != null) {
            this.setAppendedText(appendedText);
        }
    }

    public StatusInfo(int messageType, long messageNum, String appendedText) {
        this.setMessageType(messageType);
        this.setMessageNum(messageNum);
        this.setMessageText(this.readFromCatalog((int)messageNum));
        if (appendedText != null) {
            this.setAppendedText(appendedText);
        }
    }

    public StatusInfo(long messageNum, Locale locale) {
        this.setMessageNum(messageNum);
        this.setMessageText(this.readFromCatalog((int)messageNum, locale));
    }

    private String readFromCatalog(int errorNum) {
        Locale locale = null;
        LocaleInfo localeInfo = ApiThreadLocalStorageBlock.getTLB().getLocaleInfo();
        if (localeInfo != null) {
            locale = localeInfo.getLocale();
        }
        return this.readFromCatalog(errorNum, locale);
    }

    private String readFromCatalog(int errorNum, Locale locale) {
        String msg = "";
        try {
            msg = locale != null ? CatalogReader.getInstance().getMessage(errorNum, locale) : CatalogReader.getInstance().getMessage(errorNum);
        }
        catch (Exception e) {
            msg = msg + errorNum;
        }
        return msg;
    }

    public int getMessageType() {
        return this.m_messageType;
    }

    public void setMessageType(int messageType) {
        this.m_messageType = messageType;
    }

    public long getMessageNum() {
        return this.m_messageNum;
    }

    public void setMessageNum(long messageNum) {
        this.m_messageNum = messageNum;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public void setMessageText(String messageText) {
        this.m_messageText = messageText;
    }

    public String getAppendedText() {
        return this.m_appendedText;
    }

    public void setAppendedText(String appendedText) {
        this.m_appendedText = appendedText.length() > 255 ? appendedText.substring(0, 254) : appendedText;
    }

    private String getReturnCodeAsString(int returnCode) {
        if (returnCode >= 0 && returnCode < returnTypeStrings.length) {
            return returnTypeStrings[returnCode];
        }
        return Integer.toString(returnCode);
    }

    public String toString() {
        return String.format("%s (%d): %s%s%s", this.getReturnCodeAsString(this.m_messageType), this.m_messageNum, this.m_messageText != null ? this.m_messageText : "", this.m_appendedText != null ? "; " : "", this.m_appendedText != null ? this.m_appendedText : "");
    }

    public Object clone() throws CloneNotSupportedException {
        StatusInfo obj = (StatusInfo)super.clone();
        return obj;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_messageType).append(this.m_messageNum).append(this.m_messageText).append(this.m_appendedText).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatusInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StatusInfo rhs = (StatusInfo)obj;
        return new EqualsBuilder().append(this.m_messageType, rhs.m_messageType).append(this.m_messageNum, rhs.m_messageNum).append(this.m_messageText, rhs.m_messageText).append(this.m_appendedText, rhs.m_appendedText).isEquals();
    }
}

