/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ExtendedClassRegistry;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Session;
import com.bmc.arsys.api.SetFieldsFromCurrentScreen;
import com.bmc.arsys.api.SetFieldsFromCurrentTransaction;
import com.bmc.arsys.api.SetFieldsFromFilterAPI;
import com.bmc.arsys.api.SetFieldsFromForm;
import com.bmc.arsys.api.SetFieldsFromSQL;
import com.bmc.arsys.api.SetFieldsFromWebService;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SetFieldsAction
extends Action
implements ActiveLinkAction,
FilterAction,
Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger(SetFieldsAction.class);
    private static final long serialVersionUID = 2836226463662756990L;
    private List<FieldAssignInfo> m_fieldList;
    private String m_sampleForm;
    private String m_sampleServer;
    private String fromServer;
    private String readValuesFrom;

    protected SetFieldsAction() {
    }

    protected SetFieldsAction(List<FieldAssignInfo> fieldList) {
        this.m_fieldList = fieldList;
    }

    protected SetFieldsAction(String sampleSchema, String sampleServer, List<FieldAssignInfo> fieldList) {
        this.m_sampleForm = sampleSchema;
        this.m_sampleServer = sampleServer;
        this.m_fieldList = fieldList;
    }

    public List<FieldAssignInfo> getSetFieldsList() {
        return this.m_fieldList;
    }

    public void setSetFieldsList(List<FieldAssignInfo> fieldList) {
        this.m_fieldList = fieldList;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SetFieldsAction obj = (SetFieldsAction)super.clone();
        if (this.m_fieldList != null) {
            int nLen = this.m_fieldList.size();
            obj.m_fieldList = new ArrayList<FieldAssignInfo>(nLen);
            for (int i = 0; i < nLen; ++i) {
                obj.m_fieldList.add((FieldAssignInfo)this.m_fieldList.get(i).clone());
            }
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SetFieldsAction)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SetFieldsAction rhs = (SetFieldsAction)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_fieldList, rhs.m_fieldList).append(this.m_sampleForm, rhs.m_sampleForm).append(this.m_sampleServer, rhs.m_sampleServer).append(this.fromServer, rhs.fromServer).append(this.readValuesFrom, rhs.readValuesFrom).isEquals();
    }

    @Override
    public boolean equals(Object anObject, String lhsServer, String lhsForm, String rhsServer, String rhsForm) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || !(anObject instanceof SetFieldsAction)) {
            return false;
        }
        SetFieldsAction rhs = (SetFieldsAction)anObject;
        return Util.equalsFieldAssignInfo(this.m_fieldList, rhs.m_fieldList, lhsServer, lhsForm, rhsServer, rhsForm);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_fieldList).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Field List", this.m_fieldList).toString();
    }

    public String getFromServer() {
        return this.fromServer;
    }

    public String getSampleForm() {
        return this.m_sampleForm;
    }

    public void setSampleForm(String sampleForm) {
        this.m_sampleForm = sampleForm;
    }

    public String getSampleServer() {
        return this.m_sampleServer;
    }

    public void setSampleServer(String sampleServer) {
        this.m_sampleServer = sampleServer;
    }

    public void setFromServer(String fromServer) {
        this.fromServer = fromServer;
    }

    public String getReadValuesFrom() {
        return this.readValuesFrom;
    }

    public void setReadValuesFrom(String readValuesFrom) {
        this.readValuesFrom = readValuesFrom;
    }

    private static AssignInfo getFirstARAssignFieldStruct(FieldAssignInfo data) {
        return SetFieldsAction.getFirstARAssignFieldStruct(data.getAssignment());
    }

    private static AssignInfo getFirstARAssignFieldStruct(AssignInfo data) {
        int assignType = data.getAssignType();
        switch (assignType) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 8: {
                return data;
            }
            case 2: {
                return data;
            }
            case 4: {
                return SetFieldsAction.getFirstARAssignFieldStruct(data.getArithOp());
            }
            case 5: {
                return SetFieldsAction.getFirstARAssignFieldStruct(data.getFunction());
            }
            case 7: {
                return data;
            }
        }
        return null;
    }

    private static AssignInfo getFirstARAssignFieldStruct(ArithOpAssignInfo data) {
        AssignInfo ret = SetFieldsAction.getFirstARAssignFieldStruct(data.getOperandRight());
        int operation = data.getOperation();
        if (ret == null && operation != 6) {
            ret = SetFieldsAction.getFirstARAssignFieldStruct(data.getOperandLeft());
        }
        return ret;
    }

    private static AssignInfo getFirstARAssignFieldStruct(FunctionAssignInfo data) {
        List<AssignInfo> paramList = data.getParameterList();
        for (AssignInfo param : paramList) {
            AssignInfo ret = SetFieldsAction.getFirstARAssignFieldStruct(param);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static AssignInfo getFirstARAssignFieldStruct(List<FieldAssignInfo> data) {
        for (FieldAssignInfo item : data) {
            AssignInfo ret = SetFieldsAction.getFirstARAssignFieldStruct(item);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static void fixARAssignFieldStruct(FieldAssignInfo data, String serverName, String formName, QualifierInfo qualifier, String sqlCommand, List<AssignInfo> inputValues, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        AssignInfo assignInfo = data.getAssignment();
        Session session = ctx.getSession();
        if (session != null) {
            session.setCurrentFieldId(data.getFieldId());
        }
        SetFieldsAction.fixARAssignFieldStruct(assignInfo, serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
    }

    private static void fixARAssignFieldStruct(AssignInfo data, String serverName, String formName, QualifierInfo qualifier, String sqlCommand, List<AssignInfo> inputValues, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        int assignType = data.getAssignType();
        switch (assignType) {
            case 0: {
                if (data.getAssignmentAsString() == null) break;
                try {
                    Session session = ctx.getSession();
                    AssignInfo assignInfo = ctx.parseAssignment(session.getCurrentLocalForm(), session.getCurrentFieldId(), session.getCurrentRemoteForm(), data.getAssignmentAsString());
                    data.setAssignType(assignInfo.getAssignType());
                    data.setArithOp(assignInfo.getArithOp());
                    data.setDde(assignInfo.getDde());
                    data.setField(assignInfo.getField());
                    data.setFilterApi(assignInfo.getFilterApi());
                    data.setFunction(assignInfo.getFunction());
                    data.setProcess(assignInfo.getProcess());
                    data.setSql(assignInfo.getSql());
                    data.setValue(assignInfo.getValue());
                }
                catch (ARException e) {
                    logger.debug(e.getLocalizedMessage());
                }
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 8: {
                AssignFilterApiInfo inner = data.getFilterApi();
                if (inner == null) {
                    inner = ExtendedClassRegistry.newInstance(ctx.getExtendedClassRegistry(), AssignFilterApiInfo.class);
                }
                if (serviceName != null && !serviceName.equals("")) {
                    inner.setService(serviceName);
                }
                inner.setInputValues(inputValues);
                data.setFilterApi(inner);
                return;
            }
            case 2: {
                AssignFieldInfo inner = data.getField();
                if (inner == null) {
                    inner = ExtendedClassRegistry.newInstance(ctx.getExtendedClassRegistry(), AssignFieldInfo.class);
                }
                inner.setServer(serverName);
                inner.setForm(formName);
                inner.setQualifier(qualifier);
                inner.setNoMatchOption(noMatchOption);
                inner.setMultiMatchOption(multiMatchOption);
                data.setField(inner);
                return;
            }
            case 4: {
                ArithOpAssignInfo inner = data.getArithOp();
                SetFieldsAction.fixARAssignFieldStruct(inner, serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
                return;
            }
            case 5: {
                FunctionAssignInfo inner = data.getFunction();
                SetFieldsAction.fixARAssignFieldStruct(inner, serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
                return;
            }
            case 7: {
                AssignSQLInfo inner = data.getSql();
                if (inner == null) {
                    inner = ExtendedClassRegistry.newInstance(ctx.getExtendedClassRegistry(), AssignSQLInfo.class);
                }
                inner.setServer(serverName);
                inner.setSqlCommand(sqlCommand);
                inner.setNoMatchOption(noMatchOption);
                inner.setMultiMatchOption(multiMatchOption);
                return;
            }
        }
    }

    private static void fixARAssignFieldStruct(ArithOpAssignInfo data, String serverName, String formName, QualifierInfo qualifier, String sqlCommand, List<AssignInfo> inputValues, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        SetFieldsAction.fixARAssignFieldStruct(data.getOperandRight(), serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
        if (data.getOperation() != 6) {
            SetFieldsAction.fixARAssignFieldStruct(data.getOperandLeft(), serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
        }
    }

    private static void fixARAssignFieldStruct(FunctionAssignInfo data, String serverName, String formName, QualifierInfo qualifier, String sqlCommand, List<AssignInfo> inputValues, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        List<AssignInfo> assignList = data.getParameterList();
        if (assignList == null || assignList.size() <= 0) {
            return;
        }
        for (AssignInfo assignInfo : assignList) {
            SetFieldsAction.fixARAssignFieldStruct(assignInfo, serverName, formName, qualifier, sqlCommand, inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
        }
    }

    static void fixARAssignFieldStruct(List<FieldAssignInfo> data, String serverName, String formName, QualifierInfo qualifier, String sqlCommand, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        if (data == null || data.size() <= 0) {
            return;
        }
        for (FieldAssignInfo assignInfo : data) {
            SetFieldsAction.fixARAssignFieldStruct(assignInfo, serverName, formName, qualifier, sqlCommand, null, serviceName, noMatchOption, multiMatchOption, ctx);
        }
    }

    static void fixARAssignFieldStruct(List<FieldAssignInfo> data, List<AssignInfo> inputValues, String serviceName, int noMatchOption, int multiMatchOption, ARServerUser ctx) {
        if (data == null || data.size() <= 0) {
            return;
        }
        for (FieldAssignInfo assignInfo : data) {
            SetFieldsAction.fixARAssignFieldStruct(assignInfo, "", "", null, "", inputValues, serviceName, noMatchOption, multiMatchOption, ctx);
        }
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
    }

    @Override
    Object toVariant(ARServerUser ctx) {
        Object[] var = (Object[])super.toVariant(ctx);
        Object[] varInner = new Object[3];
        varInner[0] = ARTypeMgr.getInstance().ObjectListToVariant(this.m_fieldList, ctx);
        var[1] = varInner;
        return var;
    }

    static SetFieldsAction createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ArrayList<FieldAssignInfo> fieldAssignList = ARTypeMgr.getInstance().ObjectListFromVariant(FieldAssignInfo.class, (Object[])ARTypeMgr.GetAt((Object)rawData, new int[]{0}), ctx);
        String sampleServer = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
        String sampleForm = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 2));
        return SetFieldsAction.createInstance(fieldAssignList, sampleServer, sampleForm, ctx);
    }

    private static SetFieldsAction createInstance(List<FieldAssignInfo> fieldAssignList, String sampleServer, String sampleForm, ARServerUser ctx) {
        if (fieldAssignList == null) {
            return null;
        }
        String fromServer = "*";
        String fromForm = "@";
        SetFieldsAction obj = null;
        AssignInfo firstAssignment = SetFieldsAction.getFirstARAssignFieldStruct(fieldAssignList);
        int firstAssignmentType = firstAssignment == null ? 0 : firstAssignment.getAssignType();
        switch (firstAssignmentType) {
            case 8: {
                SetFieldsFromFilterAPI sffa;
                if ("ARSYS.ARF.WEBSERVICE".equals(firstAssignment.getFilterApi().getService())) {
                    sffa = ARTypeMgr.getInstance().NewObject(SetFieldsFromWebService.class, ctx);
                } else {
                    sffa = ARTypeMgr.getInstance().NewObject(SetFieldsFromFilterAPI.class, ctx);
                    sffa.setReadValuesFrom("FILTERAPI");
                }
                sffa.setServiceName(firstAssignment.getFilterApi().getService());
                try {
                    sffa.setInputAssignList(SetFieldsFromFilterAPI.buildInputAssignList(firstAssignment.getFilterApi().getInputValues(), ctx));
                }
                catch (ARException e) {
                    logger.error("createInstance(Object[], ARServerUser)", e);
                }
                obj = sffa;
                break;
            }
            case 2: {
                AssignFieldInfo assgnFieldInfo = firstAssignment.getField();
                if (assgnFieldInfo != null) {
                    fromServer = assgnFieldInfo.getServer();
                    fromForm = assgnFieldInfo.getForm();
                }
                if ("*".equals(fromForm) || "@".equals(fromForm)) {
                    if (ctx.getCurrentObj() == 6) {
                        obj = new SetFieldsFromCurrentScreen();
                        break;
                    }
                    obj = new SetFieldsFromCurrentTransaction();
                    break;
                }
                SetFieldsFromForm sff = new SetFieldsFromForm();
                sff.setSampleServer(sampleServer);
                sff.setSampleForm(sampleForm);
                ctx.getSession().setSecondaryServerName(fromServer, sff.getSampleServer());
                ctx.getSession().setCurrentRemoteForm(fromForm, sff.getSampleForm());
                QualifierInfo setIfQualification = assgnFieldInfo.getQualifier();
                if (setIfQualification != null) {
                    sff.setSetIfQualification(setIfQualification);
                    if (Config.getInstance().isStringizeSetIfQualification()) {
                        try {
                            ARServerUser tempCtx = ctx.getSession().getServer(ctx.getSession().getSecondaryServerName());
                            String setIfQualificationAsString = tempCtx.formatSetIfQualification(ctx.getSession().getCurrentRemoteForm(), ctx.getSession().getCurrentLocalForm(), setIfQualification);
                            sff.setSetIfQualification(setIfQualificationAsString);
                        }
                        catch (ARException e) {
                            logger.error("createInstance(Object[], ARServerUser)", e);
                        }
                    }
                }
                sff.setNoMatchOption(assgnFieldInfo.getNoMatchOption());
                sff.setMultiMatchOption(assgnFieldInfo.getMultiMatchOption());
                obj = sff;
                break;
            }
            case 7: {
                SetFieldsFromSQL sfsql = new SetFieldsFromSQL();
                AssignSQLInfo sqlInfo = firstAssignment.getSql();
                if (sqlInfo != null) {
                    fromServer = sqlInfo.getServer();
                    sfsql.setFromServer(fromServer);
                    sfsql.setReadValuesFrom("SQL");
                    sfsql.setSqlCommand(sqlInfo.getSqlCommand());
                    sfsql.setNoMatchOption(sqlInfo.getNoMatchOption());
                    sfsql.setMultiMatchOption(sqlInfo.getMultiMatchOption());
                }
                obj = sfsql;
                break;
            }
            default: {
                obj = ctx.getCurrentObj() == 6 ? new SetFieldsFromCurrentScreen() : new SetFieldsFromCurrentTransaction();
            }
        }
        if (obj != null) {
            obj.setFromServer(fromServer);
            obj.setReadValuesFrom(fromForm);
            if (Config.getInstance().isStringizeFieldAssignments()) {
                OutputInteger isByMatchingIds = new OutputInteger(0);
                OutputInteger isSetToDefaults = new OutputInteger(0);
                try {
                    FieldAssignInfo.buildFieldAssignmentList(ctx.getSession().getServer(ctx.getSession().getSecondaryServerName()), ctx.getSession().getCurrentLocalForm(), ctx.getSession().getCurrentRemoteForm(), isByMatchingIds, isSetToDefaults, fieldAssignList);
                }
                catch (ARException e) {
                    logger.error("createInstance(Object[], ARServerUser)", e);
                }
            }
            obj.setSetFieldsList(fieldAssignList);
        }
        return obj;
    }

    static SetFieldsAction createInstance(ARServerUser context, String sampleServer, String sampleForm, List<FieldAssignInfo> fieldList) {
        SetFieldsAction obj = SetFieldsAction.createInstance(fieldList, sampleServer, sampleForm, context);
        if (context != null && context.getExtendedClassRegistry() != null && context.getExtendedClassRegistry().isExtendingClassRegistered(SetFieldsAction.class)) {
            obj = context.getExtendedClassRegistry().newInstance(obj);
        }
        return obj;
    }
}

