/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CriteriaFlags;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.IARPersistentObject;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ObjectBase
implements IARPersistentObject,
Cloneable {
    private static final long serialVersionUID = -1884909985194732077L;
    private static Logger logger = Logger.getLogger(ObjectBase.class);
    @ARStructMemTypeInfo(Name="name", Offset=0)
    private String m_name;
    private String m_newName;
    @ARStructMemTypeInfo(Name="permissionList", Offset=1)
    protected List<PermissionInfo> m_permissionList;
    @ARStructMemTypeInfo(Name="helpText", Offset=2)
    private String m_helpText;
    @ARStructMemTypeInfo(Name="lastUpdateTime", Offset=3)
    private Timestamp m_lastUpdateTime;
    @ARStructMemTypeInfo(Name="owner", Offset=4)
    private String m_owner;
    @ARStructMemTypeInfo(Name="lastChangedBy", Offset=5)
    private String m_lastChangedBy;
    @ARStructMemTypeInfo(Name="diaryStr", Offset=6)
    private DiaryListValue m_diaryList;
    protected ObjectBaseCriteria m_changeFlags;
    protected Integer[] hashValues = null;

    protected ObjectBase() {
        this.m_name = "";
        this.m_newName = "";
        this.m_permissionList = new ArrayList<PermissionInfo>();
        this.m_helpText = "";
        this.m_lastUpdateTime = new Timestamp();
        this.m_owner = "";
        this.m_lastChangedBy = "";
        this.m_diaryList = new DiaryListValue();
    }

    protected ObjectBase(String name, List<PermissionInfo> permissionList, String helpText, long lastUpdateTime, String owner, String lastChangedBy, String diaryStr) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.m_name = name;
        if (permissionList == null || permissionList.isEmpty()) {
            this.m_permissionList = permissionList;
        } else {
            this.setPermissions(permissionList);
        }
        if (helpText == null || helpText.length() <= 0) {
            this.m_helpText = helpText;
        } else {
            this.setHelpText(helpText);
        }
        if (lastUpdateTime == 0L) {
            this.m_lastUpdateTime = new Timestamp();
        } else {
            this.setLastUpdateTime(lastUpdateTime);
        }
        if (owner == null || owner.length() <= 0) {
            this.m_owner = owner;
        } else {
            this.setOwner(owner);
        }
        if (lastChangedBy == null || lastChangedBy.length() <= 0) {
            this.m_lastChangedBy = lastChangedBy;
        } else {
            this.setLastChangedBy(lastChangedBy);
        }
        if (diaryStr == null || diaryStr.length() <= 0) {
            this.m_diaryList = this.decodeDiaryString(diaryStr);
        } else {
            this.setDiary(diaryStr);
        }
    }

    protected void createChangeFlags() {
        this.m_changeFlags = new ObjectBaseCriteria(8);
    }

    public void clear() {
        this.m_name = null;
        this.m_newName = null;
        this.m_permissionList = null;
        this.m_helpText = null;
        this.m_lastUpdateTime = null;
        this.m_owner = null;
        this.m_lastChangedBy = null;
        this.m_diaryList = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ObjectBase base = (ObjectBase)super.clone();
        if (this.m_permissionList != null) {
            base.m_permissionList = new ArrayList<PermissionInfo>(this.m_permissionList.size());
            for (int i = 0; i < this.m_permissionList.size(); ++i) {
                base.m_permissionList.add((PermissionInfo)this.m_permissionList.get(i).clone());
            }
        }
        if (this.m_lastUpdateTime != null) {
            base.m_lastUpdateTime = (Timestamp)this.m_lastUpdateTime.clone();
        }
        if (this.m_diaryList != null) {
            base.m_diaryList = (DiaryListValue)this.m_diaryList.clone();
        }
        if (this.m_changeFlags != null) {
            base.m_changeFlags = (ObjectBaseCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return base;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNewName() {
        return this.m_newName;
    }

    @Override
    public void setNewName(String newName) {
        this.m_newName = newName;
        if (this.m_name != null && this.m_name.length() == 0) {
            this.m_name = newName;
        }
        this.m_changeFlags.setParameter(0L, true);
    }

    @Override
    public List<PermissionInfo> getPermissions() {
        return this.m_permissionList;
    }

    @Override
    public void setPermissions(List<PermissionInfo> permissions) {
        this.m_permissionList = permissions;
        this.m_changeFlags.setParameter(1L, true);
    }

    @Override
    public String getHelpText() {
        return this.m_helpText;
    }

    @Override
    public void setHelpText(String helpText) {
        this.m_helpText = helpText;
        this.m_changeFlags.setParameter(2L, true);
    }

    @Override
    public Timestamp getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    protected void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.m_lastUpdateTime = lastUpdateTime;
        this.m_changeFlags.setParameter(5L, true);
    }

    protected void setLastUpdateTime(long time) {
        this.setLastUpdateTime(new Timestamp(time));
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(String owner) {
        this.m_owner = owner;
        this.m_changeFlags.setParameter(3L, true);
    }

    @Override
    public String getLastChangedBy() {
        return this.m_lastChangedBy;
    }

    @Override
    public void setLastChangedBy(String changedBy) {
        this.m_lastChangedBy = changedBy;
        this.m_changeFlags.setParameter(6L, true);
    }

    @Override
    public DiaryListValue getDiary() {
        return this.m_diaryList;
    }

    @Override
    public void setDiary(DiaryListValue diary) {
        this.m_diaryList = diary;
        this.m_changeFlags.setParameter(4L, true);
    }

    private DiaryListValue decodeDiaryString(String encoded) {
        DiaryListValue diaryListValue = null;
        try {
            diaryListValue = DiaryListValue.decode(encoded);
        }
        catch (ARException e) {
            logger.error("Error in setDiary, String=" + encoded, e);
        }
        return diaryListValue;
    }

    public void setDiary(String encoded) {
        this.setDiary(this.decodeDiaryString(encoded));
        this.m_changeFlags.setParameter(4L, true);
    }

    @Override
    public void appendDiaryText(String appendedText) {
        this.m_diaryList.setAppendedText(appendedText);
        this.m_changeFlags.setParameter(4L, true);
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public void setChangeFlags(ObjectBaseCriteria criteria) {
        try {
            this.m_changeFlags = (ObjectBaseCriteria)(criteria != null ? criteria.clone() : null);
        }
        catch (CloneNotSupportedException e) {
            logger.debug(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectBase)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ObjectBase rhs = (ObjectBase)obj;
        return new EqualsBuilder().append(this.m_name, rhs.m_name).append(this.m_newName, rhs.m_newName).append(this.m_permissionList, rhs.m_permissionList).append(this.m_helpText, rhs.m_helpText).append(this.m_lastUpdateTime, rhs.m_lastUpdateTime).append(this.m_owner, rhs.m_owner).append(this.m_lastChangedBy, rhs.m_lastChangedBy).append(this.m_diaryList, rhs.m_diaryList).append(this.m_changeFlags, rhs.m_changeFlags).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_name).append(this.m_newName).append(this.m_permissionList).append(this.m_helpText).append(this.m_lastUpdateTime).append(this.m_owner).append(this.m_lastChangedBy).append(this.m_diaryList).append(this.m_changeFlags).toHashCode();
    }

    public CriteriaFlags getChangeFlags() {
        return this.m_changeFlags;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Name", this.m_name).append("New Name", this.m_newName).append("Permission List", this.m_permissionList).append("Help Text", this.m_helpText).append("Last Update Time", this.m_lastUpdateTime).append("Owner", this.m_owner).append("Last Changed By", this.m_lastChangedBy).append("Diary List", this.m_diaryList).append("Change Flags", this.m_changeFlags).toString();
    }

    void calculateHashCode() {
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        this.hashValues[1] = this.m_permissionList != null && !this.m_permissionList.isEmpty() ? Integer.valueOf(this.m_permissionList.hashCode()) : null;
        this.hashValues[4] = this.m_diaryList != null && !this.m_diaryList.isEmpty() ? Integer.valueOf(this.m_diaryList.hashCode()) : null;
    }

    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        ObjectBaseCriteria resetFlagCrit = null;
        if (criteria != null) {
            try {
                resetFlagCrit = (ObjectBaseCriteria)criteria.clone();
                resetFlagCrit.resetCriteriaFlags();
            }
            catch (CloneNotSupportedException e) {
                logger.debug(e);
            }
        }
        this.setChangeFlags(resetFlagCrit);
        this.calculateHashCode();
    }

    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            throw new IllegalArgumentException("hashValues has not been initialized");
        }
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[1]) {
            if (this.m_permissionList != null && !this.m_permissionList.isEmpty()) {
                hashCode = this.m_permissionList.hashCode();
                if (this.hashValues[1] == null || hashCode != this.hashValues[1]) {
                    this.m_changeFlags.setParameter(1L, true);
                }
                this.hashValues[1] = this.m_permissionList != null && !this.m_permissionList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[1] != null) {
                this.m_changeFlags.setParameter(1L, true);
                this.hashValues[1] = null;
            }
        }
        if (!changeFlags[4]) {
            if (this.m_diaryList != null && (this.m_diaryList.size() != 0 || this.m_diaryList.getAppendedText() != null)) {
                hashCode = this.m_diaryList.hashCode();
                if (this.hashValues[4] == null || hashCode != this.hashValues[4]) {
                    this.m_changeFlags.setParameter(4L, true);
                }
                this.hashValues[4] = this.m_diaryList != null && !this.m_diaryList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[4] != null) {
                this.m_changeFlags.setParameter(4L, true);
                this.hashValues[4] = null;
            }
        }
    }
}

