/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEngineFactory;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.EvpEncryptionBase;
import java.security.Key;
import javax.crypto.Cipher;

public class KeyExchangeEncryption
extends EvpEncryptionBase {
    private transient ARPPKey arPPKey;

    public KeyExchangeEncryption(ARPPKey arPPKey) {
        this.arPPKey = arPPKey;
    }

    public byte[] encrypt(byte[] inputBytes) throws AREncryptionException {
        return this.encryptDecrypt(inputBytes, this.getRsaKey(), 1);
    }

    public byte[] encrypt(byte[] inputBytes, Key key) throws AREncryptionException {
        return this.encryptDecrypt(inputBytes, key, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptDecrypt(byte[] inputBytes, Key key, int mode) throws AREncryptionException {
        byte[] encryptedCipher;
        ARPPKey aRPPKey = this.arPPKey;
        synchronized (aRPPKey) {
            Cipher cipher;
            this.arPPKey.setEncMode(mode);
            Cipher cipher2 = cipher = (Cipher)AREncEngineFactory.getInstance().getEncEngineInstance(this.arPPKey.getEncType(), this.arPPKey);
            synchronized (cipher2) {
                try {
                    try {
                        cipher.init(mode, key);
                    }
                    catch (Throwable e) {
                        throw new AREncryptionException(e, 9006);
                    }
                    encryptedCipher = this.evpEncryptDecrypt(cipher, inputBytes);
                }
                finally {
                    AREncEngineFactory.getInstance().releaseEncEngineInstance(this.arPPKey, cipher);
                }
            }
        }
        return encryptedCipher;
    }

    public byte[] decrypt(byte[] inputBytes) throws AREncryptionException {
        return this.encryptDecrypt(inputBytes, this.getRsaKey(), 2);
    }

    public byte[] decrypt(byte[] inputBytes, Key key) throws AREncryptionException {
        return this.encryptDecrypt(inputBytes, key, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getRsaKey() throws AREncryptionException {
        Key key;
        ARPPKey aRPPKey = this.arPPKey;
        synchronized (aRPPKey) {
            key = this.arPPKey.getRsaKey();
        }
        return key;
    }
}

