/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CentralConfig {
    public static final String AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM = "AR System Configuration Component Setting";
    private static final String AR_SYSTEM_CONFIGURATION_COMPONENT_FORM = "AR System Configuration Component";
    private static final int AR_SYSTEM_CONFIG_COMP_FIELD_NAME = 3200;
    private static final int AR_SYSTEM_CONFIG_COMP_FIELD_STATUS = 7;
    private static final int AR_SYSTEM_CONFIG_COMP_FIELD_TYPE = 3201;
    private static final int AR_SYSTEM_CONFIG_COMP_FIELD_DESC = 3202;
    private static final int AR_SYSTEM_CONFIG_COMP_FIELD_GUID = 179;
    private static final int AR_SYSTEM_SETTING_FIELD_SETTING_NAME = 3204;
    private static final int AR_SYSTEM_SETTING_FIELD_SETTING_VALUE = 3205;
    private static final int AR_SYSTEM_CONFIG_COMPONENT_GUID = 3207;
    private static final int AR_SYSTEM_CONFIG_ENTRY_ID = 1;
    private static final int FIELD_STATUS_ACTIVE = 0;
    private static final int FIELD_STATUS_INACTIVE = 1;

    public static String createComponentEntry(ARServerUser context, String componentName, String componentType, String componentDescription, boolean status) throws ARException {
        Entry thisEntry = new Entry();
        String newEntryGUID = null;
        thisEntry.put(Integer.valueOf(3200), new Value(componentName));
        thisEntry.put(Integer.valueOf(3201), new Value(componentType));
        thisEntry.put(Integer.valueOf(3202), new Value(componentType));
        if (status) {
            thisEntry.put(Integer.valueOf(7), new Value(0));
        } else {
            thisEntry.put(Integer.valueOf(7), new Value(1));
        }
        String EntryID = context.createEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, thisEntry);
        thisEntry = context.getEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, EntryID, new int[]{179});
        if (thisEntry != null) {
            newEntryGUID = ((Value)thisEntry.get((Object)179)).toString();
        }
        return newEntryGUID;
    }

    public static void updateOlderComponents(ARServerUser context, String componentNamePrefix, String componentType, String description, boolean status) throws ARException {
        List<Entry> activeOlderComponents = CentralConfig.getComponentWithPrefix(context, componentNamePrefix, componentType);
        if (activeOlderComponents != null && activeOlderComponents.size() > 0) {
            for (Entry entry : activeOlderComponents) {
                String componentGUID;
                if (entry.get((Object)179) == null || (componentGUID = ((Value)entry.get((Object)179)).toString()) == null) continue;
                CentralConfig.updateComponent(context, componentGUID, null, componentType, description, status);
            }
        }
    }

    public static List<Entry> getComponentWithPrefix(ARServerUser context, String componentNamePrefix, String componentType) throws ARException {
        QualifierInfo activeConfigQual = CentralConfig.getQualifierForConfigSetting(componentNamePrefix + "%", componentType, null, 7);
        int[] fieldIds = new int[]{1, 179};
        OutputInteger numberReturned = new OutputInteger(-1);
        ArrayList<Entry> configComponentEntries = new ArrayList<Entry>();
        while (configComponentEntries == null || numberReturned.intValue() != configComponentEntries.size()) {
            List tempConfigSettingEntries = context.getListEntryObjects(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, activeConfigQual, configComponentEntries.size(), 0, null, fieldIds, false, numberReturned);
            configComponentEntries.addAll(tempConfigSettingEntries);
            if (configComponentEntries.size() != 0) continue;
            return null;
        }
        return configComponentEntries;
    }

    public static Entry getActiveComponent(ARServerUser context, String componentName, String componentType) throws ARException {
        QualifierInfo qualifier = CentralConfig.getQualifierForConfigSetting(componentName, componentType, null);
        ArithmeticOrRelationalOperand fieldOp = new ArithmeticOrRelationalOperand(7);
        ArithmeticOrRelationalOperand valueOp = new ArithmeticOrRelationalOperand(new Value(0));
        RelationalOperationInfo relQual = new RelationalOperationInfo(1, fieldOp, valueOp);
        QualifierInfo statusQual = new QualifierInfo(relQual);
        qualifier = new QualifierInfo(1, qualifier, statusQual);
        int[] fieldIds = new int[]{1, 179};
        Entry componentEntry = context.getOneEntryObject(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, qualifier, null, fieldIds, false, null);
        return componentEntry;
    }

    public static int createSettingEntries(ARServerUser context, String componentGUID, String componentName, String componentType, List<String[]> nameValuePair) throws ARException {
        Iterator<String[]> configIter = nameValuePair.iterator();
        int count = 0;
        while (configIter.hasNext()) {
            String[] thisNameValue = configIter.next();
            Entry thisEntry = new Entry();
            thisEntry.put(Integer.valueOf(3200), new Value(componentName));
            thisEntry.put(Integer.valueOf(3201), new Value(componentType));
            thisEntry.put(Integer.valueOf(3207), new Value(componentGUID));
            thisEntry.put(Integer.valueOf(3204), new Value(thisNameValue[0]));
            thisEntry.put(Integer.valueOf(3205), new Value(thisNameValue[1]));
            context.createEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, thisEntry);
            ++count;
        }
        return count;
    }

    public static void setSettingEntries(ARServerUser context, String entryID, String componentGUID, String componentName, String componentType, String settingName, String settingValue) throws ARException {
        Entry thisEntry = new Entry();
        if (componentName != null) {
            thisEntry.put(Integer.valueOf(3200), new Value(componentName));
        }
        if (componentType != null) {
            thisEntry.put(Integer.valueOf(3201), new Value(componentType));
        }
        if (componentGUID != null) {
            thisEntry.put(Integer.valueOf(3207), new Value(componentGUID));
        }
        if (settingName != null) {
            thisEntry.put(Integer.valueOf(3204), new Value(settingName));
        }
        if (settingValue != null) {
            thisEntry.put(Integer.valueOf(3205), new Value(settingValue));
        }
        context.setEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, entryID, thisEntry, null, 0);
    }

    private static QualifierInfo getQualifierForConfigSetting(String activeConfigName, String componentType, String settingName, int relationForComponent) {
        QualifierInfo nameGUIDQualifier = new QualifierInfo();
        QualifierInfo activeSettingValueQualifier = new QualifierInfo();
        ArithmeticOrRelationalOperand nameQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3200);
        ArithmeticOrRelationalOperand nameQualifierRight = new ArithmeticOrRelationalOperand(new Value(activeConfigName));
        QualifierInfo nameQualifier = new QualifierInfo(new RelationalOperationInfo(relationForComponent, nameQualifierLeft, nameQualifierRight));
        ArithmeticOrRelationalOperand componentQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3201);
        ArithmeticOrRelationalOperand componentQualifierRight = new ArithmeticOrRelationalOperand(new Value(componentType));
        QualifierInfo componentQualifier = new QualifierInfo(new RelationalOperationInfo(1, componentQualifierLeft, componentQualifierRight));
        ArithmeticOrRelationalOperand statusQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 7);
        ArithmeticOrRelationalOperand statusQualifierRight = new ArithmeticOrRelationalOperand(new Value(0));
        QualifierInfo statusQualifier = new QualifierInfo(new RelationalOperationInfo(1, statusQualifierLeft, statusQualifierRight));
        nameGUIDQualifier.setOperation(1);
        nameGUIDQualifier.setLeftOperand(nameQualifier);
        nameGUIDQualifier.setRightOperand(statusQualifier);
        if (settingName == null) {
            activeSettingValueQualifier.setOperation(1);
            activeSettingValueQualifier.setLeftOperand(componentQualifier);
            activeSettingValueQualifier.setRightOperand(nameGUIDQualifier);
        } else {
            ArithmeticOrRelationalOperand settingQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3204);
            ArithmeticOrRelationalOperand settingQualifierRight = new ArithmeticOrRelationalOperand(new Value(settingName));
            QualifierInfo settingQualifier = new QualifierInfo(new RelationalOperationInfo(7, settingQualifierLeft, settingQualifierRight));
            QualifierInfo activeConfigQualifier = new QualifierInfo();
            activeConfigQualifier.setOperation(1);
            activeConfigQualifier.setLeftOperand(componentQualifier);
            activeConfigQualifier.setRightOperand(nameGUIDQualifier);
            activeSettingValueQualifier.setOperation(1);
            activeSettingValueQualifier.setLeftOperand(activeConfigQualifier);
            activeSettingValueQualifier.setRightOperand(settingQualifier);
        }
        return activeSettingValueQualifier;
    }

    public static List<String[]> getConfigSettingsAsList(ARServerUser context, String configName, String configType, String settingName) throws ARException {
        QualifierInfo activeConfigQual = CentralConfig.getQualifierForConfigSetting(configName, configType, settingName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3204, 3205};
        ArrayList<String[]> nameValuePair = new ArrayList<String[]>();
        OutputInteger numberReturned = new OutputInteger(-1);
        ArrayList configSettingEntries = new ArrayList();
        while (numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = context.getListEntryObjects(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        for (Entry thisEntry : configSettingEntries) {
            String[] thisNameValue = new String[2];
            Value thisSettingName = (Value)thisEntry.get((Object)3204);
            Value thisSettingValue = (Value)thisEntry.get((Object)3205);
            if (thisSettingName == null) continue;
            thisNameValue[0] = thisSettingName.toString();
            thisNameValue[1] = thisSettingValue.toString();
            nameValuePair.add(thisNameValue);
        }
        return nameValuePair;
    }

    private static QualifierInfo getQualifierForConfigSetting(String configName, String configType, String settingName) {
        return CentralConfig.getQualifierForConfigSetting(configName, configType, settingName, 1);
    }

    public static String getEntryValue(Entry thisEntry) {
        Value thisValue = (Value)thisEntry.get((Object)3205);
        if (thisValue != null && thisValue.getDataType() == DataType.CHAR) {
            return thisValue.toString();
        }
        return null;
    }

    public static List<Entry> getConfigSettingsWithEntryIDs(ARServerUser context, String configName, String configType, String settingName) throws ARException {
        return CentralConfig.getConfigSettingsWithEntryIDs(context, configName, configType, settingName, 1);
    }

    public static List<Entry> getConfigSettingsWithEntryIDs(ARServerUser context, String configName, String configType, String settingName, int relationOPForCompName) throws ARException {
        OutputInteger numberReturned = new OutputInteger(-1);
        QualifierInfo activeConfigQual = CentralConfig.getQualifierForConfigSetting(configName, configType, settingName, relationOPForCompName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3207, 3204, 3205};
        ArrayList<Entry> configSettingEntries = new ArrayList<Entry>();
        while (configSettingEntries == null || numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = context.getListEntryObjects(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        return configSettingEntries;
    }

    public static String getComponentGUIDFromEntry(Entry thisEntry) {
        Value thisValue = (Value)thisEntry.get((Object)179);
        if (thisValue != null && thisValue.getDataType() == DataType.CHAR) {
            return thisValue.toString();
        }
        return null;
    }

    public static Map<String, List<String>> getConfigSettingsAsMap(ARServerUser context, String configName, String configType, String settingName) throws ARException {
        OutputInteger numberReturned = new OutputInteger(-1);
        QualifierInfo activeConfigQual = CentralConfig.getQualifierForConfigSetting(configName, configType, settingName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3204, 3205};
        ArrayList configSettingEntries = new ArrayList();
        while (numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = context.getListEntryObjects(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        HashMap<String, List<String>> hmSettings = new HashMap<String, List<String>>();
        for (Entry thisEntry : configSettingEntries) {
            Value thisSettingName = (Value)thisEntry.get((Object)3204);
            Value thisSettingValue = (Value)thisEntry.get((Object)3205);
            if (thisSettingName == null || thisSettingName.getValue() == null || thisSettingValue == null) continue;
            if (hmSettings.containsKey(thisSettingName.getValue())) {
                ((List)hmSettings.get(thisSettingName.getValue())).add(thisSettingValue.toString());
                continue;
            }
            ArrayList<String> settings = new ArrayList<String>();
            settings.add(thisSettingValue.toString());
            hmSettings.put(thisSettingName.toString(), settings);
        }
        return hmSettings;
    }

    public static void changeComponentStatus(ARServerUser context, String componentGUID, boolean status) throws ARException {
        String entryId = CentralConfig.getEntryIdFromGUID(context, componentGUID);
        if (entryId != null) {
            Entry entryToUpdate = new Entry();
            int updateStatus = status ? 0 : 1;
            entryToUpdate.put(Integer.valueOf(7), new Value(updateStatus));
            entryToUpdate.put(Integer.valueOf(179), new Value(componentGUID));
            context.setEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, entryId, entryToUpdate, new Timestamp(), 0);
        }
    }

    public static void updateComponent(ARServerUser context, String componentGUID, String componentName, String componentType, String componentDescription, boolean status) throws ARException {
        String entryId = CentralConfig.getEntryIdFromGUID(context, componentGUID);
        if (entryId != null) {
            Entry entryToUpdate = new Entry();
            int updateStatus = status ? 0 : 1;
            entryToUpdate.put(Integer.valueOf(7), new Value(updateStatus));
            if (componentName != null) {
                entryToUpdate.put(Integer.valueOf(3200), new Value(componentName));
            }
            if (componentType != null) {
                entryToUpdate.put(Integer.valueOf(3201), new Value(componentType));
            }
            if (componentDescription != null) {
                entryToUpdate.put(Integer.valueOf(3202), new Value(componentDescription));
            }
            entryToUpdate.put(Integer.valueOf(179), new Value(componentGUID));
            context.setEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, entryId, entryToUpdate, new Timestamp(), 0);
        }
    }

    private static String getEntryIdFromGUID(ARServerUser context, String componentGUID) throws ARException {
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(179);
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(componentGUID));
        RelationalOperationInfo rInfo = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo qInfo = new QualifierInfo(rInfo);
        int[] fieldComponents = new int[]{179, CoreFieldId.EntryId.getFieldId()};
        List componentEntries = context.getListEntryObjects(AR_SYSTEM_CONFIGURATION_COMPONENT_FORM, qInfo, 0, 2, new ArrayList(), fieldComponents, false, null);
        if (componentEntries != null && componentEntries.size() > 0) {
            Iterator itrEntry = componentEntries.iterator();
            Entry oEntry = null;
            Value avalue = null;
            if (itrEntry.hasNext() && (avalue = (Value)(oEntry = (Entry)itrEntry.next()).get((Object)CoreFieldId.EntryId.getFieldId())) != null) {
                return (String)avalue.getValue();
            }
        }
        return null;
    }

    public static void updateConfigSetting(ARServerUser context, String settingEntryID, String settingName, String settingValue) throws ARException {
        CentralConfig.setSettingEntries(context, settingEntryID, null, null, null, settingName, settingValue);
    }

    public static void updateOrCreateSetting(ARServerUser context, String componentGUID, String componentName, String componentType, String settingName, String settingValue) throws ARException {
        Map<String, List<String>> configSettingsAsMap = CentralConfig.getConfigSettingsAsMap(context, componentName, componentType, settingName);
        if (configSettingsAsMap == null || configSettingsAsMap.size() == 0) {
            String[] values = new String[]{settingName, settingValue};
            ArrayList<String[]> alSettings = new ArrayList<String[]>();
            alSettings.add(values);
            CentralConfig.createSettingEntries(context, componentGUID, componentName, componentType, alSettings);
        } else {
            List<Entry> configSettingsWithEntryIDs = CentralConfig.getConfigSettingsWithEntryIDs(context, componentName, componentType, settingName, 1);
            for (Entry thisEntry : configSettingsWithEntryIDs) {
                CentralConfig.setSettingEntries(context, thisEntry.getEntryId(), componentGUID, componentName, componentType, settingName, settingValue);
            }
        }
    }

    public static boolean deleteSetting(ARServerUser context, String componentName, String componentType, String settingName, String settingValue) throws ARException {
        boolean deleted = false;
        List<Entry> entries = CentralConfig.getConfigSettingsWithEntryIDs(context, componentName, componentType, settingName);
        if (entries != null) {
            for (Entry entry : entries) {
                String actualValue = CentralConfig.getEntryValue(entry);
                if (!StringUtils.equals((String)settingValue, (String)actualValue)) continue;
                context.deleteEntry(AR_SYSTEM_CONFIGURATION_COMPONENT_SETTING_FORM, entry.getEntryId(), 0);
                deleted = true;
            }
        }
        return deleted;
    }
}

