/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5;

import com.kaazing.gateway.client.html5.EventSourceEvent;
import com.kaazing.gateway.client.html5.EventSourceListener;
import com.kaazing.gateway.client.html5.impl.sse.EventStream;
import com.kaazing.gateway.client.html5.impl.sse.EventStreamListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventSource {
    private static final String CLASS_NAME = EventSource.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private EventStream stream = null;
    private final List<EventSourceListener> listeners = new ArrayList<EventSourceListener>();
    private EventStreamListener eventStreamListener = new EventStreamListener(){

        @Override
        public void streamOpened() {
            LOG.entering(CLASS_NAME, "streamOpened");
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.OPEN);
            for (EventSourceListener listener : EventSource.this.listeners) {
                try {
                    listener.onOpen(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onOpen: " + e.getMessage(), e);
                }
            }
        }

        @Override
        public void messageReceived(String message) {
            LOG.entering(CLASS_NAME, "fireMessageListeners", message);
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.MESSAGE, message);
            for (EventSourceListener listener : EventSource.this.listeners) {
                try {
                    listener.onMessage(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onMessage", "Application threw an exception during onMessage: " + e.getMessage(), e);
                }
            }
        }

        @Override
        public void streamErrored() {
            LOG.entering(CLASS_NAME, "fireErrorListeners");
            EventSourceEvent event = new EventSourceEvent(this, EventSourceEvent.Type.ERROR);
            for (EventSourceListener listener : EventSource.this.listeners) {
                try {
                    listener.onError(event);
                }
                catch (RuntimeException e) {
                    LOG.logp(Level.WARNING, CLASS_NAME, "onError", "Application threw an exception during onError: " + e.getMessage(), e);
                }
            }
        }
    };

    public EventSource() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    public ReadyState getReadyState() {
        return this.stream == null ? ReadyState.CONNECTING : this.stream.getReadyState();
    }

    public void connect(String eventSourceUrl) throws IOException {
        LOG.entering(CLASS_NAME, "connect", eventSourceUrl);
        if (this.stream != null) {
            LOG.warning("Reusing the same event source for a differnt URL, please create a new EventSource object");
            throw new IllegalArgumentException("Reusing the same event source for a differnt URL, please create a new EventSource object");
        }
        this.stream = new EventStream(eventSourceUrl);
        this.stream.setListener(this.eventStreamListener);
        this.stream.connect();
    }

    public void disconnect() {
        LOG.entering(CLASS_NAME, "disconnect");
        this.stream.stop();
        this.stream = null;
    }

    public void addEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "addEventSourceListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
    }

    public void removeEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "removeEventSourceListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove(listener);
    }

    public static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSED;

    }
}

