/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jndi;

import com.bmc.thirdparty.org.springframework.core.env.PropertySource;
import com.bmc.thirdparty.org.springframework.jndi.JndiLocatorDelegate;
import javax.naming.NamingException;

public class JndiPropertySource
extends PropertySource<JndiLocatorDelegate> {
    public JndiPropertySource(String name) {
        this(name, JndiLocatorDelegate.createDefaultResourceRefLocator());
    }

    public JndiPropertySource(String name, JndiLocatorDelegate jndiLocator) {
        super(name, jndiLocator);
    }

    @Override
    public Object getProperty(String name) {
        try {
            Object value = ((JndiLocatorDelegate)this.source).lookup(name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name + "] returned: [" + value + "]");
            }
            return value;
        }
        catch (NamingException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JNDI lookup for name [" + name + "] threw NamingException " + "with message: " + ex.getMessage() + ". Returning null.");
            }
            return null;
        }
    }
}

