/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.expression.spel.ast;

import com.bmc.thirdparty.org.springframework.asm.MethodVisitor;
import com.bmc.thirdparty.org.springframework.expression.TypedValue;
import com.bmc.thirdparty.org.springframework.expression.spel.CodeFlow;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.Literal;

public class FloatLiteral
extends Literal {
    private final TypedValue value;

    FloatLiteral(String payload, int pos, float value) {
        super(payload, pos);
        this.value = new TypedValue(Float.valueOf(value));
        this.exitTypeDescriptor = "F";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        mv.visitLdcInsn(this.value.getValue());
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

