/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.utils.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ARParseFormatInfoImpl
implements ARParseFormatInfo {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    protected ARServerUser context = null;
    private HashMap<String, Field> m_localFieldLabelMap;
    private HashMap<String, Field> m_localFieldIdMap;
    private int m_vuiId;
    private HashMap<String, Field> m_remoteFieldNameMap;
    private HashMap<String, Field> m_remoteFieldIdMap;
    protected Locale locale = null;
    protected String timeZone = null;
    protected int location = 0;
    protected boolean isEscalation;
    boolean includeParanthesis = true;
    boolean hasSameCondOprAsParent = false;
    Field otherField = null;
    private boolean topLevelNode = true;
    ArrayList<String> statusHistoryLabel = null;
    private boolean exceptionWhenFieldNotFound = false;

    public ARParseFormatInfoImpl() {
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList) {
        this(localFieldList, 0, "", null);
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList) {
        this.generateFieldMaps(localFieldList, vuiId, historyTag, remoteFieldList);
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, ArrayList<String> statusHistoryLabel) {
        this.setStatusHistoryLabel(statusHistoryLabel);
        this.generateFieldMaps(localFieldList, vuiId, historyTag, remoteFieldList);
    }

    public void generateFieldMaps(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList) {
        int i;
        String fldlabel = null;
        DisplayInstanceMap dil = null;
        Field tempHistoryField = null;
        String tempHistory = null;
        this.m_localFieldLabelMap = new HashMap();
        this.m_localFieldIdMap = new HashMap();
        if (remoteFieldList != null && remoteFieldList.size() > 0) {
            this.m_remoteFieldNameMap = new HashMap();
            this.m_remoteFieldIdMap = new HashMap();
        }
        this.m_vuiId = vuiId;
        if (localFieldList != null) {
            for (i = 0; i < localFieldList.size(); ++i) {
                Value val;
                fldlabel = null;
                dil = localFieldList.get(i).getDisplayInstance();
                fldlabel = vuiId == 0 ? localFieldList.get(i).getName() : ((val = dil.getProperty(vuiId, new Integer(20))) != null ? val.toString() : localFieldList.get(i).getName());
                if (localFieldList.get(i).getFieldID() == 7 && fldlabel != null) {
                    tempHistory = historyTag != null && historyTag.length() > 0 ? fldlabel + historyTag : fldlabel + "-History";
                    this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
                    if (this.m_localFieldLabelMap.get(fldlabel) != null && (this.m_localFieldLabelMap.get(fldlabel) == null || localFieldList.get(i).getFieldID() >= this.m_localFieldLabelMap.get(fldlabel).getFieldID())) continue;
                    this.m_localFieldLabelMap.put(fldlabel, localFieldList.get(i));
                    continue;
                }
                if (localFieldList.get(i).getFieldID() == 15 && this.statusHistoryLabel != null) {
                    for (String s : this.statusHistoryLabel) {
                        this.m_localFieldLabelMap.put(s, localFieldList.get(i));
                    }
                    continue;
                }
                if (localFieldList.get(i).getFieldID() == 15 && fldlabel != null) {
                    tempHistoryField = localFieldList.get(i);
                    this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
                    continue;
                }
                if (fldlabel == null) continue;
                this.m_localFieldIdMap.put(Integer.valueOf(localFieldList.get(i).getFieldID()).toString(), localFieldList.get(i));
                if (this.m_localFieldLabelMap.get(fldlabel) != null && (this.m_localFieldLabelMap.get(fldlabel) == null || localFieldList.get(i).getFieldID() >= this.m_localFieldLabelMap.get(fldlabel).getFieldID())) continue;
                this.m_localFieldLabelMap.put(fldlabel, localFieldList.get(i));
            }
        }
        if (tempHistory != null && tempHistoryField != null) {
            this.m_localFieldLabelMap.put(tempHistory, tempHistoryField);
        }
        if (remoteFieldList == null) {
            return;
        }
        for (i = 0; i < remoteFieldList.size(); ++i) {
            fldlabel = null;
            dil = remoteFieldList.get(i).getDisplayInstance();
            fldlabel = remoteFieldList.get(i).getName();
            if (remoteFieldList.get(i).getFieldID() == 7 && fldlabel != null) {
                tempHistory = fldlabel + "-History";
                this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
                this.m_remoteFieldNameMap.put(fldlabel, remoteFieldList.get(i));
                continue;
            }
            if (remoteFieldList.get(i).getFieldID() == 15 && fldlabel != null) {
                tempHistoryField = remoteFieldList.get(i);
                this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
                continue;
            }
            if (fldlabel == null) continue;
            this.m_remoteFieldIdMap.put(Integer.valueOf(remoteFieldList.get(i).getFieldID()).toString(), remoteFieldList.get(i));
            this.m_remoteFieldNameMap.put(fldlabel, remoteFieldList.get(i));
        }
        if (tempHistory != null && tempHistoryField != null) {
            this.m_remoteFieldNameMap.put(tempHistory, tempHistoryField);
        }
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, String locale) {
        this(localFieldList, vuiId, historyTag, remoteFieldList);
        this.setLocale(locale);
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, String locale, int location) {
        this(localFieldList, vuiId, historyTag, remoteFieldList);
        this.setLocale(locale);
        this.setLocation(location);
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, String locale, int location, boolean isEscalation) {
        this(localFieldList, vuiId, historyTag, remoteFieldList);
        this.setLocale(locale);
        this.setLocation(location);
        this.isEscalation = isEscalation;
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, String locale, int location, boolean isEscalation, boolean includeP) {
        this(localFieldList, vuiId, historyTag, remoteFieldList);
        this.setLocale(locale);
        this.setLocation(location);
        this.isEscalation = isEscalation;
        this.includeParanthesis = includeP;
    }

    public ARParseFormatInfoImpl(List<Field> localFieldList, int vuiId, String historyTag, List<Field> remoteFieldList, String locale, ArrayList<String> statusHistoryLabel) {
        this(localFieldList, vuiId, historyTag, remoteFieldList, statusHistoryLabel);
        this.setLocale(locale);
    }

    @Override
    public int getVuiId() {
        return this.m_vuiId;
    }

    @Override
    public Field getLocalField(String token) {
        Field fld = null;
        if (this.m_vuiId == 0 && this.m_remoteFieldNameMap != null) {
            int id;
            if (fld == null && this.m_remoteFieldIdMap != null && (fld = this.m_remoteFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_remoteFieldIdMap.get(id);
            }
            if (fld == null && this.m_remoteFieldNameMap != null) {
                fld = this.m_remoteFieldNameMap.get(token);
            }
        } else {
            int id;
            if (fld == null && this.m_localFieldIdMap != null && (fld = this.m_localFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_localFieldIdMap.get(id);
            }
            if (fld == null && this.m_localFieldLabelMap != null) {
                fld = this.m_localFieldLabelMap.get(token);
            }
        }
        return fld;
    }

    @Override
    public Field getRemoteField(String token) {
        Field fld = null;
        if (this.m_localFieldLabelMap != null && this.m_vuiId == 0) {
            int id;
            if (fld == null && this.m_localFieldIdMap != null && (fld = this.m_localFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_localFieldIdMap.get(id);
            }
            if (fld == null && this.m_localFieldLabelMap != null) {
                fld = this.m_localFieldLabelMap.get(token);
            }
        } else {
            int id;
            if (fld == null && this.m_remoteFieldIdMap != null && (fld = this.m_remoteFieldIdMap.get(token)) == null && (id = ConversionUtil.getIntValue(token)) != 0) {
                fld = this.m_remoteFieldIdMap.get(id);
            }
            if (fld == null && this.m_remoteFieldNameMap != null) {
                fld = this.m_remoteFieldNameMap.get(token);
            }
        }
        return fld;
    }

    @Override
    public String getEnumValueFromAlias(String fldid, String alias) {
        int id;
        Field fld;
        if (fldid.equals(new Integer(15).toString())) {
            fldid = new Integer(7).toString();
        }
        if ((fld = this.m_localFieldIdMap.get(fldid)) == null && (id = ConversionUtil.getIntValue(fldid)) != 0) {
            fld = this.m_remoteFieldIdMap.get(id);
        }
        if (fld instanceof SelectionField) {
            return ((SelectionField)fld).getEnumValueFromAlias(this.m_vuiId, alias);
        }
        return null;
    }

    @Override
    public String getEnumAliasFromValue(String fldid, int enumValue) {
        int id;
        Field fld = this.m_localFieldIdMap.get(fldid);
        if (fld == null && (id = ConversionUtil.getIntValue(fldid)) != 0) {
            fld = this.m_localFieldIdMap.get(id);
        }
        if (fld instanceof SelectionField) {
            return ((SelectionField)fld).getEnumAliasFromValue(this.m_vuiId, enumValue);
        }
        return null;
    }

    public void setLocation(int context) {
        this.location = context;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isEscalation() {
        return this.location == 3 || this.location == 21 || this.location == 29;
    }

    @Override
    public boolean includeParanthesis() {
        return this.includeParanthesis;
    }

    @Override
    public void setOtherOperandField(Field field) {
        this.otherField = field;
    }

    @Override
    public Field getOtherOperandField() {
        return this.otherField;
    }

    @Override
    public void setIncludeParanthesis(boolean yesorno) {
        this.includeParanthesis = yesorno;
    }

    public void setLocale(String locale) {
        this.locale = LocaleUtil.parseLocale(locale);
        if (this.locale == null) {
            this.locale = DEFAULT_LOCALE;
        }
    }

    @Override
    public ARServerUser getContext() {
        return this.context;
    }

    @Override
    public void setContext(ARServerUser context) {
        this.context = context;
    }

    @Override
    public Field getDataField(Field field) {
        if (field.getDataType() != 34) {
            return null;
        }
        ColumnField columnField = (ColumnField)field;
        ColumnFieldLimit columnLimit = (ColumnFieldLimit)columnField.getFieldLimit();
        Field parentField = this.getLocalField(String.valueOf(columnLimit.getParent()));
        if (columnLimit == null || parentField == null || parentField.getDataType() != 33 || columnLimit.getDataSource() != 0) {
            return null;
        }
        TableField tableField = (TableField)parentField;
        ARServerUser context = this.getContext();
        Field dataField = null;
        if (context != null) {
            String srcForm = ((TableFieldLimit)tableField.getFieldLimit()).getForm();
            try {
                dataField = this.getContext().getField(srcForm, columnLimit.getDataField());
            }
            catch (ARException aRException) {
                // empty catch block
            }
        }
        return dataField;
    }

    @Override
    public int getEnumIndex(String input, List<EnumItem> items) {
        return this.getEnumIndex(input, items, -1);
    }

    @Override
    public int getEnumIndex(String input, List<EnumItem> items, int oprndDataType) {
        int index = -1;
        int aliasIntValue = -1;
        boolean isIntValue = false;
        try {
            aliasIntValue = Integer.parseInt(input);
            isIntValue = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (oprndDataType == -1) {
            for (EnumItem item : items) {
                if (!input.equalsIgnoreCase(item.getEnumItemName()) && (!isIntValue || aliasIntValue != item.getEnumItemNumber())) continue;
                index = item.getEnumItemNumber();
            }
        } else {
            for (EnumItem item : items) {
                if ((oprndDataType != 4 || !input.equalsIgnoreCase(item.getEnumItemName())) && (oprndDataType != 2 || aliasIntValue != item.getEnumItemNumber())) continue;
                index = item.getEnumItemNumber();
            }
        }
        return index;
    }

    @Override
    public int getLocalFieldListSize() {
        return this.m_remoteFieldIdMap == null ? 0 : this.m_remoteFieldIdMap.size();
    }

    @Override
    public int getRemoteFieldListSize() {
        return this.m_localFieldIdMap == null ? 0 : this.m_localFieldIdMap.size();
    }

    @Override
    public boolean isTopLevelNode() {
        return this.topLevelNode;
    }

    @Override
    public void setTopLevelNode(boolean bool) {
        this.topLevelNode = bool;
    }

    @Override
    public void setExceptionWhenFieldNotFound(boolean b) {
        this.exceptionWhenFieldNotFound = b;
    }

    @Override
    public boolean getExceptionWhenFieldNotFound() {
        return this.exceptionWhenFieldNotFound;
    }

    @Override
    public boolean hasSameCondOprAsParent() {
        return this.hasSameCondOprAsParent;
    }

    @Override
    public void setSameCondOprAsParent(boolean b) {
        this.hasSameCondOprAsParent = b;
    }

    public void setStatusHistoryLabel(ArrayList<String> statusHistoryLabel) {
        this.statusHistoryLabel = statusHistoryLabel;
    }

    @Override
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }
}

