/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.qual.AssignParseFormatInfo;
import com.bmc.arsys.qual.Formatter;
import java.util.List;

public class ARAssignFormatter
extends Formatter {
    public ARAssignFormatter(AssignParseFormatInfo info) {
        this.formatInfo = info;
    }

    public String formatAssignInfo(AssignInfo af) throws ARException {
        AssignParseFormatInfo info = (AssignParseFormatInfo)this.formatInfo;
        Field field = info.getAssignField();
        info.setOtherOperandField(field);
        StringBuffer sbf = new StringBuffer();
        int operationOfAssignInfo = 0;
        if (af != null) {
            operationOfAssignInfo = af.getAssignType();
        }
        switch (operationOfAssignInfo) {
            case 0: {
                break;
            }
            case 1: {
                sbf.append(this.formatValue(af.getValue()));
                break;
            }
            case 2: {
                AssignFieldInfo afi = af.getField();
                String faf = this.formatAssignFieldInfo(afi);
                sbf.append(faf);
                break;
            }
            case 3: {
                String process = af.getProcess();
                String strProcess = this.formatProcessAssignInfo(process);
                sbf.append(strProcess);
                break;
            }
            case 4: {
                ArithOpAssignInfo aoi = af.getArithOp();
                String strAoi = this.formatArithOpAssignInfo(aoi);
                sbf.append(strAoi);
                break;
            }
            case 5: {
                FunctionAssignInfo fai = af.getFunction();
                String strFunctionAI = this.formatFunctionAssignInfo(fai);
                sbf.append(strFunctionAI);
                break;
            }
            case 6: {
                DDEAction ddea = af.getDde();
                sbf.append(this.formatDDEAssignInfo(ddea));
                break;
            }
            case 7: {
                AssignSQLInfo asi = af.getSql();
                String strASI = this.formatSQLAssignInfo(asi);
                sbf.append(strASI);
                break;
            }
            case 8: {
                AssignFilterApiInfo fApInfo = af.getFilterApi();
                sbf.append(this.formatFilterAPIAssignInfo(fApInfo));
                break;
            }
        }
        return sbf.toString();
    }

    public String formatArithOpAssignInfo(ArithOpAssignInfo aoi) throws ARException {
        String strLeft = null;
        String strRight = null;
        StringBuffer roiS = new StringBuffer();
        AssignInfo aroLeft = aoi.getOperandLeft();
        try {
            strLeft = this.formatAssignInfo(aroLeft);
        }
        catch (ARException e) {
            logger.error("Error formating the left operand of ArithOpAssignInfo", e);
            throw e;
        }
        this.formatInfo.setIncludeParanthesis(aroLeft.getAssignType() == 4);
        if (this.formatInfo.includeParanthesis()) {
            roiS.append("(").append(strLeft).append(")");
        } else {
            roiS.append(strLeft);
        }
        switch (aoi.getOperation()) {
            case 1: {
                roiS.append(" + ");
                break;
            }
            case 2: {
                roiS.append(" - ");
                break;
            }
            case 3: {
                roiS.append(" * ");
                break;
            }
            case 4: {
                roiS.append(" / ");
                break;
            }
            case 5: {
                roiS.append(" % ");
                break;
            }
            case 6: {
                roiS.append(" -");
                break;
            }
            default: {
                throw new ARException(2, 312, "Operation" + aoi.getOperation());
            }
        }
        AssignInfo aroRight = aoi.getOperandRight();
        try {
            strRight = this.formatAssignInfo(aroRight);
        }
        catch (ARException e) {
            logger.error("Error formating the left operand of ArithOpAssignInfo", e);
            throw e;
        }
        this.formatInfo.setIncludeParanthesis(aroRight.getAssignType() == 4);
        if (this.formatInfo.includeParanthesis()) {
            roiS.append("(").append(strRight).append(")");
        } else {
            roiS.append(strRight);
        }
        return roiS.toString();
    }

    public String formatFunctionAssignInfo(FunctionAssignInfo fai) throws ARException {
        StringBuffer sbfGroup = new StringBuffer();
        String funcName = FunctionAssignInfo.toFuncName(fai.getFunctionCode());
        sbfGroup.append(funcName + "(");
        List<AssignInfo> assignInfoList = fai.getParameterList();
        if (assignInfoList != null) {
            for (int i = 0; i < assignInfoList.size(); ++i) {
                AssignInfo item = assignInfoList.get(i);
                try {
                    sbfGroup.append(this.formatAssignInfo(item));
                }
                catch (ARException e) {
                    logger.error("Error formating Function parameter list", e);
                    throw e;
                }
                if (i == assignInfoList.size() - 1) continue;
                sbfGroup.append(", ");
            }
        }
        sbfGroup.append(")");
        return sbfGroup.toString();
    }

    public String formatAssignFieldInfo(AssignFieldInfo afi) throws ARException {
        StringBuffer sbf = new StringBuffer();
        int tag = afi.getTag();
        Field fld = null;
        String strField = null;
        switch (tag) {
            case 1: {
                fld = this.formatInfo.getRemoteField(String.valueOf(afi.getFieldId()));
                if (fld != null) {
                    strField = fld.getName();
                    strField = strField.replaceAll("\\$", "\\$\\$");
                } else {
                    strField = String.valueOf(afi.getFieldId());
                }
                sbf.append("$");
                sbf.append(strField);
                sbf.append("$");
                break;
            }
            case 6: {
                fld = this.formatInfo.getLocalField(Integer.toString(afi.getCurrencyPart().getFieldId()));
                if (fld != null) {
                    strField = this.formatCurrencyField(afi.getCurrencyPart(), fld);
                    strField = strField.replaceAll("\\$", "\\$\\$");
                    sbf.append("$");
                    sbf.append(strField);
                    sbf.append("$");
                    break;
                }
                sbf.append("$").append(fld).append("$");
                break;
            }
            case 56: {
                fld = this.formatInfo.getRemoteField(Integer.toString(afi.getCurrencyPart().getFieldId()));
                strField = this.formatCurrencyField(afi.getCurrencyPart(), fld);
                strField = strField.replaceAll("\\$", "\\$\\$");
                sbf.append("$");
                sbf.append(strField);
                sbf.append("$");
                break;
            }
            case 4: {
                strField = this.formatStatusHistroryField(afi.getStatHistory());
                sbf.append("$");
                sbf.append(strField);
                sbf.append("$");
                break;
            }
            case 99: {
                fld = this.formatInfo.getRemoteField(String.valueOf(afi.getFieldId()));
                if (fld != null) {
                    strField = fld.getName();
                    strField = strField.replaceAll("\\$", "\\$\\$");
                } else {
                    strField = String.valueOf(afi.getFieldId());
                }
                sbf.append("$");
                sbf.append(strField);
                sbf.append("$");
            }
        }
        return sbf.toString();
    }

    public String formatProcessAssignInfo(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append("$PROCESS$ ");
        try {
            sb.append(this.replaceFieldNamesForIds(str));
        }
        catch (ARException aRException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String formatSQLAssignInfo(AssignSQLInfo asi) {
        StringBuffer fapi = new StringBuffer("$");
        fapi.append(asi.getValueIndex());
        fapi.append("$");
        return fapi.toString();
    }

    public String formatFilterAPIAssignInfo(AssignFilterApiInfo fApInfo) {
        StringBuffer fapi = new StringBuffer("$");
        fapi.append(fApInfo.getValueIndex());
        fapi.append("$");
        return fapi.toString();
    }

    public String formatDDEAssignInfo(DDEAction ddea) {
        StringBuffer sb = new StringBuffer();
        String result = null;
        if (ddea != null) {
            try {
                String service = ddea.getServiceName();
                service = service != null ? service : "";
                sb.append(service).append(";");
                String topic = ddea.getTopic();
                topic = topic != null ? topic : "";
                sb.append(topic).append(";");
                String pathToPrg = ddea.getPathToProgram();
                pathToPrg = pathToPrg != null ? pathToPrg : "";
                sb.append(pathToPrg).append(";");
                String item = ddea.getItem();
                item = item != null ? item : "";
                sb.append(item).append(";");
                result = this.replaceFieldNamesForIds(sb.toString(), 0);
                if (result == null) {
                    result = sb.toString();
                }
            }
            catch (ARException aRException) {
                // empty catch block
            }
        }
        return "$DDE$ " + result;
    }
}

