/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArSoftByteArrayManager;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import java.io.IOException;
import java.io.InputStream;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ArFlexXdrTcpDecodingStream
extends ArXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ArFlexXdrTcpDecodingStream.class);
    protected int maxResponseSize = 500000;
    private int maxXdrDecodingStreamSize = 500128;
    private int minXdrDecodingStreamSize = 4096;
    private int marginSize = 128;
    private int socketInputStreamfragmentLen = 128;
    private boolean socketLastFragment;
    private boolean useFlexXdrStreamBuffer;

    public ArFlexXdrTcpDecodingStream(ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, ArSoftByteArrayManager.get(bufferSize, true));
    }

    @Override
    protected byte[] arEncBeforeUnXdrDecoding(byte[] arBuffer) throws OncRpcException, IOException {
        if (this.isArProcessOn()) {
            System.out.println("ArFlexXdrTcpDecodingStream.arEncBeforeUnXdrDecoding() to replace the buffer bytes before unxdr the data with len = " + this.socketInputStreamfragmentLen);
        }
        return arBuffer;
    }

    @Override
    public void readIncomingFragmentInfo(InputStream socketInputStream, byte[] bytes, int i) throws IOException, OncRpcException {
        super.readIncomingFragmentInfo(socketInputStream, bytes, i);
        this.socketInputStreamfragmentLen = this.getFragmentLength();
        if (log.isTraceEnabled()) {
            log.trace("socketInputStreamfragmentLen = " + this.socketInputStreamfragmentLen + (this.isLastFragment() ? " last" : ""));
        }
    }

    @Override
    public int changeBufferIfNeeded(int dataLen, byte[] orgBuffer) {
        int newBufferLen = 0;
        if (!(dataLen != 0 && this.isUseFlexXdrStreamBuffer() && this.isArProcessOn() && this.isDecodingProcessReady())) {
            return newBufferLen;
        }
        int orgBufferBeginIndex = this.getBufferIndex();
        int orgBufLen = orgBuffer != null ? orgBuffer.length : this.getBufferSize();
        if (this.isXdrTcpStreamResizeNeeded(dataLen, orgBufLen, this.getMinXdrDecodingStreamSize(), 128)) {
            newBufferLen = this.determinNewBufferLen(dataLen);
            if (newBufferLen != orgBufLen) {
                if (log.isTraceEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(" receiving buffer change from ").append(orgBufLen).append(" to ").append(newBufferLen).append(" bytes");
                    log.trace(msg.toString());
                }
                byte[] newBuffer = ArSoftByteArrayManager.get(newBufferLen, newBufferLen + this.minXdrDecodingStreamSize, true);
                newBufferLen = newBuffer.length;
                if (this.isArEncryptionOn() && orgBuffer != null) {
                    orgBufLen = orgBuffer.length;
                    System.arraycopy(orgBuffer, 0, newBuffer, 0, orgBufLen);
                }
                this.setBuffer(newBuffer);
                this.setBufferIndex(orgBufferBeginIndex);
                this.setBufferHighmark(newBufferLen - 4);
            } else if (log.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(" receiving accumulates to DataNotInXdrBuffer ").append(dataLen).append(" bytes");
                log.trace(msg.toString());
            }
        } else if (log.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append(" receiving re-use buffer ").append(orgBufLen).append(" bytes");
            log.trace(msg.toString());
        }
        return newBufferLen;
    }

    private int determinNewBufferLen(int dataLen) {
        return dataLen + 128;
    }

    private boolean isXdrTcpStreamResizeNeeded(int arRequiredXdrSize, int currentXdrStreamSize, int minXdrStreamSize, int marginSize) {
        boolean neededFlag = true;
        if (currentXdrStreamSize == 0) {
            return neededFlag;
        }
        if (!this.isArProcessOn() || !this.isUseFlexXdrStreamBuffer()) {
            neededFlag = false;
        } else if (arRequiredXdrSize == 0 || arRequiredXdrSize == currentXdrStreamSize || arRequiredXdrSize < currentXdrStreamSize && arRequiredXdrSize + marginSize >= currentXdrStreamSize) {
            neededFlag = false;
        }
        return neededFlag;
    }

    int getSocketInputStreamfragmentLen() {
        return this.socketInputStreamfragmentLen;
    }

    boolean isSocketLastFragment() {
        return this.socketLastFragment;
    }

    protected boolean isDecodingProcessReady() {
        return false;
    }

    int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    int getMaxXdrDecodingStreamSize() {
        return this.maxXdrDecodingStreamSize;
    }

    void setMaxXdrDecodingStreamSize(int maxXdrDecodingStreamSize) {
        this.maxXdrDecodingStreamSize = maxXdrDecodingStreamSize;
    }

    int getMinXdrDecodingStreamSize() {
        return this.minXdrDecodingStreamSize;
    }

    void setMinXdrDecodingStreamSize(int minXdrDecodingStreamSize) {
        this.minXdrDecodingStreamSize = minXdrDecodingStreamSize;
    }

    void setUseFlexXdrStreamBuffer(boolean useFlexXdrStreamBuffer) {
        this.useFlexXdrStreamBuffer = useFlexXdrStreamBuffer;
    }

    boolean isUseFlexXdrStreamBuffer() {
        return this.useFlexXdrStreamBuffer;
    }

    int getMarginSize() {
        return this.marginSize;
    }

    @Override
    protected void setBuffer(byte[] buffer) {
        ArSoftByteArrayManager.release(super.getBufferArray());
        super.setBuffer(buffer);
    }
}

