/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.utils.LogBytes;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;

public class ARPrivateKey
extends ARPPKey {
    BigInteger privateBigExponent;
    BigInteger privateBigModulus;

    @Override
    protected void setBigExponent(String exp) {
        super.setBigExponent(exp);
    }

    protected void setBigExponent(BigInteger exp) {
        this.privateBigExponent = exp;
    }

    @Override
    protected BigInteger getBigExponent() {
        return this.privateBigExponent;
    }

    @Override
    protected Key getRsaKey() throws AREncryptionException {
        RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(this.getBigModulus(), this.getBigExponent());
        try {
            String provider = this.getProvider();
            KeyFactory keyFactory = provider != null ? KeyFactory.getInstance(this.getEncAlgorithmStr(), provider) : KeyFactory.getInstance(this.getEncAlgorithmStr());
            this.encKey = (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
            if (this.debug) {
                LogBytes.printByteArrayAsHex(((RSAPrivateKey)this.encKey).getModulus().toByteArray(), "RSA private Modulus: \n");
                LogBytes.printByteArrayAsHex(((RSAPrivateKey)this.encKey).getPrivateExponent().toByteArray(), "RSA private Exponent: \n");
            }
        }
        catch (Exception e) {
            throw new AREncryptionException(e, 9006);
        }
        return this.encKey;
    }

    @Override
    protected BigInteger getBigModulus() {
        return this.privateBigModulus;
    }

    protected void setBigModulus(BigInteger privateBigModulus) {
        this.privateBigModulus = privateBigModulus;
    }

    @Override
    protected void setKeyID() {
        this.keyID = "PriKey";
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.privateBigExponent).append(this.privateBigModulus).append(this.keyID).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARPrivateKey rhs = (ARPrivateKey)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.privateBigExponent, rhs.privateBigExponent).append(this.privateBigModulus, rhs.privateBigModulus).append(this.keyID, rhs.keyID).isEquals();
    }
}

