/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncEngineFactory;
import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.util.Stack;
import org.apache.log4j.Logger;

class AREncEnginePool {
    private static int maxPoolSize = 20;
    private int numberOfActiveEngines;
    private final String instEntry;
    private final String instEntryLogging;
    private Stack<Object> pool;
    private static Logger logger = Logger.getLogger(AREncEnginePool.class);
    protected boolean obfuscated = !"AREncEngineFactory".equals(AREncEnginePool.class.getSimpleName());
    private static int maxLoggingEngStr = 5;

    AREncEnginePool(String theInstEntry) {
        this.instEntry = theInstEntry;
        this.instEntryLogging = this.obfuscated && theInstEntry.length() > maxLoggingEngStr ? theInstEntry.substring(0, maxLoggingEngStr) : new String(this.instEntry);
        this.numberOfActiveEngines = 0;
        this.pool = new Stack();
    }

    synchronized Object borrowEngine(String encType, AREncKeyBase encKey, AREncEngineFactory engineFactoryInst) throws AREncryptionException {
        if (!this.pool.empty()) {
            Object engine = this.pool.pop();
            if (logger.isDebugEnabled()) {
                logger.debug(Thread.currentThread() + " got engInstance " + this.instEntryLogging + " " + engine);
            }
            return engine;
        }
        if (this.numberOfActiveEngines < maxPoolSize) {
            try {
                logger.debug(Thread.currentThread() + " generating new engInstance " + this.numberOfActiveEngines + " " + this.instEntryLogging);
                Object engine = engineFactoryInst.generateEngineInstance(encType, encKey);
                ++this.numberOfActiveEngines;
                logger.debug(Thread.currentThread() + " generated new engInstance " + this.numberOfActiveEngines + " " + this.instEntryLogging + " " + engine);
                return engine;
            }
            catch (Throwable e) {
                if (this.numberOfActiveEngines == 0) {
                    logger.error("Can not get the first crypto.*.getInstance() from JCE " + this.instEntryLogging + " " + e);
                    if (e instanceof AREncryptionException) {
                        throw (AREncryptionException)e;
                    }
                    throw new AREncryptionException(e, 9010);
                }
                logger.error("Can not get another cipher instance for " + this.instEntryLogging + " " + e);
            }
        }
        do {
            try {
                logger.debug("Pool is empty. wait for one to become available for " + this.instEntryLogging);
                this.wait();
            }
            catch (InterruptedException e) {
                logger.debug(this.instEntryLogging + " awakes");
            }
        } while (this.pool.empty());
        Object engine = this.pool.pop();
        logger.debug(Thread.currentThread() + " waited available " + this.instEntryLogging + " " + engine);
        return engine;
    }

    synchronized void returnEngine(Object engine) {
        if (this.pool.size() < maxPoolSize) {
            this.pool.push(engine);
            this.notifyAll();
            logger.debug(Thread.currentThread() + " put back engInstance " + this.instEntryLogging + " " + engine);
        } else {
            logger.error(this.instEntryLogging + " " + engine + " pool overflow! Size = " + this.pool.size() + ", max = " + maxPoolSize + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
        }
    }

    public String toString() {
        return this.instEntry;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.instEntry).append(this.pool).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AREncEnginePool rhs = (AREncEnginePool)obj;
        return new EqualsBuilder().append(this.instEntry, rhs.instEntry).append(this.pool, rhs.pool).isEquals();
    }

    static synchronized void setMaxPoolSize(int newMaxPoolSize) {
        maxPoolSize = newMaxPoolSize;
    }
}

