/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiRpcClientStubFactory;
import com.bmc.arsys.apitransport.ApiRpcClientStubI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.arencrypt.AREncryptionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ApiRpcClientStubFactoryImpl
extends ApiRpcClientStubFactory {
    private static Logger log = Logger.getLogger(ApiRpcClientStubFactoryImpl.class);
    static ApiRpcClientStubFactoryImpl _instance = new ApiRpcClientStubFactoryImpl();

    @Override
    public ApiRpcClientStubI createARRpcClientStub(ApiUserContextI context, ApiConfigI config, int initialXdrSize, int lowerSvrRpcVersionBy) throws OncRpcException, IOException, AREncryptionException, ARException {
        ApiRpcClientStubI rpcClientStub = null;
        Class<?> clazz = null;
        StringBuilder msg = new StringBuilder();
        try {
            clazz = Class.forName(config.getRpcClientStubType());
            if (ApiRpcClientStubI.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                rpcClientStub = (ApiRpcClientStubI)constructor.newInstance(context.getServer(), context.getPort(), initialXdrSize, lowerSvrRpcVersionBy);
            }
        }
        catch (ClassNotFoundException e) {
            msg.append("ERROR when creating API RPC Client Stub type. Cause : Class '").append(config.getRpcClientStubType()).append("' not found.");
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (SecurityException e) {
            msg.append("Error when creating RpcClientStub. Cause : ").append(e);
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (NoSuchMethodException e) {
            msg.append("Error when creating RpcClientStub. Cause : '").append(clazz).append("' is not a valid ApiRpcClientStubI class.");
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (IllegalArgumentException e) {
            msg.append("Error when creating RpcClientStub. Cause : '").append(clazz).append("' is not a valid ApiRpcClientStubI class.");
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (InstantiationException e) {
            msg.append("Error when creating RpcClientStub. Cause : '").append(clazz).append("' is not a valid ApiRpcClientStubI class.");
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (IllegalAccessException e) {
            msg.append("Error when creating RpcClientStub. Cause : ").append(e);
            log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof OncRpcException) {
                throw (OncRpcException)e.getCause();
            }
            if (e.getCause() instanceof AREncryptionException) {
                throw (AREncryptionException)e.getCause();
            }
            if (e.getCause() instanceof ARException) {
                throw (ARException)e.getCause();
            }
            msg.append("Error when creating RpcClientStub. Cause : ").append(e.getCause());
            log.error(msg.toString(), e);
            throw new RuntimeException(msg.toString());
        }
        return rpcClientStub;
    }
}

