/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiProxyJRpcBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApiProxyFactory {
    private static Logger logger = Logger.getLogger(ApiProxyFactory.class);
    static Map<String, Class<? extends ApiProxyI>> apiProxyClazzCache = new Hashtable<String, Class<? extends ApiProxyI>>();

    private ApiProxyI createProxyInstance(String clazzName, ApiUserContextI context) throws InvocationTargetException, ARException {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("Connects to ").append(context.getServerInfoStr()).append(" through ");
        ApiProxyI proxy = null;
        if (null == clazzName && ApiThreadLocalStorageBlock.getTLB().getRpcClazz() == null) {
            logMsg.append("Proxy/ProxyJRpc class name should be provided.");
            logger.error(logMsg);
            throw new IllegalArgumentException(logMsg.toString());
        }
        try {
            Constructor<? extends ApiProxyI> constructor;
            Class<ApiProxyI> clazz = null;
            if (clazzName != null) {
                logger.trace("Will " + logMsg.toString() + clazzName);
                if (apiProxyClazzCache.containsKey(clazzName)) {
                    logger.trace("apiProxyClazzCache found cache for class " + clazzName);
                    clazz = apiProxyClazzCache.get(clazzName);
                } else {
                    if (ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) {
                        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                        if (ccl != null) {
                            clazz = Class.forName(clazzName, true, ccl);
                            logger.trace("ContextClassLoader load class " + clazzName);
                        } else {
                            clazz = Class.forName(clazzName);
                            logger.trace("load class " + clazzName);
                        }
                    } else {
                        clazz = Class.forName(clazzName);
                        logger.trace("load class " + clazzName);
                    }
                    apiProxyClazzCache.put(clazzName, clazz);
                    logger.trace("apiProxyClazzCache put in loaded class " + clazzName);
                }
            } else {
                clazz = ApiThreadLocalStorageBlock.getTLB().getRpcClazz();
            }
            if (ApiProxyJRpcBase.class.isAssignableFrom(clazz) || ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) {
                constructor = clazz.getDeclaredConstructor(ApiUserContextI.class);
                logger.trace("will call newInstance(context) for " + clazzName);
                proxy = constructor.newInstance(context);
            } else if (ApiProxyI.class.isAssignableFrom(clazz)) {
                constructor = clazz.getDeclaredConstructor(Boolean.TYPE);
                logger.trace("will call newInstance(true) for " + clazzName);
                proxy = constructor.newInstance(true);
            } else {
                logMsg.append(clazzName).append(" is not valid Proxy/ProxyJRpc class.");
                logger.error(logMsg);
                throw new IllegalArgumentException(logMsg.toString());
            }
            if (proxy != null) {
                logMsg.append(proxy);
            } else {
                logMsg.append(" proxy not created ");
            }
            logger.info(logMsg.toString());
        }
        catch (ClassNotFoundException e) {
            logMsg.append("RPC call failed. Cause : Class '").append(clazzName).append("' not found.");
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        catch (SecurityException e) {
            logMsg.append("RPC call failed. Cause : '").append(e);
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        catch (NoSuchMethodException e) {
            logMsg.append("RPC call failed. Cause : '").append(clazzName).append("' is not a valid ApiProxyI class.");
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        catch (IllegalArgumentException e) {
            logMsg.append("RPC call failed. Cause : '").append(clazzName).append("' is not a valid ApiProxyI class.");
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        catch (InstantiationException e) {
            logMsg.append("RPC call failed. Cause : '").append(clazzName).append("' is not a valid ApiProxyI class.");
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        catch (IllegalAccessException e) {
            logMsg.append("RPC call failed. Cause : '").append(e);
            logger.error(logMsg.toString());
            throw new RuntimeException(logMsg.toString());
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiProxyI createProxy(ApiUserContextI context) throws ARException {
        List<StatusInfo> status;
        ARException ex;
        ApiProxyI proxy;
        StringBuilder logMsg;
        block19: {
            logMsg = new StringBuilder();
            logMsg.append("Connects to ").append(context.getServerInfoStr()).append(" through ");
            proxy = null;
            if (!this.isValidRpcPort(context.getPort())) {
                throw new ARException(2, 8202, " server : " + context.getServer() + "; port : " + context.getPort());
            }
            boolean userNeedsLongerTimeoutOnInitConnection = context.getTimeoutNormal() > 120;
            try {
                if (context.getApiConfig().getJrpcMode()) {
                    if (userNeedsLongerTimeoutOnInitConnection) {
                        ApiThreadLocalStorageBlock.getTLB().setInitConnectTimeout(context.getTimeoutNormal());
                        if (logger.isTraceEnabled()) {
                            logger.trace("createProxy using user timeout value of " + context.getTimeoutNormal());
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(logMsg.toString());
                    }
                    proxy = this.createProxyInstance(ApiThreadLocalStorageBlock.getTLB().getRpcClazzName(), context);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ARException) {
                    ex = (ARException)e.getCause();
                    logMsg.append("Java Rpc failed with: ").append(ex);
                    logger.error(logMsg.toString());
                    status = ex.getLastStatus();
                    if (status != null && status.size() > 0 && status.get(0).getMessageNum() == 8203L) {
                        logger.error("Will retry Jni");
                        break block19;
                    }
                    context.setLastStatus(status);
                    throw ex;
                }
                if (logger.isDebugEnabled()) {
                    for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                        logger.debug(ste + "\n");
                    }
                }
                throw new RuntimeException(e);
            }
            finally {
                if (userNeedsLongerTimeoutOnInitConnection) {
                    ApiThreadLocalStorageBlock.getTLB().setInitConnectTimeout(120);
                }
            }
        }
        try {
            if (null == proxy && !ApiThreadLocalStorageBlock.getTLB().isCMDBCall()) {
                proxy = this.createProxyInstance(ApiThreadLocalStorageBlock.getTLB().getRpcClazzName(), context);
                logger.debug("established a jni proxy for server : " + context.getServer() + "; port : " + context.getPort());
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ARException) {
                ex = (ARException)e.getCause();
                logMsg.append("Java Rpc failed with: ").append(ex);
                logger.error(logMsg.toString());
                status = ex.getLastStatus();
                context.setLastStatus(status);
                throw ex;
            }
            throw new RuntimeException(e);
        }
        return proxy;
    }

    private boolean isValidRpcPort(int port) {
        return port == 0 || port >= 1 && port <= 65535;
    }
}

