/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.chunking.ARChunkImport;
import com.bmc.arsys.api.session.ARRpcClientStub;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiUserContextBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorFactory;
import com.bmc.arsys.apitransport.chunking.IARChunkReceivable;
import com.bmc.arsys.apitransport.chunking.IARChunkSendable;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcTimeOutBase;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.apitransport.session.ArStatusInfo;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.arrpc.xdr.DecoratedArRpcXdrOut;
import com.bmc.arsys.utils.ProcessUtil;
import java.util.concurrent.locks.ReentrantLock;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public abstract class ApiProxyJRpcBase
extends ApiProxyBase {
    private static Logger logger = Logger.getLogger(ApiProxyJRpcBase.class);
    protected ARRpcClientStub rpcClient = null;
    protected final ReentrantLock lock = new ReentrantLock();

    protected ApiProxyJRpcBase() {
    }

    protected ApiProxyJRpcBase(boolean isLegacyServer) {
        super(isLegacyServer);
    }

    protected ApiProxyJRpcBase(ApiUserContextI context) {
        super(context);
    }

    protected void initThreadLocalVariables(ApiUserContextI context) {
        ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(null);
        if (context != null) {
            ApiThreadLocalStorageBlock.getTLB().setLocaleInfo(context.getLocaleInfo());
            ApiThreadLocalStorageBlock.getTLB().setApiThreadInfo(null);
            if (context instanceof ApiUserContextBase) {
                ((ApiProxyManager)ProxyManager.getProxyManager()).setGenericUserSessionInfo(context);
            }
        }
    }

    protected void initThreadLocalInternalVariables() {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(null);
    }

    protected int getInitialXdrSize(ApiUserContextI context) {
        int xdrSize = 0;
        ARServerContext svrCtx = ProxyManager.getARServerContext(context.getServer(), context.getPort());
        if (svrCtx != null) {
            xdrSize = svrCtx.getCurrentXDRBufferSize();
        }
        if (xdrSize <= 0 || xdrSize < 4096 || xdrSize > 10000000) {
            xdrSize = 500128;
        }
        return xdrSize;
    }

    protected void initialization(ApiUserContextI context) throws ARException {
        ((ApiProxyManager)ProxyManager.getProxyManager()).checkCleanUpTimer();
    }

    protected int connectionTry(ApiUserContextI context, int haveTriedTimes, Exception e) throws ARException {
        if (haveTriedTimes < context.getApiConfig().getConnectionMaxRetries()) {
            this.closeConnection();
            try {
                Thread.sleep(context.getApiConfig().getTimeLagBetweenRetriesMillSec());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new ARException(2, 90, e.getLocalizedMessage() + " " + context.getServerInfoStr());
        }
        return ++haveTriedTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void arCall(ApiUserContextI context, int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut result) throws ARException {
        boolean useLock = this.isPotentialMultiThreads();
        ReentrantLock curLock = null;
        try {
            if (useLock) {
                curLock = this.lock;
                curLock.lock();
            }
            this.initThreadLocalVariables(context);
            this.arCall(context, procedureNumber, params, result, false);
        }
        finally {
            if (curLock != null) {
                curLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void arCall(ApiUserContextI context, int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut result, boolean haveRetried) throws ARException {
        context.logApiTime("+API call, Procedure #" + procedureNumber);
        long start = System.currentTimeMillis();
        StringBuilder msg = logger.isDebugEnabled() ? new StringBuilder() : null;
        String connectToMsg = context.getServerInfoStr();
        boolean succeed = false;
        DecoratedArRpcXdrOut orgResult = new DecoratedArRpcXdrOut(result.getTheObject());
        if (msg != null) {
            msg.append("ProcNumber ").append(procedureNumber).append(" via ").append(this).append(" for " + connectToMsg);
        }
        try {
            if (ARChunkProcessorFactory.isChunkingSupportedCall(procedureNumber)) {
                int chunkingRound;
                if (msg != null) {
                    msg.append(", with chunking ");
                }
                if ((chunkingRound = this.arChunkingCall(context, procedureNumber, params, result)) > 0 && msg != null) {
                    msg.append(chunkingRound).append(" round call").append(chunkingRound > 1 ? "s, " : ",");
                }
            } else {
                ARRpcClientStub rpcClient = (ARRpcClientStub)this.getRpcClient(context);
                this.setUserSession(context, rpcClient);
                rpcClient.arCall(procedureNumber, params, result);
            }
            succeed = true;
            return;
        }
        catch (OncRpcException e) {
            if (msg != null) {
                String emsg = msg.toString() + " received OncRpcException: " + e.getLocalizedMessage();
                logger.debug(emsg);
            }
            if (haveRetried) {
                logger.debug("has already retried. close the connection, resetChunkProcessor and throw exception");
                this.resetChunkProcessor();
                this.closeConnection(context);
                throw this.convertException(e, procedureNumber, context);
            }
            boolean closeConn = true;
            boolean redoHandShake = false;
            if (e.getReason() == 7 && e instanceof OncRpcAuthenticationException) {
                switch (((OncRpcAuthenticationException)e).getAuthStatus()) {
                    case 2: {
                        closeConn = false;
                        redoHandShake = true;
                        break;
                    }
                    case 1: {
                        this.getRpcClient(context).enableAPICallEncryption(false);
                        closeConn = false;
                        break;
                    }
                    case 5: {
                        this.getRpcClient(context).enableAPICallEncryption(true);
                        closeConn = false;
                        break;
                    }
                }
            } else if (e.getReason() == 11 || e.getReason() == 2 || e.getReason() == 1 || e.getReason() == 10 || e.getReason() == 5 || this.isArException(e)) {
                logger.debug("that rpc error does not warrant a retry. close the connection, resetChunkProcessor and throw exception");
                this.resetChunkProcessor();
                this.closeConnection(context);
                throw this.convertException(e, procedureNumber, context);
            }
            if (redoHandShake) {
                try {
                    this.getRpcClient(context).handShake(connectToMsg, false, 0, 0);
                }
                catch (Exception e1) {
                    closeConn = true;
                }
            }
            if (closeConn) {
                if (msg != null) {
                    msg.append(" connection ").append(this).append(" to ").append(connectToMsg).append(" re-established w reason : ").append(e.getLocalizedMessage());
                    logger.debug(msg.toString());
                }
                this.closeConnection(context);
            }
            msg = null;
            logger.debug("retrying arCall");
            this.arCall(context, procedureNumber, params, result, true);
            return;
        }
        finally {
            this.updateUserContext(context, result.getTheObject());
            try {
                try {
                    if (this.verifyStatus(context, result.getTheObject(), succeed, msg)) {
                        result.setTheObject(orgResult.getTheObject());
                        this.retryApiCall(context, procedureNumber, params, result);
                    }
                }
                catch (Exception e1) {
                    logger.debug("API internal: retry API call failed ." + e1.getLocalizedMessage());
                }
                finally {
                    if (result.getStatus().hasError()) {
                        ArStatusInfo statusInfo = new ArStatusInfo(result.getStatus());
                        throw new ARException(statusInfo);
                    }
                }
            }
            finally {
                context.logApiTime("-API call, Procedure #" + procedureNumber);
                if (msg != null) {
                    if (succeed && !result.getTheObject().getStatus().hasError()) {
                        msg.append(" succeed. -API arcall");
                    } else {
                        msg.append(" returned error. -API arcall");
                    }
                    ProcessUtil.getInstance().PrintProcessTime(start, msg.toString());
                    logger.debug(msg.toString());
                }
            }
        }
    }

    private void retryApiCall(ApiUserContextI context, int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut result) throws ARException, OncRpcException {
        ARRpcClientStub newRpcClient = (ARRpcClientStub)this.getRpcClient(context);
        this.setUserSession(context, newRpcClient);
        logger.debug("re-sending API call " + procedureNumber);
        newRpcClient.arCall(procedureNumber, params, result);
        logger.debug("re-sent API call " + procedureNumber + " successfully.");
    }

    private void prepareChunkingApiRetryCall(ApiUserContextI context, int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut result) throws ARException, OncRpcException {
        ARRpcClientStub newRpcClient = (ARRpcClientStub)this.getRpcClient(context);
        this.setUserSession(context, newRpcClient);
        logger.debug("will re-sending chunking API call " + procedureNumber);
        this.arCall(context, procedureNumber, params, result, false);
    }

    private void setUserSession(ApiUserContextI context, ARRpcClientStub rpcClient) throws ARException {
        ArRpcCallContext callCxt = rpcClient.getArRpcCallContext();
        for (int key : context.getUserSession().keySet()) {
            callCxt.setSessionVariable(key, context.getUserSession().get(key));
        }
    }

    protected boolean isArException(OncRpcException e) {
        return e.getReason() == 16 && e.getCause() instanceof AREncryptionException;
    }

    protected IARChunkable getChunkProcessor(ApiUserContextI context, int procedureNumber) throws ARException {
        if (ApiThreadLocalStorageBlock.getTLB().getChunkProcessor() == null) {
            IARChunkable chunkProcessor = ARChunkProcessorFactory.createProcessor(procedureNumber);
            chunkProcessor.init(this.getInternalObj(context));
            ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(chunkProcessor);
        }
        return ApiThreadLocalStorageBlock.getTLB().getChunkProcessor();
    }

    protected void resetChunkProcessor() {
        ApiThreadLocalStorageBlock.getTLB().resetChunkingProcessor();
    }

    private int arChunkingCall(ApiUserContextI context, int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut out) throws ARException, OncRpcException {
        ArRpcControlStruct controlIn = params.getControl();
        ArStatusInfo lastStatus = new ArStatusInfo();
        IARChunkable chunkProcessor = this.getChunkProcessor(context, procedureNumber);
        int roundNumber = chunkProcessor.getRoundNumber();
        DecoratedArRpcXdrOut orgResult = new DecoratedArRpcXdrOut(out.getTheObject());
        try {
            while (chunkProcessor.hasNextRound()) {
                chunkProcessor.nextRound();
                roundNumber = chunkProcessor.getRoundNumber();
                logger.debug("arChunkingCall: Processor=" + chunkProcessor + ", Proc Number=" + procedureNumber + ", Round Number=" + roundNumber + " via " + this);
                if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(procedureNumber)) {
                    ((IARChunkSendable)chunkProcessor).loadOneChunkToParamIn(this.getArRpcCallContext(context).getSessionVariable(1).getIntValue(), params);
                }
                ARRpcClientStub rpcClient = (ARRpcClientStub)this.getRpcClient(context);
                this.setUserSession(context, rpcClient);
                rpcClient.arCall(procedureNumber, params, out);
                if (out.getTheObject().getStatus().hasError()) {
                    StringBuilder msg = logger.isDebugEnabled() ? new StringBuilder() : null;
                    boolean shouldRetry = false;
                    if (this.verifyStatus(context, out.getTheObject(), false, msg)) {
                        shouldRetry = true;
                        chunkProcessor.setRoundNumber(--roundNumber);
                        this.prepareChunkingApiRetryCall(context, procedureNumber, params, orgResult);
                        return 0;
                    }
                    if (!shouldRetry) {
                        lastStatus.add(out.getTheObject().getStatus());
                        break;
                    }
                } else {
                    lastStatus.add(out.getTheObject().getStatus());
                }
                if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(procedureNumber)) {
                    ((IARChunkReceivable)chunkProcessor).retrieveChunkingData(out.getTheObject());
                }
                controlIn.setCacheId(out.getTheObject().getControl().getCacheId());
                controlIn.setRequestId(out.getTheObject().getControl().getRequestId());
                logger.debug("chunking request id is set to " + out.getTheObject().getControl().getRequestId());
            }
            if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(procedureNumber)) {
                ((IARChunkReceivable)chunkProcessor).postProcess(out.getTheObject());
                logger.debug("arChunkingCall: Done with postProcess via " + this);
            }
            logger.debug("chunking finished successfully, resetChunkProcessor.");
            this.resetChunkProcessor();
        }
        catch (OncRpcException e) {
            chunkProcessor.setRoundNumber(--roundNumber);
            if (chunkProcessor instanceof ARChunkImport) {
                logger.debug("reset the chunk request id and import buf");
                params.getControl().setRequestId(0);
                ((ARChunkImport)chunkProcessor).resetToOriginImportBuf(params);
            }
            throw e;
        }
        return roundNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws ARException {
        block8: {
            boolean useLock = this.isPotentialMultiThreads();
            ReentrantLock curLock = null;
            try {
                if (useLock) {
                    curLock = this.lock;
                    curLock.lock();
                }
                if (this.rpcClient == null) break block8;
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("connection " + this + " closed.");
                    }
                    this.rpcClient.close();
                    this.rpcClient = null;
                }
                catch (OncRpcException e) {
                    throw this.convertException(e);
                }
            }
            finally {
                if (curLock != null) {
                    curLock.unlock();
                }
            }
        }
    }

    protected void closeConnection(ApiUserContextI context) throws ARException {
        this.closeConnection();
    }

    protected void updateUserContext(ApiUserContextI context, ArRpcXdrOut result) {
        if (result == null || context == null) {
            return;
        }
        ArRpcControlStruct control = result.getControl();
        if (control != null) {
            if (context.getImpersonatedUser() != null && context.getImpersonatedUser().length() != 0) {
                context.setImpersonatedCacheId(control.getCacheId());
            } else {
                context.setCacheId(control.getCacheId());
            }
            ArTimestamp operationTime = control.getOperationTime();
            if (operationTime != null) {
                context.setOperationTime(new Timestamp(operationTime.value));
            }
            if (context.getOverridePrevIP()) {
                context.setOverridePrevIP(false);
            }
            if (context.getServiceStatMsg() != null) {
                context.setServiceStatMsg(null);
            }
        }
    }

    protected boolean verifyStatus(ApiUserContextI context, ArRpcXdrOut result, boolean succeed, StringBuilder msg) throws ARException {
        if (context == null || result == null || result.getStatus() == null) {
            return false;
        }
        boolean needToRetryAPICall = false;
        ArStatusInfo lastStatus = new ArStatusInfo(result.getStatus());
        if (result.getStatus().hasError()) {
            for (StatusInfo status : lastStatus) {
                if (status.getMessageNum() != 8206L) continue;
                needToRetryAPICall = true;
                ARServerContext svrCtx = ProxyManager.getARServerContext(context.getServer(), context.getPort());
                svrCtx.setClientTypeToRpcQueueMap(status.getAppendedText());
                break;
            }
        }
        if (needToRetryAPICall) {
            context.setLastStatus(new ArStatusInfo());
        } else {
            context.setLastStatus(lastStatus);
        }
        context.setMultiLastStatus(null);
        return needToRetryAPICall;
    }

    protected boolean verifyStatus(ApiUserContextI context, ArRpcXdrOut result) throws ARException {
        return this.verifyStatus(context, result, true, null);
    }

    protected ARException convertException(OncRpcException e) {
        return this.convertException(e, 0);
    }

    private ARException convertException(OncRpcException e, int procedureNumber) {
        return this.convertException(e, procedureNumber, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ARException convertException(OncRpcException e, int procedureNumber, ApiUserContextI context) {
        String connectToMsg;
        ARException arE = null;
        StringBuilder msg = new StringBuilder();
        String string = connectToMsg = context != null ? context.getServerInfoStr() : "(no context)";
        if (this.isArException(e)) {
            arE = new ARException(2, ((AREncryptionException)e.getCause()).getErrorNum(), connectToMsg + " " + ((AREncryptionException)e.getCause()).getMessage());
        } else if (e.getReason() == 5 && procedureNumber > 0 && context != null) {
            ProcessUtil.callServerProcess(context.getServer());
            arE = new ARException(2, this.getErrorCodeForProcedure(context, procedureNumber), connectToMsg + " " + e.getLocalizedMessage());
        } else if (e.getReason() == 10) {
            arE = new ARException(2, 341, connectToMsg + " " + e.getLocalizedMessage());
        } else {
            try {
                msg.append("ProcNumber ").append(procedureNumber).append(" via ").append(this).append(" for " + connectToMsg).append(", converts OncRpcException");
                msg.append(" to ARError ");
                msg.append(91);
                logger.error(msg, e);
            }
            finally {
                arE = new ARException(2, 91, connectToMsg + " " + e.getLocalizedMessage());
            }
        }
        return arE;
    }

    protected String getServerCharSetName(ApiUserContextI context) throws ARException {
        return this.getArRpcCallContext(context).getServerCharSetName();
    }

    protected Object getInternalObj(ApiUserContextI context) throws ARException {
        return ApiThreadLocalStorageBlock.getTLB().getInternalChunkingObj();
    }

    protected void setInternalObj(ApiUserContextI context, Object internalObj) throws ARException {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(internalObj);
    }

    protected void cleanUpTL() {
        if (ApiThreadLocalStorageBlock.isTLBExist()) {
            ApiThreadLocalStorageBlock.getTLB().cleanUp();
        }
    }

    protected ArRpcCallContext getArRpcCallContext(ApiUserContextI context) throws ARException {
        return this.getRpcClient(context).getArRpcCallContext();
    }

    @Override
    protected String ARInitApiSourceGuid(ApiUserContextI context) throws ARException {
        return null;
    }

    private int getErrorCodeForProcedure(ApiUserContextI context, int procedureNumber) {
        return ((ApiRpcTimeOutBase)context.getApiPropertyManager().get("AR_PROPERTY_RPC_TIMEOUT")).getErrorCode(procedureNumber);
    }

    protected boolean isPotentialMultiThreads() {
        return !ProxyManager.isUseConnectionPooling();
    }
}

