/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.sql.Date;

public class LicenseValidInfo
implements Serializable {
    private static final long serialVersionUID = 1317246872915779409L;
    private int m_numLicenses;
    private boolean m_isDemo;
    private Date m_expireDate;
    private String m_tokenList;

    public LicenseValidInfo() {
    }

    public LicenseValidInfo(int numLicenses, boolean isDemo, Date expireDate, String tokenList) {
        this.m_numLicenses = numLicenses;
        this.m_isDemo = isDemo;
        this.setExpireDate(expireDate);
        this.m_tokenList = tokenList;
    }

    private void setExpireDate(Date expireDate) {
        if (expireDate == null) {
            this.m_expireDate = null;
            return;
        }
        this.m_expireDate = new Date(expireDate.getTime());
    }

    public Date getExpireDate() {
        return this.m_expireDate;
    }

    public int getNumLicenses() {
        return this.m_numLicenses;
    }

    public boolean isDemo() {
        return this.m_isDemo;
    }

    public String getTokenList() {
        return this.m_tokenList;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_numLicenses = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_isDemo = ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, 1));
        this.m_expireDate = ConversionUtil.getSqlDateValue(ARTypeMgr.GetAt((Object)rawData, 2));
        this.m_tokenList = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3));
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{this.m_numLicenses, this.m_isDemo ? 1 : 0, ConversionUtil.getARTimestamp(this.m_expireDate), this.m_tokenList};
        return var;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Num Licenses", this.m_numLicenses).append("Is Demo", this.m_isDemo).append("Expire Date", this.m_expireDate).append("Token List", this.m_tokenList).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_numLicenses).append(this.m_isDemo).append(this.m_expireDate).append(this.m_tokenList).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LicenseValidInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LicenseValidInfo rhs = (LicenseValidInfo)obj;
        return new EqualsBuilder().append(this.m_numLicenses, rhs.m_numLicenses).append(this.m_isDemo, rhs.m_isDemo).append(this.m_expireDate, rhs.m_expireDate).append(this.m_tokenList, rhs.m_tokenList).isEquals();
    }
}

