/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.DataType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum FunctionCode {
    Count(59, "COUNT", new FunctionArgument(DataType.NULL)),
    Sum(60, "SUM", new FunctionArgument(DataType.NULL)),
    Avg(61, "AVG", new FunctionArgument(DataType.NULL)),
    Min(62, "MIN", new FunctionArgument(DataType.NULL)),
    Max(63, "MAX", new FunctionArgument(DataType.NULL)),
    DateDiff(33, "DATEDIFF", new FunctionArgument(3, DataType.CHAR, DataType.TIME, DataType.TIME)),
    DateNum(35, "DATENUM", new FunctionArgument(2, DataType.CHAR, DataType.TIME)),
    DateName(34, "DATENAME", new FunctionArgument(2, DataType.CHAR, DataType.TIME)),
    DateAdd(32, "DATEADD", new FunctionArgument(2, DataType.CHAR, DataType.TIME)),
    Date(1, "DATE", new FunctionArgument(1, DataType.TIME)),
    Day(4, "DAY", new FunctionArgument(1, DataType.TIME)),
    Week(65, "WEEK", new FunctionArgument(1, DataType.TIME)),
    Month(3, "MONTH", new FunctionArgument(1, DataType.TIME)),
    Quarter(64, "QUARTER", new FunctionArgument(1, DataType.TIME)),
    Year(5, "YEAR", new FunctionArgument(1, DataType.TIME)),
    Hour(7, "HOUR", new FunctionArgument(1, DataType.TIME)),
    Minute(8, "MINUTE", new FunctionArgument(1, DataType.TIME)),
    Time(2, "TIME", new FunctionArgument(1, DataType.TIME)),
    Second(9, "SECOND", new FunctionArgument(1, DataType.TIME)),
    Weekday(6, "WEEKDAY", new FunctionArgument(1, DataType.TIME)),
    Upper(14, "UPPER", new FunctionArgument(DataType.CHAR)),
    Lower(15, "LOWER", new FunctionArgument(DataType.CHAR)),
    Ltrim(19, "LTRIM", new FunctionArgument(DataType.CHAR)),
    Rtrim(20, "RTRIM", new FunctionArgument(DataType.CHAR)),
    Replace(23, "REPLACE", new FunctionArgument(DataType.CHAR, DataType.CHAR, DataType.CHAR)),
    Lpad(21, "LPAD", new FunctionArgument(DataType.CHAR, DataType.INTEGER, DataType.CHAR)),
    Rpad(22, "RPAD", new FunctionArgument(DataType.CHAR, DataType.INTEGER, DataType.CHAR)),
    Substr(66, "SUBSTR", new FunctionArgument(2, DataType.CHAR, DataType.INTEGER, DataType.INTEGER)),
    Distinct(67, "DISTINCT", new FunctionArgument(DataType.NULL)),
    Currentdate(68, "CURRENTDATE", new FunctionArgument(DataType.NULL));

    private final int value;
    private final String name;
    private final FunctionArgument arguments;
    private static final Map<Integer, FunctionCode> idLookup;
    private static final Map<String, FunctionCode> nameLookup;

    public int intValue() {
        return this.value;
    }

    public String getFunctionName() {
        return this.name;
    }

    private FunctionCode(int intValue, String name, FunctionArgument arguments) {
        this.value = intValue;
        this.name = name;
        this.arguments = arguments;
    }

    public static FunctionCode getFunctionCode(int code) {
        return idLookup.get(code);
    }

    public static FunctionCode getFunctionCode(String code) {
        return nameLookup.get(code);
    }

    public DataType getParamType(int paramIndx) {
        if (this.arguments != null && paramIndx < this.arguments.getMaximumNumberOfArguments()) {
            return this.arguments.getParamDatatypes()[paramIndx];
        }
        return DataType.NULL;
    }

    public DataType[] getParamDatatypes() {
        return this.arguments.getParamDatatypes();
    }

    public int getMinimumNumberOfArguments() {
        return this.arguments.getMinimumNumberOfArguments();
    }

    public int getMaximumNumberOfArguments() {
        return this.arguments.getMaximumNumberOfArguments();
    }

    static {
        idLookup = new HashMap<Integer, FunctionCode>();
        nameLookup = new HashMap<String, FunctionCode>();
        for (FunctionCode funcCode : EnumSet.allOf(FunctionCode.class)) {
            idLookup.put(funcCode.intValue(), funcCode);
            nameLookup.put(funcCode.getFunctionName(), funcCode);
        }
    }

    private static class FunctionArgument {
        private final int minArgs;
        private final int maxArgs;
        private final DataType[] argDataTypes;

        public FunctionArgument(DataType ... argDataTypes) {
            this.minArgs = argDataTypes.length;
            this.maxArgs = argDataTypes.length;
            this.argDataTypes = argDataTypes;
        }

        public FunctionArgument(int min, DataType ... argDataTypes) {
            this.minArgs = min;
            this.maxArgs = argDataTypes.length;
            this.argDataTypes = argDataTypes;
        }

        public int getMinimumNumberOfArguments() {
            return this.minArgs;
        }

        public int getMaximumNumberOfArguments() {
            return this.maxArgs;
        }

        public DataType[] getParamDatatypes() {
            return this.argDataTypes;
        }
    }
}

