/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.zip.DataFormatException;

public class AlertMessageInfo
implements Serializable {
    private static final long serialVersionUID = 1538327159080758632L;
    private Timestamp timestamp;
    private int sourceType;
    private int priority;
    private String alertText;
    private String sourceTag;
    private String serverName;
    private String serverAddr;
    private String formName;
    private String objectId;
    private String user;
    public static final int AR_ALERT_MSG_TOTAL_LEN = 1;
    public static final int AR_ALERT_MSG_SERVER_VERSION = 2;
    public static final int AR_ALERT_MSG_TIMESTAMP = 3;
    public static final int AR_ALERT_MSG_TYPE_CODE = 4;
    public static final int AR_ALERT_MSG_PRIORITY = 5;
    public static final int AR_ALERT_MSG_TEXT_LEN = 6;
    public static final int AR_ALERT_MSG_TEXT = 7;
    public static final int AR_ALERT_MSG_SOURCE_LEN = 8;
    public static final int AR_ALERT_MSG_SOURCE = 9;
    public static final int AR_ALERT_MSG_SOURCE_SERVER_LEN = 10;
    public static final int AR_ALERT_MSG_SOURCE_SERVER = 11;
    public static final int AR_ALERT_MSG_SOURCE_FORM_LEN = 12;
    public static final int AR_ALERT_MSG_SOURCE_FORM = 13;
    public static final int AR_ALERT_MSG_SOURCE_OBJECT_LEN = 14;
    public static final int AR_ALERT_MSG_SOURCE_OBJECT = 15;
    public static final int AR_ALERT_MSG_SOURCE_SVR_ADDR_LEN = 16;
    public static final int AR_ALERT_MSG_SOURCE_SVR_ADDR = 17;
    public static final int AR_ALERT_MSG_ITEM_COUNT = 17;
    public static final int AR_ALERT_MSG_ITEM_COUNT_V1 = 15;
    public static final int AR_ALERT_MSG_PROTOCOL_VERSION = 2;
    public static final int AR_ALERT_SOURCE_GP = 1;
    public static final int AR_ALERT_SOURCE_AR = 2;
    public static final int AR_ALERT_SOURCE_FIRST = 3;
    public static final int AR_ALERT_SOURCE_CHECK = 4;
    public static final int AR_ALERT_SOURCE_FB = 5;
    public static final String AR_ALERT_ACK = "ack";
    public static final String AR_ALERT_MSG_SEPARATOR = "\\";

    public AlertMessageInfo() {
    }

    public AlertMessageInfo(Timestamp time, int type, int prior, String text, String tag, String svrName, String form, String id) {
        this.sourceType = type;
        this.priority = prior;
        this.alertText = text;
        this.sourceTag = tag;
        this.serverName = svrName;
        this.formName = form;
        this.objectId = id;
        try {
            this.timestamp = time != null ? (Timestamp)time.clone() : null;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone not supported");
        }
    }

    public AlertMessageInfo(Timestamp time, int type, int prior, String text, String tag, String svrName, String svrAddr, String form, String id) {
        this.sourceType = type;
        this.priority = prior;
        this.alertText = text;
        this.sourceTag = tag;
        this.serverName = svrName;
        this.serverAddr = svrAddr;
        this.formName = form;
        this.objectId = id;
        try {
            this.timestamp = time != null ? (Timestamp)time.clone() : null;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone not supported");
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.timestamp = new Timestamp(ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        this.sourceType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 5));
        this.priority = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 6));
        this.alertText = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 7));
        this.sourceTag = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 8));
        this.serverName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 9));
        this.serverAddr = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 10));
        this.formName = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 11));
        this.objectId = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 12));
        this.user = ctx.getUser();
    }

    static AlertMessageInfo createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        AlertMessageInfo obj = new AlertMessageInfo();
        if (rawData.length == 14 && rawData[0] != null) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Timestamp", this.timestamp).append("Source Type", this.sourceType).append("Priority", this.priority).append("Alert Text", this.alertText).append("Source Tag", this.sourceTag).append("Server Name", this.serverName).append("Server Addr", this.serverAddr).append("Form Name", this.formName).append("Object Id", this.objectId).append("User", this.user).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.timestamp).append(this.sourceType).append(this.priority).append(this.alertText).append(this.sourceTag).append(this.serverName).append(this.serverAddr).append(this.formName).append(this.objectId).append(this.user).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlertMessageInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AlertMessageInfo rhs = (AlertMessageInfo)obj;
        return new EqualsBuilder().append(this.timestamp, rhs.timestamp).append(this.sourceType, rhs.sourceType).append(this.priority, rhs.priority).append(this.alertText, rhs.alertText).append(this.sourceTag, rhs.sourceTag).append(this.serverName, rhs.serverName).append(this.serverAddr, rhs.serverAddr).append(this.formName, rhs.formName).append(this.objectId, rhs.objectId).append(this.user, rhs.user).isEquals();
    }

    public static AlertMessageInfo DecodeAlertMessage(AlertMessageCriteria criteria, Object message, int len) throws ARException {
        if (message == null || len < 8) {
            throw new ARException(2, 3317, "");
        }
        AlertMessageInfo messageInfo = new AlertMessageInfo();
        byte[] bytes = (byte[])message;
        int embeddedLen = -1;
        String outputString = new String(bytes);
        String firstFourByte = outputString.substring(0, 4);
        if (firstFourByte.equalsIgnoreCase("2059")) {
            try {
                int off = 4;
                embeddedLen = bytes[off++] & 0xFF;
                embeddedLen = embeddedLen << 8 | bytes[off++] & 0xFF;
                embeddedLen = embeddedLen << 8 | bytes[off++] & 0xFF;
                embeddedLen = embeddedLen << 8 | bytes[off++] & 0xFF;
                if (embeddedLen != len) {
                    throw new ARException(2, 3317, "");
                }
                ARDecompressor decompressor = new ARDecompressor();
                decompressor.setInput(bytes, 8, len - 8);
                byte[] decompressedResult = decompressor.inflate();
                outputString = new String(decompressedResult).trim();
            }
            catch (DataFormatException e) {
                throw new ARException(2, 9004, e.getLocalizedMessage());
            }
        }
        int numAlertMessageItems = 0;
        String itemPtr1 = outputString;
        while (itemPtr1.indexOf(AR_ALERT_MSG_SEPARATOR, 0) != -1) {
            ++numAlertMessageItems;
            itemPtr1 = itemPtr1.substring(itemPtr1.indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1);
        }
        int expectedItemCount = 0;
        int indexInt = outputString.indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1;
        int serverVersion = Integer.parseInt(outputString.substring(indexInt, indexInt + 1));
        switch (serverVersion) {
            case 1: {
                if (numAlertMessageItems < 15) {
                    throw new ARException(2, 3317, "");
                }
                expectedItemCount = 15;
                break;
            }
            case 2: {
                if (numAlertMessageItems < 17) {
                    throw new ARException(2, 3317, "");
                }
                expectedItemCount = 17;
                break;
            }
            default: {
                throw new ARException(2, 3317, "");
            }
        }
        int nextItemLength = -1;
        String separatorStr = outputString;
        block21: for (int msgIndex = 1; separatorStr.length() != 0 && msgIndex <= expectedItemCount; ++msgIndex) {
            if (separatorStr.indexOf(AR_ALERT_MSG_SEPARATOR, 0) == -1) {
                throw new ARException(2, 3317, "");
            }
            String leftOutStr = null;
            if (nextItemLength != -1) {
                if (!AR_ALERT_MSG_SEPARATOR.equals(String.valueOf(separatorStr.charAt(nextItemLength)))) {
                    throw new ARException(2, 3317, "");
                }
                leftOutStr = separatorStr.substring(0, nextItemLength);
                separatorStr = separatorStr.substring(nextItemLength + 1);
                nextItemLength = -1;
            } else {
                leftOutStr = separatorStr.substring(0, separatorStr.indexOf(AR_ALERT_MSG_SEPARATOR, 0));
                separatorStr = separatorStr.substring(separatorStr.indexOf(AR_ALERT_MSG_SEPARATOR, 0) + 1);
            }
            switch (msgIndex) {
                case 1: {
                    if (Integer.parseInt(leftOutStr) == outputString.length()) continue block21;
                    throw new ARException(2, 3317, "");
                }
                case 2: {
                    serverVersion = Integer.parseInt(leftOutStr);
                    continue block21;
                }
                case 3: {
                    messageInfo.timestamp = new Timestamp(Long.valueOf(leftOutStr));
                    continue block21;
                }
                case 4: {
                    messageInfo.sourceType = Integer.parseInt(leftOutStr);
                    continue block21;
                }
                case 5: {
                    messageInfo.priority = Integer.parseInt(leftOutStr);
                    continue block21;
                }
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    nextItemLength = Integer.parseInt(leftOutStr);
                    continue block21;
                }
                case 7: {
                    messageInfo.alertText = leftOutStr;
                    continue block21;
                }
                case 9: {
                    messageInfo.sourceTag = leftOutStr;
                    continue block21;
                }
                case 11: {
                    messageInfo.serverName = leftOutStr;
                    continue block21;
                }
                case 13: {
                    messageInfo.formName = leftOutStr;
                    continue block21;
                }
                case 15: {
                    messageInfo.objectId = leftOutStr;
                    continue block21;
                }
                case 17: {
                    messageInfo.serverAddr = leftOutStr;
                    continue block21;
                }
            }
        }
        return messageInfo;
    }
}

