/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArSoftByteArrayManager;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.apache.log4j.Logger;

public class ArXdrTcpEncodingStream
extends XdrTcpEncodingStream {
    private static Logger logger = Logger.getLogger(ArXdrTcpEncodingStream.class);
    private boolean arEncryptionOnFlag = true;
    private boolean arProcessOnFlag = true;
    private transient boolean arProcessDone = false;
    private transient boolean arDataNotInXdrBuffer = false;
    private int orgBufferBeginIndex;
    private transient ByteBuffer arTotalBuf = null;
    private transient byte[] headerBuf = null;
    private int bufferSize;

    public ArXdrTcpEncodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.setBufferSize(bufferSize);
    }

    public ArXdrTcpEncodingStream(ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.setBufferSize(bufferSize);
    }

    protected ArXdrTcpEncodingStream(Socket streamingSocket, byte[] buffer) throws IOException {
        super(streamingSocket, buffer);
        this.setBufferSize(buffer.length);
    }

    protected ArXdrTcpEncodingStream(ArNetworkSocket streamingSocket, byte[] buffer) throws IOException {
        super(streamingSocket, buffer);
        this.setBufferSize(buffer.length);
    }

    protected void arExcBeforeXdrEncodeParams() {
        this.setOrgBufferBeginIndex(this.getBufferIndex());
        logger.debug((Object)"AR arExcBeforeXdrEncodeParams, call resetArFlags, flag=true");
        this.resetArFlags(true);
    }

    protected byte[] arEncAfterXdrEncoding(byte[] arBuffer) throws OncRpcException, IOException {
        if (this.isArProcessOn()) {
            System.out.println("Need to be override! ArXdrTcpEncodingStream.arEncAfterXdrEncoding() to apply ArXdrEnc processes the data after xdr the data.");
        }
        return arBuffer;
    }

    protected void arEncodeEncryptedData(XdrAble arXdrEnc, ArXdrTcpEncodingStream xdr) throws OncRpcException, IOException {
        byte[] xdrHeader;
        this.setArEncryptionOn(false);
        this.setArProcessOn(false);
        if (this.isDataNotInXdrBuffer() && (xdrHeader = this.getHeaderBuf()) != null) {
            System.arraycopy(this.getHeaderBuf(), 0, super.getBuffer(), 0, this.getOrgBufferBeginIndex());
        }
        this.setBufferIndex(this.getOrgBufferBeginIndex());
        arXdrEnc.xdrEncode((XdrEncodingStream)xdr);
    }

    protected byte[] getEncodedBuffer() {
        int dataLen = 0;
        byte[] arBuffer = null;
        if (this.isDataNotInXdrBuffer()) {
            this.arTotalBuf = StringByteUtil.checkAndExpandByteBufferCapacity((ByteBuffer)this.arTotalBuf, (int)this.getBufferIndex());
            this.arTotalBuf.put(this.getBuffer(), 4, this.getBufferIndex());
            dataLen = this.arTotalBuf.position();
            arBuffer = ArSoftByteArrayManager.get(dataLen, dataLen + 4096, true);
            this.arTotalBuf.position(0);
            this.arTotalBuf.get(arBuffer);
        } else {
            dataLen = this.getBufferIndex();
            arBuffer = ArSoftByteArrayManager.get(dataLen, dataLen + 4096, true);
            System.arraycopy(this.getBuffer(), this.orgBufferBeginIndex, arBuffer, 0, dataLen);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("encodedBuffer ");
            if (this.isDataNotInXdrBuffer()) {
                msg.append("DataNotInXdrBuffer ");
            }
            msg.append("dataLen = ").append(dataLen);
            logger.trace((Object)msg.toString());
        }
        return arBuffer;
    }

    public void endEncoding() throws OncRpcException, IOException {
        logger.debug((Object)"AR endEncoding, setArProcessDone true");
        this.setArProcessDone(true);
        if (this.isArProcessOn()) {
            this.arEncAfterXdrEncoding(this.getEncodedBuffer());
        }
        super.endEncoding();
    }

    protected boolean isArProcessOn() {
        return this.arProcessOnFlag;
    }

    public void setArProcessOn(boolean turnOnArProcess) {
        this.arProcessOnFlag = turnOnArProcess;
    }

    protected int getOrgBufferBeginIndex() {
        return this.orgBufferBeginIndex;
    }

    public void setOrgBufferBeginIndex(int newOrgBufferBeginIndex) {
        this.orgBufferBeginIndex = newOrgBufferBeginIndex;
    }

    protected void streamFlush(boolean lastFragment) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AR streamFlush, bytes=" + this.getBufferIndex() + " isArRrocessOn=" + this.isArProcessOn() + " isArProcessDone=" + this.isArProcessDone()));
        }
        if (!this.isArProcessOn() || this.isArProcessDone()) {
            super.streamFlush(lastFragment);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AR streamFlush, call resetArFlags, flag=" + lastFragment));
            }
            this.resetArFlags(lastFragment);
        } else {
            this.holdStreamFlush();
        }
    }

    protected void holdStreamFlush() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"AR holdStreamFlush");
        }
        int offset = 4;
        if (this.arTotalBuf == null) {
            int initCapacity = StringByteUtil.getNewBufferCapacityForExpanding((int)this.bufferSize, (int)0);
            this.arTotalBuf = ByteBuffer.allocateDirect(initCapacity);
        }
        if (!this.isDataNotInXdrBuffer()) {
            offset = this.orgBufferBeginIndex;
            this.headerBuf = new byte[this.orgBufferBeginIndex];
            System.arraycopy(this.getBuffer(), 0, this.headerBuf, 0, this.orgBufferBeginIndex);
        }
        int len = this.getBufferIndex() - offset;
        this.arTotalBuf = StringByteUtil.checkAndExpandByteBufferCapacity((ByteBuffer)this.arTotalBuf, (int)len);
        this.arTotalBuf.put(this.getBuffer(), offset, len);
        this.setDataNotInXdrBuffer(true);
    }

    protected void resetArFlags(boolean flag) {
        if (!flag) {
            return;
        }
        this.arTotalBuf = null;
        this.setHeaderBuf(null);
        this.setArProcessDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    protected boolean isDataNotInXdrBuffer() {
        return this.arDataNotInXdrBuffer;
    }

    protected void setDataNotInXdrBuffer(boolean isDataNotInXdrBuffer) {
        this.arDataNotInXdrBuffer = isDataNotInXdrBuffer;
    }

    protected boolean isArProcessDone() {
        return this.arProcessDone;
    }

    public void setArProcessDone(boolean arProcessDone) {
        this.arProcessDone = arProcessDone;
    }

    protected byte[] getHeaderBuf() {
        return this.headerBuf;
    }

    protected void setHeaderBuf(byte[] headerBuf) {
        this.headerBuf = headerBuf;
    }

    public void xdrEncodeString(String value) throws OncRpcException, IOException {
        super.xdrEncodeString(value);
    }

    public boolean isArEncryptionOn() {
        return this.arEncryptionOnFlag;
    }

    public void setArEncryptionOn(boolean arEncryptionOnFlag) {
        this.arEncryptionOnFlag = arEncryptionOnFlag;
    }

    int getArBufferDataLen() {
        return this.arTotalBuf.position();
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

