/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentHashMap;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

public abstract class ArConnectionInfo
implements ArEncryptionInfoI {
    private static Logger log = Logger.getLogger(ArConnectionInfo.class);
    public static ConcurrentHashMap<String, String> connection_CharSetMap = new ConcurrentHashMap();

    public static boolean isRemoteHostCharSetExist(String key) {
        if (key == null) {
            return false;
        }
        return connection_CharSetMap.containsKey(key);
    }

    public static String getRemoteHostCharSet(String connectionKey) {
        String codeSet = null;
        if (connectionKey != null) {
            codeSet = connection_CharSetMap.get(connectionKey);
        }
        if (codeSet == null) {
            codeSet = "utf-8";
        }
        return codeSet;
    }

    public static void setRemoteHostCharSet(String key, String serverKnownCharSet) {
        if (key != null) {
            connection_CharSetMap.put(key, serverKnownCharSet);
        }
    }

    public static boolean isRemoteHostCodeSetExist() {
        String key = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        if (key == null) {
            return false;
        }
        return connection_CharSetMap.containsKey(key);
    }

    public static void setRemoteHostCharSet(String serverKnownCharSet) {
        String key = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        ArConnectionInfo.setRemoteHostCharSet(key, serverKnownCharSet);
    }

    public static void updateRemoteHostInfoFromRpcControlStruct(byte[] remoteHostLanguageStr, XdrDecodingStream stream) {
        String charset = ArConnectionInfo.getRemoteHostLanguageStr(remoteHostLanguageStr);
        stream.setCharacterEncoding(charset);
        ARThreadLocalStorageBlock.getTLB().setRemoteHostCharSet(charset);
        if (log.isTraceEnabled()) {
            String key = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
            log.trace((Object)("++++++++++set remote host " + key + "  encoding " + charset));
        }
    }

    static String getRemoteHostLanguageStr(byte[] remoteHostLanguageStr) {
        String languageStr = null;
        try {
            languageStr = StringByteUtil.createNullTerminatedString((byte[])remoteHostLanguageStr, (String)"utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.trace((Object)e.getLocalizedMessage());
        }
        String knowCharSet = ARCharSet.getServerCharSetName((String)languageStr);
        if (log.isTraceEnabled()) {
            log.trace((Object)("RemoteHostLanguage " + languageStr + ", CharSet " + knowCharSet));
        }
        if (!ArConnectionInfo.isRemoteHostCodeSetExist()) {
            ArConnectionInfo.setRemoteHostCharSet(knowCharSet);
        }
        return knowCharSet;
    }
}

