/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.http;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.Channel;
import com.kaazing.gateway.client.html5.impl.auth.AuthenticationUtil;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.util.HttpURI;
import com.kaazing.gateway.client.html5.util.StringUtils;
import com.kaazing.gateway.client.security.ChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeRequest;
import com.kaazing.gateway.client.security.ChallengeResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpRequestAuthenticationHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestAuthenticationHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate: ";
    private static final String APPLICATION_PREFIX = "Application ";
    private static final String HTTP_1_1_START = "HTTP/1.1";
    private static final int HTTP_1_1_START_LEN = "HTTP/1.1".length();
    private static final byte[] HTTP_1_1_START_BYTES = StringUtils.getUtf8Bytes("HTTP/1.1");

    private Channel getWebSocketChannel(HttpRequest request) {
        if (request.parent != null) {
            return request.parent.getParent();
        }
        return null;
    }

    private void handleClearAuthenticationData(HttpRequest request) {
        Channel channel = this.getWebSocketChannel(request);
        if (channel == null) {
            return;
        }
        ChallengeHandler nextChallengeHandler = null;
        if (channel.challengeResponse != null) {
            nextChallengeHandler = channel.challengeResponse.getNextChallengeHandler();
            channel.challengeResponse.clearCredentials();
            channel.challengeResponse = null;
        }
        channel.challengeResponse = new ChallengeResponse(null, nextChallengeHandler);
    }

    private void handleRemoveAuthenticationData(HttpRequest request) {
        this.handleClearAuthenticationData(request);
    }

    protected static String[] getLines(ByteBuffer buf) {
        ArrayList<String> lineList = new ArrayList<String>();
        while (buf.hasRemaining()) {
            byte next = buf.get();
            ArrayList<Byte> lineText = new ArrayList<Byte>();
            while (next != 13) {
                lineText.add(next);
                if (!buf.hasRemaining()) break;
                next = buf.get();
            }
            if (buf.hasRemaining()) {
                next = buf.get();
            }
            byte[] lineTextBytes = new byte[lineText.size()];
            int i = 0;
            for (Byte text : lineText) {
                lineTextBytes[i] = text;
                ++i;
            }
            lineList.add(new String(lineTextBytes, UTF_8));
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    protected static boolean isHTTPResponse(ByteBuffer buf) {
        if (buf.remaining() < HTTP_1_1_START_LEN) {
            return false;
        }
        for (int i = 0; i < HTTP_1_1_START_LEN; ++i) {
            if (buf.getAt(i) == HTTP_1_1_START_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    private void onLoadWrappedHTTPResponse(HttpRequest request, HttpResponse response) throws Exception {
        String wwwAuthenticate;
        LOG.entering(CLASS_NAME, "onLoadWrappedHTTPResponse");
        ByteBuffer responseBody = response.getBody();
        String[] lines = HttpRequestAuthenticationHandler.getLines(responseBody);
        int statusCode = Integer.parseInt(lines[0].split(" ")[1]);
        if (statusCode == 401) {
            wwwAuthenticate = null;
            for (int i = 1; i < lines.length; ++i) {
                if (!lines[i].startsWith(WWW_AUTHENTICATE)) continue;
                wwwAuthenticate = lines[i].substring(WWW_AUTHENTICATE.length());
                break;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("connectToWebSocket.onLoadWrappedHTTPResponse: WWW-Authenticate: " + StringUtils.stripControlCharacters(wwwAuthenticate));
            }
            if (wwwAuthenticate == null || "".equals(wwwAuthenticate)) {
                throw new IllegalStateException("Missing authentication challenge in wrapped HTTP 401 response");
            }
            if (!wwwAuthenticate.startsWith(APPLICATION_PREFIX)) {
                throw new IllegalStateException("Only Application challenges are supported by the client");
            }
        } else {
            throw new IllegalStateException("Unsupported wrapped response with HTTP status code " + statusCode);
        }
        String rawChallenge = wwwAuthenticate.substring(APPLICATION_PREFIX.length());
        this.handle401(request, rawChallenge);
    }

    private void handle401(HttpRequest request, String challenge) throws Exception {
        LOG.entering(CLASS_NAME, "handle401");
        HttpURI uri = request.getUri();
        WebSocketEmulatedChannel channel = (WebSocketEmulatedChannel)this.getWebSocketChannel(request);
        if (channel == null) {
            throw new IllegalStateException("There is no WebSocketChannel associated with this request");
        }
        channel.authenticationReceived = true;
        String challengeUrl = channel.getLocation().toString();
        if (channel.redirectUri != null) {
            challengeUrl = channel.redirectUri.getScheme() + "://" + channel.redirectUri.getURI().getAuthority() + channel.redirectUri.getPath();
            challengeUrl = challengeUrl.replace("/;e/cb", "");
        }
        ChallengeRequest challengeRequest = new ChallengeRequest(challengeUrl, challenge);
        try {
            channel.challengeResponse = AuthenticationUtil.getChallengeResponse(challengeRequest, channel.challengeResponse);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage());
            this.handleClearAuthenticationData(request);
            throw new IllegalStateException("Unexpected error processing challenge " + challenge, e);
        }
        if (channel.challengeResponse == null || channel.challengeResponse.getCredentials() == null) {
            throw new IllegalStateException("No response possible for challenge " + challenge);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("response from challenge handler = " + StringUtils.stripControlCharacters(String.valueOf(channel.challengeResponse.getCredentials())));
        }
        try {
            HttpRequest newRequest = new HttpRequest(request.getMethod(), uri, request.isAsync());
            newRequest.parent = request.parent;
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                newRequest.setHeader(entry.getKey(), entry.getValue());
            }
            this.processOpen(newRequest);
        }
        catch (Exception e1) {
            LOG.log(Level.FINE, e1.getMessage(), e1);
            throw new Exception("Unable to authenticate user", e1);
        }
    }

    @Override
    public void processOpen(HttpRequest request) {
        Channel channel = this.getWebSocketChannel(request);
        if (channel != null && channel.challengeResponse.getCredentials() != null) {
            String credentials = new String(channel.challengeResponse.getCredentials());
            LOG.finest("requestOpened: Authorization: " + StringUtils.stripControlCharacters(credentials));
            request.setHeader(HEADER_AUTHORIZATION, credentials);
            this.handleClearAuthenticationData(request);
        }
        this.nextHandler.processOpen(request);
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, ByteBuffer payload) {
                HttpRequestAuthenticationHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                int responseCode = response.getStatusCode();
                switch (responseCode) {
                    case 200: {
                        ByteBuffer responseBuffer = response.getBody();
                        if (HttpRequestAuthenticationHandler.isHTTPResponse(responseBuffer)) {
                            try {
                                HttpRequestAuthenticationHandler.this.onLoadWrappedHTTPResponse(request, response);
                            }
                            catch (Exception e) {
                                LOG.log(Level.FINE, e.getMessage(), e);
                                HttpRequestAuthenticationHandler.this.listener.errorOccurred(request);
                            }
                            break;
                        }
                        HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                        HttpRequestAuthenticationHandler.this.listener.requestLoaded(request, response);
                        break;
                    }
                    case 401: {
                        String challenge = response.getHeader(HttpRequestAuthenticationHandler.HEADER_WWW_AUTHENTICATE);
                        try {
                            HttpRequestAuthenticationHandler.this.handle401(request, challenge);
                        }
                        catch (Exception e) {
                            LOG.log(Level.FINE, e.getMessage());
                            HttpRequestAuthenticationHandler.this.listener.errorOccurred(request);
                        }
                        break;
                    }
                    default: {
                        HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                        HttpRequestAuthenticationHandler.this.listener.requestLoaded(request, response);
                    }
                }
            }

            @Override
            public void requestClosed(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
            }

            @Override
            public void errorOccurred(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                HttpRequestAuthenticationHandler.this.listener.errorOccurred(request);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                HttpRequestAuthenticationHandler.this.handleRemoveAuthenticationData(request);
                HttpRequestAuthenticationHandler.this.listener.requestAborted(request);
            }
        });
    }

    @Override
    public void setListener(HttpRequestListener listener) {
        this.listener = listener;
    }
}

