/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.archgidutil;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ChangeIdInfo;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FieldChangeIdInfo;
import com.bmc.arsys.api.FormChangeIdInfo;
import com.bmc.arsys.api.GroupChangeIdInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VuiChangeIdInfo;
import com.bmc.arsys.demo.archgidutil.ArchgidInteractiveHandler;
import com.bmc.arsys.demo.archgidutil.ArchgidOperationConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ArchgidCommandLineUtil {
    private static final Logger LOGGER = Logger.getLogger(ArchgidCommandLineUtil.class);
    protected boolean isInteractiveFlow = false;
    protected long startTime = Integer.MIN_VALUE;
    protected String tcpPort = null;
    protected String authenticationString = null;
    protected String archgidInputFilePath = null;
    protected String operationName = null;
    protected String serverName = null;
    protected String userName = null;
    protected String password = null;
    protected String operationType = null;
    protected int normalTimeout = Integer.MIN_VALUE;
    protected int longTimeout = Integer.MIN_VALUE;
    protected int extraLongTimeout = Integer.MIN_VALUE;
    protected List<ChangeIdInfo> changeIdInfoList = new ArrayList<ChangeIdInfo>();
    protected String commandLineString = null;
    protected String chgidRunStatus = null;
    ARServerUser primaryServer = null;
    protected int oldId;
    protected int newId;
    protected String formName;
    protected StringBuilder overallExecutionStatus = new StringBuilder();
    boolean overallSuccess = true;

    public static void main(String[] args) throws Exception {
        ArchgidCommandLineUtil changeIdutil = new ArchgidCommandLineUtil();
        changeIdutil.arChangeId(args);
    }

    public boolean arChangeId(String args) throws ARException, Exception {
        this.commandLineString = args;
        return this.arChangeId(this.translateCommandline(args));
    }

    public boolean arChangeId(String[] args) throws Exception {
        try {
            LOGGER.info((Object)"(c) Copyright 2015-2016 BMC software, Inc.");
            BasicConfigurator.configure();
            this.startTime = System.currentTimeMillis();
            LOGGER.info((Object)"Started with Archgid with version:9.1.00 Build 001");
            LOGGER.info((Object)("Archgid Utility Run Start time: " + new Date()));
            this.chgidRunStatus = "START";
            this.parseAndVerifyCommandLineOptions(args);
            if (this.isInteractiveFlow) {
                ArchgidInteractiveHandler archgidInteractiveHandler = new ArchgidInteractiveHandler();
                archgidInteractiveHandler.handleInteractiveChangeId();
            } else {
                this.initServer();
            }
            Entry upgradeTrackerEntry = this.createUpgradeTrackerEntry();
            this.setChangeIdInfoList();
            this.processChangeIdWithAPI();
            this.updateUpgradeTrackerEntry(upgradeTrackerEntry);
            LOGGER.info((Object)("Total time taken in msec completing the Archgid run: " + (System.currentTimeMillis() - this.startTime) + " msec"));
            LOGGER.info((Object)("Archgid Utility Run End time: " + new Date()));
        }
        catch (ARException e) {
            LOGGER.error((Object)("ARException occured in server\n" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)("***Operation Error*** Please ensure supplied arguments \n" + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        return this.overallSuccess;
    }

    public String getOverAllStatus() {
        return this.overallExecutionStatus.toString();
    }

    private Entry createUpgradeTrackerEntry() throws ARException {
        if (this.isInteractiveFlow) {
            return null;
        }
        Entry entry = new Entry();
        entry.put(43001, new Value("archgid", DataType.CHAR));
        entry.put(43003, new Value("9.1.00 Build 001", DataType.CHAR));
        entry.put(43006, new Value((Object)((int)this.startTime), DataType.INTEGER));
        entry.put(43002, new Value(this.chgidRunStatus, DataType.CHAR));
        entry.put(43011, new Value(this.serverName, DataType.CHAR));
        entry.put(43010, new Value(this.commandLineString, DataType.CHAR));
        try {
            this.primaryServer.mergeEntry("AR System Upgrade Tracker", entry, 2);
        }
        catch (ARException e) {
            LOGGER.error((Object)"ARException occurred in createUpgradeTrackerEntry. ");
            throw e;
        }
        return entry;
    }

    private void updateUpgradeTrackerEntry(Entry existingEntry) throws ARException {
        if (this.isInteractiveFlow) {
            return;
        }
        if (existingEntry == null || existingEntry.getEntryId() == null) {
            return;
        }
        existingEntry.put(1, new Value(existingEntry.getEntryId(), DataType.CHAR));
        existingEntry.put(43001, new Value("archgid", DataType.CHAR));
        existingEntry.put(43005, new Value((Object)((int)System.currentTimeMillis()), DataType.INTEGER));
        existingEntry.put(43002, new Value(this.chgidRunStatus, DataType.CHAR));
        try {
            this.primaryServer.mergeEntry("AR System Upgrade Tracker", existingEntry, 4);
        }
        catch (ARException e) {
            LOGGER.error((Object)"ARException occurred in updateUpgradeTrackerEntry. ");
            throw e;
        }
    }

    private void setChangeIdInfoList() throws Exception {
        String[] fieldValues = null;
        String recordLine = null;
        int oldId = 0;
        int newId = 0;
        String formName = null;
        ChangeIdInfo changeIdInfo = null;
        String delims = "[\\\\;,:+\\*/\\^\\t ]+";
        ArrayList<String> records = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.archgidInputFilePath));
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((String)line)) continue;
                records.add(line);
            }
            reader.close();
            LOGGER.info((Object)Arrays.deepToString(records.toArray()));
            for (int i = 0; i < records.size(); ++i) {
                recordLine = ((String)records.get(i)).toString();
                fieldValues = recordLine.split(delims);
                oldId = this.parseId(fieldValues[0]);
                newId = this.parseId(fieldValues[1]);
                formName = this.prepareObjectName(fieldValues, recordLine);
                changeIdInfo = this.prepareChangeIdInfo(oldId, newId, formName);
                this.changeIdInfoList.add(changeIdInfo);
            }
            LOGGER.info((Object)("Successfully prepared input list from file \n" + this.changeIdInfoList));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Exception occurred trying to read path content. Check file Format and delimiter. Allowed delimiters are:  \\ ; , : + * / ^ tab space");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occurred trying to read path content. Check file Format " + this.archgidInputFilePath));
            throw e;
        }
    }

    private List<List<StatusInfo>> processChangeIdWithAPI() throws ARException {
        List<List<StatusInfo>> statusList = null;
        try {
            this.primaryServer.changeId(this.changeIdInfoList);
            statusList = this.primaryServer.getMultiLastStatus();
            this.parseChangeIdStatus(statusList);
            this.primaryServer.logout();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)"IllegalArgumentException in processChangeIdWithAPI");
            throw e;
        }
        catch (ARException e) {
            LOGGER.error((Object)"ARException in processChangeIdWithAPI");
            e.printStackTrace();
            throw e;
        }
        finally {
            this.primaryServer.logout();
        }
        this.chgidRunStatus = "archgid executed successfully";
        return statusList;
    }

    protected void initServer() throws ARException {
        if (null != this.primaryServer) {
            return;
        }
        this.primaryServer = new ARServerUser();
        this.primaryServer.setUser(this.userName);
        this.primaryServer.setPassword(this.password);
        this.primaryServer.setServer(this.serverName);
        this.primaryServer.setTimeoutNormal(this.normalTimeout);
        this.primaryServer.setTimeoutLong(this.longTimeout);
        this.primaryServer.setTimeoutXLong(this.extraLongTimeout);
        this.primaryServer.setAuthentication("");
        if (StringUtils.isNotEmpty((String)this.tcpPort)) {
            this.primaryServer.setPort(Integer.parseInt(this.tcpPort));
        }
        this.primaryServer.setDesignOverlayGroup("-2");
        this.primaryServer.login();
    }

    private boolean parseChangeIdStatus(List<List<StatusInfo>> errorStatusList) throws ARException {
        int recordCount = 0;
        if (errorStatusList.size() != this.changeIdInfoList.size()) {
            LOGGER.error((Object)"**** ARCHGID RUN STATUS DETAILS **** Status list not recieved for all inputs *****");
        }
        if (null != errorStatusList && !errorStatusList.isEmpty()) {
            LOGGER.info((Object)"**** ARCHGID RUN STATUS DETAILS **** \n");
            for (List<StatusInfo> statList : errorStatusList) {
                ChangeIdInfo inputRecord = this.changeIdInfoList.get(recordCount);
                String recordStatus = ++recordCount + ". " + "OldId = " + inputRecord.getOldId() + "\tNewId = " + inputRecord.getNewId() + "\tFormName = " + ChangeIdInfo.getFormName(inputRecord) + " >> " + (statList.isEmpty() ? "[ID_CHANGED_SUCCESS]" : (!statList.isEmpty() && statList.get(0).getMessageType() == 1 ? "[ID_CHANGED_SUCCESS_WITH_WARNING] " + statList.get(0).getMessageText() : "[ID_CHANGE_ERROR]=" + Arrays.deepToString(statList.toArray())));
                this.overallExecutionStatus.append("\n").append(recordStatus);
                if (statList.isEmpty() || statList.get(0).getMessageType() != 2) continue;
                this.overallSuccess = false;
            }
            LOGGER.info((Object)this.getOverAllStatus());
            if (this.overallSuccess) {
                LOGGER.info((Object)"**** ARCHGID RUN STATUS DETAILS **** ARCHGID RUN SUCCESS : NO ERROR IN THIS OPERATION ***");
            } else {
                LOGGER.error((Object)"**** ARCHGID RUN STATUS DETAILS **** ARCHGID RUN ERROR OCCURED *****");
            }
        }
        return this.overallSuccess;
    }

    private void parseAndVerifyCommandLineOptions(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            LOGGER.info((Object)"** INFO ** - Command Line Options Not provided for ArchgidUtil to Process.");
            LOGGER.info((Object)"** INFO ** - Archgid will dafault to interactive mode.");
            this.isInteractiveFlow = true;
            return;
        }
        Options options = new Options();
        options.addOption("c", true, "operation name");
        options.addOption("F", true, "Path of Input Ids file");
        options.addOption("o", false, "");
        options.addOption("x", true, "server name");
        options.addOption("t", true, "tcp port");
        options.addOption("u", true, "user name");
        options.addOption("p", true, "password");
        options.addOption("N", true, "Normal Timeout");
        options.addOption("L", true, "Long Timeout");
        options.addOption("X", true, "Extra LongTimeout");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            LOGGER.info((Object)("Supplied Archgid Command Line Options : " + Arrays.deepToString(cmd.getOptions())));
            this.parseCommandLineOptions(cmd);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("** ERROR in arguments parsing: ** " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
    }

    private void parseCommandLineOptions(CommandLine cmd) {
        if (cmd.hasOption("F")) {
            this.archgidInputFilePath = cmd.getOptionValue("F");
            LOGGER.info((Object)("Input File Path = " + this.archgidInputFilePath));
            if (StringUtils.isEmpty((String)this.archgidInputFilePath)) {
                LOGGER.error((Object)"**ERROR** archgidInputFilePath argument not provided");
            } else if (!new File(this.archgidInputFilePath).exists()) {
                LOGGER.error((Object)"**ERROR** archgidInputFilePath incorrect. File not exists on location.");
                throw new IllegalArgumentException("archgidInputFile not exists on location");
            }
        }
        if (cmd.hasOption("c")) {
            this.operationType = cmd.getOptionValue("c");
            LOGGER.info((Object)("Operation Type = " + this.operationType));
            if (StringUtils.isEmpty((String)this.operationType)) {
                LOGGER.error((Object)"**ERROR** operationType argument not provided");
            }
        }
        if (cmd.hasOption("x")) {
            this.serverName = cmd.getOptionValue("x");
            LOGGER.info((Object)("serverName = " + this.serverName));
            if (StringUtils.isEmpty((String)this.serverName)) {
                LOGGER.error((Object)"**ERROR** serverName argument not provided");
            }
        }
        if (cmd.hasOption("u")) {
            this.userName = cmd.getOptionValue("u");
            LOGGER.info((Object)("username = " + this.userName));
            if (StringUtils.isEmpty((String)this.userName)) {
                LOGGER.error((Object)"**ERROR** user argument not provided");
            }
        }
        if (cmd.hasOption("p")) {
            this.password = cmd.getOptionValue("p");
            LOGGER.info((Object)("password = " + this.password));
        }
        if (cmd.hasOption("N")) {
            this.normalTimeout = Integer.parseInt(cmd.getOptionValue("N"));
            LOGGER.info((Object)("normalTimeOut = " + this.normalTimeout));
        }
        if (cmd.hasOption("L")) {
            this.longTimeout = Integer.parseInt(cmd.getOptionValue("L"));
            LOGGER.info((Object)("longTimeout = " + this.longTimeout));
        }
        if (cmd.hasOption("X")) {
            this.extraLongTimeout = Integer.parseInt(cmd.getOptionValue("X"));
            LOGGER.info((Object)("extraLongTimeout = " + this.extraLongTimeout));
        }
        if (cmd.hasOption("t")) {
            this.tcpPort = cmd.getOptionValue("t");
            LOGGER.info((Object)("tcp port = " + this.tcpPort));
        }
    }

    protected ChangeIdInfo prepareChangeIdInfo(int oldId, int newId, String formName) {
        ChangeIdInfo changeIdInfo = null;
        int operationTypeInt = Integer.parseInt(this.operationType);
        ArchgidOperationConstants operation = ArchgidOperationConstants.getOperation(operationTypeInt);
        switch (operation) {
            case AR_CHG_OPERATION_FORM: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new FormChangeIdInfo(oldId, newId);
                break;
            }
            case AR_CHG_OPERATION_FIELD: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new FieldChangeIdInfo(oldId, newId, formName);
                break;
            }
            case AR_CHG_OPERATION_VUI: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new VuiChangeIdInfo(oldId, newId, formName);
                break;
            }
            case AR_CHG_OPERATION_GROUP: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new GroupChangeIdInfo(oldId, newId);
                break;
            }
            case AR_CHG_OPERATION_FIELD_BULK: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new FieldChangeIdInfo(oldId, newId, formName);
                break;
            }
            case AR_CHG_OPERATION_FIELD_BULK2: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new FieldChangeIdInfo(oldId, newId, formName);
                break;
            }
            case AR_CHG_OPERATION_VUI_BULK: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new VuiChangeIdInfo(oldId, newId, formName);
                break;
            }
            case AR_CHG_OPERATION_VUI_BULK2: {
                LOGGER.info((Object)("in switch case of  : " + (Object)((Object)operation)));
                changeIdInfo = new VuiChangeIdInfo(oldId, newId, formName);
                break;
            }
            default: {
                LOGGER.info((Object)"in switch case of  : DEFAULT ");
            }
        }
        return changeIdInfo;
    }

    private String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    v.addElement(current.toString());
                    current = new StringBuffer();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new Exception("unbalanced quotes in " + toProcess);
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    private int parseId(String idString) {
        if (StringUtils.isNumeric((String)idString)) {
            return Integer.valueOf(idString);
        }
        LOGGER.error((Object)("** ERROR ** Id field is not numeric : " + idString));
        throw new IllegalArgumentException("Id field is not numeric: " + idString);
    }

    private String prepareObjectName(String[] fieldValues, String completeRecordString) {
        String objectName = "";
        if (fieldValues[2] == null || StringUtils.isEmpty((String)fieldValues[2])) {
            LOGGER.error((Object)"** ERROR ** Form/VUI Name is not provided properly");
        } else {
            objectName = completeRecordString.substring(completeRecordString.indexOf(fieldValues[2]), completeRecordString.length());
        }
        return objectName.trim();
    }
}

