/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.ViewItemData;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportCommandParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private static final String ELEM_EXPORT_SET = "exportset";
    private static final String ATTRIB_TYPE = "type";
    private static final String ELEM_VIEW = "view";
    private static final String ELEM_SUB_ITEM = "subItem";
    private static final String ELEM_ITEM = "item";
    private static final String ATTRIB_VIEW_TYPE = "viewType";
    private static final String ATTRIB_VIEW_ID = "viewId";
    private static final String ATTRIB_FORM = "form";
    private static final String ATTRIB_LABEL = "label";
    private static final String ATTRIB_LOCALE = "locale";
    private static final String ATTRIB_LOCKED = "locked";
    private static final String ATTRIB_RELATED = "related";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_ID = "id";
    private static final String ELEM_ITEMTYPE = "itemTtype";
    private static final String ELEM_PL_PACKINGLIST_ROOT = "packinglist";
    private static final String ELEM_PL_FORMSLIST = "forms-list";
    private static final String ELEM_PL_FORMS = "forms";
    private static final String ELEM_PL_ACTIVELINKSLIST = "active-links-list";
    private static final String ELEM_PL_ACTIVELINKS = "active-links";
    private static final String ELEM_PL_FILTERSLIST = "filters-list";
    private static final String ELEM_PL_FILTERS = "filters";
    private static final String ELEM_PL_ESCALATIONSLIST = "esclations-list";
    private static final String ELEM_PL_ESCALATIONS = "esclations";
    private static final String ELEM_PL_ACTIVELINKGUIDESLIST = "active-link-guides-list";
    private static final String ELEM_PL_ACTIVELINKGUIDES = "active-link-guides";
    private static final String ELEM_PL_FILTERGUIDESLIST = "filter-guides-list";
    private static final String ELEM_PL_FILTERGUIDES = "filter-guides";
    private static final String ELEM_PL_APPLICATIONSLIST = "applications-list";
    private static final String ELEM_PL_APPLICATIONS = "applications";
    private static final String ELEM_PL_PACKINGLISTSLIST = "packing-lists-list";
    private static final String ELEM_PL_PACKINGLISTS = "packing-lists";
    private static final String ELEM_PL_MENUSLIST = "menus-list";
    private static final String ELEM_PL_MENUS = "menus";
    private static final String ELEM_PL_GROUPSLIST = "groups-list";
    private static final String ELEM_PL_GROUPS = "groups";
    private static final String ELEM_PL_DSOMAPSLIST = "distributed-mappings-list";
    private static final String ELEM_PL_DSOMAPS = "distributed-mappings";
    private static final String ELEM_PL_DSOPOOLSLIST = "distributed-pools-list";
    private static final String ELEM_PL_DSOPOOLS = "distributed-pools";
    private static final String ELEM_PL_WEBSERVICESLIST = "web-services-list";
    private static final String ELEM_PL_WEBSERVICES = "web-services";
    private static final String ELEM_TYPE = "type";
    private static final String VERSION_NUMBER = "1";
    private static final String ATTRIB_VERSION = "version";
    private DefinitionOptions options = null;
    private DefinitionItemType currentType = null;
    private boolean packingList = false;
    private boolean exportSet = false;
    private boolean isExport = false;

    public ExportCommandParser(DefinitionOptions options) {
        this.options = options;
    }

    public Document exportDataToXML() throws ParserConfigurationException {
        if (this.options == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement(ELEM_EXPORT_SET);
        root.setAttribute(ATTRIB_VERSION, VERSION_NUMBER);
        doc.appendChild(root);
        Map<DefinitionItemType, List<BaseItemData>> items = this.options.getItems();
        for (DefinitionItemType type : items.keySet()) {
            Element typeElement = doc.createElement(ELEM_ITEMTYPE);
            typeElement.setAttribute(ATTRIB_ID, Integer.toString(type.getConstant()));
            root.appendChild(typeElement);
            List<BaseItemData> list = items.get((Object)type);
            for (BaseItemData baseItemData : list) {
                if (baseItemData instanceof DefinitionItemData) {
                    DefinitionItemData item = (DefinitionItemData)baseItemData;
                    Element itemElement = doc.createElement(ELEM_ITEM);
                    itemElement.setAttribute("type", Integer.toString(item.getType().getConstant()));
                    itemElement.setAttribute(ATTRIB_NAME, item.getName());
                    itemElement.setAttribute(ATTRIB_RELATED, item.getRelated().toString());
                    itemElement.setAttribute(ATTRIB_LOCKED, Boolean.toString(item.isLocked()));
                    if (item.getSubItems() != null && item.getSubItems().size() > 0) {
                        for (String subItemName : item.getSubItems()) {
                            Element subItem = doc.createElement(ELEM_SUB_ITEM);
                            subItem.setAttribute(ATTRIB_NAME, subItemName);
                            itemElement.appendChild(subItem);
                        }
                    }
                    typeElement.appendChild(itemElement);
                    continue;
                }
                if (!(baseItemData instanceof ViewItemData)) continue;
                ViewItemData view = (ViewItemData)baseItemData;
                Element viewElement = doc.createElement(ELEM_VIEW);
                viewElement.setAttribute(ATTRIB_NAME, view.getName());
                viewElement.setAttribute(ATTRIB_LOCALE, view.getLocale());
                viewElement.setAttribute(ATTRIB_LABEL, view.getLabel());
                viewElement.setAttribute(ATTRIB_FORM, view.getForm());
                viewElement.setAttribute(ATTRIB_VIEW_ID, Integer.toString(view.getViewId()));
                viewElement.setAttribute(ATTRIB_VIEW_TYPE, Integer.toString(view.getVuiType()));
                typeElement.appendChild(viewElement);
            }
        }
        return doc;
    }

    public void populateFromFile(File file, boolean isExport) {
        this.isExport = isExport;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(file, (DefaultHandler)this);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ELEM_PL_PACKINGLIST_ROOT)) {
            this.packingList = true;
        } else if (qName.equals(ELEM_EXPORT_SET)) {
            this.exportSet = true;
        }
        if (this.exportSet) {
            if (qName.equals("type")) {
                this.currentType = DefinitionItemType.valueOf(attributes.getValue(ATTRIB_NAME));
            }
            if (this.currentType != null && qName.equals("object")) {
                RelatedType related = RelatedType.valueOf(attributes.getValue(ATTRIB_RELATED));
                String name = attributes.getValue(ATTRIB_NAME);
                this.options.add(new DefinitionItemData(this.currentType, name, related));
                if (!this.isExport && !related.equals((Object)RelatedType.NONE) && logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)MessageFormat.format("Importing related objects is not supported. {0} {1} will be imported as a stand alone object.", this.currentType.getTypeName(), name));
                }
            }
        }
        if (this.packingList) {
            String name = attributes.getValue(ATTRIB_NAME);
            if (qName.equals(ELEM_PL_ACTIVELINKGUIDES)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.ACTIVE_LINK_GUIDE, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_ACTIVELINKS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.ACTIVE_LINK, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_APPLICATIONS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.APPLICATION, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_DSOMAPS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.DISTRIBUTED_MAPPING, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_DSOPOOLS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.DISTRIBUTED_POOL, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_ESCALATIONS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.ESCALATION, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_FILTERGUIDES)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.FILTER_GUIDE, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_FILTERS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.FILTER, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_FORMS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.FORM, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_MENUS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.MENU, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_PACKINGLISTS)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.PACKING_LIST, name, RelatedType.NONE));
            }
            if (qName.equals(ELEM_PL_WEBSERVICES)) {
                this.options.add(new DefinitionItemData(DefinitionItemType.WEB_SERVICE, name, RelatedType.NONE));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("type")) {
            this.currentType = null;
        }
    }

    public void exportDataToFile(String fileLocation, DefinitionOptions options) {
        if (options == null) {
            return;
        }
        try {
            Document doc = this.exportDataToXML();
            if (doc != null) {
                OutputFormat format = new OutputFormat(doc);
                format.setIndenting(true);
                XMLSerializer serializer = new XMLSerializer(new FileOutputStream(new File(fileLocation)), format);
                serializer.serialize(doc);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

