/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.xml;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ARXMLParser
extends Parser
implements ContentHandler {
    private static final char AR_DEFN_DIARY_SEP = '\u0003';
    private static final char AR_DEFN_DIARY_COMMA = '\u0004';
    private static final char AR_DEFN_STAT_HIST_SEP = '\u0003';
    private static final char AR_DEFN_STAT_HIST_COMMA = '\u0004';
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String FIELD = "field";
    private static final String FIELD_INFO = "field-info";
    private static final String INSTANCE = "instance";
    private static final String ID = "id";
    private static final String XFORM = "xform";
    private XMLReader parser = null;
    private boolean parsingData = false;
    private boolean parsingFormInfo = false;
    private boolean parsingFieldInfo = false;
    private boolean parsingRow = false;
    private boolean parsingStatusHistory = false;
    private boolean parsingDiary = false;
    private boolean parsingUser = false;
    private boolean parsingDate = false;
    private boolean parsingDiaryText = false;
    private boolean parsingAttachType = false;
    private boolean parsingAttachFileName = false;
    private boolean parsingPlainText = false;
    private boolean parsingAttachment = false;
    private boolean parsingCurrency = false;
    private boolean parsingCurrencyValue = false;
    private boolean parsingCurrencyType = false;
    private boolean parsingCurrencyDate = false;
    private boolean parsingCurrencyFunctional = false;
    private StringBuffer currentToken;
    private StringBuffer attachType;
    private StringBuffer attachFileName;
    private StringBuffer formName;
    private StringBuffer user;
    private StringBuffer date;
    private StringBuffer diaryText;
    private StringBuffer currencyValue;
    private StringBuffer currencyType;
    private StringBuffer currencyDate;
    private StringBuffer currencyFunctional;
    private List<String> dataTokens = null;
    private FormInformation currentForm = null;
    private FieldInformation currentField = null;
    private StringBuffer fieldName;
    private StringBuffer fieldType;
    private StringBuffer fieldId;
    private StringWriter writer = null;
    private XMLSerializer xmlSerializer = null;
    private final OutputFormat format = new OutputFormat();
    private int tokenIndex = 0;

    public ARXMLParser() throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        this.parser = new SAXParser();
        this.parser.setFeature("http://xml.org/sax/features/validation", false);
        this.format.setOmitXMLDeclaration(true);
    }

    public void parseFile(String fileName) throws IOException, SAXException {
        this.parser.setContentHandler(this);
        this.parser.parse(new File(fileName).toURI().toString());
    }

    public List<FormInformation> extractFormInformation(String fileName, boolean firstOnly) {
        ArrayList<FormInformation> result = new ArrayList<FormInformation>();
        FormInformation schemaInfo = null;
        try {
            schemaInfo = this.extractFieldInfo(fileName, null);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ARImportException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (schemaInfo != null) {
            result.add(schemaInfo);
        }
        return result;
    }

    public FormInformation extractFieldInfo(String strFile, FormInformation schemaInfo) throws DOMException, ARImportException, SAXException, IOException {
        FormInformation result = null;
        DOMParser parser = new DOMParser();
        parser.parse(new File(strFile).toURI().toString());
        result = this.extractFieldInfo(parser.getDocument(), schemaInfo);
        return result;
    }

    public FormInformation extractFieldInfo(Document document, FormInformation schemaInfo) throws DOMException, ARImportException {
        FormInformation result = null;
        result = schemaInfo == null ? new FormInformation() : schemaInfo;
        Element root = document.getDocumentElement();
        NodeList xformList = root.getChildNodes();
        block0: for (int iLoop = 0; iLoop < xformList.getLength(); ++iLoop) {
            Node xformItem = xformList.item(iLoop);
            if (!XFORM.equals(xformItem.getNodeName())) continue;
            Node schemaNode = xformItem.getAttributes().getNamedItem(ID);
            result.setName(schemaNode.getNodeValue());
            NodeList instanceList = xformItem.getChildNodes();
            for (int jLoop = 0; jLoop < instanceList.getLength(); ++jLoop) {
                Node instanceItem = instanceList.item(jLoop);
                if (!INSTANCE.equals(instanceItem.getNodeName())) continue;
                NodeList fieldInfoList = instanceItem.getChildNodes();
                for (int kLoop = 0; kLoop < fieldInfoList.getLength(); ++kLoop) {
                    Node fieldInfoItem = fieldInfoList.item(kLoop);
                    if (!FIELD_INFO.equals(fieldInfoItem.getNodeName())) continue;
                    NodeList fieldList = fieldInfoItem.getChildNodes();
                    for (int mLoop = 0; mLoop < fieldList.getLength(); ++mLoop) {
                        Node fieldItem = fieldList.item(mLoop);
                        if (!FIELD.equals(fieldItem.getNodeName())) continue;
                        NodeList paramList = fieldItem.getChildNodes();
                        FieldInformation fieldInfo = new FieldInformation();
                        for (int pLoop = 0; pLoop < paramList.getLength(); ++pLoop) {
                            Node paramItem = paramList.item(pLoop);
                            if (NAME.equals(paramItem.getNodeName())) {
                                fieldInfo.setName(paramItem.getFirstChild().getNodeValue());
                                continue;
                            }
                            if (ID.equals(paramItem.getNodeName())) {
                                fieldInfo.setFieldId(paramItem.getFirstChild().getNodeValue());
                                continue;
                            }
                            if (!TYPE.equals(paramItem.getNodeName())) continue;
                            fieldInfo.setDataType(paramItem.getFirstChild().getNodeValue());
                        }
                        result.getFields().put(fieldInfo.getFieldId(), fieldInfo);
                    }
                    break block0;
                }
                break block0;
            }
            break;
        }
        return result;
    }

    public Document openFile(String strFile) {
        Logger logger = ThreadLocalStorage.getLogger();
        Document result = null;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new File(strFile).toURI().toString());
            result = parser.getDocument();
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), e), (Throwable)e);
        }
        return result;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.parsingRow && this.xmlSerializer != null) {
            this.xmlSerializer.characters(ch, start, length);
        }
        if (this.parsingPlainText || this.parsingStatusHistory || this.parsingDiary || this.parsingAttachment || this.parsingCurrency) {
            if (!(!this.parsingPlainText || this.parsingStatusHistory || this.parsingDiary || this.parsingAttachment || this.parsingCurrency)) {
                this.currentToken.append(ch, start, length);
            } else if (this.parsingUser) {
                this.user.append(ch, start, length);
            } else if (this.parsingDate) {
                this.date.append(ch, start, length);
            } else if (this.parsingDiaryText) {
                this.diaryText.append(ch, start, length);
            } else if (this.parsingAttachType) {
                this.attachType.append(ch, start, length);
            } else if (this.parsingAttachFileName) {
                this.attachFileName.append(ch, start, length);
            } else if (this.parsingCurrencyValue) {
                this.currencyValue.append(ch, start, length);
            } else if (this.parsingCurrencyType) {
                this.currencyType.append(ch, start, length);
            } else if (this.parsingCurrencyDate) {
                this.currencyDate.append(ch, start, length);
            } else if (this.parsingCurrencyFunctional) {
                this.currencyFunctional.append(ch, start, length);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            this.fireEvent(new ParseEvent(2));
        }
        catch (ARImportException e) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), e), (Throwable)e);
        }
        catch (ARException e) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), new Object[]{e}), (Throwable)e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.parsingRow) {
            this.xmlSerializer.endElement(uri, localName, qName);
        }
        if (XFORM.equals(localName)) {
            this.parsingFormInfo = false;
            this.parsingFieldInfo = false;
            this.parsingData = false;
            this.parsingRow = false;
            this.parsingStatusHistory = false;
            this.parsingDiary = false;
            this.parsingUser = false;
            this.parsingDate = false;
            this.parsingDiaryText = false;
        }
        if (this.parsingFormInfo && FIELD_INFO.equals(localName)) {
            this.parsingFieldInfo = false;
            this.parsingFormInfo = false;
            this.parsingData = true;
            try {
                this.fireEvent(new ParseEvent(0, this.currentForm));
            }
            catch (ARImportException e) {
                logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), e), (Throwable)e);
                throw new SAXException(ImportErrors.IMPORT_ERROR_PARSING.toDefMsg(), e);
            }
            catch (ARException e) {
                logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), new Object[]{e}), (Throwable)e);
                throw new SAXException(ImportErrors.IMPORT_ERROR_PARSING.toDefMsg(), (Exception)((Object)e));
            }
        }
        if (this.parsingFieldInfo) {
            if (FIELD.equals(localName)) {
                this.parsingFieldInfo = false;
                this.currentField.setTokenIndex(this.tokenIndex);
                ++this.tokenIndex;
                this.currentForm.getFields().put(this.currentField.getFieldId(), this.currentField);
            } else if (NAME.equals(localName) && this.parsingFieldInfo) {
                this.currentField.setName(this.currentToken.toString());
                this.parsingPlainText = false;
            } else if (ID.equals(localName) && this.parsingFieldInfo) {
                this.currentField.setFieldId(this.currentToken.toString());
                this.parsingPlainText = false;
            } else if (TYPE.equals(localName) && this.parsingFieldInfo) {
                try {
                    this.currentField.setDataType(this.currentToken.toString());
                }
                catch (ARImportException e) {
                    logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), e));
                    throw new SAXException(ImportErrors.IMPORT_ERROR_PARSING.toDefMsg(), e);
                }
                this.parsingPlainText = false;
            }
        }
        if (this.parsingData) {
            if ("attach_value".equals(localName)) {
                this.currentToken.append(this.attachType);
                this.currentToken.append(" ");
                this.currentToken.append(this.attachFileName);
                this.attachType = null;
                this.attachFileName = null;
            } else if ("loc_type".equals(localName)) {
                this.parsingAttachType = false;
            } else if ("filename".equals(localName) || "buffer".equals(localName)) {
                this.parsingAttachFileName = false;
            } else if ("status_history".equals(localName) || "Status_History".equals(localName)) {
                if (this.date != null && this.date.length() > 0) {
                    this.currentToken.append(this.date);
                    this.currentToken.append('\u0004');
                    this.currentToken.append(this.user);
                    this.currentToken.append('\u0003');
                } else {
                    this.currentToken.append('\u0003');
                }
                this.date = null;
                this.user = null;
            } else if ("diary".equals(localName)) {
                if (this.date != null && this.date.length() > 0) {
                    this.currentToken.append(this.date);
                    this.currentToken.append('\u0004');
                    this.currentToken.append(this.user);
                    this.currentToken.append('\u0004');
                    this.currentToken.append(this.diaryText);
                    this.currentToken.append('\u0003');
                } else {
                    this.currentToken.append('\u0003');
                }
            } else if ("currency".equals(localName)) {
                this.currentToken.append(this.currencyValue);
                this.currentToken.append(" ");
                this.currentToken.append(this.currencyType);
                this.currentToken.append(" ");
                this.currentToken.append(this.currencyDate);
                this.currentToken.append(" ");
                this.currentToken.append(this.currencyFunctional);
                this.currencyFunctional = null;
                this.currencyDate = null;
                this.currencyType = null;
                this.currencyValue = null;
            } else if ("currency_value".equals(localName)) {
                this.parsingCurrencyValue = false;
            } else if ("currency_type".equals(localName)) {
                this.parsingCurrencyType = false;
            } else if ("currency_date".equals(localName)) {
                this.parsingCurrencyDate = false;
            } else if ("currency_functional".equals(localName)) {
                this.parsingCurrencyFunctional = false;
            } else if ("user".equals(localName)) {
                this.parsingUser = false;
            } else if ("date".equals(localName)) {
                this.parsingDate = false;
            } else if ("diary_content".equals(localName)) {
                this.parsingDiaryText = false;
            } else if ("value".equals(localName) && this.parsingRow) {
                this.parsingPlainText = false;
            } else if ("entry".equals(localName)) {
                this.xmlSerializer.endDocument();
                this.xmlSerializer = null;
                this.parsingRow = false;
                try {
                    if (this.isAbort() && this.isCopyToLog()) {
                        this.fireEvent(new ParseEvent(1, null, this.writer.toString()));
                    }
                    this.fireEvent(new ParseEvent(1, this.dataTokens, this.writer.toString()));
                }
                catch (ARImportException e) {
                    logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), e), (Throwable)e);
                    throw new SAXException(ImportErrors.IMPORT_ERROR_PARSING.toDefMsg(), e);
                }
                catch (ARException e) {
                    logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), new Object[]{e}), (Throwable)e);
                    throw new SAXException(ImportErrors.IMPORT_ERROR_PARSING.toDefMsg(), (Exception)((Object)e));
                }
            } else if ("field_value".equals(localName) && this.parsingRow) {
                if (this.parsingStatusHistory) {
                    this.parsingStatusHistory = false;
                } else if (this.parsingDiary) {
                    this.parsingDiary = false;
                } else if (this.parsingAttachment) {
                    this.parsingAttachment = false;
                } else if (this.parsingCurrency) {
                    this.parsingCurrency = false;
                }
                String tokenString = this.currentToken.toString();
                tokenString = tokenString.replace("\\r\\n", "\r\n");
                tokenString = tokenString.replace("\\r", "\r");
                tokenString = tokenString.replace("\\n", "\n");
                this.dataTokens.add(tokenString);
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.xmlSerializer = new XMLSerializer();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.parsingRow) {
            this.xmlSerializer.startElement(uri, localName, qName, atts);
        }
        if (XFORM.equals(localName)) {
            String value = atts.getValue(ID);
            this.parsingFormInfo = true;
            this.currentToken = new StringBuffer();
            this.currentForm = new FormInformation();
            this.tokenIndex = 0;
            this.currentForm.setName(value);
        } else if (FIELD_INFO.equals(localName)) {
            this.parsingFormInfo = true;
        } else if (this.parsingFormInfo) {
            if (FIELD.equals(localName)) {
                this.parsingFieldInfo = true;
                this.currentField = new FieldInformation();
            } else if (NAME.equals(localName) && this.parsingFieldInfo) {
                this.currentToken = new StringBuffer();
                this.parsingPlainText = true;
            } else if (ID.equals(localName) && this.parsingFieldInfo) {
                this.currentToken = new StringBuffer();
                this.parsingPlainText = true;
            } else if (TYPE.equals(localName) && this.parsingFieldInfo) {
                this.currentToken = new StringBuffer();
                this.parsingPlainText = true;
            }
        } else if (this.parsingData) {
            if ("attach_value".equals(localName)) {
                this.parsingAttachment = true;
            } else if ("loc_type".equals(localName)) {
                this.parsingAttachType = true;
                this.attachType = new StringBuffer();
            } else if ("filename".equals(localName) || "buffer".equals(localName)) {
                this.parsingAttachFileName = true;
                this.attachFileName = new StringBuffer();
            } else if ("status_history".equals(localName) || "Status_History".equals(localName)) {
                this.parsingStatusHistory = true;
            } else if ("diary".equals(localName)) {
                this.parsingDiary = true;
            } else if ("currency".equals(localName)) {
                this.parsingCurrency = true;
            } else if ("currency_value".equals(localName)) {
                this.parsingCurrencyValue = true;
                this.currencyValue = new StringBuffer();
            } else if ("currency_type".equals(localName)) {
                this.parsingCurrencyType = true;
                this.currencyType = new StringBuffer();
            } else if ("currency_date".equals(localName)) {
                this.parsingCurrencyDate = true;
                this.currencyDate = new StringBuffer();
            } else if ("currency_functional".equals(localName)) {
                this.parsingCurrencyFunctional = true;
                this.currencyFunctional = new StringBuffer();
            } else if ("user".equals(localName)) {
                this.parsingUser = true;
                this.user = new StringBuffer();
            } else if ("date".equals(localName)) {
                this.parsingDate = true;
                this.date = new StringBuffer();
            } else if ("diary_content".equals(localName)) {
                this.parsingDiaryText = true;
                this.diaryText = new StringBuffer();
            } else if ("value".equals(localName) && this.parsingRow) {
                this.parsingPlainText = true;
            } else if ("entry".equals(localName)) {
                this.parsingRow = true;
                this.writer = new StringWriter();
                this.xmlSerializer = new XMLSerializer(this.writer, this.format);
                this.xmlSerializer.startDocument();
                this.xmlSerializer.startElement(uri, localName, qName, atts);
                this.dataTokens = new ArrayList<String>();
            } else if ("field_value".equals(localName) && this.parsingRow) {
                this.currentToken = new StringBuffer();
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

