/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.arm;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FileOptions;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ARMXMLParser
extends DefaultHandler
implements IParser {
    private static final String ELEM_DATAHANDLING = "datahandling";
    private static final String ATTRIB_BADRECORDS = "badrecords";
    private static final String BADRECORDS_SKIP = "SKIP";
    private static final String BADRECORDS_FALLBACK = "FALLBACK";
    private static final String ATTRIB_DUPLICATERECORDS = "duplicaterecords";
    private static final String DUP_ERROR = "DUP_ERROR";
    private static final String DUP_NEW_ID = "DUP_NEW_ID";
    private static final String DUP_OVERWRITE = "DUP_OVERWRITE";
    private static final String DUP_MERGE = "DUP_MERGE";
    private static final String GEN_NEWID = "GEN_NEW_ID";
    private static final String ATTRIB_STRIPLEADING = "stripleading";
    private static final String ATTRIB_STRIPTRAILING = "striptrailing";
    private static final String ATTRIB_TRUNCATE = "truncate";
    private static final String ELEM_DUPLICATEMATCHING = "duplicatematching";
    private static final String ELEM_FALLBACK = "fallback";
    private static final String ATTRIB_TYPE = "type";
    private static final String NONE = "NONE";
    private static final String COMPOUND = "COMPOUND";
    private static final String CONSTANT = "CONSTANT";
    private static final String KEYWORD = "KEYWORD";
    private static final String ATTRIB_CONSTANT = "constant";
    private static final String ATTRIB_COMPOUND = "compound";
    private static final String ATTRIB_KEYWORD = "keyword";
    private static final String ELEM_FIELD = "field";
    private static final String ATTRIB_ID = "id";
    private static final String ELEM_FLAGS = "flags";
    private static final String ATTRIB_DISABLEREQUIRED = "disableRequired";
    private static final String ATTRIB_DISABLEPATTERN = "disablePattern";
    private static final String ATTRIB_SUPPRESSFILTERS = "suppressFilters";
    private static final String ATTRIB_ALLOWTOOMANY = "allowTooMany";
    private static final String ATTRIB_ALLOWTOOFEW = "allowTooFew";
    private static final String ATTRIB_MULTIMATCH = "multimatch";
    private static final String SKIP = "SKIP";
    private static final String USEFIRST = "USEFIRST";
    private static final String ATTRIB_FORCEOVERRIDE = "forceoverride";
    private static final String ATTRIB_SUPPRESSDEFAULTS = "suppressDefaults";
    private static final String ELEM_FORMMAP = "formmap";
    private static final String ATTRIB_FILEFORM = "fileform";
    private static final String ATTRIB_SERVERFORM = "serverform";
    private static final String ELEM_FORMMAPPINGS = "formmappings";
    private static final String ELEM_IMPORTMAPPING = "importmapping";
    private static final String ATTRIB_NAME = "name";
    private static final String ELEM_MAPPING = "mapping";
    private static final String ATTRIB_FIELD = "field";
    private static final String ELEM_NORMAL = "normal";
    private static final String FIELDID = "FIELDID";
    private static final String FIELDNAME = "FIELDNAME";
    private static final String ATTRIB_FIELDID = "fieldid";
    private static final String ATTRIB_TOKENINDEX = "tokenIndex";
    private static final String ATTRIB_FIELDNAME = "fieldname";
    private static final String ELEM_OPTIONS = "options";
    private static final String ELEM_SOURCEFILE = "sourcefile";
    private static final String ELEM_DESTINATIONSERVER = "destinationserver";
    private static final String ATTRIB_FILENAME = "filename";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String ASCII = "ASCII";
    private static final String CSV = "CSV";
    private static final String ARX = "ARX";
    private static final String XML = "XML";
    private static final String ATTRIB_TITLES = "titles";
    private static final String ATTRIB_SEPERATOR = "seperator";
    private static final String ELEM_TIMEHANDLING = "timehandling";
    private static final String ATTRIB_DATEFORMAT = "dateFormat";
    private static final String ATTRIB_TIMEFORMAT = "timeFormat";
    private static final String ATTRIB_DATETIMEFORMAT = "dateTimeFormat";
    private static final String ATTRIB_DATESEPARATOR = "dateSeparator";
    private static final String ATTRIB_USE24HOUR = "use24Hour";
    private static final String ATTRIB_AMPMSUFFIX = "ampmSuffix";
    private static final String ATTRIB_AMSYMBOL = "amSymbol";
    private static final String ATTRIB_PMSYMBOL = "pmSymbol";
    private static final String ATTRIB_TIMESEPARATOR = "timeSeparator";
    private static final String ATTRIB_TRANSACTIONSIZE = "transactionSize";
    private static final String ELEM_REALNUMBERHANDLING = "realnumberhandling";
    private static final String ATTRIB_DIGITGROUPSEPARATOR = "digitgroupSeparator";
    private static final String ATTRIB_DECIMALSEPARATOR = "decimalSeparator";
    private ImportOptions options = null;
    private boolean parsingDuplicateMatching = false;
    private boolean parsingFormMap = false;
    private String currentSourceForm = null;
    private String currentTargetForm = null;
    private int currentField = -1;
    private boolean parsingMapping = false;
    private MappingOptions mappingOptions = null;
    private final List<IParseListener> listeners = new ArrayList<IParseListener>();
    private boolean abort = false;
    private Map<String, String> tempArgs = null;

    public ARMXMLParser(ImportOptions options) {
        this.options = options;
        this.tempArgs = new HashMap<String, String>();
    }

    public ARMXMLParser(ImportOptions options, Map<String, String> tempArgs) {
        this.options = options;
        this.tempArgs = tempArgs != null ? tempArgs : new HashMap<String, String>();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (ELEM_DUPLICATEMATCHING.equals(name)) {
            this.parsingDuplicateMatching = false;
        } else if (ELEM_MAPPING.equals(name)) {
            this.parsingMapping = false;
        } else if (ELEM_FORMMAP.equals(name)) {
            this.parsingFormMap = false;
            this.options.getFormMap().put(this.currentSourceForm, this.currentTargetForm);
            this.options.addMappingOptions(this.currentSourceForm, this.currentTargetForm, this.mappingOptions);
            this.currentSourceForm = null;
            this.currentTargetForm = null;
            this.mappingOptions = null;
            this.currentField = -1;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (ELEM_DATAHANDLING.equals(qName)) {
            if (this.options.getDataOptions() == null) {
                this.options.setDataOptions(new DataOptions());
            }
            this.options.getDataOptions().setBadRecordHandling(DataOptions.BadRecords.valueOf(atts.getValue(ATTRIB_BADRECORDS)));
            if (!this.tempArgs.containsKey("-D")) {
                this.options.getDataOptions().setDuplicateIdHandling(DataOptions.DuplicateHandling.valueOf(atts.getValue(ATTRIB_DUPLICATERECORDS)));
            }
            this.options.getDataOptions().setStripLeading(Boolean.parseBoolean(atts.getValue(ATTRIB_STRIPLEADING)));
            this.options.getDataOptions().setStripTrailing(Boolean.parseBoolean(atts.getValue(ATTRIB_STRIPTRAILING)));
            if (!this.tempArgs.containsKey("-c")) {
                this.options.getDataOptions().setTruncate(Boolean.parseBoolean(atts.getValue(ATTRIB_TRUNCATE)));
            }
            if (!this.tempArgs.containsKey("-b")) {
                this.options.getDataOptions().setTransactionSize(Integer.parseInt(atts.getValue(ATTRIB_TRANSACTIONSIZE)));
            }
        } else if (ELEM_FLAGS.equals(qName)) {
            if (this.options.getDataOptions() == null) {
                this.options.setDataOptions(new DataOptions());
            }
            if (!this.tempArgs.containsKey("-q")) {
                this.options.getDataOptions().setDisableRequired(Boolean.parseBoolean(atts.getValue(ATTRIB_DISABLEREQUIRED)));
            }
            if (!this.tempArgs.containsKey("-h")) {
                this.options.getDataOptions().setDisablePattern(Boolean.parseBoolean(atts.getValue(ATTRIB_DISABLEPATTERN)));
            }
            if (!this.tempArgs.containsKey("-n")) {
                this.options.getDataOptions().setSuppressFilters(Boolean.parseBoolean(atts.getValue(ATTRIB_SUPPRESSFILTERS)));
            }
            this.options.getDataOptions().setAllowTooFew(Boolean.parseBoolean(atts.getValue(ATTRIB_ALLOWTOOFEW)));
            this.options.getDataOptions().setAllowTooMany(Boolean.parseBoolean(atts.getValue(ATTRIB_ALLOWTOOMANY)));
            if (!this.tempArgs.containsKey("-t")) {
                this.options.getDataOptions().setMultiMatch(DataOptions.MultiMatch.valueOf(atts.getValue(ATTRIB_MULTIMATCH)));
            }
            this.options.getDataOptions().setForceoverride(Boolean.parseBoolean(atts.getValue(ATTRIB_FORCEOVERRIDE)));
            if (!this.tempArgs.containsKey("-i")) {
                if (atts.getValue(ATTRIB_SUPPRESSDEFAULTS) != null && atts.getValue(ATTRIB_SUPPRESSDEFAULTS).equalsIgnoreCase("true")) {
                    this.options.getDataOptions().setSuppressDefaults(1);
                } else {
                    this.options.getDataOptions().setSuppressDefaults(0);
                }
            }
        } else if (ELEM_DUPLICATEMATCHING.equals(qName)) {
            this.parsingDuplicateMatching = true;
        } else if ("field".equals(qName)) {
            if (this.parsingDuplicateMatching) {
                if (this.options.getDataOptions() == null) {
                    this.options.setDataOptions(new DataOptions());
                }
                if (this.options.getDataOptions().getDuplicateFields() == null) {
                    this.options.getDataOptions().setDuplicateFields(new ArrayList<Integer>());
                }
                if (!this.tempArgs.containsKey("-e")) {
                    this.options.getDataOptions().getDuplicateFields().add(Integer.parseInt(atts.getValue(ATTRIB_ID)));
                }
            }
        } else if (ELEM_TIMEHANDLING.equals(qName)) {
            if (this.options.getDataOptions() == null) {
                this.options.setDataOptions(new DataOptions());
            }
            this.options.getDataOptions().setDateFormat(atts.getValue(ATTRIB_DATEFORMAT));
            this.options.getDataOptions().setDateSeperator(atts.getValue(ATTRIB_DATESEPARATOR));
            this.options.getDataOptions().setDateTimeFormat(atts.getValue(ATTRIB_DATETIMEFORMAT));
            this.options.getDataOptions().setUse24Hour(Boolean.parseBoolean(atts.getValue(ATTRIB_USE24HOUR)));
            this.options.getDataOptions().setAMPMSuffix(Boolean.parseBoolean(atts.getValue(ATTRIB_AMPMSUFFIX)));
            this.options.getDataOptions().setAMString(atts.getValue(ATTRIB_AMSYMBOL));
            this.options.getDataOptions().setPMString(atts.getValue(ATTRIB_PMSYMBOL));
            this.options.getDataOptions().setTimeSeperator(atts.getValue(ATTRIB_TIMESEPARATOR));
            this.options.getDataOptions().setTimeFormat(atts.getValue(ATTRIB_TIMEFORMAT));
        } else if (ELEM_REALNUMBERHANDLING.equals(qName)) {
            if (this.options.getDataOptions() == null) {
                this.options.setDataOptions(new DataOptions());
            }
            this.options.getDataOptions().setDigitGroupSeparator(atts.getValue(ATTRIB_DIGITGROUPSEPARATOR));
            this.options.getDataOptions().setDecimalSeparator(atts.getValue(ATTRIB_DECIMALSEPARATOR));
        } else if (ELEM_SOURCEFILE.equals(qName)) {
            if (this.options.getFileOptions() == null) {
                this.options.setFileOptions(new FileOptions());
            }
            if (!this.tempArgs.containsKey("-o")) {
                this.options.getFileOptions().setDataFile(atts.getValue(ATTRIB_FILENAME));
                this.options.getFileOptions().setType(atts.getValue(ATTRIB_TYPE));
            }
            this.options.getFileOptions().setHasTitles(Boolean.parseBoolean(atts.getValue(ATTRIB_TITLES)));
            this.options.getFileOptions().setSeparator(atts.getValue(ATTRIB_SEPERATOR));
        } else if (ELEM_DESTINATIONSERVER.equals(qName)) {
            if (this.options.getContext() == null) {
                this.options.setContext(new ARServerUser());
            }
            String serverName = atts.getValue(ATTRIB_NAME);
            this.options.getContext().setServer(serverName);
        } else if (ELEM_FORMMAP.equals(qName)) {
            this.parsingFormMap = true;
            this.currentSourceForm = atts.getValue(ATTRIB_FILEFORM);
            if (!this.tempArgs.containsKey("-f")) {
                this.currentTargetForm = atts.getValue(ATTRIB_SERVERFORM);
                if (this.currentSourceForm.length() == 0) {
                    this.currentSourceForm = "ARImport_Data_Holder";
                }
            }
            this.mappingOptions = new MappingOptions();
            this.currentField = -1;
        } else if (ELEM_MAPPING.equals(qName)) {
            this.parsingMapping = true;
            this.currentField = Integer.parseInt(atts.getValue("field"));
        } else if (ELEM_NORMAL.equals(qName) && this.parsingMapping && this.parsingFormMap) {
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.valueOf(atts.getValue(ATTRIB_TYPE)));
            switch (mapping.getType()) {
                case NONE: {
                    break;
                }
                case FIELDID: {
                    mapping.setFieldId(Integer.parseInt(atts.getValue(ATTRIB_FIELDID)));
                    if (atts.getValue(ATTRIB_TOKENINDEX) != null) {
                        mapping.setTokenIndex(Integer.parseInt(atts.getValue(ATTRIB_TOKENINDEX)));
                        if (mapping.getTokenIndex() >= 0 || !this.options.getFileOptions().getType().equals(CSV) && !this.options.getFileOptions().getType().equals("ASC")) break;
                        mapping.setTokenIndex(mapping.getFieldId());
                        break;
                    }
                    if (!this.options.getFileOptions().getType().equals(CSV) && !this.options.getFileOptions().getType().equals("ASC")) break;
                    mapping.setTokenIndex(mapping.getFieldId());
                    break;
                }
                case KEYWORD: {
                    String value = atts.getValue(ATTRIB_KEYWORD);
                    if (value.equals("$NULL$")) {
                        mapping.setKeyword(-1);
                        break;
                    }
                    Keyword keyword = Keyword.toKeyword((String)value);
                    mapping.setKeyword(keyword);
                    break;
                }
                case CONSTANT: {
                    mapping.setConstant(atts.getValue(ATTRIB_CONSTANT));
                    break;
                }
                case COMPOUND: {
                    mapping.setCompound(atts.getValue(ATTRIB_COMPOUND));
                    break;
                }
                case FIELDNAME: {
                    mapping.setFieldName(atts.getValue(ATTRIB_FIELDNAME));
                }
            }
            this.mappingOptions.addMapping(this.currentField, mapping);
        } else if (ELEM_FALLBACK.equals(qName) && this.parsingMapping && this.parsingFormMap) {
            Mapping mapping = new Mapping();
            mapping.setType(Mapping.Type.valueOf(atts.getValue(ATTRIB_TYPE)));
            switch (mapping.getType()) {
                case NONE: {
                    break;
                }
                case FIELDID: {
                    mapping.setFieldId(Integer.parseInt(atts.getValue(ATTRIB_FIELDID)));
                    if (atts.getValue(ATTRIB_TOKENINDEX) != null) {
                        mapping.setTokenIndex(Integer.parseInt(atts.getValue(ATTRIB_TOKENINDEX)));
                        if (mapping.getTokenIndex() >= 0 || !this.options.getFileOptions().getType().equals(CSV) && !this.options.getFileOptions().getType().equals("ASC")) break;
                        mapping.setTokenIndex(mapping.getFieldId());
                        break;
                    }
                    if (!this.options.getFileOptions().getType().equals(CSV) && !this.options.getFileOptions().getType().equals("ASC")) break;
                    mapping.setTokenIndex(mapping.getFieldId());
                    break;
                }
                case KEYWORD: {
                    String value = atts.getValue(ATTRIB_KEYWORD);
                    if (value.equals("$NULL$")) {
                        mapping.setKeyword(new Integer(-1));
                        break;
                    }
                    Keyword keyword = Keyword.toKeyword((String)value);
                    mapping.setKeyword(keyword);
                    break;
                }
                case CONSTANT: {
                    mapping.setConstant(atts.getValue(ATTRIB_CONSTANT));
                    break;
                }
                case COMPOUND: {
                    mapping.setCompound(atts.getValue(ATTRIB_COMPOUND));
                    break;
                }
                case FIELDNAME: {
                    mapping.setFieldName(atts.getValue(ATTRIB_FIELDNAME));
                }
            }
            this.mappingOptions.addFallback(this.currentField, mapping);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public String generateXML(ImportOptions options) throws ParserConfigurationException, IOException, TransformerFactoryConfigurationError, TransformerException {
        String value = "";
        if (options != null) {
            Document doc = this.exportDataToXML(options);
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            value = writer.toString();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToARMXML(ImportOptions options, String fileName, boolean bUnicode) throws IOException, ParserConfigurationException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (fileName != null) {
            try (FileOutputStream outStream = null;){
                Document doc = this.exportDataToXML(options);
                DOMSource source = new DOMSource(doc);
                File file = new File(fileName);
                outStream = new FileOutputStream(file);
                StreamResult result = new StreamResult(outStream);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("indent", "yes");
                xformer.transform(source, result);
            }
        }
    }

    private Document exportDataToXML(ImportOptions options) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement(ELEM_IMPORTMAPPING);
        doc.appendChild(root);
        Element optionsElement = doc.createElement(ELEM_OPTIONS);
        root.appendChild(optionsElement);
        Element dataHandlingElement = doc.createElement(ELEM_DATAHANDLING);
        optionsElement.appendChild(dataHandlingElement);
        dataHandlingElement.setAttribute(ATTRIB_BADRECORDS, options.getDataOptions().getBadRecordHandling().name());
        dataHandlingElement.setAttribute(ATTRIB_STRIPLEADING, Boolean.toString(options.getDataOptions().isStripLeading()));
        dataHandlingElement.setAttribute(ATTRIB_STRIPTRAILING, Boolean.toString(options.getDataOptions().isStripTrailing()));
        dataHandlingElement.setAttribute(ATTRIB_TRUNCATE, Boolean.toString(options.getDataOptions().isTruncate()));
        dataHandlingElement.setAttribute(ATTRIB_DUPLICATERECORDS, options.getDataOptions().getDuplicateIdHandling().name());
        dataHandlingElement.setAttribute(ATTRIB_TRANSACTIONSIZE, Integer.toString(options.getDataOptions().getTransactionSize()));
        Element timeHandlingElement = doc.createElement(ELEM_TIMEHANDLING);
        optionsElement.appendChild(timeHandlingElement);
        timeHandlingElement.setAttribute(ATTRIB_DATEFORMAT, options.getDataOptions().getDateFormat());
        timeHandlingElement.setAttribute(ATTRIB_DATESEPARATOR, options.getDataOptions().getDateSeperator());
        timeHandlingElement.setAttribute(ATTRIB_DATETIMEFORMAT, options.getDataOptions().getDateTimeFormat());
        timeHandlingElement.setAttribute(ATTRIB_AMSYMBOL, options.getDataOptions().getAMString());
        timeHandlingElement.setAttribute(ATTRIB_PMSYMBOL, options.getDataOptions().getPMString());
        timeHandlingElement.setAttribute(ATTRIB_TIMEFORMAT, options.getDataOptions().getTimeFormat());
        timeHandlingElement.setAttribute(ATTRIB_TIMESEPARATOR, options.getDataOptions().getTimeSeperator());
        timeHandlingElement.setAttribute(ATTRIB_USE24HOUR, Boolean.toString(options.getDataOptions().is24Hour()));
        timeHandlingElement.setAttribute(ATTRIB_AMPMSUFFIX, Boolean.toString(options.getDataOptions().isAMPMSuffix()));
        Element realnumberHandlingElement = doc.createElement(ELEM_REALNUMBERHANDLING);
        optionsElement.appendChild(realnumberHandlingElement);
        realnumberHandlingElement.setAttribute(ATTRIB_DIGITGROUPSEPARATOR, String.valueOf(options.getDataOptions().getDigitGroupSeparator()));
        realnumberHandlingElement.setAttribute(ATTRIB_DECIMALSEPARATOR, String.valueOf(options.getDataOptions().getDecimalSeparator()));
        Element flagsElement = doc.createElement(ELEM_FLAGS);
        optionsElement.appendChild(flagsElement);
        flagsElement.setAttribute(ATTRIB_MULTIMATCH, options.getDataOptions().getMultiMatch().name());
        flagsElement.setAttribute(ATTRIB_ALLOWTOOFEW, Boolean.toString(options.getDataOptions().isAllowTooFew()));
        flagsElement.setAttribute(ATTRIB_ALLOWTOOMANY, Boolean.toString(options.getDataOptions().isAllowTooMany()));
        flagsElement.setAttribute(ATTRIB_DISABLEPATTERN, Boolean.toString(options.getDataOptions().isDisablePattern()));
        flagsElement.setAttribute(ATTRIB_DISABLEREQUIRED, Boolean.toString(options.getDataOptions().isDisableRequired()));
        flagsElement.setAttribute(ATTRIB_FORCEOVERRIDE, Boolean.toString(options.getDataOptions().isForceoverride()));
        if (options.getDataOptions().getSuppressDefaults() == 0) {
            flagsElement.setAttribute(ATTRIB_SUPPRESSDEFAULTS, "false");
        } else {
            flagsElement.setAttribute(ATTRIB_SUPPRESSDEFAULTS, "true");
        }
        flagsElement.setAttribute(ATTRIB_SUPPRESSFILTERS, Boolean.toString(options.getDataOptions().isSuppressFilters()));
        if (options.getDataOptions().getDuplicateFields() != null && !options.getDataOptions().getDuplicateFields().isEmpty()) {
            Element dupIdElement = doc.createElement(ELEM_DUPLICATEMATCHING);
            optionsElement.appendChild(dupIdElement);
            for (Integer id : options.getDataOptions().getDuplicateFields()) {
                if (id == null) continue;
                Element dupIdField = doc.createElement("field");
                dupIdField.setAttribute(ATTRIB_ID, id.toString());
                dupIdElement.appendChild(dupIdField);
            }
        }
        Element sourceFileElement = doc.createElement(ELEM_SOURCEFILE);
        root.appendChild(sourceFileElement);
        sourceFileElement.setAttribute(ATTRIB_FILENAME, options.getFileOptions().getDataFile());
        sourceFileElement.setAttribute(ATTRIB_TYPE, options.getFileOptions().getType());
        sourceFileElement.setAttribute(ATTRIB_SEPERATOR, options.getFileOptions().getSeparator());
        sourceFileElement.setAttribute(ATTRIB_TITLES, Boolean.toString(options.getFileOptions().isHasTitles()));
        Element destinationServerElement = doc.createElement(ELEM_DESTINATIONSERVER);
        root.appendChild(destinationServerElement);
        destinationServerElement.setAttribute(ATTRIB_NAME, options.getContext().getServer());
        Element formMappingsElem = doc.createElement(ELEM_FORMMAPPINGS);
        root.appendChild(formMappingsElem);
        Map<String, Map<String, MappingOptions>> formMappingOptions = options.getFormMappingOptions();
        for (String fileForm : formMappingOptions.keySet()) {
            if (fileForm == null) continue;
            Map<String, MappingOptions> destMap = formMappingOptions.get(fileForm);
            if (fileForm.equals("ARImport_Data_Holder")) {
                fileForm = "";
            }
            if (destMap == null) continue;
            for (String serverForm : destMap.keySet()) {
                MappingOptions mappings;
                if (serverForm == null || (mappings = destMap.get(serverForm)) == null || mappings.getMappings() == null || mappings.getMappings().isEmpty()) continue;
                Element formMapElement = doc.createElement(ELEM_FORMMAP);
                formMapElement.setAttribute(ATTRIB_FILEFORM, fileForm);
                formMapElement.setAttribute(ATTRIB_SERVERFORM, serverForm);
                formMappingsElem.appendChild(formMapElement);
                HashSet<Integer> fieldSet = new HashSet<Integer>();
                if (mappings.getMappings() != null && !mappings.getMappings().isEmpty()) {
                    fieldSet.addAll(mappings.getMappings().keySet());
                }
                if (mappings.getFallbacks() != null && !mappings.getFallbacks().isEmpty()) {
                    fieldSet.addAll(mappings.getFallbacks().keySet());
                }
                for (Integer fieldId : fieldSet) {
                    Object keyword;
                    if (fieldId == null) continue;
                    Mapping mapping = mappings.getMappings().get(fieldId);
                    Mapping fallback = null;
                    if (mappings.getFallbacks() != null && !mappings.getFallbacks().isEmpty()) {
                        fallback = mappings.getFallbacks().get(fieldId);
                    }
                    if (mapping == null && fallback == null) continue;
                    Element mappingElement = doc.createElement(ELEM_MAPPING);
                    mappingElement.setAttribute("field", fieldId.toString());
                    formMapElement.appendChild(mappingElement);
                    if (mapping != null) {
                        Element normalElement = doc.createElement(ELEM_NORMAL);
                        normalElement.setAttribute(ATTRIB_TYPE, mapping.getType().name());
                        switch (mapping.getType()) {
                            case NONE: {
                                break;
                            }
                            case FIELDID: {
                                normalElement.setAttribute(ATTRIB_FIELDID, Integer.toString(mapping.getFieldId()));
                                normalElement.setAttribute(ATTRIB_TOKENINDEX, Integer.toString(mapping.getTokenIndex()));
                                break;
                            }
                            case KEYWORD: {
                                keyword = mapping.getKeyword();
                                if (keyword instanceof Integer || keyword == null) {
                                    normalElement.setAttribute(ATTRIB_KEYWORD, "$NULL$");
                                    break;
                                }
                                if (!(keyword instanceof Keyword)) break;
                                normalElement.setAttribute(ATTRIB_KEYWORD, keyword.toString());
                                break;
                            }
                            case CONSTANT: {
                                normalElement.setAttribute(ATTRIB_CONSTANT, mapping.getConstant());
                                break;
                            }
                            case COMPOUND: {
                                normalElement.setAttribute(ATTRIB_COMPOUND, mapping.getCompound());
                                break;
                            }
                            case FIELDNAME: {
                                normalElement.setAttribute(ATTRIB_FIELDNAME, mapping.getFieldName());
                            }
                        }
                        mappingElement.appendChild(normalElement);
                    }
                    if (fallback == null) continue;
                    Element fallbackElement = doc.createElement(ELEM_FALLBACK);
                    fallbackElement.setAttribute(ATTRIB_TYPE, fallback.getType().name());
                    mappingElement.appendChild(fallbackElement);
                    switch (fallback.getType()) {
                        case NONE: {
                            break;
                        }
                        case FIELDID: {
                            fallbackElement.setAttribute(ATTRIB_FIELDID, Integer.toString(fallback.getFieldId()));
                            fallbackElement.setAttribute(ATTRIB_TOKENINDEX, Integer.toString(fallback.getTokenIndex()));
                            break;
                        }
                        case KEYWORD: {
                            keyword = fallback.getKeyword();
                            if (keyword instanceof Integer || keyword == null) {
                                fallbackElement.setAttribute(ATTRIB_KEYWORD, "$NULL$");
                                break;
                            }
                            if (!(keyword instanceof Keyword)) break;
                            fallbackElement.setAttribute(ATTRIB_KEYWORD, keyword.toString());
                            break;
                        }
                        case CONSTANT: {
                            fallbackElement.setAttribute(ATTRIB_CONSTANT, fallback.getConstant());
                            break;
                        }
                        case COMPOUND: {
                            fallbackElement.setAttribute(ATTRIB_COMPOUND, fallback.getCompound());
                            break;
                        }
                        case FIELDNAME: {
                            fallbackElement.setAttribute(ATTRIB_FIELDNAME, fallback.getFieldName());
                        }
                    }
                }
            }
        }
        return doc;
    }

    public void parseXML(File file) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(file, (DefaultHandler)this);
    }

    public void parseFile(String fileName) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(fileName);
        if (file != null) {
            this.parseXML(file);
        }
    }

    @Override
    public void addListener(IParseListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IParseListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireEvent(ParseEvent event) throws ARImportException, ARException {
        if (this.listeners != null && this.listeners.size() > 0) {
            for (IParseListener listener : this.listeners) {
                listener.handleEvent(event);
            }
        }
    }

    @Override
    public boolean isAbort() {
        if (this.listeners != null && this.listeners.size() > 0) {
            for (IParseListener listener : this.listeners) {
                if (!listener.isAbort()) continue;
                this.abort = true;
                break;
            }
        }
        return this.abort;
    }

    @Override
    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    @Override
    public boolean isCopyToLog() {
        return false;
    }

    @Override
    public void setCopyToLog(boolean copyToLog) {
    }
}

