/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.arm;

import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARMParser
extends Parser {
    public static final String DELIMETER = "$";
    private static final String SPACE = " ";
    private ImportOptions options = null;
    private static final String LINEFEED = "\r\n";
    private Map<String, String> tempArgs = null;

    public ARMParser(ImportOptions options) {
        this.options = options;
        this.tempArgs = new HashMap<String, String>();
    }

    public ARMParser(ImportOptions options, Map<String, String> tempArgs) {
        this.options = options;
        this.tempArgs = tempArgs != null ? tempArgs : new HashMap<String, String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Mapping parseMapping(String armString, FormInformation schemaInfo) {
        Mapping result = new Mapping();
        String parseString = armString.trim();
        int numDelimeters = Util.countDelimeters(armString, DELIMETER);
        switch (numDelimeters) {
            case 0: 
            case 1: {
                result.setType(Mapping.Type.CONSTANT);
                result.setConstant(armString);
                return result;
            }
            case 2: {
                if (parseString.length() == 2 && parseString.startsWith(DELIMETER) && parseString.endsWith(DELIMETER)) {
                    result.setType(Mapping.Type.CONSTANT);
                    result.setConstant("");
                    return result;
                }
                if ("$--1$".equals(parseString)) {
                    result.setType(Mapping.Type.KEYWORD);
                    result.setKeyword(-1);
                    return result;
                }
                if (parseString.startsWith(DELIMETER) && parseString.endsWith(DELIMETER)) {
                    parseString = parseString.substring(1, parseString.length() - 1);
                    try {
                        int number = Integer.parseInt(parseString);
                        if (number > 0) {
                            result.setType(Mapping.Type.FIELDID);
                            result.setFieldId(number);
                            return result;
                        }
                        result.setType(Mapping.Type.KEYWORD);
                        result.setKeyword(Keyword.toKeyword((int)(number *= -1)));
                        if (result.getKeyword() != null) return result;
                        throw new ARImportException("Unable to convert value to keyword : " + parseString);
                    }
                    catch (Exception e) {
                        if ("$NULL$".equals(armString.trim())) {
                            result.setType(Mapping.Type.KEYWORD);
                            result.setKeyword(new Integer(-1));
                        } else {
                            for (int iLoop = 0; iLoop < Mapping.keywords.length; ++iLoop) {
                                if (!armString.equals(Mapping.keywords[iLoop].toString())) continue;
                                result.setType(Mapping.Type.KEYWORD);
                                result.setKeyword(Mapping.keywords[iLoop]);
                                break;
                            }
                        }
                        if (result.getType() != Mapping.Type.NONE) return result;
                        if (schemaInfo != null) {
                            for (FieldInformation information : schemaInfo.getFields().values()) {
                                if (parseString.equals(information.getName())) {
                                    result.setType(Mapping.Type.FIELDID);
                                    result.setFieldName(information.getName());
                                    result.setFieldId(information.getFieldId());
                                    result.setTokenIndex(information.getTokenIndex());
                                    continue;
                                }
                                if (!parseString.equals(Long.toString(information.getFieldId()))) continue;
                                result.setType(Mapping.Type.FIELDID);
                                result.setFieldName(information.getName());
                                result.setFieldId(information.getFieldId());
                                result.setTokenIndex(information.getTokenIndex());
                            }
                            return result;
                        }
                        result.setType(Mapping.Type.FIELDNAME);
                        result.setFieldName(parseString);
                        if (!this.options.getFileOptions().getType().equals("CSV") && !this.options.getFileOptions().getType().equals("ASC") || !result.getFieldName().startsWith("Field-")) return result;
                        String indexString = result.getFieldName().replace("Field-", "").trim();
                        Integer index = Integer.parseInt(indexString);
                        result.setFieldId(index - 1);
                        result.setTokenIndex(index - 1);
                        return result;
                    }
                }
                result.setType(Mapping.Type.COMPOUND);
                String strMap = this.parseCompound(armString, schemaInfo);
                result.setCompound(strMap);
                return result;
            }
            default: {
                String strMap = this.parseCompound(armString, schemaInfo);
                result.setType(Mapping.Type.COMPOUND);
                result.setCompound(strMap);
            }
        }
        return result;
    }

    private String parseCompound(String strARMString, FormInformation schemaInfo) {
        String strMap = strARMString;
        if (schemaInfo != null) {
            strMap = strMap.replace("$NULL$", "$--1$");
            for (int kLoop = 0; kLoop < Mapping.keywords.length; ++kLoop) {
                strMap = strMap.replace(Mapping.keywords[kLoop].toString(), "$-" + Mapping.keywords[kLoop].toInt() + '$');
            }
            for (FieldInformation information : schemaInfo.getFields().values()) {
                strMap = strMap.replace(DELIMETER + information.getName() + DELIMETER, DELIMETER + information.getFieldId() + DELIMETER);
            }
        }
        return strMap;
    }

    private boolean extractAllowTooFew(String strLine) throws ARImportException {
        if (strLine.length() > "Allow-Too-Few-Fields:".length() + 1) {
            return Integer.parseInt(strLine.substring("Allow-Too-Few-Fields:".length()).trim()) == 1;
        }
        throw new ARImportException("Allow-Too-Few-Fields:is not defined");
    }

    private boolean extractAllowTooMany(String strLine) throws ARImportException {
        if (strLine.length() > "Allow-Too-Many-Fields:".length() + 1) {
            return Integer.parseInt(strLine.substring("Allow-Too-Many-Fields:".length()).trim()) == 1;
        }
        throw new ARImportException("Allow-Too-Many-Fields:is not defined");
    }

    private DataOptions.BadRecords extractBadRecordHandling(String strLine) throws ARImportException {
        if (strLine.length() > "Bad-Record-Handling:".length() + 1) {
            int armValue = Integer.parseInt(strLine.substring("Bad-Record-Handling:".length()).trim());
            return DataOptions.BadRecords.fromARMValue(armValue);
        }
        throw new ARImportException("Bad-Record-Handling:is not defined");
    }

    private boolean extractDisablePattern(String strLine) throws ARImportException {
        if (strLine.length() > "Disable-Pattern:".length() + 1) {
            return Integer.parseInt(strLine.substring("Disable-Pattern:".length()).trim()) == 1;
        }
        throw new ARImportException("Disable-Pattern:is not defined");
    }

    private boolean extractDisableRequired(String strLine) throws ARImportException {
        if (strLine.length() > "Disable-Required-ness:".length() + 1) {
            return Integer.parseInt(strLine.substring("Disable-Required-ness:".length()).trim()) == 1;
        }
        throw new ARImportException("Disable-Required-ness:is not defined");
    }

    private DataOptions.DuplicateHandling extractDuplicateIDHandling(String strLine) throws ARImportException {
        if (strLine.length() > "Duplicate-Id-Handling:".length() + 1) {
            int armValue = Integer.parseInt(strLine.substring("Duplicate-Id-Handling:".length()).trim());
            return DataOptions.DuplicateHandling.fromARMValue(armValue);
        }
        throw new ARImportException("Duplicate-Id-Handling:is not defined");
    }

    private String extractFieldSeparator(String strLine) throws ARImportException {
        if (strLine.length() > "Import-Field-Separator:".length() + 1) {
            return strLine.substring("Import-Field-Separator:".length()).trim();
        }
        return "";
    }

    private boolean extractFieldTitles(String strLine) throws ARImportException {
        if (strLine.length() > "Import-Field-Titles:".length() + 1) {
            return Integer.parseInt(strLine.substring("Import-Field-Titles:".length()).trim()) == 1;
        }
        throw new ARImportException("Import-Field-Titles:is not defined");
    }

    private String extractImportFileFormat(String strLine) throws ARImportException {
        if (strLine.length() > "Import-File-Format:".length() + 1) {
            int armValue = Integer.parseInt(strLine.substring("Import-File-Format:".length()).trim());
            switch (armValue) {
                case 3: {
                    return "ARX";
                }
                case 1: {
                    return "ASC";
                }
                case 2: {
                    return "CSV";
                }
                case 4: {
                    return "XML";
                }
            }
            throw new ARImportException("Import-File-Format: has an unsupported value");
        }
        throw new ARImportException("Import-File-Format:is not defined");
    }

    private String extractImportFileName(String strLine) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.getOptions() != null && this.getOptions().getFileOptions().getDataFile() != null && this.getOptions().getFileOptions().getDataFile().length() > 0) {
            logger.info((Object)MessageFormat.format(ImportErrors.EXTRACT_IMPORT_FILE_NAME.toDefMsg(), this.getOptions().getFileOptions().getDataFile()));
            return this.getOptions().getFileOptions().getDataFile();
        }
        if (strLine.length() > "Import-Filename:".length() + 1) {
            return strLine.substring("Import-Filename:".length()).trim();
        }
        throw new ARImportException("Import-Filename:is not defined");
    }

    private void extractMapping(String line, boolean isFallback, MappingOptions maps) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        String process = null;
        process = isFallback ? line.substring("Fallback-Mapping:".length()).trim() : line.substring("Mapping:".length()).trim();
        int equalsPos = process.indexOf("=");
        String strFieldId = process.substring(0, equalsPos).trim();
        Mapping fieldMapping = this.parseMapping(process.substring(equalsPos + 1), null);
        int fieldId = Integer.parseInt(strFieldId);
        if (isFallback) {
            maps.addFallback(fieldId, fieldMapping);
        } else {
            maps.addMapping(fieldId, fieldMapping);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.EXTRACT_MAPPING.toDefMsg(), isFallback, fieldMapping));
        }
    }

    private String extractSchemaName(String strLine) throws ARImportException {
        if (strLine.length() > "SchemaName:".length() + 1) {
            return strLine.substring("SchemaName:".length()).trim();
        }
        return null;
    }

    private String extractServerName(String strLine) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.getOptions() != null && this.getOptions().getContext().getServer() != null && this.getOptions().getContext().getServer().length() > 0) {
            logger.info((Object)MessageFormat.format(ImportErrors.EXTRACT_SERVER_NAME.toDefMsg(), this.getOptions().getContext().getServer()));
            return this.getOptions().getContext().getServer();
        }
        if (strLine.length() > "ServerName:".length() + 1) {
            return strLine.substring("ServerName:".length()).trim();
        }
        return null;
    }

    private boolean extractTrimValues(String strLine) throws ARImportException {
        if (strLine.length() > "Strip-White-Space:".length() + 1) {
            return Integer.parseInt(strLine.substring("Strip-White-Space:".length()).trim()) == 1;
        }
        throw new ARImportException("Strip-White-Space:is not defined");
    }

    private boolean extractTruncateValues(String strLine) throws ARImportException {
        if (strLine.length() > "Truncate-Values:".length() + 1) {
            return Integer.parseInt(strLine.substring("Truncate-Values:".length()).trim()) == 1;
        }
        throw new ARImportException("Truncate-Values:is not defined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateFromARM(ImportOptions options, String fileName, String charSet) throws FileNotFoundException, UnsupportedEncodingException, ARImportException {
        String line;
        Logger logger = ThreadLocalStorage.getLogger();
        FileInputStream inStream = new FileInputStream(fileName);
        InputStreamReader streamReader = null;
        streamReader = charSet != null && charSet.length() > 0 ? new InputStreamReader((InputStream)inStream, charSet) : new InputStreamReader(inStream);
        BufferedReader fileReader = new BufferedReader(streamReader);
        options.setFromARM(true);
        MappingOptions maps = new MappingOptions();
        if (this.tempArgs.containsKey("-f")) {
            options.addMappingOptions("ARImport_Data_Holder", options.getFormMap().get("ARImport_Data_Holder"), maps);
        }
        boolean firstLine = true;
        boolean endReached = false;
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append(System.getProperty("line.separator"));
        while ((line = fileReader.readLine()) != null && !endReached) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.PROCESSING.toDefMsg(), line));
            }
            logBuffer.append(line).append(System.getProperty("line.separator"));
            if (firstLine) {
                maps.setMappingName(line);
                firstLine = false;
            }
            if (line.startsWith("SchemaName:") && !this.tempArgs.containsKey("-f")) {
                String schemaName = this.extractSchemaName(line);
                options.addMappingOptions("ARImport_Data_Holder", schemaName, maps);
                options.setImportAllDataSets(false);
                options.getFormMap().put("ARImport_Data_Holder", schemaName);
                continue;
            }
            if (line.startsWith("ServerName:")) {
                options.getContext().setServer(this.extractServerName(line));
                continue;
            }
            if (line.startsWith("Import-Filename:") && !this.tempArgs.containsKey("-o")) {
                options.getFileOptions().setDataFile(this.extractImportFileName(line));
                continue;
            }
            if (line.startsWith("Import-File-Format:") && !this.tempArgs.containsKey("-o")) {
                options.getFileOptions().setType(this.extractImportFileFormat(line));
                continue;
            }
            if (line.startsWith("Import-Field-Titles:") && !this.tempArgs.containsKey("-o")) {
                options.getFileOptions().setHasTitles(this.extractFieldTitles(line));
                continue;
            }
            if (line.startsWith("Import-Field-Separator:") && !this.tempArgs.containsKey("-o")) {
                options.getFileOptions().setSeparator(this.extractFieldSeparator(line));
                continue;
            }
            if (line.startsWith("Bad-Record-Handling:")) {
                options.getDataOptions().setBadRecordHandling(this.extractBadRecordHandling(line));
                continue;
            }
            if (line.startsWith("Duplicate-Id-Handling:") && !this.tempArgs.containsKey("-D")) {
                options.getDataOptions().setDuplicateIdHandling(this.extractDuplicateIDHandling(line));
                continue;
            }
            if (line.startsWith("Strip-White-Space:")) {
                boolean strip = this.extractTrimValues(line);
                options.getDataOptions().setStripLeading(strip);
                options.getDataOptions().setStripTrailing(strip);
                continue;
            }
            if (line.startsWith("Truncate-Values:") && !this.tempArgs.containsKey("-c")) {
                options.getDataOptions().setTruncate(this.extractTruncateValues(line));
                continue;
            }
            if (line.startsWith("Disable-Required-ness:") && !this.tempArgs.containsKey("-q")) {
                options.getDataOptions().setDisableRequired(this.extractDisableRequired(line));
                continue;
            }
            if (line.startsWith("Disable-Pattern:") && !this.tempArgs.containsKey("-h")) {
                options.getDataOptions().setDisablePattern(this.extractDisablePattern(line));
                continue;
            }
            if (line.startsWith("Allow-Too-Many-Fields:")) {
                options.getDataOptions().setAllowTooMany(this.extractAllowTooMany(line));
                continue;
            }
            if (line.startsWith("Allow-Too-Few-Fields:")) {
                options.getDataOptions().setAllowTooFew(this.extractAllowTooFew(line));
                continue;
            }
            if (line.startsWith("Mapping:")) {
                this.extractMapping(line, false, maps);
                continue;
            }
            if (line.startsWith("Fallback-Mapping:")) {
                this.extractMapping(line, true, maps);
                continue;
            }
            if (line.startsWith("end")) {
                endReached = true;
                continue;
            }
            if (line.startsWith("Import-Log-Filename:") && !this.tempArgs.containsKey("-l")) {
                options.setLogFile(this.extractLogFile(line));
                continue;
            }
            if (line.startsWith("24-Hour-Format:")) {
                options.getDataOptions().setUse24Hour(this.extract24HourMode(line));
                continue;
            }
            if (line.startsWith("Time-Separator:")) {
                options.getDataOptions().setTimeSeperator(this.extractTimeSeperator(line));
                continue;
            }
            if (line.startsWith("Date-Separator:")) {
                options.getDataOptions().setDateSeperator(this.extractDateSeperator(line));
                continue;
            }
            if (line.startsWith("Long-Date-Format:")) {
                options.getDataOptions().setDateTimeFormat(this.extractLongDateFormat(line));
                continue;
            }
            if (line.startsWith("Short-Date-Format:")) {
                options.getDataOptions().setDateFormat(this.extractShortDateFormat(line));
                continue;
            }
            if (line.startsWith("Morning-String:")) {
                options.getDataOptions().setAMString(this.extractAMString(line));
                continue;
            }
            if (line.startsWith("Afternoon-String:")) {
                options.getDataOptions().setPMString(this.extractPMString(line));
                continue;
            }
            if (line.startsWith("Digit-Group-Separator:")) {
                options.getDataOptions().setDigitGroupSeparator(this.extractDigitGroupSeparator(line));
                continue;
            }
            if (!line.startsWith("Decimal-Separator:")) continue;
            options.getDataOptions().setDecimalSeparator(this.extractDecimalSeparator(line));
        }
        logBuffer.append(System.getProperty("line.separator"));
        logger.info((Object)MessageFormat.format(ImportErrors.MAPPING.toDefMsg(), fileName, logBuffer.toString()));
        if (inStream == null) return;
        try {
            inStream.close();
            return;
        }
        catch (IOException ioe) {
            logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), ioe.getMessage()), (Throwable)ioe);
        }
        return;
        catch (IOException e) {
            try {
                logger.error((Object)MessageFormat.format(ImportErrors.EXCEPTION_AT_PARSING_ARM.toDefMsg(), e), (Throwable)e);
                if (inStream == null) return;
            }
            catch (Throwable throwable) {
                if (inStream == null) throw throwable;
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), ioe.getMessage()), (Throwable)ioe);
                }
                throw throwable;
            }
            try {
                inStream.close();
                return;
            }
            catch (IOException ioe) {
                logger.warn((Object)MessageFormat.format(ImportErrors.NOT_CLOSE_ARM_FILE.toDefMsg(), System.getProperty("line.separator"), ioe.getMessage()), (Throwable)ioe);
            }
            return;
        }
    }

    private boolean extract24HourMode(String strLine) throws ARImportException {
        if (strLine.length() > "24-Hour-Format:".length() + 1) {
            return Integer.parseInt(strLine.substring("24-Hour-Format:".length()).trim()) == 1;
        }
        throw new ARImportException("24-Hour-Format:is not defined");
    }

    private String extractTimeSeperator(String strLine) throws ARImportException {
        if (strLine.length() > "Time-Separator:".length() + 1) {
            return strLine.substring("Time-Separator:".length()).trim();
        }
        throw new ARImportException("Time-Separator:is not defined");
    }

    private String extractDateSeperator(String strLine) throws ARImportException {
        if (strLine.length() > "Date-Separator:".length() + 1) {
            return strLine.substring("Date-Separator:".length()).trim();
        }
        throw new ARImportException("Date-Separator:is not defined");
    }

    private String extractShortDateFormat(String strLine) throws ARImportException {
        if (strLine.length() > "Short-Date-Format:".length() + 1) {
            return strLine.substring("Short-Date-Format:".length()).trim();
        }
        throw new ARImportException("Short-Date-Format:is not defined");
    }

    private String extractLongDateFormat(String strLine) throws ARImportException {
        if (strLine.length() > "Long-Date-Format:".length() + 1) {
            return strLine.substring("Long-Date-Format:".length()).trim();
        }
        throw new ARImportException("Long-Date-Format:is not defined");
    }

    private String extractAMString(String strLine) throws ARImportException {
        if (strLine.length() > "Morning-String:".length() + 1) {
            return strLine.substring("Morning-String:".length()).trim();
        }
        throw new ARImportException("Morning-String:is not defined");
    }

    private String extractPMString(String strLine) throws ARImportException {
        if (strLine.length() > "Afternoon-String:".length() + 1) {
            return strLine.substring("Afternoon-String:".length()).trim();
        }
        throw new ARImportException("Afternoon-String:is not defined");
    }

    private String extractDigitGroupSeparator(String strLine) throws ARImportException {
        if (strLine.length() > "Digit-Group-Separator:".length() + 1) {
            return strLine.substring("Digit-Group-Separator:".length()).trim();
        }
        throw new ARImportException("Digit-Group-Separator:is not defined");
    }

    private String extractDecimalSeparator(String strLine) throws ARImportException {
        if (strLine.length() > "Decimal-Separator:".length() + 1) {
            return strLine.substring("Decimal-Separator:".length()).trim();
        }
        throw new ARImportException("Decimal-Separator:is not defined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToARM(ImportOptions options, String strFileName, boolean bUnicode) throws IOException, ARImportException, NullPointerException {
        OutputStreamWriter streamWriter = null;
        try (FileOutputStream outStream = new FileOutputStream(strFileName);){
            streamWriter = bUnicode ? new OutputStreamWriter((OutputStream)outStream, "UTF-8") : new OutputStreamWriter(outStream);
            BufferedWriter fileWriter = new BufferedWriter(streamWriter);
            if (options.getFirstFileForm() == null) {
                throw new ARImportException("No Form Information found in the data file");
            }
            String formName = options.getFirstFileForm().getName();
            MappingOptions mappings = options.getMappingOptions(formName, formName);
            if (mappings == null) {
                throw new NullPointerException("Mapping information cannot be null");
            }
            if (mappings.getMappingName() == null || mappings.getMappingName().length() < 1) {
                mappings.setMappingName(strFileName);
            }
            fileWriter.write(mappings.getMappingName() + LINEFEED);
            fileWriter.write("SchemaName: " + formName + LINEFEED);
            fileWriter.write("ServerName: " + options.getContext().getServer() + LINEFEED);
            fileWriter.write("Import-Filename: " + options.getFileOptions().getDataFile() + LINEFEED);
            fileWriter.write("Import-File-Format: " + Integer.toString(this.getDataTypeValue(options.getFileOptions().getType())) + LINEFEED);
            fileWriter.write("Import-Field-Titles: " + (options.getFileOptions().isHasTitles() ? "1" : "0") + LINEFEED);
            fileWriter.write("Import-Field-Separator: " + options.getFileOptions().getSeparator() + LINEFEED);
            fileWriter.write("Bad-Record-Handling: " + Integer.toString(options.getDataOptions().getBadRecordHandling().getARMValue()) + LINEFEED);
            fileWriter.write("Duplicate-Id-Handling: " + Integer.toString(options.getDataOptions().getDuplicateIdHandling().getARMValue()) + LINEFEED);
            fileWriter.write("Strip-White-Space: " + (options.getDataOptions().isStripLeading() || options.getDataOptions().isStripTrailing() ? "1" : "0") + LINEFEED);
            fileWriter.write("Truncate-Values: " + (options.getDataOptions().isTruncate() ? "1" : "0") + LINEFEED);
            fileWriter.write("Disable-Required-ness: " + (options.getDataOptions().isDisableRequired() ? "1" : "0") + LINEFEED);
            fileWriter.write("Disable-Pattern: " + (options.getDataOptions().isDisablePattern() ? "1" : "0") + LINEFEED);
            fileWriter.write("Allow-Too-Many-Fields: " + (options.getDataOptions().isAllowTooMany() ? "1" : "0") + LINEFEED);
            fileWriter.write("Allow-Too-Few-Fields: " + (options.getDataOptions().isAllowTooFew() ? "1" : "0") + LINEFEED);
            if (options.getLogFile() != null && options.getLogFile().length() > 0) {
                fileWriter.write("Import-Log-Filename: " + options.getLogFile() + LINEFEED);
            }
            fileWriter.write("24-Hour-Format: " + (options.getDataOptions().is24Hour() ? "1" : "0") + LINEFEED);
            if (options.getDataOptions().getTimeSeperator() != null && options.getDataOptions().getTimeSeperator().length() > 0) {
                fileWriter.write("Time-Separator: " + options.getDataOptions().getTimeSeperator() + LINEFEED);
            }
            if (options.getDataOptions().getDateSeperator() != null && options.getDataOptions().getDateSeperator().length() > 0) {
                fileWriter.write("Date-Separator: " + options.getDataOptions().getDateSeperator() + LINEFEED);
            }
            if (options.getDataOptions().getDateTimeFormat() != null && options.getDataOptions().getDateTimeFormat().length() > 0) {
                fileWriter.write("Long-Date-Format: " + options.getDataOptions().getDateTimeFormat() + LINEFEED);
            }
            if (options.getDataOptions().getDateFormat() != null && options.getDataOptions().getDateFormat().length() > 0) {
                fileWriter.write("Short-Date-Format: " + options.getDataOptions().getDateFormat() + LINEFEED);
            }
            if (options.getDataOptions().getAMString() != null && options.getDataOptions().getAMString().length() > 0) {
                fileWriter.write("Morning-String: " + options.getDataOptions().getAMString() + LINEFEED);
            }
            if (options.getDataOptions().getPMString() != null && options.getDataOptions().getPMString().length() > 0) {
                fileWriter.write("Afternoon-String: " + options.getDataOptions().getPMString() + LINEFEED);
            }
            fileWriter.write("Digit-Group-Separator: " + options.getDataOptions().getDigitGroupSeparator() + LINEFEED);
            fileWriter.write("Decimal-Separator: " + options.getDataOptions().getDecimalSeparator() + LINEFEED);
            if (mappings.getMappings() != null) {
                for (int schemaField : mappings.getMappings().keySet()) {
                    fileWriter.write("Mapping: " + schemaField + mappings.getMappings().get(schemaField).toARMString() + LINEFEED);
                }
            }
            if (mappings.getFallbacks() != null) {
                for (int schemaField : mappings.getFallbacks().keySet()) {
                    fileWriter.write("Fallback-Mapping: " + schemaField + '=' + mappings.getFallbacks().get(schemaField).fallBackToArmString() + LINEFEED);
                }
            }
            fileWriter.write("end\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private int getDataTypeValue(String type) throws ARImportException {
        if (type != null) {
            if (type.equals("ARX")) {
                return 3;
            }
            if (type.equals("XML")) {
                return 4;
            }
            if (type.equals("CSV")) {
                return 2;
            }
            if (type.equals("ASC")) {
                return 1;
            }
        }
        throw new ARImportException("Unsupported data file type specified");
    }

    private String extractLogFile(String strLine) throws ARImportException {
        if (strLine.length() > "Import-Log-Filename:".length() + 1) {
            return strLine.substring("Import-Log-Filename:".length()).trim();
        }
        throw new ARImportException("Import-Log-Filename:is not defined");
    }

    public final ImportOptions getOptions() {
        return this.options;
    }

    public final void setOptions(ImportOptions options) {
        this.options = options;
    }
}

