/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataOptions {
    protected static final String[] NEWLINE_TOKENS = new String[]{"\\r\\n", "\\n"};
    private boolean disableRequired = false;
    private boolean disablePattern = false;
    private boolean suppressFilters = false;
    private boolean suppressAssociations = false;
    private boolean allowTooMany = true;
    private boolean allowTooFew = true;
    private boolean forceoverride = false;
    private int suppressDefaults = 0;
    private MultiMatch multiMatch = MultiMatch.USEFIRST;
    private List<Integer> duplicateFields = null;
    private String multiDuplicateFields = null;
    private boolean stripLeading = false;
    private boolean stripTrailing = false;
    private boolean truncate = false;
    private BadRecords badRecordHandling = BadRecords.SKIP;
    private DuplicateHandling duplicateIdHandling = DuplicateHandling.DUP_MERGE;
    private boolean amPMSuffix = true;
    private String amString = "";
    private List<String> newLineTokens = new ArrayList<String>();
    private boolean forceBulk = false;
    private int transactionSize = 100;
    private boolean use24Hour = false;
    private String dateFormat = null;
    private String timeFormat = null;
    private String dateTimeFormat = null;
    private String pmString = "";
    private String dateSeperator = "";
    private String timeSeperator = "";
    private String digitGroupSeparator = "";
    private String decimalSeparator = "";
    private List<String> customDateFormats = new ArrayList<String>();
    private List<String> customDateTimeFormats = new ArrayList<String>();
    private List<String> customTimeFormats = new ArrayList<String>();
    private String customAMString = "";
    private String customPMString = "";
    private String customDigitgroupSeparator = "";
    private String customDecimalSeparator = "";
    private boolean skipDuplicate = false;

    public DataOptions() {
        this.newLineTokens = new ArrayList<String>(NEWLINE_TOKENS.length);
        for (String newLine : NEWLINE_TOKENS) {
            this.newLineTokens.add(newLine);
        }
    }

    public List<String> getCustomDateFormats() {
        return this.customDateFormats;
    }

    public void setCustomDateFormats(List<String> customDateFormats) {
        this.customDateFormats = customDateFormats;
    }

    public List<String> getCustomDateTimeFormats() {
        return this.customDateTimeFormats;
    }

    public void setCustomDateTimeFormats(List<String> customDateTimeFormats) {
        this.customDateTimeFormats = customDateTimeFormats;
    }

    public List<String> getCustomTimeFormats() {
        return this.customTimeFormats;
    }

    public void setCustomTimeFormats(List<String> customTimeFormats) {
        this.customTimeFormats = customTimeFormats;
    }

    public String getCustomAMString() {
        return this.customAMString;
    }

    public void setCustomAMString(String customAMString) {
        this.customAMString = customAMString;
    }

    public String getCustomPMString() {
        return this.customPMString;
    }

    public void setCustomPMString(String customPMString) {
        this.customPMString = customPMString;
    }

    public boolean isAllowTooFew() {
        return this.allowTooFew;
    }

    public void setAllowTooFew(boolean allowTooFew) {
        this.allowTooFew = allowTooFew;
    }

    public boolean isAllowTooMany() {
        return this.allowTooMany;
    }

    public void setAllowTooMany(boolean allowTooMany) {
        this.allowTooMany = allowTooMany;
    }

    public BadRecords getBadRecordHandling() {
        return this.badRecordHandling;
    }

    public void setBadRecordHandling(BadRecords badRecordHandling) {
        this.badRecordHandling = badRecordHandling;
    }

    public boolean isDisablePattern() {
        return this.disablePattern;
    }

    public void setDisablePattern(boolean disablePattern) {
        this.disablePattern = disablePattern;
    }

    public boolean isDisableRequired() {
        return this.disableRequired;
    }

    public void setDisableRequired(boolean disableRequired) {
        this.disableRequired = disableRequired;
    }

    public DuplicateHandling getDuplicateIdHandling() {
        return this.duplicateIdHandling;
    }

    public void setDuplicateIdHandling(DuplicateHandling duplicateIdHandling) {
        this.duplicateIdHandling = duplicateIdHandling;
    }

    public boolean isForceoverride() {
        return this.forceoverride;
    }

    public void setForceoverride(boolean forceoverride) {
        this.forceoverride = forceoverride;
    }

    public MultiMatch getMultiMatch() {
        return this.multiMatch;
    }

    public void setMultiMatch(MultiMatch multiMatch) {
        this.multiMatch = multiMatch;
    }

    public boolean isStripLeading() {
        return this.stripLeading;
    }

    public void setStripLeading(boolean stripLeading) {
        this.stripLeading = stripLeading;
    }

    public boolean isStripTrailing() {
        return this.stripTrailing;
    }

    public void setStripTrailing(boolean stripTrailing) {
        this.stripTrailing = stripTrailing;
    }

    public int getSuppressDefaults() {
        return this.suppressDefaults;
    }

    public void setSuppressDefaults(int suppressDefaults) {
        this.suppressDefaults = suppressDefaults;
    }

    public boolean isSuppressFilters() {
        return this.suppressFilters;
    }

    public void setSuppressFilters(boolean suppressFilters) {
        this.suppressFilters = suppressFilters;
    }

    public boolean isSuppressAssociations() {
        return this.suppressAssociations;
    }

    public void setSuppressAssociations(boolean suppressAssociations) {
        this.suppressAssociations = suppressAssociations;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public List<Integer> getDuplicateFields() {
        return this.duplicateFields;
    }

    public void setDuplicateFields(List<Integer> duplicateFields) {
        this.duplicateFields = duplicateFields;
    }

    public void setDuplicateFields(int[] duplicateFields) {
        if (duplicateFields != null && duplicateFields.length > 0) {
            this.duplicateFields = new ArrayList<Integer>();
            for (int fieldId : duplicateFields) {
                this.duplicateFields.add(fieldId);
            }
        }
    }

    public boolean isAMPMSuffix() {
        return this.amPMSuffix;
    }

    public void setAMPMSuffix(boolean amPMSuffix) {
        this.amPMSuffix = amPMSuffix;
    }

    public String getAMString() {
        return this.amString;
    }

    public void setAMString(String amString) {
        this.amString = amString;
    }

    public boolean is24Hour() {
        return this.use24Hour;
    }

    public void setUse24Hour(boolean use24Hour) {
        this.use24Hour = use24Hour;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String longDateFormat) {
        this.dateFormat = longDateFormat;
    }

    public String getPMString() {
        return this.pmString;
    }

    public void setPMString(String pmString) {
        this.pmString = pmString;
    }

    public String getDateSeperator() {
        return this.dateSeperator;
    }

    public void setDateSeperator(String dateSeperator) {
        this.dateSeperator = dateSeperator;
    }

    public String getTimeSeperator() {
        return this.timeSeperator;
    }

    public void setTimeSeperator(String timeSeperator) {
        this.timeSeperator = timeSeperator;
    }

    public void addDuplicateFieldId(int fieldId) {
        if (this.duplicateFields == null) {
            this.duplicateFields = new ArrayList<Integer>();
        }
        if (!this.duplicateFields.contains(fieldId)) {
            this.duplicateFields.add(fieldId);
        }
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public List<String> getNewLineTokens() {
        return this.newLineTokens;
    }

    public void setNewLineTokens(List<String> newLineTokens) {
        this.newLineTokens = newLineTokens;
    }

    public int getTransactionSize() {
        return this.transactionSize;
    }

    public void setTransactionSize(int transactionSize) {
        this.transactionSize = transactionSize;
    }

    public String getDigitGroupSeparator() {
        return this.digitGroupSeparator;
    }

    public void setDigitGroupSeparator(String digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public DataOptions clone() {
        DataOptions options = new DataOptions();
        options.disableRequired = this.disableRequired;
        options.disablePattern = this.disablePattern;
        options.suppressFilters = this.suppressFilters;
        options.suppressAssociations = this.suppressAssociations;
        options.allowTooMany = this.allowTooMany;
        options.allowTooFew = this.allowTooFew;
        options.forceoverride = this.forceoverride;
        options.suppressDefaults = this.suppressDefaults;
        options.multiMatch = this.multiMatch;
        options.duplicateFields = this.duplicateFields;
        options.stripLeading = this.stripLeading;
        options.stripTrailing = this.stripTrailing;
        options.truncate = this.truncate;
        options.badRecordHandling = this.badRecordHandling;
        options.duplicateIdHandling = this.duplicateIdHandling;
        options.amPMSuffix = this.amPMSuffix;
        options.amString = this.amString;
        options.newLineTokens = new ArrayList<String>(this.newLineTokens);
        options.transactionSize = this.transactionSize;
        options.use24Hour = this.use24Hour;
        options.dateFormat = this.dateFormat;
        options.timeFormat = this.timeFormat;
        options.dateTimeFormat = this.dateTimeFormat;
        options.pmString = this.pmString;
        options.dateSeperator = this.dateSeperator;
        options.timeSeperator = this.timeSeperator;
        options.digitGroupSeparator = this.digitGroupSeparator;
        options.decimalSeparator = this.decimalSeparator;
        options.forceBulk = this.forceBulk;
        options.skipDuplicate = this.skipDuplicate;
        options.customDateFormats = this.customDateFormats;
        options.customDateTimeFormats = this.customDateTimeFormats;
        options.customTimeFormats = this.customTimeFormats;
        options.customAMString = this.customAMString;
        options.customPMString = this.customPMString;
        options.customDigitgroupSeparator = this.customDigitgroupSeparator;
        options.customDecimalSeparator = this.customDecimalSeparator;
        options.multiDuplicateFields = this.multiDuplicateFields;
        return options;
    }

    public String getCustomDigitgroupSeparator() {
        return this.customDigitgroupSeparator;
    }

    public void setCustomDigitgroupSeparator(String customDigitgroupSeparator) {
        this.customDigitgroupSeparator = customDigitgroupSeparator;
    }

    public String getCustomDecimalSeparator() {
        return this.customDecimalSeparator;
    }

    public void setCustomDecimalSeparator(String customDecimalSeparator) {
        this.customDecimalSeparator = customDecimalSeparator;
    }

    public boolean isForceBulk() {
        return this.forceBulk;
    }

    public void setForceBulk(boolean forceBulk) {
        this.forceBulk = forceBulk;
    }

    public List<Integer> getDuplicateFieldsFormMultiMode(String fName) {
        List<Integer> res = null;
        StringBuffer suruceString = new StringBuffer(this.multiDuplicateFields);
        while (suruceString != null && suruceString.toString().trim().length() > 0) {
            res = this.findIDSForSchema(suruceString, fName);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    private List<Integer> findIDSForSchema(StringBuffer suruceString, String sname) {
        Logger logger = ThreadLocalStorage.getLogger();
        ArrayList<Integer> result = null;
        int fIdx = suruceString.indexOf(sname);
        if (fIdx >= 0) {
            String eval = suruceString.toString().substring(fIdx + sname.length()).trim();
            if (eval != null && eval.trim().length() > 0) {
                if (eval.startsWith("=")) {
                    try {
                        eval = eval.substring(1).trim();
                        int semoCoIdx = eval.indexOf(";");
                        if (-1 != semoCoIdx) {
                            eval = eval.substring(0, semoCoIdx).trim();
                        }
                        String[] fields = eval.split(",");
                        result = new ArrayList<Integer>(fields.length);
                        for (String field : fields) {
                            int fieldId = Integer.parseInt(field.trim());
                            result.add(fieldId);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_PARSING_ALTFID.toDefMsg(), sname));
                    }
                    suruceString.delete(0, suruceString.length());
                } else {
                    suruceString.delete(0, suruceString.length());
                    suruceString.append(eval);
                }
            } else {
                suruceString.delete(0, suruceString.length());
            }
        } else {
            suruceString.delete(0, suruceString.length());
        }
        return result;
    }

    public void setMultiDuplicateFields(String multiDuplicateFields) {
        this.multiDuplicateFields = multiDuplicateFields;
    }

    public String getMultiDuplicateFields() {
        return this.multiDuplicateFields;
    }

    public void setSkipDuplicate(boolean logerror) {
        this.skipDuplicate = logerror;
    }

    public boolean isSkipDuplicate() {
        return this.skipDuplicate;
    }

    public static enum MultiMatch {
        SKIP(6),
        USEFIRST(3),
        UPDATEALL(5);

        private final int armValue;

        private MultiMatch(int armValue) {
            this.armValue = armValue;
        }

        public int getARMValue() {
            return this.armValue;
        }

        public static MultiMatch fromARMValue(int armValue) {
            for (MultiMatch item : MultiMatch.values()) {
                if (armValue != item.getARMValue()) continue;
                return item;
            }
            return SKIP;
        }
    }

    public static enum BadRecords {
        ALERTUSER(0),
        SKIP(1),
        FALLBACK(2),
        STOP(3);

        private final int armValue;

        private BadRecords(int armValue) {
            this.armValue = armValue;
        }

        public int getARMValue() {
            return this.armValue;
        }

        public static BadRecords fromARMValue(int armValue) {
            for (BadRecords item : BadRecords.values()) {
                if (armValue != item.getARMValue()) continue;
                return item;
            }
            return SKIP;
        }
    }

    public static enum DuplicateHandling {
        DUP_ERROR(1, 1),
        DUP_NEW_ID(2, 2),
        DUP_OVERWRITE(3, 3),
        DUP_MERGE(4, 4),
        GEN_NEW_ID(5, 0);

        private final int constant;
        private final int armValue;

        private DuplicateHandling(int constant, int oldImportCode) {
            this.constant = constant;
            this.armValue = oldImportCode;
        }

        public int getMergeOption() {
            return this.constant;
        }

        public int getARMValue() {
            return this.armValue;
        }

        public static DuplicateHandling fromARMValue(int armValue) {
            for (DuplicateHandling item : DuplicateHandling.values()) {
                if (armValue != item.getARMValue()) continue;
                return item;
            }
            return DUP_MERGE;
        }
    }
}

