/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.ArLogBytes;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrTcpDecodingStream
extends XdrDecodingStream {
    private Object socket;
    InputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int fragmentLength;
    private boolean lastFragment;

    public XdrTcpDecodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        this.socket = streamingSocket;
        this.stream = ((Socket)this.socket).getInputStream();
        this.buffer = this.createBuffer(bufferSize);
        this.prepareBuffer(this.buffer.length);
    }

    public XdrTcpDecodingStream(ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        this.convertSocket(streamingSocket);
        this.setStream(this.extractStream(streamingSocket));
        this.buffer = this.createBuffer(bufferSize);
        this.prepareBuffer(this.buffer.length);
    }

    protected XdrTcpDecodingStream(Socket streamingSocket, byte[] newBuffer) throws IOException {
        this.socket = streamingSocket;
        this.stream = ((Socket)this.socket).getInputStream();
        this.buffer = newBuffer;
        this.prepareBuffer(this.buffer.length);
    }

    protected XdrTcpDecodingStream(ArNetworkSocket streamingSocket, byte[] newBuffer) throws IOException {
        this.convertSocket(streamingSocket);
        this.setStream(this.extractStream(streamingSocket));
        this.buffer = newBuffer;
        this.prepareBuffer(this.buffer.length);
    }

    private void prepareBuffer(int bufferSize) {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    private byte[] createBuffer(int bufferSize) {
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        return new byte[bufferSize];
    }

    @Override
    public InetAddress getSenderAddress() {
        return ((Socket)this.socket).getInetAddress();
    }

    @Override
    public int getSenderPort() {
        return ((Socket)this.socket).getPort();
    }

    @Override
    public void beginDecoding() throws OncRpcException, IOException {
        this.fill();
    }

    protected void readBuffer(InputStream stream, byte[] bytes, int bytesToRead) throws IOException, OncRpcException {
        String msg;
        int byteOffset = 0;
        if (ArLogBytes.isDebugEnabled()) {
            msg = "readBuffer: start, bytesToRead=" + bytesToRead;
            ArLogBytes.debugout(msg);
        }
        while (bytesToRead > 0) {
            int bytesRead = stream.read(bytes, byteOffset, bytesToRead);
            if (bytesRead <= 0) {
                if (ArLogBytes.isDebugEnabled()) {
                    msg = "readBuffer: EOF: bytesToRead=" + bytesToRead + ", byteOffset=" + byteOffset + ", bytesRead=" + bytesRead;
                    ArLogBytes.debugout(msg);
                }
                throw new OncRpcException(4);
            }
            if (ArLogBytes.isDebugEnabled()) {
                msg = "readBuffer: bytesToRead=" + bytesToRead + ", byteOffset=" + byteOffset + ", bytesRead=" + bytesRead;
                ArLogBytes.printByteArrayAsHex(bytes, byteOffset, bytesToRead, msg);
            }
            bytesToRead -= bytesRead;
            byteOffset += bytesRead;
        }
    }

    protected void fill() throws OncRpcException, IOException {
        if (this.fragmentLength <= 0) {
            if (this.lastFragment) {
                throw new OncRpcException(43);
            }
            this.readInHeaderOfNextFragment();
        }
        this.bufferIndex = 0;
        if (this.fragmentLength < this.buffer.length) {
            if (ArLogBytes.isDebugEnabled()) {
                String msg = "fill: fragmentLength=" + this.fragmentLength + " lastFragment=" + this.lastFragment + " bufferHighmark=" + (this.fragmentLength - 4) + " bufferIndex=" + this.bufferIndex;
                ArLogBytes.debugout(msg);
            }
            this.readBuffer(this.stream, this.buffer, this.fragmentLength);
            this.bufferHighmark = this.fragmentLength - 4;
            this.fragmentLength = 0;
        } else {
            if (ArLogBytes.isDebugEnabled()) {
                String msg = "fill: fragmentLength=" + this.fragmentLength + " lastFragment=" + this.lastFragment + " bufferHighmark=" + (this.buffer.length - 4) + " bufferIndex=" + this.bufferIndex;
                ArLogBytes.debugout(msg);
            }
            this.readBuffer(this.stream, this.buffer, this.buffer.length);
            this.bufferHighmark = this.buffer.length - 4;
            this.fragmentLength -= this.buffer.length;
        }
    }

    @Override
    public void endDecoding() throws OncRpcException, IOException {
        try {
            while (!this.lastFragment || this.fragmentLength != 0) {
                this.fill();
            }
        }
        finally {
            this.bufferIndex = 0;
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
        }
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.stream = null;
        this.socket = null;
    }

    @Override
    public int xdrDecodeInt() throws OncRpcException, IOException {
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int value = this.buffer[this.bufferIndex++] & 0xFF;
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return value;
    }

    @Override
    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        int offset = 0;
        byte[] bytes = new byte[length];
        while (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
        return bytes;
    }

    @Override
    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int bufferIndex) {
        this.bufferIndex = bufferIndex;
    }

    public int getBufferHighmark() {
        return this.bufferHighmark;
    }

    protected void setBufferHighmark(int bufferHighmark) {
        this.bufferHighmark = bufferHighmark;
    }

    protected boolean isLastFragment() {
        return this.lastFragment;
    }

    protected void readIncomingFragmentInfo(InputStream socketInputStream, byte[] bytes, int i) throws IOException, OncRpcException {
        this.readBuffer(socketInputStream, bytes, 4);
        this.fragmentLength = bytes[0] & 0xFF;
        this.fragmentLength = (this.fragmentLength << 8) + (bytes[1] & 0xFF);
        this.fragmentLength = (this.fragmentLength << 8) + (bytes[2] & 0xFF);
        this.fragmentLength = (this.fragmentLength << 8) + (bytes[3] & 0xFF);
        if ((this.fragmentLength & Integer.MIN_VALUE) != 0) {
            this.fragmentLength &= Integer.MAX_VALUE;
            this.lastFragment = true;
        } else {
            this.lastFragment = false;
        }
        if ((this.fragmentLength & 3) != 0) {
            throw new IOException("ONC/RPC XDR fragment length is not a multiple of four");
        }
    }

    protected int getFragmentLength() {
        return this.fragmentLength;
    }

    protected byte[] getBufferArray() {
        return this.buffer;
    }

    protected void convertSocket(ArNetworkSocket streamingSocket) {
        this.socket = streamingSocket.getSocket();
    }

    protected InputStream extractStream(ArNetworkSocket streamingSocket) throws IOException {
        return streamingSocket.getInputStream();
    }

    protected void setStream(InputStream streaming) {
        this.stream = streaming;
    }

    public void readInHeaderOfNextFragment() throws IOException, OncRpcException {
        byte[] bytes = new byte[4];
        this.readIncomingFragmentInfo(this.stream, bytes, 4);
    }
}

