/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.util;

import com.kaazing.gateway.client.html5.util.GenericURI;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class WSCompositeURI
extends GenericURI<WSCompositeURI> {
    static Map<String, String> wsEquivalent = new HashMap<String, String>();
    String scheme = null;

    @Override
    protected boolean isValidScheme(String scheme) {
        return wsEquivalent.get(scheme) != null;
    }

    public WSCompositeURI(String location) throws URISyntaxException {
        this(new URI(location));
    }

    public WSCompositeURI(URI uri) throws URISyntaxException {
        super(uri);
    }

    @Override
    protected WSCompositeURI duplicate(URI uri) {
        try {
            return new WSCompositeURI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isSecure() {
        String scheme = this.getScheme();
        return "wss".equals(wsEquivalent.get(scheme));
    }

    public WSURI getWSEquivalent() {
        try {
            String wsEquivScheme = wsEquivalent.get(this.getScheme());
            return WSURI.replaceScheme(this.uri, wsEquivScheme);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            String location = this.uri.toString();
            int schemeEndIndex = location.indexOf("://");
            this.scheme = schemeEndIndex != -1 ? location.substring(0, schemeEndIndex) : this.uri.toString();
        }
        return this.scheme;
    }

    static {
        wsEquivalent.put("ws", "ws");
        wsEquivalent.put("wss", "wss");
        wsEquivalent.put("java:ws", "ws");
        wsEquivalent.put("java:wse", "ws");
        wsEquivalent.put("java:wss", "wss");
        wsEquivalent.put("java:wse+ssl", "wss");
    }
}

