/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util;

import com.bmc.thirdparty.org.springframework.lang.UsesJava8;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.nio.charset.Charset;
import java.util.Base64;

public abstract class Base64Utils {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Base64Delegate delegate;

    private static void assertSupported() {
        Assert.state(delegate != null, "Neither Java 8 nor Apache Commons Codec found - Base64 encoding not supported");
    }

    public static byte[] encode(byte[] src) {
        Base64Utils.assertSupported();
        return delegate.encode(src);
    }

    public static String encodeToString(byte[] src) {
        Base64Utils.assertSupported();
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return "";
        }
        return new String(delegate.encode(src), DEFAULT_CHARSET);
    }

    public static byte[] decode(byte[] src) {
        Base64Utils.assertSupported();
        return delegate.decode(src);
    }

    public static byte[] decodeFromString(String src) {
        Base64Utils.assertSupported();
        if (src == null) {
            return null;
        }
        if (src.length() == 0) {
            return new byte[0];
        }
        return delegate.decode(src.getBytes(DEFAULT_CHARSET));
    }

    static {
        Base64Delegate delegateToUse = null;
        if (ClassUtils.isPresent("java.util.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new JdkBase64Delegate();
        } else if (ClassUtils.isPresent("com.bmc.thirdparty.org.apache.commons.codec.binary.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new CommonsCodecBase64Delegate();
        }
        delegate = delegateToUse;
    }

    private static class CommonsCodecBase64Delegate
    implements Base64Delegate {
        private final com.bmc.thirdparty.org.apache.commons.codec.binary.Base64 base64 = new com.bmc.thirdparty.org.apache.commons.codec.binary.Base64();

        private CommonsCodecBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            return this.base64.encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.base64.decode(src);
        }
    }

    @UsesJava8
    private static class JdkBase64Delegate
    implements Base64Delegate {
        private JdkBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return Base64.getEncoder().encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return Base64.getDecoder().decode(src);
        }
    }

    private static interface Base64Delegate {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);
    }
}

