/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.env;

import com.bmc.thirdparty.org.springframework.core.env.CommandLinePropertySource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class JOptCommandLinePropertySource
extends CommandLinePropertySource<OptionSet> {
    public JOptCommandLinePropertySource(OptionSet options) {
        super(options);
    }

    public JOptCommandLinePropertySource(String name, OptionSet options) {
        super(name, options);
    }

    @Override
    protected boolean containsOption(String name) {
        return ((OptionSet)this.source).has(name);
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList names = new ArrayList();
        for (OptionSpec spec : ((OptionSet)this.source).specs()) {
            ArrayList aliases = new ArrayList(spec.options());
            if (aliases.isEmpty()) continue;
            names.add(aliases.get(aliases.size() - 1));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public List<String> getOptionValues(String name) {
        List argValues = ((OptionSet)this.source).valuesOf(name);
        ArrayList<String> stringArgValues = new ArrayList<String>();
        for (Object argValue : argValues) {
            Assert.isInstanceOf(String.class, argValue, "Argument values must be of type String");
            stringArgValues.add((String)argValue);
        }
        if (stringArgValues.isEmpty()) {
            return ((OptionSet)this.source).has(name) ? Collections.emptyList() : null;
        }
        return Collections.unmodifiableList(stringArgValues);
    }

    @Override
    protected List<String> getNonOptionArgs() {
        List argValues = ((OptionSet)this.source).nonOptionArguments();
        ArrayList<String> stringArgValues = new ArrayList<String>();
        for (Object argValue : argValues) {
            Assert.isInstanceOf(String.class, argValue, "Argument values must be of type String");
            stringArgValues.add((String)argValue);
        }
        return stringArgValues.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(stringArgValues);
    }
}

