/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.context.annotation.AdviceMode;
import com.bmc.thirdparty.org.springframework.context.annotation.AnnotationConfigUtils;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportSelector;
import com.bmc.thirdparty.org.springframework.core.GenericTypeResolver;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotatedTypeMetadata;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.annotation.Annotation;

public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class<?> annoType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        AnnotationAttributes attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importingClassMetadata, annoType);
        Assert.notNull(attributes, String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        AdviceMode adviceMode = (AdviceMode)((Object)attributes.getEnum(this.getAdviceModeAttributeName()));
        String[] imports = this.selectImports(adviceMode);
        Assert.notNull(imports, String.format("Unknown AdviceMode: '%s'", new Object[]{adviceMode}));
        return imports;
    }

    protected abstract String[] selectImports(AdviceMode var1);
}

