/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.cache.interceptor;

import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheOperation;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheOperationSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class CompositeCacheOperationSource
implements CacheOperationSource,
Serializable {
    private final CacheOperationSource[] cacheOperationSources;

    public CompositeCacheOperationSource(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty(cacheOperationSources, "cacheOperationSources array must not be empty");
        this.cacheOperationSources = cacheOperationSources;
    }

    public final CacheOperationSource[] getCacheOperationSources() {
        return this.cacheOperationSources;
    }

    @Override
    public Collection<CacheOperation> getCacheOperations(Method method, Class<?> targetClass) {
        ArrayList<CacheOperation> ops = null;
        for (CacheOperationSource source : this.cacheOperationSources) {
            Collection<CacheOperation> cacheOperations = source.getCacheOperations(method, targetClass);
            if (cacheOperations == null) continue;
            if (ops == null) {
                ops = new ArrayList<CacheOperation>();
            }
            ops.addAll(cacheOperations);
        }
        return ops;
    }
}

