/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.cache.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Autowired;
import com.bmc.thirdparty.org.springframework.cache.CacheManager;
import com.bmc.thirdparty.org.springframework.cache.annotation.CachingConfigurer;
import com.bmc.thirdparty.org.springframework.cache.annotation.EnableCaching;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheErrorHandler;
import com.bmc.thirdparty.org.springframework.cache.interceptor.CacheResolver;
import com.bmc.thirdparty.org.springframework.cache.interceptor.KeyGenerator;
import com.bmc.thirdparty.org.springframework.context.annotation.Configuration;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportAware;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import java.util.Collection;

@Configuration
public abstract class AbstractCachingConfiguration<C extends CachingConfigurer>
implements ImportAware {
    protected AnnotationAttributes enableCaching;
    protected CacheManager cacheManager;
    protected CacheResolver cacheResolver;
    protected KeyGenerator keyGenerator;
    protected CacheErrorHandler errorHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableCaching = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableCaching.class.getName(), false));
        Assert.notNull(this.enableCaching, "@EnableCaching is not present on importing class " + importMetadata.getClassName());
    }

    @Autowired(required=false)
    void setConfigurers(Collection<C> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of " + "CachingConfigurer were found when only 1 was expected. " + "Refactor the configuration such that CachingConfigurer is " + "implemented only once or not at all.");
        }
        CachingConfigurer configurer = (CachingConfigurer)configurers.iterator().next();
        this.useCachingConfigurer(configurer);
    }

    protected void useCachingConfigurer(C config) {
        this.cacheManager = config.cacheManager();
        this.cacheResolver = config.cacheResolver();
        this.keyGenerator = config.keyGenerator();
        this.errorHandler = config.errorHandler();
    }
}

