/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.propertyeditors;

import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.ResourceEditor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ResourceUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;

public class FileEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public FileEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public FileEditor(ResourceEditor resourceEditor) {
        Assert.notNull(resourceEditor, "ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        File file;
        if (!StringUtils.hasText(text)) {
            this.setValue(null);
            return;
        }
        if (!ResourceUtils.isUrl(text) && (file = new File(text)).isAbsolute()) {
            this.setValue(file);
            return;
        }
        this.resourceEditor.setAsText(text);
        Resource resource = (Resource)this.resourceEditor.getValue();
        if (ResourceUtils.isUrl(text) || resource.exists()) {
            try {
                this.setValue(resource.getFile());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not retrieve File for " + resource + ": " + ex.getMessage());
            }
        } else {
            this.setValue(new File(text));
        }
    }

    @Override
    public String getAsText() {
        File value = (File)this.getValue();
        return value != null ? value.getPath() : "";
    }
}

