/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.samples;

import com.bmc.arsys.api.ARBulkException;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.EntryReturn;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class arjoo {
    public static void main(String[] args) throws IOException {
        ARServerUser context = new ARServerUser("Demo", "", "", "localhost");
        arjoo.getContainers(context);
        arjoo.getQuery(context);
    }

    public static void getContainers(ARServerUser context) {
        String key1 = "Sample";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key1);
        try {
            List<Container> containers = context.getListContainerObjects(keys);
            System.out.println("find " + containers.size() + " objects");
        }
        catch (ARException e) {
            System.out.println("find objects failed");
            arjoo.printARException(e);
        }
    }

    public static void getQuery(ARServerUser context) {
        String query = "'3_Create_Date' < \"4/9/2005\"";
        FieldCriteria crit = new FieldCriteria();
        crit.setRetrieveAll(true);
        try {
            List<Field> fieldList = context.getListFieldObjects(null, 0, 0L, null);
            QualifierInfo qualifier = context.parseQualification(query, fieldList, null, 0);
            System.out.println("query has been successfully parsed. (" + query + ")");
            String updatedQuery = context.formatQualification(qualifier, fieldList, null, 0, false);
            System.out.println("qualification has been successfully parsed. (" + updatedQuery + ")");
        }
        catch (ARException e) {
            System.out.println("can't parse the query");
            arjoo.printARException(e);
        }
    }

    public static void printARException(ARException ex) {
        List<StatusInfo> statusList = ex.getLastStatus();
        if (statusList != null) {
            arjoo.PrintStatusInfoList("", statusList);
        }
        if (ex.getClass() == ARBulkException.class) {
            List<BulkEntryReturn> blkEntryReturn = ((ARBulkException)ex).getBulkEntryReturn();
            arjoo.PrintBulkEntryReturnList("", blkEntryReturn);
        }
    }

    public static void PrintStatusInfoList(String indent, StatusInfo[] value) {
        if (value == null || value.length == 0) {
            System.out.println(indent + "ReturnCode:  OK");
            System.out.println(indent + "Status List : 0 items");
            return;
        }
        System.out.print(indent + "ReturnCode:  ");
        switch (value[0].getMessageType()) {
            case 0: {
                System.out.println("OK");
                break;
            }
            case 1: {
                System.out.println("WARNING");
                break;
            }
            case 2: {
                System.out.println("ERROR");
                break;
            }
            case 3: {
                System.out.println("FATAL");
                break;
            }
            default: {
                System.out.println("<Unknown Type>: " + value[0].getMessageType());
            }
        }
        System.out.println(indent + "Status List : " + value.length + " items");
        for (int i = 0; i < value.length; ++i) {
            arjoo.PrintStatusInfo(indent + "   ", "Status Struct :", value[i]);
        }
    }

    public static void PrintStatusInfoList(String indent, List<StatusInfo> value) {
        arjoo.PrintStatusInfoList(indent, value.toArray(new StatusInfo[0]));
    }

    public static void PrintStatusInfo(String indent, String header, StatusInfo value) {
        System.out.println(indent + header);
        System.out.print(indent + "Message type : ");
        switch (value.getMessageType()) {
            case 0: {
                System.out.println("NOTE");
                break;
            }
            case 1: {
                System.out.println("WARNING");
                break;
            }
            case 2: {
                System.out.println("ERROR");
                break;
            }
            case 3: {
                System.out.println("FATAL");
                break;
            }
            default: {
                System.out.println("<Unknown Type>: " + value.getMessageType());
            }
        }
        System.out.println(indent + "Message number : " + value.getMessageNum());
        System.out.println(indent + "Message:  " + value.getMessageText());
        System.out.println(indent + "Appended: " + value.getAppendedText());
    }

    public static void PrintBulkEntryReturnList(String indent, List<BulkEntryReturn> returnList) {
        System.out.println(indent + "BulkEntryReturn:");
        if (returnList == null || returnList.size() == 0) {
            System.out.println(indent + "BulkEntry List : 0 items");
            return;
        }
        System.out.println(indent + "Number of calls: " + returnList.size());
        block4: for (int i = 0; i < returnList.size(); ++i) {
            System.out.println(indent + "Call type: " + returnList.get(i).getCallType());
            switch (returnList.get(i).getCallType()) {
                case 1: 
                case 4: {
                    arjoo.PrintEntryReturn(indent + "   ", (EntryReturn)returnList.get(i));
                }
                case 2: 
                case 3: {
                    arjoo.PrintStatusInfoList(indent + "     ", returnList.get(i).getStatusList());
                    continue block4;
                }
                default: {
                    System.out.println(indent + "<undefined call type> ");
                }
            }
        }
    }

    public static void PrintEntryReturn(String indent, EntryReturn value) {
        switch (value.getCallType()) {
            case 1: 
            case 4: {
                System.out.println(indent + "Entry Id: " + value.getEntryId());
                break;
            }
            default: {
                System.out.println(indent + "<undefined call type> ");
            }
        }
    }
}

