/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.samples;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JavaAPITest {
    private ARServerUser server = new ARServerUser();
    private String formName = "JavaAPITest";

    public JavaAPITest() {
        this.server.setServer("localhost");
        this.server.setUser("Demo");
        this.server.setPassword("");
        this.server.setClientType(4000);
    }

    public static void main(String[] args) throws ARException {
        JavaAPITest.serverMappingChanged();
        JavaAPITest.serverMappingDeleted_C0();
        JavaAPITest.serverMappingDeleted_w_ClientQueue();
    }

    private static void serverCall() throws ARException {
        JavaAPITest test = new JavaAPITest();
        test.ssi("4000 390685; 36 390680");
        test.ssi("4000 390685");
        test.ssi("");
        test.ssi("4000 390680; 36 390685");
        test.ssi("36 390685");
        test.connect();
        JavaAPITest.gsiCall(test);
        String entryId = "000000000000001";
        System.out.println("client type " + test.server.getClientType() + "Server checking call");
        Entry entry0 = test.server.getEntry("User", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry0.getEntryId());
    }

    private static void serverMappingDeleted_C0() throws ARException {
        JavaAPITest test = new JavaAPITest();
        String entryId = "000000000000001";
        test.ssi("");
        System.out.println("client type " + test.server.getClientType() + "Server mapping deleted");
        Entry entry = test.server.getEntry("Form_S390685_delete_C0", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry.getEntryId());
        System.out.println("client type " + test.server.getClientType() + "resent request to testing if the queue is correct");
        Entry entry3 = test.server.getEntry("Form_SDelted_C0", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry3.getEntryId());
    }

    private static void serverMappingDeleted_w_ClientQueue() throws ARException {
        JavaAPITest test = new JavaAPITest();
        String entryId = "000000000000001";
        test.server.usePrivateRpcQueue(390680);
        System.out.println("client type " + test.server.getClientType() + "Server mapping 390635 w C0");
        Entry entry0 = test.server.getEntry("Form_S390685_C390680", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry0.getEntryId());
        test.ssi("");
        System.out.println("client type " + test.server.getClientType() + "Server mapping deleted");
        Entry entry = test.server.getEntry("Form_S390685_delete_C390680", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry.getEntryId());
    }

    private static void serverMappingChanged() throws ARException {
        JavaAPITest test = new JavaAPITest();
        test.ssi("4000 390685");
        test.connect();
        JavaAPITest.gsiCall(test);
        String entryId = "000000000000001";
        System.out.println("client type " + test.server.getClientType() + "Server mapping 390635 w C0");
        Entry entry0 = test.server.getEntry("Form_S390685_C0", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry0.getEntryId());
        test.ssi("4000 390680");
        System.out.println("client type " + test.server.getClientType() + "Server mapping 390635 w C0");
        Entry entry = test.server.getEntry("Form_S390685_ChangeTo_S390680_C0", entryId, null);
        System.out.println("client type " + test.server.getClientType() + " get Entry #" + entryId + "  successfully." + entry.getEntryId());
    }

    private static void gsiCall(JavaAPITest test) {
        int[] info = new int[]{435};
        ServerInfoMap result = null;
        try {
            result = test.server.getServerInfo(info);
            System.out.println("ARGetServerInfo Results: " + result.toString());
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    void connect() {
        System.out.println();
        System.out.println("Connecting to AR Server...");
        try {
            this.server.verifyUser();
        }
        catch (ARException e) {
            this.ARExceptionHandler(e, "Cannot verify user " + this.server.getUser() + ".");
            System.exit(1);
        }
        System.out.println("Connected to AR Server " + this.server.getServer());
    }

    void ssi(String mapping) throws ARException {
        int[] infoRequest = new int[]{435};
        System.out.println("SSI to AR Server " + this.server.getServer() + mapping);
        ServerInfoMap serverInfo = this.server.getServerInfo(infoRequest);
        serverInfo.put(435, new Value(mapping));
        this.server.setServerInfo(serverInfo);
    }

    public String createEntry(String submitter, String status, String shortDesc) {
        String entryIdOut = "";
        try {
            Entry entry = new Entry();
            entry.put(2, new Value(submitter));
            entry.put(7, new Value(status, DataType.ENUM));
            entry.put(8, new Value(shortDesc));
            entryIdOut = this.server.createEntry(this.formName, entry);
            System.out.println();
            System.out.println("Entry created. The id # is " + entryIdOut);
        }
        catch (ARException e) {
            this.ARExceptionHandler(e, "Cannot create the entry.");
        }
        return entryIdOut;
    }

    void modifyEntry(String entryId) {
        try {
            Entry entry = this.server.getEntry(this.formName, entryId, null);
            entry.put(8, new Value("Modified by JavaAPITest"));
            this.server.setEntry(this.formName, entryId, entry, null, 0);
            System.out.println();
            System.out.println("Entry #" + entryId + " modified successfully.");
        }
        catch (ARException e) {
            this.ARExceptionHandler(e, "Cannot modify the entry. ");
        }
    }

    void queryEntrysByID(String entryId) {
        System.out.println();
        System.out.println("Retrieving entry with entry ID#" + entryId);
        try {
            Entry entry = this.server.getEntry(this.formName, entryId, null);
            if (entry == null) {
                System.out.println("No data found for ID#" + entryId);
                return;
            }
            System.out.println("Number of fields: " + entry.size());
            Set fieldIds = entry.keySet();
            for (Integer fieldId : fieldIds) {
                Field field = this.server.getField(this.formName, fieldId);
                Value val = (Value)entry.get(fieldId);
                System.out.print(field.getName().toString());
                System.out.print(": " + val);
                System.out.print(" , ID: " + field.getFieldID());
                System.out.print(" , Field type: " + field.getDataType());
                if (field instanceof DateTimeField) {
                    System.out.print(", DateTime value: ");
                    Timestamp callDateTimeTS = (Timestamp)val.getValue();
                    if (callDateTimeTS != null) {
                        System.out.print(callDateTimeTS.toDate());
                    }
                }
                System.out.println("");
            }
        }
        catch (ARException e) {
            this.ARExceptionHandler(e, "Problem while querying by entry id. ");
        }
    }

    void queryEntrysByQual(String qualStr) {
        System.out.println();
        System.out.println("Retrieving entryies with qualification " + qualStr);
        try {
            List<Field> fields = this.server.getListFieldObjects(this.formName);
            QualifierInfo qual = this.server.parseQualification(qualStr, fields, null, 0);
            int[] fieldIds = new int[]{2, 7, 8};
            OutputInteger nMatches = new OutputInteger();
            ArrayList<SortInfo> sortOrder = new ArrayList<SortInfo>();
            sortOrder.add(new SortInfo(2, 2));
            List<Entry> entryList = this.server.getListEntryObjects(this.formName, qual, 0, 0, sortOrder, fieldIds, true, nMatches);
            System.out.println("Query returned " + nMatches + " matches.");
            if (nMatches.intValue() > 0) {
                System.out.println("Request Id         Short Description");
                for (int i = 0; i < entryList.size(); ++i) {
                    System.out.println(entryList.get(i).getEntryId() + "     " + entryList.get(i).get(8));
                }
            }
        }
        catch (ARException e) {
            this.ARExceptionHandler(e, "Problem while querying by qualifier. ");
        }
    }

    public void ARExceptionHandler(ARException e, String errMessage) {
        System.out.println(errMessage);
        this.printStatusList(this.server.getLastStatus());
        System.out.print("Stack Trace:");
        e.printStackTrace();
    }

    public void printStatusList(List<StatusInfo> statusList) {
        if (statusList == null || statusList.size() == 0) {
            System.out.println("Status List is empty.");
            return;
        }
        System.out.print("Message type: ");
        switch (statusList.get(0).getMessageType()) {
            case 0: {
                System.out.println("Note");
                break;
            }
            case 1: {
                System.out.println("Warning");
                break;
            }
            case 2: {
                System.out.println("Error");
                break;
            }
            case 3: {
                System.out.println("Fatal Error");
                break;
            }
            default: {
                System.out.println("Unknown (" + statusList.get(0).getMessageType() + ")");
            }
        }
        System.out.println("Status List:");
        for (int i = 0; i < statusList.size(); ++i) {
            System.out.println(statusList.get(i).getMessageText());
            System.out.println(statusList.get(i).getAppendedText());
        }
    }

    public void cleanup() {
        this.server.logout();
        System.out.println();
        System.out.println("User logged out.");
    }
}

