/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.xdr;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.apache.log4j.Logger;

public class ArRpcPassword
implements XdrAble {
    private static final transient String EMPTY_PASSWORD = "";
    protected transient byte[] encryptedPassword = new byte[0];
    protected transient boolean passwordUnencrypted = true;
    public transient String passwordStr = "";
    private static Logger logger = Logger.getLogger(ArRpcPassword.class);
    private boolean debug = logger.isDebugEnabled();

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeDynamicOpaque(this.encryptedPassword);
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        if (!this.passwordUnencrypted || this.encryptedPassword.length > 0) {
            this.encryptedPassword = xdr.xdrDecodeOpaque(this.encryptedPassword.length);
        } else {
            this.passwordStr = xdr.xdrDecodeString();
        }
    }

    public void setPasswordStr(String password, String serverCharsetName) throws AREncryptionException, UnsupportedEncodingException {
        this.passwordStr = password == null ? EMPTY_PASSWORD : password;
        this.passwordUnencrypted = true;
        PasswordEncryption pwdEnc = new PasswordEncryption(0, this.debug);
        this.encryptedPassword = pwdEnc.encryptPasswordEx(this.passwordStr.getBytes(serverCharsetName));
        if (this.encryptedPassword != null && this.encryptedPassword.length > 0) {
            this.passwordUnencrypted = false;
            logger.debug("ArControlStruct*.ArRpcPassword password string is encrypted.");
        }
    }
}

