/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arcompress;

import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arcompress.Decompressable;
import com.bmc.arsys.utils.ARFileHandler;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ARDecompressor
implements Decompressable {
    private static final int COMPRESSION_HEADER_SIZE = 8;
    private int uncompressedLen;
    private Inflater decompressor = new Inflater(true);
    private CRC32 checker = new CRC32();
    private byte[] compressedBytes;
    private int offset;
    private int length;

    public ARDecompressor() {
        this.cleanDecompressor();
    }

    @Override
    public void setInput(byte[] inBytes, int off, int len) {
        if (inBytes == null || len == 0) {
            this.cleanDecompressor();
            return;
        }
        if (len < 8 || inBytes[off] != ARCompressor.ARZIP_MAGIC[0] || inBytes[off + 1] != ARCompressor.ARZIP_MAGIC[1]) {
            this.uncompressedLen = 0;
        } else {
            this.uncompressedLen = inBytes[off + 4] & 0xFF;
            this.uncompressedLen |= (inBytes[off + 5] & 0xFF) << 8;
            this.uncompressedLen |= (inBytes[off + 6] & 0xFF) << 16;
            this.uncompressedLen |= (inBytes[off + 7] & 0xFF) << 24;
        }
        this.compressedBytes = inBytes;
        this.offset = off;
        this.length = len;
        if (this.uncompressedLen != 0) {
            this.decompressor.setInput(inBytes, 8 + this.offset, len - 8);
        }
    }

    @Override
    public void setInput(byte[] inBytes) {
        this.setInput(inBytes, 0, inBytes.length);
    }

    @Override
    public void setInput(File ifile) throws IOException {
        this.setInput(ARFileHandler.readBytesFromFile(ifile));
    }

    private void cleanDecompressor() {
        this.compressedBytes = null;
        this.offset = 0;
        this.length = 0;
        this.uncompressedLen = 0;
        this.checker.reset();
        this.decompressor.reset();
    }

    @Override
    public byte[] inflate() throws DataFormatException {
        if (this.compressedBytes == null || this.compressedBytes.length == 0) {
            return null;
        }
        byte[] outBytes = null;
        if (this.uncompressedLen == 0) {
            outBytes = this.compressedBytes;
        } else {
            outBytes = new byte[this.uncompressedLen];
            this.decompressor.inflate(outBytes);
            this.checker.update(outBytes);
            long checksum = this.checker.getValue();
            int off = this.offset + this.length - 4;
            int embededchecksum = this.compressedBytes[off++] & 0xFF;
            embededchecksum |= (this.compressedBytes[off++] & 0xFF) << 8;
            embededchecksum |= (this.compressedBytes[off++] & 0xFF) << 16;
            if ((embededchecksum |= (this.compressedBytes[off++] & 0xFF) << 24) != (int)(checksum & 0xFFFFFFFFFFFFFFFFL)) {
                this.cleanDecompressor();
                throw new DataFormatException();
            }
        }
        this.cleanDecompressor();
        return outBytes;
    }

    @Override
    public int inflate(File ofile) throws DataFormatException, IOException {
        int outLen = 0;
        byte[] b = this.inflate();
        if (b != null && b.length > 0) {
            outLen = b.length;
            ARFileHandler.writeBytesIntoFile(b, ofile);
        }
        return outLen;
    }

    public void end() {
        this.decompressor.end();
    }
}

