/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.internal;

import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentField;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.COMMethodInfo;
import com.bmc.arsys.api.COMMethodParmInfo;
import com.bmc.arsys.api.COMValueInfo;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.ChangeFieldAction;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CloseWindowAction;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CommitChangesAction;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyField;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DataDictionaryMenu;
import com.bmc.arsys.api.DateOnlyField;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.DecimalField;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryField;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DirectSqlAction;
import com.bmc.arsys.api.DisplayField;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.DisplayPropertyMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationInterval;
import com.bmc.arsys.api.EscalationTime;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExitGuideAction;
import com.bmc.arsys.api.ExternalReference;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterMessageAction;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormDataDictionaryMenu;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.GotoAction;
import com.bmc.arsys.api.GotoGuideLabelAction;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IntegerField;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.JoinFieldMapping;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LogAction;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.NotifyAction;
import com.bmc.arsys.api.ObjectPrinter;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OleAutomationAction;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.OverlaidInfo;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.PushFieldsAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.QuerySourceForm;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RecursiveQuery;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RunMacroAction;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.TimeOnlyField;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewField;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.api.ViewFieldMapping;
import com.bmc.arsys.api.WaitAction;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ApiRecorder
extends ObjectPrinter {
    private static Logger log = Logger.getLogger(ApiRecorder.class);
    private PrintWriter cmdOut = null;
    private PrintWriter resOut = null;
    private String curApiName = null;
    private String prevApiName = null;
    private long start;
    private long finish;
    private int apiRecordingMode = 0;
    private List<IQuerySource> currQuerySources = null;
    private int currIdx;
    private List<IQuerySource> currJoinableSources;
    private boolean doNotRecordType = false;
    private int currFieldDataType = 0;
    private static final int LOGGING_OFF = 0;
    private static final int LOGGING_APPEND_FILE = 2;
    private static final int LOGGING_START_FINISH_TIME = 4;
    private static final int LOGGING_ELAPSED_TIME = 8;
    private static final int LOGGING_COMBO_FILE = 16;
    private static final int LOGGING_NO_RESULT_DATA = 32;
    private static final int LOGGING_USE_BUFFERING = 64;
    private static final String DEF_CMDFILE = "_arapicmd.log";
    private static final String DEF_RESFILE = "_arapires.log";
    private String curCmdName = null;
    private static final String CMD_CREATE_CONTAINER = "cco";
    private static final String CMD_SET_CONTAINER = "sco";
    private static final String CMD_CREATE_FORM = "cs";
    private static final String CMD_SET_FORM = "ss";
    private static final String CMD_CREATE_MENU = "cc";
    private static final String CMD_SET_MENU = "sc";
    private static final String CMD_CREATE_FIELD = "csf";
    private static final String CMD_SET_FIELD = "ssf";
    private static final String CMD_SET_MULTIPLE_FIELDS = "smsf";
    private static final String CMD_CREATE_MULTIPLE_FIELDS = "cmsf";
    private static final String CMD_CREATE_ACTIVE_LINK = "cal";
    private static final String CMD_SET_ACTIVE_LINK = "sal";
    private static final String CMD_CREATE_FILTER = "cf";
    private static final String CMD_SET_FILTER = "sf";
    private static final String CMD_CREATE_ESCALATION = "ces";
    private static final String CMD_SET_ESCALATION = "ses";
    private static final String CMD_CREATE_VIEW = "cv";
    private static final String CMD_SET_VIEW = "sv";
    private static final Object CMD_CREATE_IMAGE = "ci";
    private static final Object CMD_SET_IMAGE = "si";
    private static final Object CMD_CREATE_OVERLAY_FROM_OBJECT = "cofo";

    public ApiRecorder(int mode, String prefix) {
        this.setApiRecording(mode, prefix);
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.clearApiRecording();
    }

    public List<String> setApiRecording(int mode, String prefix) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (mode > 0) {
            this.apiRecordingMode = mode;
            String cmdFile = prefix + DEF_CMDFILE;
            String resFile = prefix + DEF_RESFILE;
            log.info("ApiRecorder, mode=" + this.apiRecordingMode + ", cmdFile=" + cmdFile + ", resFile=" + resFile);
            boolean autoFlush = (this.apiRecordingMode & 0x40) == 0;
            boolean append = (this.apiRecordingMode & 2) != 0;
            try {
                File saveFile;
                File file = new File(resFile);
                if (file.exists() && !append) {
                    saveFile = new File(resFile + ".save");
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                    file.renameTo(new File(resFile + ".save"));
                }
                if ((file = new File(cmdFile)).exists() && !append) {
                    saveFile = new File(cmdFile + ".save");
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                    file.renameTo(new File(cmdFile + ".save"));
                }
                this.resOut = new PrintWriter(new FileOutputStream(resFile, append), autoFlush);
                this.cmdOut = (this.apiRecordingMode & 0x10) != 0 ? this.resOut : new PrintWriter(new FileOutputStream(cmdFile, append), autoFlush);
                fileList.add(cmdFile);
                fileList.add(resFile);
            }
            catch (FileNotFoundException e) {
                log.error("Could not create the output files.", e);
                this.clearApiRecording();
            }
        }
        return fileList;
    }

    public void clearApiRecording() {
        if (this.cmdOut != null && this.cmdOut != this.resOut) {
            this.cmdOut.close();
        }
        if (this.resOut != null) {
            this.resOut.close();
        }
        this.apiRecordingMode = 0;
    }

    public void recordCommand(String name, String command, Object ... objects) {
        if (this.apiRecordingMode > 0) {
            this.recordCommandHeader(name, command);
            this.curCmdName = command;
            for (Object x : objects) {
                this.recordArg(x);
            }
            this.start = System.currentTimeMillis();
            this.prevApiName = this.curApiName;
            this.curApiName = name;
        }
    }

    public void recordCommand(String name, String command, Container container, boolean removeInvalidRefs) {
        if (this.isRecordingOn()) {
            this.recordCommandHeader(name, command);
            this.curCmdName = command;
            if (CMD_CREATE_CONTAINER.equals(this.curCmdName)) {
                this.recordArgCreate(container, removeInvalidRefs);
            } else if (CMD_SET_CONTAINER.equals(this.curCmdName)) {
                this.recordArgSet(container, removeInvalidRefs);
            }
            this.start = System.currentTimeMillis();
            this.prevApiName = this.curApiName;
            this.curApiName = name;
        }
    }

    private void recordCommandHeader(String name, String command) {
        this.cmdOut.println("#");
        this.cmdOut.println("# " + name);
        this.cmdOut.println("#");
        this.cmdOut.println(command);
    }

    private void recordArg(Object obj) {
        if (obj == null) {
            this.recordArg("");
        } else if (obj instanceof String) {
            this.recordArg((String)obj);
        } else if (obj instanceof Integer) {
            this.recordArg(obj.toString());
        } else if (obj instanceof Long) {
            this.recordArg(obj.toString());
        } else if (obj instanceof byte[]) {
            this.recordArg(new String((byte[])obj));
        } else if (obj instanceof Object[]) {
            this.recordArg((Object[])obj);
        } else if (obj instanceof int[]) {
            this.recordArg((int[])obj);
        } else if (obj instanceof ObjectPropertyMap) {
            this.recordArg((ObjectPropertyMap)obj);
        } else if (obj instanceof Entry) {
            this.recordArg((Entry)obj);
        } else if (obj instanceof DisplayInstanceMap) {
            this.recordArg((DisplayInstanceMap)obj);
        } else if (obj instanceof DisplayPropertyMap) {
            this.recordArg((DisplayPropertyMap)obj);
        } else if (obj instanceof DiaryListValue) {
            this.recordArg((DiaryListValue)obj);
        } else if (obj instanceof ServerInfoMap) {
            this.recordArg((ServerInfoMap)obj);
        } else if (obj instanceof Map) {
            this.recordArg((Map)obj);
        } else if (obj instanceof List) {
            if (CMD_SET_MULTIPLE_FIELDS.equals(this.curCmdName) || CMD_CREATE_MULTIPLE_FIELDS.equals(this.curCmdName)) {
                this.recordArgSet((List)obj, false);
            } else {
                this.recordArg((List)obj);
            }
        } else if (obj instanceof StructItemInfo) {
            this.recordArg((StructItemInfo)obj);
        } else if (obj instanceof WorkflowLockInfo) {
            this.recordArg((WorkflowLockInfo)obj);
        } else if (obj instanceof QualifierInfo) {
            this.recordArg((QualifierInfo)obj);
        } else if (obj instanceof AssignInfo) {
            this.recordArg((AssignInfo)obj);
        } else if (obj instanceof LoggingInfo) {
            this.recordArg((LoggingInfo)obj);
        } else if (obj instanceof OutputInteger) {
            this.recordArg((OutputInteger)obj);
        } else if (obj instanceof RegularQuery) {
            this.recordArg((RegularQuery)obj);
        } else if (obj instanceof Value) {
            this.recordArg((Value)obj);
        } else if (obj instanceof IQuerySource) {
            this.recordArg((IQuerySource)obj);
        } else if (obj instanceof SortInfo) {
            this.recordArg((SortInfo)obj);
        } else if (obj instanceof CoordinateInfo) {
            this.recordArg((CoordinateInfo)obj);
        } else if (obj instanceof QueryFormField) {
            this.recordArg((QueryFormField)obj);
        } else if (obj instanceof Boolean) {
            this.recordArg((Boolean)obj);
        } else if (obj instanceof AssignFilterApiInfo) {
            this.recordArg((AssignFilterApiInfo)obj);
        } else if (obj instanceof AssignSQLInfo) {
            this.recordArg((AssignSQLInfo)obj);
        } else if (obj instanceof DDEAction) {
            this.recordArg((DDEAction)obj);
        } else if (obj instanceof FunctionAssignInfo) {
            this.recordArg((FunctionAssignInfo)obj);
        } else if (obj instanceof ArithOpAssignInfo) {
            this.recordArg((ArithOpAssignInfo)obj);
        } else if (obj instanceof AssignFieldInfo) {
            this.recordArg((AssignFieldInfo)obj);
        } else if (obj instanceof RelationalOperationInfo) {
            this.recordArg((RelationalOperationInfo)obj);
        } else if (obj instanceof ArithmeticOrRelationalOperand) {
            this.recordArg((ArithmeticOrRelationalOperand)obj);
        } else if (obj instanceof StatusHistoryValueIndicator) {
            this.recordArg((StatusHistoryValueIndicator)obj);
        } else if (obj instanceof CurrencyPartInfo) {
            this.recordArg((CurrencyPartInfo)obj);
        } else if (obj instanceof Timestamp) {
            this.recordArg((Timestamp)obj);
        } else if (obj instanceof EscalationTimeCriteria) {
            this.recordArg((EscalationTimeCriteria)obj);
        } else if (obj instanceof LocalizedRequestInfo) {
            this.recordArg((LocalizedRequestInfo)obj);
        } else if (obj instanceof LocalizedValueCriteria) {
            this.recordArg((LocalizedValueCriteria)obj);
        } else if (obj instanceof SupportFile) {
            this.recordArg((SupportFile)obj);
        } else if (obj instanceof SupportFileKey) {
            this.recordArg((SupportFileKey)obj);
        } else if (obj instanceof Container) {
            this.recordArg((Container)obj);
        } else if (obj instanceof Form) {
            if (CMD_CREATE_FORM.equals(this.curCmdName)) {
                this.recordArgCreate((Form)obj);
            } else if (CMD_SET_FORM.equals(this.curCmdName)) {
                this.recordArgSet((Form)obj);
            } else {
                this.recordArg((Form)obj);
            }
        } else if (obj instanceof EntryListFieldInfo) {
            this.recordArg((EntryListFieldInfo)obj);
        } else if (obj instanceof IndexInfo) {
            this.recordArg((IndexInfo)obj);
        } else if (obj instanceof ArchiveInfo) {
            this.recordArg((ArchiveInfo)obj);
        } else if (obj instanceof AuditInfo) {
            this.recordArg((AuditInfo)obj);
        } else if (obj instanceof MenuItem) {
            this.recordArg((MenuItem)obj);
        } else if (obj instanceof FieldMapping) {
            this.recordArg((FieldMapping)obj);
        } else if (obj instanceof EnumItem) {
            this.recordArg((EnumItem)obj);
        } else if (obj instanceof FieldLimit) {
            this.recordArg((FieldLimit)obj);
        } else if (obj instanceof CurrencyDetail) {
            this.recordArg((CurrencyDetail)obj);
        } else if (obj instanceof FieldAssignInfo) {
            this.recordArg((FieldAssignInfo)obj);
        } else if (obj instanceof PushFieldsInfo) {
            this.recordArg((PushFieldsInfo)obj);
        } else if (obj instanceof COMMethodInfo) {
            this.recordArg((COMMethodInfo)obj);
        } else if (obj instanceof COMMethodParmInfo) {
            this.recordArg((COMMethodParmInfo)obj);
        } else if (obj instanceof COMValueInfo) {
            this.recordArg((COMValueInfo)obj);
        } else if (obj instanceof ActiveLinkAction) {
            this.recordArg((ActiveLinkAction)obj);
        } else if (obj instanceof FilterAction) {
            this.recordArg((FilterAction)obj);
        } else if (obj instanceof Menu) {
            if (CMD_CREATE_MENU.equals(this.curCmdName)) {
                this.recordArgCreate((Menu)obj);
            } else if (CMD_SET_MENU.equals(this.curCmdName)) {
                this.recordArgSet((Menu)obj);
            } else {
                this.recordArg((Menu)obj);
            }
        } else if (obj instanceof PermissionInfo) {
            this.recordArg((PermissionInfo)obj);
        } else if (obj instanceof ContainerOwner) {
            this.recordArg((ContainerOwner)obj);
        } else if (obj instanceof Reference) {
            this.recordArg((Reference)obj);
        } else if (obj instanceof Field) {
            if (CMD_CREATE_FIELD.equals(this.curCmdName)) {
                this.recordArgCreate((Field)obj);
            } else if (CMD_SET_FIELD.equals(this.curCmdName)) {
                ArrayList<Field> fields = new ArrayList<Field>();
                fields.add((Field)obj);
                this.recordArgSet(fields, true);
            } else {
                this.recordArg((Field)obj);
            }
        } else if (obj instanceof ActiveLink) {
            if (CMD_CREATE_ACTIVE_LINK.equals(this.curCmdName)) {
                this.recordArgCreate((ActiveLink)obj);
            } else if (CMD_SET_ACTIVE_LINK.equals(this.curCmdName)) {
                this.recordArgSet((ActiveLink)obj);
            } else {
                this.recordArg((ActiveLink)obj);
            }
        } else if (obj instanceof Filter) {
            if (CMD_CREATE_FILTER.equals(this.curCmdName)) {
                this.recordArgCreate((Filter)obj);
            } else if (CMD_SET_FILTER.equals(this.curCmdName)) {
                this.recordArgSet((Filter)obj);
            }
        } else if (obj instanceof Escalation) {
            if (CMD_CREATE_ESCALATION.equals(this.curCmdName)) {
                this.recordArgCreate((Escalation)obj);
            } else if (CMD_SET_ESCALATION.equals(this.curCmdName)) {
                this.recordArgSet((Escalation)obj);
            }
        } else if (obj instanceof View) {
            if (CMD_CREATE_VIEW.equals(this.curCmdName)) {
                this.recordArgCreate((View)obj);
            } else if (CMD_SET_VIEW.equals(this.curCmdName)) {
                this.recordArgSet((View)obj);
            }
        } else if (obj instanceof Image) {
            if (CMD_CREATE_IMAGE.equals(this.curCmdName)) {
                this.recordArgCreate((Image)obj);
            } else if (CMD_SET_IMAGE.equals(this.curCmdName)) {
                this.recordArgSet((Image)obj);
            }
        } else if (obj instanceof ImageData) {
            this.recordArg((ImageData)obj);
        } else if (obj instanceof OverlaidInfo) {
            if (CMD_CREATE_OVERLAY_FROM_OBJECT.equals(this.curCmdName)) {
                this.recordArgCreate((OverlaidInfo)obj);
            } else {
                this.recordArg((OverlaidInfo)obj);
            }
        } else {
            this.recordArg(obj.toString());
        }
    }

    private void recordArg(String arg) {
        if (arg != null) {
            this.cmdOut.println(arg);
        } else {
            this.cmdOut.println("");
        }
    }

    private void recordArg(Object[] list) {
        if (list != null) {
            this.cmdOut.println(list.length);
            for (int i = 0; i < list.length; ++i) {
                this.cmdOut.println(list[i].toString());
            }
        } else {
            this.cmdOut.println(0);
        }
    }

    private void recordArg(int[] list) {
        if (list != null) {
            this.cmdOut.println(list.length);
            for (int i = 0; i < list.length; ++i) {
                this.cmdOut.println(list[i]);
            }
        } else {
            this.cmdOut.println(0);
        }
    }

    private void recordArg(Map<Integer, Value> map) {
        if (map != null) {
            this.cmdOut.println(map.size());
            for (Integer key : map.keySet()) {
                this.cmdOut.println(key);
                if (map.get(key) != null) {
                    this.cmdOut.println(map.get(key).toString());
                    continue;
                }
                this.cmdOut.println("null");
            }
        } else {
            this.cmdOut.println(0);
        }
    }

    private <T> void recordArg(List<T> list) {
        if (list != null) {
            T t1;
            if (list.size() > 0 && (t1 = list.get(0)) instanceof StructItemInfo) {
                StructItemInfo item = (StructItemInfo)t1;
                this.cmdOut.println((item.getType() & 0x40000000) == 0 ? 1 : 2);
            }
            this.cmdOut.println(list.size());
            for (T t : list) {
                ++this.currIdx;
                this.recordArg(t);
            }
        } else {
            this.cmdOut.println(0);
        }
    }

    private void recordArg(StructItemInfo item) {
        this.recordArg(item.getType() & 0xFF);
        this.recordArg(item.getName());
        if (item.getSelectedElements() != null) {
            this.recordArg(item.getSelectedElements());
        }
    }

    private void recordArg(WorkflowLockInfo lockInfo) {
        int lockType = lockInfo.getLockType();
        this.recordArg(lockType);
        if (lockType > 0) {
            this.recordArg(lockInfo.getLockKey());
        }
    }

    private void recordArg(SupportFile supportFile) {
        this.recordArg(supportFile.getKey());
        this.recordArg(supportFile.getFilePath());
    }

    private void recordArg(SupportFileKey supportFileKey) {
        this.recordArg(supportFileKey.getFileType());
        this.recordArg(supportFileKey.getName());
        this.recordArg(supportFileKey.getFieldId());
        this.recordArg(supportFileKey.getFileId());
    }

    private void recordArg(LocalizedValueCriteria criteria) {
        boolean isValueSet = (1 & criteria.getPropertiesToRetrieve()) > 0;
        this.recordArg(isValueSet);
        boolean isTimeStampSet = (2 & criteria.getPropertiesToRetrieve()) > 0;
        this.recordArg(isTimeStampSet);
    }

    private void recordArg(LocalizedRequestInfo localizedRqInfo) {
        int messageType = localizedRqInfo.getMessageType();
        this.recordArg(messageType);
        this.recordArg(localizedRqInfo.getName());
        switch (messageType) {
            case 5: 
            case 8: {
                this.recordArg(localizedRqInfo.getInternalID());
                break;
            }
            case 1: 
            case 2: {
                this.recordArg(localizedRqInfo.getIfElse());
                this.recordArg(localizedRqInfo.getAction());
                break;
            }
        }
    }

    private void recordArg(ServerInfoMap serverInfoMap) {
        this.recordArg(serverInfoMap.size());
        for (Map.Entry entry : serverInfoMap.entrySet()) {
            this.recordArg(entry.getKey());
            this.recordArg((Value)entry.getValue());
        }
    }

    private void recordArgCreate(View view) {
        this.curCmdName = null;
        this.recordArg(view.getFormName());
        this.recordArg(view.getVUIId());
        this.recordArg(view.getName());
        this.recordArg(view.getLocale());
        this.recordArg(view.getVUIType());
        this.recordArg(view.getDisplayProperties());
        this.recordArg(view.getHelpText());
        this.recordArg(view.getOwner());
        this.recordArg(view.getDiary());
    }

    private void recordArgSet(View view) {
        this.curCmdName = null;
        this.recordArg(view.getFormName());
        this.recordArg(view.getVUIId());
        this.recordArgConditionally(view.getNewName());
        this.recordArgConditionally(view.getLocale());
        this.recordArgConditionally(view.getVUIType());
        this.recordArgConditionally(view.getDisplayProperties());
        this.recordArgConditionally(view.getHelpText());
        this.recordArgConditionally(view.getOwner());
        this.recordArgConditionally(view.getDiary());
    }

    private void recordArgCreate(Escalation escalation) {
        this.curCmdName = null;
        this.recordArg(escalation.getName());
        this.recordArg(escalation.getEscalationTm());
        this.recordArg(escalation.getFormList());
        this.recordArg(escalation.getQualifier());
        this.recordArg(escalation.getActionList());
        this.recordArg(escalation.getElseList());
        this.recordArg(escalation.getHelpText());
        this.recordArg(escalation.getOwner());
        this.recordArg(escalation.getDiary());
        this.recordArg(escalation.getProperties());
    }

    private void recordArgSet(Escalation escalation) {
        this.curCmdName = null;
        this.recordArg(escalation.getName());
        this.recordArgConditionally(escalation.getNewName());
        this.recordArgConditionally(escalation.getEscalationTm());
        this.recordArgConditionally(escalation.getFormList());
        this.recordArgConditionally(escalation.isEnable());
        this.recordArgConditionally(escalation.getQualifier());
        this.recordArgConditionally(escalation.getActionList());
        this.recordArgConditionally(escalation.getElseList());
        this.recordArgConditionally(escalation.getHelpText());
        this.recordArgConditionally(escalation.getOwner());
        this.recordArgConditionally(escalation.getDiary());
        this.recordArgConditionally(escalation.getProperties());
    }

    private void recordArg(EscalationTimeCriteria escTmCriteria) {
        if (escTmCriteria instanceof EscalationInterval) {
            this.recordArg(1);
            this.recordArg(((EscalationInterval)escTmCriteria).getValue());
        } else if (escTmCriteria instanceof EscalationTime) {
            this.recordArg(2);
            EscalationTime time = (EscalationTime)escTmCriteria;
            this.recordArg(time.getMonthDayMask());
            this.recordArg(time.getHourMask());
            this.recordArg(time.getMinute());
            this.recordArg(time.getWeekDayMask());
        } else if (escTmCriteria == null) {
            this.recordArg(1);
            this.recordArg("");
        }
    }

    private void recordArgCreate(Filter filter) {
        this.curCmdName = null;
        this.recordArg(filter.getName());
        this.recordArg(filter.getOrder());
        this.recordArg(filter.getFormList());
        this.recordArg(filter.getOpSet());
        this.recordArg(filter.isEnable());
        this.recordArg(filter.getQualifier());
        this.recordArg(filter.getActionList());
        this.recordArg(filter.getElseList());
        this.recordArg(filter.getHelpText());
        this.recordArg(filter.getOwner());
        this.recordArg(filter.getDiary());
        this.recordArg(filter.getProperties());
        this.recordArg(filter.getErrorFilterOptions());
        this.recordArg(filter.getErrorHandlingFilter());
    }

    private void recordArgSet(Filter filter) {
        this.curCmdName = null;
        this.recordArg(filter.getName());
        this.recordArgConditionally(filter.getNewName());
        this.recordArgConditionally(filter.getOrder());
        this.recordArgConditionally(filter.getFormList());
        this.recordArgConditionally(filter.getOpSet());
        this.recordArgConditionally(filter.isEnable());
        this.recordArgConditionally(filter.getQualifier());
        this.recordArgConditionally(filter.getActionList());
        this.recordArgConditionally(filter.getElseList());
        this.recordArgConditionally(filter.getHelpText());
        this.recordArgConditionally(filter.getOwner());
        this.recordArgConditionally(filter.getDiary());
        this.recordArgConditionally(filter.getProperties());
        this.recordArgConditionally(filter.getErrorFilterOptions());
        this.recordArgConditionally(filter.getErrorHandlingFilter());
    }

    private void recordArg(FilterAction filterAction) {
        Action action = (Action)((Object)filterAction);
        this.recordArg(Action.getActionType(action, false));
        if (action instanceof NotifyAction) {
            this.recordArg((NotifyAction)action);
        } else if (action instanceof FilterMessageAction) {
            this.recordArg((FilterMessageAction)action);
        } else if (action instanceof LogAction) {
            this.recordArg(((LogAction)action).getFilePath());
        } else if (action instanceof SetFieldsAction) {
            this.recordArg((SetFieldsAction)action);
        } else if (action instanceof RunProcessAction) {
            this.recordArg(((RunProcessAction)action).getCommandLine());
        } else if (action instanceof PushFieldsAction) {
            this.recordArg((PushFieldsAction)action);
        } else if (action instanceof DirectSqlAction) {
            this.recordArg((DirectSqlAction)action);
        } else if (action instanceof GotoAction) {
            this.recordArg((GotoAction)action);
        } else if (action instanceof CallGuideAction) {
            this.recordArg((CallGuideAction)action);
        } else if (action instanceof ExitGuideAction) {
            this.recordArg((ExitGuideAction)action);
        } else if (action instanceof GotoGuideLabelAction) {
            this.recordArg((GotoGuideLabelAction)action);
        }
    }

    private void recordArg(FilterMessageAction fmAction) {
        this.recordArg(fmAction.getMessageType());
        this.recordArg(fmAction.getMessageNum());
        this.recordArg(fmAction.getMessageText());
    }

    private void recordArg(NotifyAction nAction) {
        int notifyMechanism = nAction.getNotifyMechanism();
        this.recordArg(notifyMechanism);
        if (notifyMechanism == 99) {
            this.recordArg(nAction.getNotifyMechanismXRef());
        }
        this.recordArg(nAction.getUser());
        this.recordArg(nAction.getNotifyText());
        this.recordArg(nAction.getNotifyPriority());
        this.recordArg(nAction.getSubjectText());
        int fieldIdListType = nAction.getFieldIdListType();
        this.recordArg(fieldIdListType);
        if (fieldIdListType == 2) {
            this.recordArg(nAction.getFieldIdList());
        }
    }

    private void recordArgCreate(ActiveLink activeLink) {
        this.curCmdName = null;
        this.recordArg(activeLink.getName());
        this.recordArg(activeLink.getOrder());
        List<String> formList = activeLink.getFormList();
        if (formList != null) {
            this.recordArg(1);
            this.recordArg(formList);
        } else {
            this.recordArg(0);
        }
        this.recordArg(activeLink.getGroupList());
        this.recordArg(activeLink.getExecuteMask());
        this.recordArg(activeLink.getControlField());
        this.recordArg(activeLink.getFocusField());
        this.recordArg(activeLink.getQualifier());
        this.recordArg(activeLink.getActionList());
        this.recordArg(activeLink.getElseList());
        this.recordArg(activeLink.getHelpText());
        this.recordArg(activeLink.getOwner());
        this.recordArg(activeLink.getDiary());
        this.recordArg(activeLink.getProperties());
        this.recordArg(activeLink.getErrorActlinkOptions());
        this.recordArg(activeLink.getErrorActlinkName());
    }

    private void recordArgSet(ActiveLink activeLink) {
        this.curCmdName = null;
        this.recordArg(activeLink.getName());
        this.recordArgConditionally(activeLink.getNewName());
        this.recordArgConditionally(activeLink.getOrder());
        this.recordArgConditionally(activeLink.getFormList());
        this.recordArgConditionally(activeLink.getGroupList());
        this.recordArgConditionally(activeLink.getExecuteMask());
        this.recordArgConditionally(activeLink.getControlField());
        this.recordArgConditionally(activeLink.getFocusField());
        this.recordArgConditionally(activeLink.isEnable());
        this.recordArgConditionally(activeLink.getQualifier());
        this.recordArgConditionally(activeLink.getActionList());
        this.recordArgConditionally(activeLink.getElseList());
        this.recordArgConditionally(activeLink.getHelpText());
        this.recordArgConditionally(activeLink.getOwner());
        this.recordArgConditionally(activeLink.getDiary());
        this.recordArgConditionally(activeLink.getProperties());
        this.recordArg(activeLink.getErrorActlinkOptions());
        this.recordArg(activeLink.getErrorActlinkName());
    }

    private void recordArg(ActiveLinkAction activeLinkAction) {
        Action action = (Action)((Object)activeLinkAction);
        this.recordArg(Action.getActionType(action, true));
        if (action instanceof RunMacroAction) {
            RunMacroAction rAction = (RunMacroAction)action;
            this.recordArg(rAction.getMacroName());
            this.recordArg(rAction.getMacroText());
            this.recordArg(rAction.getMacroParms());
        } else if (action instanceof SetFieldsAction) {
            this.recordArg((SetFieldsAction)action);
        } else if (action instanceof RunProcessAction) {
            RunProcessAction runAction = (RunProcessAction)action;
            this.recordArg(runAction.getCommandLine());
        } else if (action instanceof MessageAction) {
            this.recordArg((MessageAction)action);
        } else if (action instanceof ChangeFieldAction) {
            ChangeFieldAction cFieldAction = (ChangeFieldAction)action;
            this.recordArg(cFieldAction.getOption());
            this.recordArg(cFieldAction.getFieldId());
            this.recordArgConditionally(cFieldAction.getCharMenu());
            this.recordArgConditionally(cFieldAction.getProps());
            if (cFieldAction.getFocus() == 1) {
                this.recordArg("T");
            } else {
                this.recordArg("F");
            }
            this.recordArg(cFieldAction.getAccessOption());
        } else if (action instanceof DDEAction) {
            this.recordArg((DDEAction)action);
        } else if (action instanceof PushFieldsAction) {
            this.recordArg((PushFieldsAction)action);
        } else if (action instanceof DirectSqlAction) {
            this.recordArg((DirectSqlAction)action);
        } else if (action instanceof OleAutomationAction) {
            OleAutomationAction oAction = (OleAutomationAction)action;
            this.recordArg(oAction.getAutoServerName());
            this.recordArg(oAction.isVisible());
            this.recordArg(oAction.getClsId());
            this.recordArg(oAction.getAction());
            this.recordArg(oAction.getMethodList());
        } else if (action instanceof OpenWindowAction) {
            this.recordArg((OpenWindowAction)action);
        } else if (action instanceof CommitChangesAction) {
            CommitChangesAction cAction = (CommitChangesAction)action;
            this.recordArg(cAction.getFormName());
        } else if (action instanceof CloseWindowAction) {
            CloseWindowAction cAction = (CloseWindowAction)action;
            this.recordArg(cAction.isCloseAll());
        } else if (action instanceof CallGuideAction) {
            this.recordArg((CallGuideAction)action);
        } else if (action instanceof ExitGuideAction) {
            this.recordArg((ExitGuideAction)action);
        } else if (action instanceof GotoGuideLabelAction) {
            this.recordArg((GotoGuideLabelAction)action);
        } else if (action instanceof WaitAction) {
            this.recordArg((WaitAction)action);
        } else if (action instanceof GotoAction) {
            this.recordArg((GotoAction)action);
        }
    }

    private void recordArg(GotoAction gAction) {
        this.recordArg(gAction.getTag());
        this.recordArg(gAction.getFieldIdOrValue());
    }

    private void recordArg(WaitAction wAction) {
        this.recordArg(wAction.getContinueButtonTitle());
    }

    private void recordArg(GotoGuideLabelAction gtAction) {
        this.recordArg(gtAction.getLabel());
    }

    private void recordArg(ExitGuideAction egAction) {
        this.recordArg(egAction.isCloseAll());
    }

    private void recordArg(CallGuideAction cgAction) {
        this.recordArg(cgAction.getServerName());
        this.recordArg(cgAction.getGuideName());
        this.recordArg(cgAction.getGuideMode());
        this.recordArg(cgAction.getGuideTableId());
        this.recordArg(cgAction.getInputValueFieldPairs());
        this.recordArg(cgAction.getOutputValueFieldPairs());
        this.recordArg(cgAction.getSampleServer());
        this.recordArg(cgAction.getSampleGuide());
    }

    private void recordArg(OpenWindowAction opwdAction) {
        this.recordArg(opwdAction.getServerName());
        this.recordArg(opwdAction.getFormName());
        this.recordArg(opwdAction.getVuiLabel());
        this.recordArg(opwdAction.isCloseBox());
        this.recordArg(opwdAction.getInputValueFieldPairs());
        this.recordArg(opwdAction.getOutputValueFieldPairs());
        this.recordArg(opwdAction.getWindowMode());
        this.recordArg(opwdAction.getTargetLocation());
        this.recordArg(opwdAction.getQuery());
        this.recordArg(opwdAction.isNoMatchContinue());
        this.recordArg(opwdAction.isSuppressEmptyLst());
        this.recordArg(opwdAction.getMsg());
        this.recordArg(opwdAction.getPollinginterval());
        this.recordArg(opwdAction.getSortOrderList());
    }

    private void recordArg(COMMethodInfo comMethodInfo) {
        this.recordArg(comMethodInfo.getMethodName());
        this.recordArg(comMethodInfo.getMethodIId());
        this.recordArg(comMethodInfo.getMethodType());
        this.recordArg(comMethodInfo.getMethodValue());
        this.recordArg(comMethodInfo.getParameterList());
    }

    private void recordArg(COMMethodParmInfo parmInfo) {
        this.recordArg(parmInfo.getParmName());
        this.recordArg(parmInfo.getParmType());
        this.recordArg(parmInfo.getParmValue());
    }

    private void recordArg(COMValueInfo comValueInfo) {
        if (comValueInfo != null) {
            this.recordArg(comValueInfo.getTransId());
            this.recordArg(comValueInfo.getValueIId());
            int valueType = comValueInfo.getValueType();
            this.recordArg(valueType);
            switch (valueType) {
                case 1: {
                    this.recordArg(comValueInfo.getFieldId());
                    break;
                }
                case 2: {
                    this.recordArg(comValueInfo.getValue());
                    break;
                }
            }
        } else {
            this.recordArg(1);
            this.recordArg("");
            this.recordArg(0);
        }
    }

    private void recordArg(DirectSqlAction sAction) {
        this.recordArg(sAction.getServer());
        this.recordArg(sAction.getCommand());
    }

    private void recordArg(PushFieldsAction pAction) {
        this.recordArg(pAction.getSampleForm());
        this.recordArg(pAction.getSampleServer());
        this.recordArg(pAction.getPushFieldsList());
    }

    private void recordArg(PushFieldsInfo pFieldInfo) {
        this.recordArg(pFieldInfo.getField());
        this.recordArg(pFieldInfo.getAssignment());
    }

    private void recordArg(MessageAction mAction) {
        if (mAction != null) {
            this.recordArg(mAction.getMessageType());
            this.recordArg(mAction.getMessageNum());
            this.recordArg(mAction.getMessageText());
            this.recordArg(mAction.isUsePromptingPane());
        } else {
            this.recordArg(2);
            this.recordArg(10000);
            this.recordArg("");
            this.recordArg("T");
        }
    }

    private void recordArg(SetFieldsAction sFieldAction) {
        this.recordArg(sFieldAction.getSetFieldsList());
        this.recordArg(sFieldAction.getSampleServer());
        this.recordArg(sFieldAction.getSampleForm());
    }

    private void recordArg(FieldAssignInfo fieldAssignInfo) {
        this.recordArg(fieldAssignInfo.getFieldId());
        this.recordArg(fieldAssignInfo.getAssignment());
    }

    private void recordArgCreate(Field field) {
        this.curCmdName = null;
        this.recordArg(field.getForm());
        this.recordArg(field.getFieldID());
        this.recordArg(field.getName());
        this.recordArg(field);
        this.recordArg(field.getFieldOption());
        this.recordArg(field.getCreateMode());
        this.recordArg(field.getAuditOption());
        boolean x = this.doNotRecordType;
        this.doNotRecordType = true;
        this.recordArgConditionally(field.getDefaultValue());
        this.doNotRecordType = x;
        this.recordArg(field.getPermissions());
        int currBkp = this.currFieldDataType;
        this.currFieldDataType = field.getDataType();
        this.recordArgConditionally(field.getFieldLimit());
        this.currFieldDataType = currBkp;
        this.recordArg(field.getDisplayInstance());
        this.recordArg(field.getHelpText());
        this.recordArg(field.getOwner());
        this.recordArg(field.getDiary());
        this.recordArg(field.getFieldMap());
    }

    private void recordArgSet(Field field) {
        this.curCmdName = null;
        this.recordArg(field.getFieldID());
        this.recordArg(field);
        if (field != null && field.getNewName().length() != 0) {
            this.recordArgConditionally(field.getNewName());
        } else {
            this.recordArgConditionally(null);
        }
        this.recordArgConditionally(field.getFieldMap());
        this.recordArgConditionally(field.getFieldOption() != 0 ? Integer.valueOf(field.getFieldOption()) : null);
        this.recordArgConditionally(field.getCreateMode() != 0 ? Integer.valueOf(field.getCreateMode()) : null);
        this.recordArgConditionally(field.getAuditOption() != 0 ? Integer.valueOf(field.getAuditOption()) : null);
        boolean x = this.doNotRecordType;
        this.doNotRecordType = true;
        this.recordArgConditionally(field.getDefaultValue());
        this.doNotRecordType = x;
        if (field != null && field.getPermissions() != null && !field.getPermissions().isEmpty()) {
            this.recordArgConditionally(field.getPermissions());
        } else {
            this.recordArgConditionally(null);
        }
        int currBkp = this.currFieldDataType;
        this.currFieldDataType = field.getDataType();
        this.recordArgConditionally(field.getFieldLimit());
        this.currFieldDataType = currBkp;
        this.recordArgConditionally(field.getDisplayInstance());
        if (field != null && field.SetFieldOptionsSet()) {
            this.recordArgConditionally(field.getSetFieldOptions());
        } else {
            this.recordArgConditionally(null);
        }
        if (field != null && field.getHelpText().length() != 0) {
            this.recordArgConditionally(field.getHelpText());
        } else {
            this.recordArgConditionally(null);
        }
        if (field != null && field.getOwner().length() != 0) {
            this.recordArgConditionally(field.getOwner());
        } else {
            this.recordArgConditionally(null);
        }
        if (field != null && field.getDiary() != null && !field.getDiary().isEmpty()) {
            this.recordArgConditionally(field.getDiary());
        } else {
            this.recordArgConditionally(null);
        }
        if (field != null && field.getObjectProperty() != null && !field.getObjectProperty().isEmpty()) {
            this.recordArgConditionally(field.getObjectProperty());
        } else {
            this.recordArgConditionally(null);
        }
    }

    private void recordArgSet(List<Field> fields, boolean isSSF) {
        this.curCmdName = null;
        int size = fields.size();
        if (fields != null && size > 0) {
            if (!isSSF) {
                this.recordArg(size);
            }
            this.recordArg(fields.get(0).getForm());
            for (Field field : fields) {
                this.recordArgSet(field);
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(DisplayInstanceMap displayInstanceMap) {
        if (displayInstanceMap != null) {
            this.recordArg(displayInstanceMap.size());
            for (Map.Entry entry : displayInstanceMap.entrySet()) {
                this.recordArg(entry.getKey());
                this.recordArg((DisplayPropertyMap)entry.getValue());
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(DisplayPropertyMap displayPropertyMap) {
        if (displayPropertyMap != null) {
            this.recordArg(displayPropertyMap.size());
            for (Map.Entry entry : displayPropertyMap.entrySet()) {
                this.recordArg(entry.getKey());
                this.recordArg((Value)entry.getValue());
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(EnumItem enumItem) {
        this.recordArg(enumItem.getEnumItemName());
        this.recordArg(enumItem.getEnumItemNumber());
    }

    private void recordArg(FieldLimit fieldLimit) {
        block0 : switch (this.currFieldDataType) {
            case 2: {
                IntegerFieldLimit iFieldLimit = (IntegerFieldLimit)fieldLimit;
                this.recordArg(iFieldLimit.getLowRange());
                this.recordArg(iFieldLimit.getHighRange());
                break;
            }
            case 3: {
                RealFieldLimit rFieldLimit = (RealFieldLimit)fieldLimit;
                this.recordArg(rFieldLimit.getLowRange());
                this.recordArg(rFieldLimit.getHighRange());
                this.recordArg(rFieldLimit.getPrecision());
                break;
            }
            case 4: {
                CharacterFieldLimit cFieldLimit = (CharacterFieldLimit)fieldLimit;
                this.recordArg(cFieldLimit.getLengthUnits());
                this.recordArg(cFieldLimit.getStorageOptionForCLOB());
                this.recordArg(cFieldLimit.getMaxLength());
                this.recordArg(cFieldLimit.getMenuStyle());
                this.recordArg(cFieldLimit.getQBEMatch());
                this.recordArg(cFieldLimit.getCharMenu());
                this.recordArg(cFieldLimit.getPattern());
                this.recordArg(cFieldLimit.getFullTextOption());
                break;
            }
            case 5: {
                DiaryFieldLimit dFieldLimit = (DiaryFieldLimit)fieldLimit;
                this.recordArg(dFieldLimit.getFullTextOption());
                break;
            }
            case 7: {
                break;
            }
            case 6: 
            case 8: {
                SelectionFieldLimit sFieldLimit = (SelectionFieldLimit)fieldLimit;
                int listStyle = sFieldLimit.getListStyle();
                this.recordArg(listStyle);
                switch (listStyle) {
                    case 1: {
                        List<EnumItem> enumItemList = sFieldLimit.getValues();
                        EnumItem[] enumArray = new EnumItem[enumItemList.size()];
                        sFieldLimit.getValues().toArray(enumArray);
                        Object[] enumStringArray = new String[enumArray.length];
                        for (int i = 0; i < enumArray.length; ++i) {
                            EnumItem item = enumArray[i];
                            enumStringArray[i] = item.getEnumItemName();
                        }
                        this.recordArg(enumStringArray);
                        break block0;
                    }
                    case 2: {
                        this.recordArg(sFieldLimit.getValues());
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                AttachmentFieldLimit aFieldLimit = (AttachmentFieldLimit)fieldLimit;
                this.recordArg(aFieldLimit.getMaxSize());
                this.recordArg(aFieldLimit.getFullTextOption());
                break;
            }
            case 10: {
                DecimalFieldLimit dcFieldLimit = (DecimalFieldLimit)fieldLimit;
                this.recordArg(dcFieldLimit.getLowRange());
                this.recordArg(dcFieldLimit.getHighRange());
                this.recordArg(dcFieldLimit.getPrecision());
                break;
            }
            case 12: {
                CurrencyFieldLimit cuFieldLimit = (CurrencyFieldLimit)fieldLimit;
                this.recordArg(cuFieldLimit.getLowRange());
                this.recordArg(cuFieldLimit.getHighRange());
                this.recordArg(cuFieldLimit.getPrecision());
                this.recordArg(cuFieldLimit.getFunctional());
                this.recordArg(cuFieldLimit.getAllowable());
                break;
            }
            case 33: {
                TableFieldLimit tFieldLimit = (TableFieldLimit)fieldLimit;
                this.recordArg(tFieldLimit.getForm());
                this.recordArg(tFieldLimit.getServer());
                this.recordArg(tFieldLimit.getQualifier());
                this.recordArg(tFieldLimit.getQualifier());
                this.recordArg(tFieldLimit.getSampleForm());
                this.recordArg(tFieldLimit.getSampleServer());
                break;
            }
            case 34: {
                ColumnFieldLimit colFieldLimit = (ColumnFieldLimit)fieldLimit;
                this.recordArg(colFieldLimit.getParent());
                this.recordArg(colFieldLimit.getDataField());
                this.recordArg(colFieldLimit.getDataSource());
                this.recordArg(colFieldLimit.getColumnLength());
                break;
            }
            case 42: {
                ViewFieldLimit vFieldLimit = (ViewFieldLimit)fieldLimit;
                this.recordArg(vFieldLimit.getMaxLength());
                break;
            }
            case 43: {
                DisplayFieldLimit dsFieldLimit = (DisplayFieldLimit)fieldLimit;
                this.recordArg(dsFieldLimit.getLengthUnits());
                this.recordArg(dsFieldLimit.getMaxLength());
                break;
            }
        }
    }

    private void recordArg(CurrencyDetail currencyDetail) {
        this.recordArg(currencyDetail.getCurrencyCode());
        this.recordArg(currencyDetail.getPrecision());
    }

    private void recordArg(FieldMapping fieldMapping) {
        if (fieldMapping != null) {
            int type = fieldMapping.getMappingType();
            this.recordArg(type);
            switch (type) {
                case 2: {
                    JoinFieldMapping jMapping = (JoinFieldMapping)fieldMapping;
                    this.recordArg(jMapping.getIndex());
                    this.recordArg(jMapping.getFieldID());
                    break;
                }
                case 3: {
                    this.recordArg(((ViewFieldMapping)fieldMapping).getFieldName());
                    break;
                }
                case 4: {
                    this.recordArg(((VendorFieldMapping)fieldMapping).getFieldName());
                }
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(Field field) {
        int type = 4;
        if (field instanceof IntegerField) {
            type = 2;
        } else if (field instanceof RealField) {
            type = 3;
        } else if (field instanceof DiaryField) {
            type = 5;
        } else if (field instanceof SelectionField) {
            type = 6;
        } else if (field instanceof DateTimeField) {
            type = 7;
        } else if (field instanceof DecimalField) {
            type = 10;
        } else if (field instanceof AttachmentField) {
            type = 11;
        } else if (field instanceof CurrencyField) {
            type = 12;
        } else if (field instanceof DateOnlyField) {
            type = 13;
        } else if (field instanceof TimeOnlyField) {
            type = 14;
        } else if (field instanceof TableField) {
            type = 33;
        } else if (field instanceof ColumnField) {
            type = 34;
        } else if (field instanceof ViewField) {
            type = 42;
        } else if (field instanceof DisplayField) {
            type = 43;
        }
        this.recordArg(type);
    }

    private void recordArgCreate(Menu menu) {
        this.curCmdName = null;
        this.recordArg(menu);
        this.recordArg(menu.getName());
        this.recordArg(menu.getRefreshCode());
        this.recordArg(menu.getHelpText());
        this.recordArg(menu.getOwner());
        this.recordArg(menu.getDiary());
        this.recordArg(menu.getProperties());
    }

    private void recordArgSet(Menu menu) {
        this.curCmdName = null;
        this.recordArg(menu);
        this.recordArg(menu.getName());
        this.recordArgConditionally(menu.getNewName());
        this.recordArgConditionally(menu.getRefreshCode());
        this.recordArgConditionally(menu.getHelpText());
        this.recordArgConditionally(menu.getOwner());
        this.recordArgConditionally(menu.getDiary());
        this.recordArgConditionally(menu.getProperties());
    }

    private void recordArg(Menu menu) {
        int menuType = menu.getMenuType();
        this.recordArg(menuType);
        switch (menuType) {
            case 1: {
                this.recordArg(menu.getContent());
                break;
            }
            case 2: {
                QueryMenu qMenu = (QueryMenu)menu;
                this.recordArg(qMenu.getForm());
                this.recordArg(qMenu.getServer());
                this.recordArg(qMenu.getQualification());
                this.recordArg(qMenu.getLabelField().get(0));
                this.recordArg(qMenu.getValueField());
                this.recordArg(qMenu.isSortOnLabel());
                this.recordArg(qMenu.getSampleForm());
                this.recordArg(qMenu.getSampleServer());
                break;
            }
            case 3: {
                FileMenu fileMenu = (FileMenu)menu;
                this.recordArg(fileMenu.getLocation());
                this.recordArg(fileMenu.getFileName());
                break;
            }
            case 4: {
                SqlMenu sqlMenu = (SqlMenu)menu;
                this.recordArg(sqlMenu.getServer());
                this.recordArg(sqlMenu.getSQLCommand());
                this.recordArg(sqlMenu.getLabelIndex().get(0));
                this.recordArg(sqlMenu.getValueIndex());
                break;
            }
            case 6: {
                DataDictionaryMenu ddMenu = (DataDictionaryMenu)menu;
                this.recordArg(ddMenu.getServer());
                this.recordArg(ddMenu.getNameType());
                this.recordArg(ddMenu.getValueFormat());
                if (ddMenu instanceof FormDataDictionaryMenu) {
                    this.recordArg(1);
                    FormDataDictionaryMenu fddMenu = (FormDataDictionaryMenu)ddMenu;
                    this.recordArg(fddMenu.getFormType());
                    this.recordArg(fddMenu.isIncludeHidden());
                    break;
                }
                if (!(ddMenu instanceof FieldDataDictionaryMenu)) break;
                this.recordArg(2);
                FieldDataDictionaryMenu fddMenu = (FieldDataDictionaryMenu)ddMenu;
                this.recordArg(fddMenu.getFieldType());
                this.recordArg(fddMenu.getForm());
                break;
            }
            case 5: {
                this.recordArg(menu.getName());
            }
        }
    }

    private void recordArg(MenuItem menuItem) {
        this.recordArg(menuItem.getLabel());
        List<MenuItem> subMenu = menuItem.getSubMenu();
        if (subMenu != null) {
            this.recordArg(2);
            this.recordArg(subMenu);
        } else {
            this.recordArg(1);
            this.recordArg(menuItem.getValue());
        }
    }

    private void recordArgCreate(Form form) {
        this.curCmdName = null;
        this.recordArg(form);
        this.recordArg(form.getName());
        this.recordArg(form.getPermissions());
        this.recordArg(form.getAdminGrpList());
        this.recordArg(form.getEntryListFieldInfo());
        this.recordArg(form.getSortInfo());
        this.recordArg(form.getIndexInfo());
        this.recordArgConditionally(form.getArchiveInfo());
        this.recordArgConditionally(form.getAuditInfo());
        this.recordArg(form.getDefaultVUI());
        this.recordArg(form.getHelpText());
        this.recordArg(form.getOwner());
        this.recordArg(form.getDiary());
        this.recordArg(form.getProperties());
    }

    private void recordArgSet(Form form) {
        this.curCmdName = null;
        this.recordArgConditionally(form);
        this.recordArg(form.getName());
        this.recordArgConditionally(form.getNewName());
        this.recordArgConditionally(form.getPermissions());
        this.recordArgConditionally(form.getAdminGrpList());
        this.recordArgConditionally(form.getEntryListFieldInfo());
        this.recordArgConditionally(form.getSortInfo());
        this.recordArgConditionally(form.getIndexInfo());
        this.recordArgConditionally(form.getArchiveInfo());
        this.recordArgConditionally(form.getAuditInfo());
        this.recordArgConditionally(form.getHelpText());
        this.recordArgConditionally(form.getOwner());
        this.recordArgConditionally(form.getDiary());
        this.recordArgConditionally(form.getProperties());
    }

    private void recordArg(AuditInfo auditInfo) {
        int style = auditInfo.getAuditStyle();
        this.recordArg(style);
        if (style == 1 || style == 2) {
            this.recordArg(auditInfo.getAuditForm());
        }
        this.recordArg(auditInfo.getQualifier());
    }

    private void recordArg(ArchiveInfo archiveInfo) {
        this.recordArg(archiveInfo.isEnable() ? 1 : 0);
        int type = archiveInfo.getArchiveType();
        this.recordArg(type);
        if (type == 1 || type == 3) {
            this.recordArg(archiveInfo.getArchiveDest());
        }
        this.recordArg(archiveInfo.getQualifier());
        EscalationTime escalationTime = archiveInfo.getArchiveTmInfo();
        this.recordArg(1);
        this.recordArg(escalationTime.getMonthDayMask());
        this.recordArg(1);
        this.recordArg(escalationTime.getWeekDayMask());
        this.recordArg(1);
        this.recordArg(escalationTime.getHourMask());
        this.recordArg(escalationTime.getMinute());
    }

    private void recordArg(IndexInfo indexInfo) {
        this.recordArg(indexInfo.getIndexFields());
        this.recordArg(indexInfo.isUnique());
        this.recordArg(indexInfo.getIndexName());
    }

    private void recordArg(EntryListFieldInfo entryListFieldInfo) {
        this.recordArg(entryListFieldInfo.getFieldId());
        this.recordArg(entryListFieldInfo.getColumnWidth());
        this.recordArg(entryListFieldInfo.getSeparator());
    }

    private void recordArg(Form form) {
        this.recordArg(form.getFormType());
    }

    private void recordArgSet(Container container, boolean removeInvalidRefs) {
        this.curCmdName = null;
        this.recordArg(container);
        this.recordArg(container.getName());
        this.recordArgConditionally(container.getNewName());
        this.recordArgConditionally(container.getPermissions());
        this.recordArgConditionally(container.getAdminGroupList());
        this.recordArgConditionally(container.getContainerOwner());
        this.recordArgConditionally(container.getLabel());
        this.recordArgConditionally(container.getDescription());
        List<Reference> refList = container.getReferences();
        this.recordArgConditionally(refList);
        if (refList != null) {
            this.recordArg(removeInvalidRefs);
        }
        this.recordArgConditionally(container.getHelpText());
        this.recordArgConditionally(container.getOwner());
        this.recordArgConditionally(container.getDiary());
        this.recordArgConditionally(container.getProperties());
    }

    private void recordArgCreate(Container container, boolean removeInvalidRefs) {
        this.curCmdName = null;
        this.recordArg(container);
        this.recordArg(container.getName());
        this.recordArg(container.getPermissions());
        this.recordArg(container.getAdminGroupList());
        this.recordArg(container.getContainerOwner());
        this.recordArg(container.getLabel());
        this.recordArg(container.getDescription());
        this.recordArg(container.getReferences());
        this.recordArg(removeInvalidRefs);
        this.recordArg(container.getHelpText());
        this.recordArg(container.getOwner());
        this.recordArg(container.getDiary());
        this.recordArg(container.getProperties());
    }

    private void recordArg(ObjectPropertyMap objPropMap) {
        if (objPropMap != null) {
            this.recordArg(objPropMap.size());
            for (Map.Entry entry : objPropMap.entrySet()) {
                this.recordArg(entry.getKey());
                this.recordArg((Value)entry.getValue());
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(DiaryListValue diaryListValue) {
        if (diaryListValue != null) {
            this.recordArg(diaryListValue.getAppendedText());
        } else {
            this.recordArg("");
        }
    }

    private void recordArg(Reference reference) {
        this.recordArg(reference.getLabel());
        this.recordArg(reference.getDescription());
        this.recordArg(reference.getReferenceType());
        if (reference instanceof ExternalReference) {
            this.recordArg("1");
            ExternalReference extRef = (ExternalReference)reference;
            this.recordArg(extRef.getAdminGroupList());
            this.recordArg(extRef.getValue());
        } else {
            this.recordArg("0");
            this.recordArg(reference.getName());
        }
    }

    private void recordArg(ReferenceType referenceType) {
        this.recordArg(referenceType.toInt());
    }

    private <T> void recordArgConditionally(T t) {
        if (t != null) {
            this.recordArg("T");
            this.recordArg(t);
        } else {
            this.recordArg("F");
        }
    }

    private void recordArg(ContainerOwner containerOwner) {
        int type = containerOwner.getType();
        this.recordArg(type);
        if (type != 0 && type != 1) {
            this.recordArg(containerOwner.getName());
        }
    }

    private void recordArg(PermissionInfo permInfo) {
        this.recordArg(permInfo.getGroupID());
        this.recordArg(permInfo.getPermissionValue());
    }

    private void recordArg(Container container) {
        this.recordArg(container.getType());
    }

    private void recordArg(Entry entry) {
        this.recordArg(entry.size());
        for (Map.Entry jEntry : entry.entrySet()) {
            this.recordArg(jEntry.getKey());
            this.recordArg((Value)jEntry.getValue());
        }
    }

    private void recordArg(RegularQuery regQuery) {
        if (regQuery != null) {
            this.currQuerySources = regQuery.getFromSources();
            this.recordArg(this.currQuerySources);
            this.recordArg(regQuery.getFromFields());
            this.recordArg(regQuery.getQualifier());
            this.recordArg(regQuery.getGroupBy());
            this.recordArg(regQuery.getHaving());
            this.currQuerySources = null;
            this.recordArg(regQuery.getSortBy());
        } else {
            List querySources = null;
            this.recordArg(querySources);
            List queryFromFields = null;
            this.recordArg(queryFromFields);
            QualifierInfo qual = null;
            this.recordArg(qual);
            List groupBy = null;
            this.recordArg(groupBy);
            QualifierInfo having = null;
            this.recordArg(having);
            List sortList = null;
            this.recordArg(sortList);
        }
    }

    private void recordArg(SortInfo sortInfo) {
        if (sortInfo != null) {
            this.recordArg(sortInfo.getFieldID());
            this.recordArg(sortInfo.getSortOrder());
            if (this.currQuerySources != null && this.currQuerySources.size() > 0) {
                this.recordArg(this.getIdx(this.currQuerySources, sortInfo.getSource()));
            }
        } else {
            this.recordArg(0);
            this.recordArg(1);
        }
    }

    private void recordArg(OutputInteger outputInt) {
        if (outputInt != null) {
            this.recordArg("T");
        } else {
            this.recordArg("F");
        }
    }

    private void recordArg(LoggingInfo loggingInfo) {
        boolean isEnabled = loggingInfo.isEnabled();
        this.recordArg(isEnabled);
        if (isEnabled) {
            this.recordArg(loggingInfo.getType());
            long whereToLog = loggingInfo.getWriteToFileOrStatus();
            this.recordArg(whereToLog);
            if ((int)(whereToLog & 1L) == 1) {
                this.recordArg(loggingInfo.getPath());
            }
        }
    }

    private void recordArg(Boolean boolValue) {
        if (boolValue.booleanValue()) {
            this.recordArg("T");
        } else {
            this.recordArg("F");
        }
    }

    private void recordArg(AssignInfo assignInfo) {
        if (assignInfo != null) {
            int type = assignInfo.getAssignType();
            this.recordArg(type);
            switch (type) {
                case 1: {
                    this.recordArg(assignInfo.getValue());
                    break;
                }
                case 2: {
                    this.recordArg(assignInfo.getField());
                    break;
                }
                case 3: {
                    this.recordArg(assignInfo.getProcess());
                    break;
                }
                case 4: {
                    this.recordArg(assignInfo.getArithOp());
                    break;
                }
                case 5: {
                    this.recordArg(assignInfo.getFunction());
                    break;
                }
                case 6: {
                    this.recordArg(assignInfo.getDde());
                    break;
                }
                case 7: {
                    this.recordArg(assignInfo.getSql());
                    break;
                }
                case 8: {
                    this.recordArg(assignInfo.getFilterApi());
                    break;
                }
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(AssignFilterApiInfo assignFilterApiInfo) {
        if (assignFilterApiInfo != null) {
            this.recordArg(assignFilterApiInfo.getService());
            this.recordArg(assignFilterApiInfo.getInputValues());
            this.recordArg(assignFilterApiInfo.getValueIndex());
        } else {
            this.recordArg("");
            this.recordArg(0);
            this.recordArg(1);
        }
    }

    private void recordArg(AssignSQLInfo assignSqlInfo) {
        if (assignSqlInfo != null) {
            this.recordArg(assignSqlInfo.getServer());
            this.recordArg(assignSqlInfo.getSqlCommand());
            this.recordArg(assignSqlInfo.getValueIndex());
            this.recordArg(assignSqlInfo.getNoMatchOption());
            this.recordArg(assignSqlInfo.getMultiMatchOption());
        } else {
            this.recordArg("");
            this.recordArg("");
            this.recordArg(1);
            this.recordArg(2);
            this.recordArg(2);
        }
    }

    private void recordArg(DDEAction ddeAction) {
        if (ddeAction != null) {
            String item;
            this.recordArg(ddeAction.getServiceName());
            this.recordArg(ddeAction.getTopic());
            int action = ddeAction.getAction();
            this.recordArg(action);
            this.recordArg(ddeAction.getPathToProgram());
            if (action != 3) {
                this.recordArg(ddeAction.getCommand());
            }
            if ((item = ddeAction.getItem()) != null) {
                this.recordArg("T");
                this.recordArg(item);
            } else {
                this.recordArg("F");
            }
        } else {
            this.recordArg("");
            this.recordArg("");
            this.recordArg(1);
            this.recordArg("");
            this.recordArg("F");
        }
    }

    private void recordArg(FunctionAssignInfo functionalAssignInfo) {
        if (functionalAssignInfo != null) {
            this.recordArg(functionalAssignInfo.getFunctionCode());
            this.recordArg(functionalAssignInfo.getParameterList());
        } else {
            this.recordArg(1);
            this.recordArg(0);
        }
    }

    private void recordArg(ArithOpAssignInfo arithOpAssignInfo) {
        if (arithOpAssignInfo != null) {
            int operation = arithOpAssignInfo.getOperation();
            this.recordArg(operation);
            if (operation != 6) {
                this.recordArg(arithOpAssignInfo.getOperandLeft());
            }
            this.recordArg(arithOpAssignInfo.getOperandRight());
        } else {
            this.recordArg(0);
            AssignInfo leftOperand = null;
            AssignInfo rightOperand = null;
            this.recordArg(leftOperand);
            this.recordArg(rightOperand);
        }
    }

    private void recordArg(AssignFieldInfo assignFieldInfo) {
        if (assignFieldInfo != null) {
            this.recordArg(assignFieldInfo.getServer());
            this.recordArg(assignFieldInfo.getForm());
            int tag = assignFieldInfo.getTag();
            this.recordArg(tag);
            if (tag == 1) {
                this.recordArg(assignFieldInfo.getFieldId());
            } else if (tag == 4) {
                this.recordArg(assignFieldInfo.getStatHistory());
            } else if (tag == 6) {
                this.recordArg(assignFieldInfo.getCurrencyPart());
            }
            this.recordArg(assignFieldInfo.getQualifier());
            this.recordArg(assignFieldInfo.getNoMatchOption());
            this.recordArg(assignFieldInfo.getMultiMatchOption());
        } else {
            this.recordArg("");
            this.recordArg("");
            this.recordArg(0);
            QualifierInfo qualifier = null;
            this.recordArg(qualifier);
            this.recordArg(2);
            this.recordArg(2);
        }
    }

    private void recordArg(QualifierInfo qal) {
        if (qal != null) {
            int operation = qal.getOperation();
            this.recordArg(operation);
            QualifierInfo opLeft = null;
            QualifierInfo opRight = null;
            switch (operation) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    opLeft = qal.getLeftOperand();
                    this.recordArg(opLeft);
                    opRight = qal.getRightOperand();
                    this.recordArg(opRight);
                    break;
                }
                case 3: {
                    opLeft = qal.getLeftOperand();
                    this.recordArg(opLeft);
                    break;
                }
                case 4: {
                    RelationalOperationInfo rOpInfo = qal.getRelationalOperationInfo();
                    this.recordArg(rOpInfo);
                    break;
                }
                case 5: {
                    QualifierFromFieldInfo fromFidInfo = qal.getFromFieldInfo();
                    this.recordArg(fromFidInfo.getValue());
                    break;
                }
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(RelationalOperationInfo rOpInfo) {
        if (rOpInfo != null) {
            int operation = rOpInfo.getOperation();
            this.recordArg(operation);
            ArithmeticOrRelationalOperand leftOperand = rOpInfo.getLeftOperand();
            this.recordArg(leftOperand);
            ArithmeticOrRelationalOperand rightOperand = rOpInfo.getRightOperand();
            this.recordArg(rightOperand);
        } else {
            this.recordArg(0);
            ArithmeticOrRelationalOperand leftOperand = null;
            ArithmeticOrRelationalOperand rightOperand = null;
            this.recordArg(leftOperand);
            this.recordArg(rightOperand);
        }
    }

    private void recordArg(ArithmeticOrRelationalOperand operand) {
        if (operand != null) {
            int operation = operand.getType().toInt();
            this.recordArg(operation);
            Object valueObj = operand.getValue();
            switch (operation) {
                case 1: 
                case 50: 
                case 51: 
                case 99: {
                    if (valueObj instanceof QueryFormField) {
                        this.recordArg((QueryFormField)valueObj);
                        break;
                    }
                    this.recordArg(valueObj.toString());
                    break;
                }
                case 2: {
                    Value value = (Value)valueObj;
                    this.recordArg(value);
                    break;
                }
                case 3: {
                    ArithmeticOperationInfo arithmeticOpInfo = (ArithmeticOperationInfo)valueObj;
                    this.recordArg(arithmeticOpInfo.getOperation());
                    if (operation != 6) {
                        this.recordArg(arithmeticOpInfo.getLeftOperand());
                    }
                    this.recordArg(arithmeticOpInfo.getRightOperand());
                    break;
                }
                case 4: {
                    StatusHistoryValueIndicator statusHistory = (StatusHistoryValueIndicator)valueObj;
                    this.recordArg(statusHistory);
                    break;
                }
                case 5: {
                    List valList = (List)valueObj;
                    this.recordArg(valList);
                    break;
                }
                case 6: 
                case 54: 
                case 55: 
                case 56: {
                    CurrencyPartInfo currPartInfo = (CurrencyPartInfo)valueObj;
                    this.recordArg(currPartInfo);
                    break;
                }
                case 52: {
                    int variable = (Integer)valueObj;
                    this.recordArg(variable);
                    break;
                }
                case 53: {
                    QueryInfo queryInfo = (QueryInfo)valueObj;
                    this.recordArg(queryInfo.getFormID());
                    this.recordArg(queryInfo.getServerName());
                    this.recordArg(queryInfo.getQualifierInfo());
                    this.recordArg(queryInfo.getFieldID());
                    this.recordArg(queryInfo.getMatchMode());
                    break;
                }
                case 7: {
                    ValueSetQuery valueSetQuery = (ValueSetQuery)valueObj;
                    this.currJoinableSources = valueSetQuery.getFromSources();
                    this.recordArg(this.currJoinableSources);
                    this.currQuerySources = valueSetQuery.getFromSources();
                    this.recordArg(valueSetQuery.getFromFields());
                    this.recordArg(valueSetQuery.getQualifier());
                    this.recordArg(valueSetQuery.getGroupBy());
                    this.recordArg(valueSetQuery.getHaving());
                    break;
                }
            }
        } else {
            this.recordArg(0);
        }
    }

    private void recordArg(StatusHistoryValueIndicator statusHistory) {
        if (statusHistory != null) {
            this.recordArg(statusHistory.getEnumValue());
            this.recordArg(statusHistory.getType());
        } else {
            this.recordArg(0);
            this.recordArg(2);
        }
    }

    private void recordArg(CurrencyPartInfo currPartInfo) {
        if (currPartInfo != null) {
            this.recordArg(currPartInfo.getFieldId());
            int partTag = currPartInfo.getPartTag();
            this.recordArg(partTag);
            if (partTag == 4) {
                this.recordArg(currPartInfo.getCurrencyCode());
            }
        } else {
            this.recordArg(0);
            this.recordArg(0);
        }
    }

    private void recordArg(IQuerySource querySource) {
        boolean toContinue = true;
        if (querySource instanceof QuerySourceForm) {
            this.recordArg(0);
            this.recordArg(((QuerySourceForm)querySource).getName());
        } else if (querySource instanceof RecursiveQuery) {
            this.recordArg(2);
            RecursiveQuery recQuery = (RecursiveQuery)querySource;
            this.currQuerySources = recQuery.getFromSources();
            this.recordArg(this.currQuerySources);
            this.recordArg(recQuery.getFromFields());
            this.recordArg(recQuery.getQualifier());
            this.currQuerySources.add(recQuery);
            this.recordArg(recQuery.getRecursionQualifier());
            this.recordArg(recQuery.getLevelsToRetrieve());
        } else {
            toContinue = false;
            this.recordArg(1);
        }
        if (toContinue && this.currIdx != 0 && this.currJoinableSources != null && this.currJoinableSources.size() > 0) {
            this.recordArg(querySource.getJoinType());
            this.recordArg(querySource.getJoinQualifier());
            this.recordArg(this.getIdx(this.currJoinableSources, querySource.getJoinedWith()));
        }
    }

    private void recordArg(QueryFormField queryFromField) {
        if (queryFromField != null) {
            this.recordArg(queryFromField.getFieldId());
            IQuerySource querySource = queryFromField.getSource();
            this.recordArg(this.getIdx(this.currQuerySources, querySource));
        } else {
            this.recordArg(0);
            this.recordArg(0);
        }
    }

    private <T> int getIdx(List<T> list, T element) {
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            if (t != element) continue;
            return i;
        }
        return -1;
    }

    private void recordArg(Value value) {
        if (value != null) {
            int dataType = value.getDataType().toInt();
            Object valueObj = value.getValue();
            if (!this.doNotRecordType) {
                this.recordArg(dataType);
            }
            switch (dataType) {
                case 1: {
                    Keyword keyWord = (Keyword)valueObj;
                    this.recordArg(-keyWord.getAsFieldID() + 1);
                    break;
                }
                case 5: {
                    DiaryListValue diaryListValue = (DiaryListValue)valueObj;
                    this.recordArg(diaryListValue.getAppendedText());
                    break;
                }
                case 7: {
                    Timestamp timeStamp = (Timestamp)valueObj;
                    this.recordArg(timeStamp);
                    break;
                }
                case 14: {
                    Time time = (Time)valueObj;
                    this.recordArg(String.valueOf(time.getValue()));
                    break;
                }
                case 9: {
                    ByteListValue byteListValue = (ByteListValue)valueObj;
                    this.recordArg(byteListValue.getType());
                    this.recordArg((Object)byteListValue.getValue());
                    break;
                }
                case 41: {
                    List coords = (List)valueObj;
                    this.recordArg(coords);
                    break;
                }
                case 11: {
                    AttachmentValue attachment = (AttachmentValue)valueObj;
                    this.recordArg(attachment.getName());
                    int locationType = attachment.getLocationType();
                    this.recordArg(locationType);
                    if (locationType == 1) {
                        this.recordArg(attachment.getValueFileName());
                        break;
                    }
                    this.recordArg(new String(attachment.getValue()));
                    break;
                }
                case 12: {
                    CurrencyValue currency = (CurrencyValue)valueObj;
                    this.recordArg(currency.getValueString());
                    this.recordArg(currency.getCurrencyCode());
                    this.recordArg(currency.getConversionDate());
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.recordArg(valueObj);
                    break;
                }
            }
        } else if (!this.doNotRecordType) {
            this.recordArg(0);
        }
    }

    private void recordArg(Timestamp timestamp) {
        if (timestamp != null) {
            this.recordArg(String.valueOf(timestamp.getValue()));
        } else {
            this.recordArg("");
        }
    }

    private void recordArg(CoordinateInfo cordInfo) {
        if (cordInfo != null) {
            this.recordArg(cordInfo.getXCoordinate());
            this.recordArg(cordInfo.getYCoordinate());
        } else {
            this.recordArg(0);
            this.recordArg(0);
        }
    }

    private void recordArgCreate(Image image) {
        this.recordArg(image.getName());
        this.recordArg(image.getType());
        this.recordArg(image.getDescription());
        this.recordArg(2);
        this.recordArg(image.getImageData());
        this.recordArg(image.getHelpText());
        this.recordArg(image.getOwner());
        this.recordArg(image.getDiary());
        this.recordArg(image.getProperties());
    }

    private void recordArgSet(Image image) {
        this.recordArg(image.getName());
        this.recordArgConditionally(image.getNewName());
        this.recordArgConditionally(image.getType());
        this.recordArgConditionally(image.getDescription());
        this.recordArgConditionally(image.getImageData());
        this.recordArgConditionally(image.getHelpText());
        this.recordArgConditionally(image.getOwner());
        this.recordArgConditionally(image.getDiary());
        this.recordArgConditionally(image.getProperties());
    }

    private void recordArg(ImageData imageData) {
        if (imageData != null) {
            int length = imageData.getValue().length;
            byte[] bytes = imageData.getValue();
            this.recordArg(length);
            for (int i = 0; i < length; ++i) {
                this.recordArg(Integer.toHexString(bytes[i]));
            }
        } else {
            this.recordArg(0);
            this.recordArg(0);
        }
    }

    private void recordArg(OverlaidInfo overlayObj) {
        int objType = overlayObj.getObjType();
        this.recordArg(objType);
        if (objType == 15 || objType == 14) {
            this.recordArg(overlayObj.getFormName());
            this.recordArg(overlayObj.getId());
        } else {
            this.recordArg(overlayObj.getName());
        }
        this.recordArg(overlayObj.getObjectModificationLogLabel());
    }

    private void recordArgCreate(OverlaidInfo overlayObj) {
        this.recordArg(overlayObj.getName());
        int objType = overlayObj.getObjType();
        this.recordArg(objType);
        if (objType == 15 || objType == 14) {
            this.recordArg(overlayObj.getFormName());
            this.recordArg(overlayObj.getId());
        }
    }

    private void recordArgConditionally(ImageData imageData) {
        if (imageData != null) {
            this.recordArg(2);
            this.recordArg("T");
            this.recordArg(imageData);
        } else {
            this.recordArg("F");
        }
    }

    @Override
    public void printResult(String resultString) {
        if (this.apiRecordingMode > 0) {
            StringTokenizer tokens = new StringTokenizer(resultString, "\n", true);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals("\n")) {
                    this.resOut.println();
                    continue;
                }
                this.resOut.print(token);
            }
        }
    }

    public void recordResults(List<StatusInfo> statusList, Object ... objects) {
        if (this.apiRecordingMode > 0) {
            this.finish = System.currentTimeMillis();
            this.printResultHeader(this.curApiName);
            if ((this.apiRecordingMode & 0x20) == 0) {
                for (Object x : objects) {
                    this.print("", null, x);
                }
            }
            this.printStatusInfoList("", null, statusList);
            this.recordTime();
            this.curApiName = this.prevApiName;
            this.prevApiName = null;
        }
    }

    public void recordResultsWithObjectHeader(List<StatusInfo> statusList, String header, Object ... objects) {
        if (this.apiRecordingMode > 0) {
            this.finish = System.currentTimeMillis();
            this.printResultHeader(this.curApiName);
            if ((this.apiRecordingMode & 0x20) == 0) {
                for (Object x : objects) {
                    this.print("", header, x);
                }
            }
            this.printStatusInfoList("", null, statusList);
            this.recordTime();
            this.curApiName = this.prevApiName;
            this.prevApiName = null;
        }
    }

    private void recordTime() {
        if ((this.apiRecordingMode & 4) != 0) {
            this.printResult("Start Time: " + this.start + " (" + new Date(this.start).toString() + ")" + "\n");
            this.printResult("Finish Time: " + this.finish + " (" + new Date(this.finish).toString() + ")" + "\n");
        }
        if ((this.apiRecordingMode & 8) != 0) {
            this.printResult("Elapsed Time: " + (this.finish - this.start) + " ms" + "\n");
        }
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiRecorder)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return new EqualsBuilder().isEquals();
    }

    public boolean isNestedRecording() {
        return this.curApiName != null;
    }

    public boolean isRecordingOn() {
        return this.apiRecordingMode > 0;
    }
}

