/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CriteriaFlags;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.TaskCriteria;
import com.bmc.arsys.api.Timestamp;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import org.apache.log4j.Logger;

class TaskInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8197071859700440563L;
    private static Logger logger = Logger.getLogger(TaskInfo.class);
    private String name;
    private Timestamp lastUpdateTime;
    private String owner;
    private String lastChangedBy;
    private int taskId;
    private int state;
    private String description;
    private ObjectPropertyMap objPropList;
    private CriteriaFlags m_changeFlags;
    protected Integer[] hashValues = null;

    protected TaskInfo() {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.hashValues = new Integer[11];
    }

    public TaskInfo(String taskName, String description, ObjectPropertyMap propList) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.setName(taskName);
        if (description == null) {
            this.description = description;
        } else {
            this.setDescription(description);
        }
        if (propList == null) {
            this.objPropList = propList;
        } else {
            this.setObjPropList(propList);
        }
    }

    TaskInfo(String taskName, int taskId, int state, String description, ObjectPropertyMap propList) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.setName(taskName);
        if (description == null) {
            this.description = description;
        } else {
            this.setDescription(description);
        }
        if (propList == null) {
            this.objPropList = propList;
        } else {
            this.setObjPropList(propList);
        }
        if (taskId == 0) {
            this.taskId = taskId;
        } else {
            this.setTaskId(taskId);
        }
        if (state == 0) {
            this.state = state;
        } else {
            this.setState(state);
        }
    }

    protected void createChangeFlags() {
        this.m_changeFlags = new TaskCriteria();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.m_changeFlags.setParameter(0L, true);
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    protected void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        this.m_changeFlags.setParameter(5L, true);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.m_changeFlags.setParameter(3L, true);
    }

    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    void setLastChangedBy(String lastChangedBy) {
        this.lastChangedBy = lastChangedBy;
        this.m_changeFlags.setParameter(6L, true);
    }

    public int getTaskId() {
        return this.taskId;
    }

    void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
        this.m_changeFlags.setParameter(2L, true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.m_changeFlags.setParameter(4L, true);
    }

    public ObjectPropertyMap getObjPropList() {
        return this.objPropList;
    }

    public void setObjPropList(ObjectPropertyMap objPropList) {
        this.objPropList = objPropList;
        this.m_changeFlags.setParameter(7L, true);
    }

    void calculateChangeFlagsOnSet() {
        boolean[] changeFlags;
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        if (!(changeFlags = this.m_changeFlags.getParameters())[7]) {
            if (this.objPropList != null && !this.objPropList.isEmpty()) {
                int hashCode = this.objPropList.hashCode();
                if (this.hashValues[7] == null || hashCode != this.hashValues[7]) {
                    this.m_changeFlags.setParameter(7L, true);
                }
                this.hashValues[7] = this.objPropList != null && !this.objPropList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[7] != null) {
                this.m_changeFlags.setParameter(7L, true);
                this.hashValues[7] = null;
            }
        }
    }

    void calculateHashCodeOnGet(CriteriaFlags criteria) {
        if (criteria == null) {
            criteria = new TaskCriteria();
        }
        ObjectBaseCriteria resetFlagCrit = null;
        if (criteria != null) {
            try {
                resetFlagCrit = (ObjectBaseCriteria)criteria.clone();
                resetFlagCrit.resetCriteriaFlags();
            }
            catch (CloneNotSupportedException e) {
                logger.debug(e);
            }
        }
        this.setChangeFlags(resetFlagCrit);
        this.calculateHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TaskInfo rhs = (TaskInfo)obj;
        return new EqualsBuilder().append(this.name, rhs.name).append(this.taskId, rhs.taskId).append(this.state, rhs.state).append(this.lastUpdateTime, rhs.lastUpdateTime).append(this.owner, rhs.owner).append(this.lastChangedBy, rhs.lastChangedBy).append(this.description, rhs.description).append(this.objPropList, rhs.objPropList).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.name).append(this.taskId).append(this.state).append(this.lastUpdateTime).append(this.owner).append(this.lastChangedBy).append(this.description).append(this.objPropList).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Name", this.name).append("TaskID", this.taskId).append("State", this.state).append("Last Update Time", this.lastUpdateTime).append("Owner", this.owner).append("last Changed By", this.lastChangedBy).append("Description", this.description).append("Obj Prop List", this.objPropList).toString();
    }

    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[11];
        }
        this.hashValues[0] = this.name != null ? Integer.valueOf(this.name.hashCode()) : null;
        this.hashValues[5] = this.lastUpdateTime != null ? Integer.valueOf(this.lastUpdateTime.hashCode()) : null;
        this.hashValues[3] = this.owner != null ? Integer.valueOf(this.owner.hashCode()) : null;
        this.hashValues[6] = this.lastChangedBy != null ? Integer.valueOf(this.lastChangedBy.hashCode()) : null;
        this.hashValues[4] = this.description != null ? Integer.valueOf(this.description.hashCode()) : null;
        this.hashValues[7] = this.objPropList != null && !this.objPropList.isEmpty() ? Integer.valueOf(this.objPropList.hashCode()) : null;
        this.hashValues[2] = this.state;
    }

    protected void resetChangeFlags() {
        this.m_changeFlags.setRetrieveAll(false);
    }

    public void setChangeFlags(CriteriaFlags criteria) {
        try {
            this.m_changeFlags = (CriteriaFlags)(criteria != null ? criteria.clone() : null);
        }
        catch (CloneNotSupportedException e) {
            logger.debug(e);
        }
    }

    CriteriaFlags getChangeFlags() {
        return this.m_changeFlags;
    }
}

