/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusHistoryItem;
import com.bmc.arsys.api.Timestamp;
import java.io.Serializable;
import java.util.ArrayList;

public class StatusHistoryValue
extends ArrayList<StatusHistoryItem>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2594082708847191622L;
    public static final String AR_DEFN_STATUS_HISTORYSEP = new String(new char[]{'\u0003'});
    public static final String AR_DEFN_STATUS_HISTORYCOMMA = new String(new char[]{'\u0004'});

    public static StatusHistoryValue decode(String encoded) throws ARException {
        StatusHistoryValue statusHistory = new StatusHistoryValue();
        if (encoded != null) {
            String[] lines;
            for (String line : lines = encoded.split(AR_DEFN_STATUS_HISTORYSEP)) {
                if (line.length() == 0) {
                    statusHistory.add(null);
                    continue;
                }
                String[] parts = line.split(AR_DEFN_STATUS_HISTORYCOMMA);
                if (parts.length == 2) {
                    String timeValStr = parts[0];
                    long timeVal = Long.parseLong(timeValStr);
                    String user = parts[1];
                    StatusHistoryItem item = new StatusHistoryItem(user, new Timestamp(timeVal));
                    statusHistory.add(item);
                    continue;
                }
                throw new ARException(2, 340, encoded);
            }
        }
        return statusHistory;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        for (StatusHistoryItem item : this) {
            if (item != null) {
                sb.append(new Long(item.getTimestamp().getValue()).toString());
                sb.append(AR_DEFN_STATUS_HISTORYCOMMA);
                sb.append(item.getUser());
            }
            sb.append(AR_DEFN_STATUS_HISTORYSEP);
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        StatusHistoryValue obj = new StatusHistoryValue();
        for (StatusHistoryItem item : this) {
            StatusHistoryItem cloned = null;
            try {
                cloned = (StatusHistoryItem)item.clone();
            }
            catch (CloneNotSupportedException e) {
                cloned = new StatusHistoryItem(item.getUser(), item.getTimestamp());
            }
            obj.add(cloned);
        }
        return obj;
    }
}

