/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.IARQualifierOperand;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class RelationalOperationInfo
implements IARQualifierOperand,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4521340937557441828L;
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_REL_OP_EQUAL = 1;
    public static final int AR_REL_OP_GREATER = 2;
    public static final int AR_REL_OP_GREATER_EQUAL = 3;
    public static final int AR_REL_OP_LESS = 4;
    public static final int AR_REL_OP_LESS_EQUAL = 5;
    public static final int AR_REL_OP_NOT_EQUAL = 6;
    public static final int AR_REL_OP_LIKE = 7;
    public static final int AR_REL_OP_IN = 8;
    public static final int AR_REL_OP_NOT_IN = 9;

    public RelationalOperationInfo() {
    }

    public RelationalOperationInfo(int operation, ArithmeticOrRelationalOperand op1, ArithmeticOrRelationalOperand op2) throws IllegalArgumentException {
        if (!this.validate(operation)) {
            throw new IllegalArgumentException("invalid operation in Qualifierinfo constructor");
        }
        this.m_operation = operation;
        this.m_operandLeft = op1;
        this.m_operandRight = op2;
    }

    public void setOperation(int operation) {
        this.m_operation = operation;
    }

    public void setLeftOperand(ArithmeticOrRelationalOperand op) {
        this.m_operandLeft = op;
    }

    public void setRightOperand(ArithmeticOrRelationalOperand op) {
        this.m_operandRight = op;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    public int getOperation() {
        return this.m_operation;
    }

    private boolean validate(int operation) {
        return operation >= 1 && operation <= 9;
    }

    public Object clone() throws CloneNotSupportedException {
        RelationalOperationInfo obj = (RelationalOperationInfo)super.clone();
        if (this.m_operandLeft != null) {
            obj.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        }
        if (this.m_operandRight != null) {
            obj.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelationalOperationInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RelationalOperationInfo rhs = (RelationalOperationInfo)obj;
        return new EqualsBuilder().append(this.m_operation, rhs.m_operation).append(this.m_operandLeft, rhs.m_operandLeft).append(this.m_operandRight, rhs.m_operandRight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_operation).append(this.m_operandLeft).append(this.m_operandRight).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Operation", this.m_operation).append("Operand Left", this.m_operandLeft).append("Operand Right", this.m_operandRight).toString();
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_operation = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_operandLeft = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)rawData, 1), ctx);
        this.m_operandRight = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)rawData, 2), ctx);
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{this.getOperation(), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandLeft, ctx), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandRight, ctx)};
        return var;
    }

    static RelationalOperationInfo createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null || ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0)) == 0) {
            return null;
        }
        RelationalOperationInfo obj = new RelationalOperationInfo();
        if (rawData.length == 3) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }
}

