/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.CaseOperandInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.FieldOperandInfo;
import com.bmc.arsys.api.FunctionOperandInfo;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ArithmeticOrRelationalOperand
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7278982475786875358L;
    private OperandType m_operandType;
    private Object m_operand;

    ArithmeticOrRelationalOperand() {
        this.m_operandType = null;
        this.m_operand = null;
    }

    public ArithmeticOrRelationalOperand(OperandType opType, int fldID) {
        if (!(OperandType.FIELDID.equals(opType) || OperandType.FIELDID_CURRENT.equals(opType) || OperandType.FIELDID_TRANSACTION.equals(opType) || OperandType.FIELDID_DB.equals(opType) || opType.toInt() >= 12 || opType.toInt() <= 26)) {
            throw new IllegalArgumentException("datatype not supported by this method");
        }
        this.m_operandType = opType;
        this.m_operand = new Integer(fldID);
    }

    public ArithmeticOrRelationalOperand(int fldID) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new Integer(fldID);
    }

    public ArithmeticOrRelationalOperand(int fldID, IQuerySource sourceForm) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(fldID, sourceForm);
    }

    public ArithmeticOrRelationalOperand(int fldID, int funcid, IQuerySource sourceForm) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(fldID, funcid, sourceForm);
    }

    public ArithmeticOrRelationalOperand(QueryFormField formField) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(formField.getFieldId(), formField.getFuncId(), formField.getSource());
    }

    public ArithmeticOrRelationalOperand(int i, int fieldId) {
        this.m_operandType = this.toOperandType(i);
        this.m_operand = new Integer(fieldId);
    }

    public ArithmeticOrRelationalOperand(Value val) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = val;
    }

    public ArithmeticOrRelationalOperand(ArithmeticOperationInfo opInfo) {
        this.m_operandType = OperandType.ARITHMETIC_OP;
        this.m_operand = opInfo;
    }

    public ArithmeticOrRelationalOperand(StatusHistoryValueIndicator statusHistory) {
        this.m_operandType = OperandType.STATUS_HISTORY;
        this.m_operand = statusHistory;
    }

    public ArithmeticOrRelationalOperand(List<Value> valList) {
        this.m_operandType = OperandType.VALUE_SET;
        this.m_operand = valList;
    }

    public ArithmeticOrRelationalOperand(CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = OperandType.CURRENCY_FLD;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(OperandType opType, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = opType;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(int opType, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = this.toOperandType(opType);
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(QueryInfo queryInfo) {
        this.m_operandType = OperandType.QUERY_INFO;
        this.m_operand = queryInfo;
    }

    public ArithmeticOrRelationalOperand(ValueSetQuery queryValueSet) {
        this.m_operandType = OperandType.VALUE_SET_QUERY;
        this.m_operand = queryValueSet;
    }

    public ArithmeticOrRelationalOperand(FieldOperandInfo fieldInfo) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = fieldInfo;
    }

    public ArithmeticOrRelationalOperand(FunctionOperandInfo functionInfo) {
        this.m_operandType = OperandType.FUNCTION;
        this.m_operand = functionInfo;
    }

    public ArithmeticOrRelationalOperand(CaseOperandInfo caseInfo) {
        this.m_operandType = OperandType.CASE;
        this.m_operand = caseInfo;
    }

    OperandType toOperandType(int i) {
        switch (i) {
            case 1: {
                return OperandType.FIELDID;
            }
            case 2: {
                return OperandType.VALUE;
            }
            case 3: {
                return OperandType.ARITHMETIC_OP;
            }
            case 4: {
                return OperandType.STATUS_HISTORY;
            }
            case 5: {
                return OperandType.VALUE_SET;
            }
            case 6: {
                return OperandType.CURRENCY_FLD;
            }
            case 7: {
                return OperandType.VALUE_SET_QUERY;
            }
            case 9: {
                return OperandType.FUNCTION;
            }
            case 10: {
                return OperandType.CASE;
            }
            case 50: {
                return OperandType.FIELDID_TRANSACTION;
            }
            case 51: {
                return OperandType.FIELDID_DB;
            }
            case 99: {
                return OperandType.FIELDID_CURRENT;
            }
            case 52: {
                return OperandType.LOCAL_VARIABLE;
            }
            case 53: {
                return OperandType.QUERY_INFO;
            }
            case 54: {
                return OperandType.CURRENCY_FLD_TRAN;
            }
            case 55: {
                return OperandType.CURRENCY_FLD_DB;
            }
            case 56: {
                return OperandType.CURRENCY_FLD_CURRENT;
            }
        }
        if (i >= 12 && i <= 26) {
            return OperandType.getOperandType(i);
        }
        return null;
    }

    public OperandType getType() {
        return this.m_operandType;
    }

    public Object getValue() {
        return this.m_operand;
    }

    int getTypeInt() {
        return this.m_operandType.toInt();
    }

    int getIntValue() {
        return (Integer)this.m_operand;
    }

    public void setValue(Value val) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = val;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOrRelationalOperand obj = (ArithmeticOrRelationalOperand)super.clone();
        if (this.m_operand != null) {
            switch (this.getTypeInt()) {
                case 1: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 50: 
                case 51: 
                case 99: {
                    if (obj.m_operand instanceof QueryFormField) {
                        obj.m_operand = ((QueryFormField)this.m_operand).clone();
                        break;
                    }
                    if (obj.m_operand instanceof FieldOperandInfo) {
                        obj.m_operand = ((FieldOperandInfo)this.m_operand).clone();
                        break;
                    }
                    obj.m_operand = new Integer(this.getIntValue());
                    break;
                }
                case 9: {
                    obj.m_operand = ((FunctionOperandInfo)this.m_operand).clone();
                    break;
                }
                case 10: {
                    obj.m_operand = ((CaseOperandInfo)this.m_operand).clone();
                    break;
                }
                case 2: {
                    obj.m_operand = ((Value)this.m_operand).clone();
                    break;
                }
                case 3: {
                    obj.m_operand = ((ArithmeticOperationInfo)this.m_operand).clone();
                    break;
                }
                case 6: 
                case 54: 
                case 55: 
                case 56: {
                    obj.m_operand = ((CurrencyPartInfo)this.m_operand).clone();
                    break;
                }
                case 4: {
                    obj.m_operand = ((StatusHistoryValueIndicator)this.m_operand).clone();
                    break;
                }
                case 5: {
                    List arrayCur = (List)this.m_operand;
                    int nLen = arrayCur.size();
                    ArrayList<Value> arrayNew = new ArrayList<Value>(nLen);
                    for (int i = 0; i < nLen; ++i) {
                        Value val = (Value)arrayCur.get(i);
                        if (val != null) {
                            arrayNew.add((Value)val.clone());
                            continue;
                        }
                        arrayNew.add(null);
                    }
                    obj.m_operand = arrayNew;
                    break;
                }
                case 52: {
                    obj.m_operand = new Integer(this.getIntValue());
                    break;
                }
                case 53: {
                    obj.m_operand = ((QueryInfo)this.m_operand).clone();
                    break;
                }
                case 7: {
                    obj.m_operand = ((ValueSetQuery)this.m_operand).clone();
                    break;
                }
                default: {
                    obj.m_operand = null;
                }
            }
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArithmeticOrRelationalOperand)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ArithmeticOrRelationalOperand rhs = (ArithmeticOrRelationalOperand)obj;
        return new EqualsBuilder().append(this.m_operandType, rhs.m_operandType).append(this.m_operand, rhs.m_operand).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_operandType).append(this.m_operand).toHashCode();
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        int typ = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_operandType = OperandType.getOperandType(typ);
        Object val = ARTypeMgr.GetAt((Object)rawData, 1);
        switch (typ) {
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 50: 
            case 51: 
            case 99: {
                this.m_operand = new Integer(ConversionUtil.getIntValue(val));
                break;
            }
            case 2: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(Value.class, val, ctx);
                break;
            }
            case 3: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOperationInfo.class, val, ctx);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(CurrencyPartInfo.class, val, ctx);
                break;
            }
            case 4: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(StatusHistoryValueIndicator.class, val, ctx);
                break;
            }
            case 5: {
                this.m_operand = ARTypeMgr.getInstance().ObjectListFromVariant(Value.class, val, ctx);
                break;
            }
            case 52: {
                this.m_operand = new Integer(ConversionUtil.getIntValue(val));
                break;
            }
            case 53: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(QueryInfo.class, val, ctx);
                break;
            }
            case 9: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(FunctionOperandInfo.class, val, ctx);
                break;
            }
            case 10: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(CaseOperandInfo.class, val, ctx);
                break;
            }
        }
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[2];
        int typ = this.getTypeInt();
        var[0] = new Integer(typ);
        switch (typ) {
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 50: 
            case 51: 
            case 99: {
                var[1] = new Integer(ConversionUtil.getIntValue(this.m_operand));
                break;
            }
            case 2: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 3: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 4: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 5: {
                var[1] = ARTypeMgr.getInstance().ObjectListFromVariant(Value.class, this.m_operand, ctx);
                break;
            }
            case 52: {
                var[1] = new Integer(ConversionUtil.getIntValue(this.m_operand));
                break;
            }
            case 53: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 9: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
            case 10: {
                var[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, ctx);
                break;
            }
        }
        return var;
    }

    static ArithmeticOrRelationalOperand createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ArithmeticOrRelationalOperand obj = new ArithmeticOrRelationalOperand();
        if (rawData.length == 2) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Operand Type", this.m_operandType).append("Operand", this.m_operand).toString();
    }
}

